/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.db.ConnectionProfile;
import workbench.db.KeepAliveDaemon;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class EditConnectScriptsPanel
extends JPanel
implements ValidatingComponent {
    private EditorPanel postConnectEditor;
    private EditorPanel preDisconnectEditor;
    private EditorPanel keepAliveScriptEditor;
    private JTextField keepAliveInterval;

    public EditConnectScriptsPanel(ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            throw new NullPointerException("Null profile specified!");
        }
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblPostConnectScript"));
        this.postConnectEditor = EditorPanel.createSqlEditor();
        this.postConnectEditor.setText(connectionProfile.getPostConnectScript());
        Dimension dimension = new Dimension(200, 200);
        this.postConnectEditor.setPreferredSize(dimension);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.postConnectEditor, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
        JLabel jLabel2 = new JLabel(ResourceMgr.getString("LblPreDisconnectScript"));
        this.preDisconnectEditor = EditorPanel.createSqlEditor();
        this.preDisconnectEditor.setText(connectionProfile.getPreDisconnectScript());
        this.preDisconnectEditor.setPreferredSize(dimension);
        this.preDisconnectEditor.setCaretVisible(false);
        jPanel2.add((Component)this.preDisconnectEditor, "Center");
        jPanel2.add((Component)jLabel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 5));
        JLabel jLabel3 = new JLabel(ResourceMgr.getString("LblIdleScript"));
        this.keepAliveScriptEditor = EditorPanel.createSqlEditor();
        this.keepAliveScriptEditor.setText(connectionProfile.getIdleScript());
        this.keepAliveScriptEditor.setPreferredSize(dimension);
        this.keepAliveScriptEditor.setCaretVisible(false);
        jPanel3.add((Component)this.keepAliveScriptEditor, "Center");
        jPanel3.add((Component)jLabel3, "North");
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel jLabel4 = new JLabel(ResourceMgr.getString("LblIdleScriptTime"));
        jLabel4.setToolTipText(ResourceMgr.getDescription("LblIdleScriptTime"));
        jPanel4.add(jLabel4);
        this.keepAliveInterval = new JTextField(8);
        this.keepAliveInterval.setText(KeepAliveDaemon.getTimeDisplay(connectionProfile.getIdleTime()));
        jPanel4.add(this.keepAliveInterval);
        jPanel3.add((Component)jPanel4, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = WbSwingUtilities.getEmptyInsets();
        this.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.postConnectEditor);
        wbTraversalPolicy.addComponent(this.preDisconnectEditor);
        wbTraversalPolicy.addComponent(this.keepAliveScriptEditor);
        wbTraversalPolicy.addComponent(this.keepAliveInterval);
        wbTraversalPolicy.setDefaultComponent(this.postConnectEditor);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.setFocusCycleRoot(false);
    }

    public String getKeepAliveScript() {
        return this.keepAliveScriptEditor.getText().trim();
    }

    private long getIdleTime() {
        String string = this.keepAliveInterval.getText().trim().toLowerCase();
        return KeepAliveDaemon.parseTimeInterval(string);
    }

    public String getPostConnectScript() {
        return this.postConnectEditor.getText().trim();
    }

    public String getPreDisconnectScript() {
        return this.preDisconnectEditor.getText().trim();
    }

    public static boolean editScripts(Dialog dialog, ConnectionProfile connectionProfile) {
        EditConnectScriptsPanel editConnectScriptsPanel = new EditConnectScriptsPanel(connectionProfile);
        ValidatingDialog validatingDialog = new ValidatingDialog(dialog, ResourceMgr.getString("LblEditConnScripts"), (JComponent)editConnectScriptsPanel);
        editConnectScriptsPanel.keepAliveScriptEditor.addKeyBinding(validatingDialog.getESCAction());
        editConnectScriptsPanel.postConnectEditor.addKeyBinding(validatingDialog.getESCAction());
        editConnectScriptsPanel.preDisconnectEditor.addKeyBinding(validatingDialog.getESCAction());
        boolean bl = Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.connectscripts.window");
        if (!bl) {
            validatingDialog.setSize(600, 550);
        }
        WbSwingUtilities.center(validatingDialog, dialog);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.connectscripts.window");
        if (validatingDialog.isCancelled()) {
            return false;
        }
        connectionProfile.setPreDisconnectScript(editConnectScriptsPanel.getPreDisconnectScript());
        connectionProfile.setPostConnectScript(editConnectScriptsPanel.getPostConnectScript());
        connectionProfile.setIdleScript(editConnectScriptsPanel.getKeepAliveScript());
        connectionProfile.setIdleTime(editConnectScriptsPanel.getIdleTime());
        return true;
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        EventQueue.invokeLater(this.postConnectEditor::requestFocusInWindow);
    }
}

