/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.db.ConnectionProfile;
import workbench.db.ObjectNameFilter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.profiles.ObjectFilterTemplate;
import workbench.gui.profiles.ObjectFilterTemplateStorage;
import workbench.gui.profiles.TemplateListEditor;
import workbench.gui.profiles.TemplateType;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class EditConnectionFiltersPanel
extends JPanel
implements ValidatingComponent,
ActionListener {
    private EditorPanel schemaFilterEditor;
    private EditorPanel catalogFilterEditor;
    private JCheckBox catalogInclusionFlag;
    private JCheckBox schemaInclusionFlag;
    private JCheckBox retrievalFilter;
    private ObjectNameFilter schemaFilter;
    private ObjectNameFilter catalogFilter;
    private JComboBox catalogTemplates;
    private JComboBox schemaTemplates;
    private JButton addSchemaTemplate;
    private JButton addCatalogTemplate;
    private JButton editSchemaTemplates;
    private JButton editCatalogTemplates;

    public EditConnectionFiltersPanel(ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            throw new NullPointerException("Null profile specified!");
        }
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblSchemaFilter"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "First");
        this.schemaTemplates = new JComboBox();
        ObjectFilterTemplateStorage objectFilterTemplateStorage = new ObjectFilterTemplateStorage(TemplateType.schema);
        this.schemaTemplates.setModel(objectFilterTemplateStorage);
        this.schemaTemplates.addActionListener(this);
        jPanel2.add((Component)this.schemaTemplates, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.addSchemaTemplate = new JButton();
        this.addSchemaTemplate.setIcon(IconMgr.getInstance().getLabelIcon("add"));
        this.addSchemaTemplate.addActionListener(this);
        int n = IconMgr.getInstance().getSizeForLabel();
        WbSwingUtilities.adjustButtonWidth(this.addSchemaTemplate, n + 6, n + 6);
        jPanel3.add((Component)this.addSchemaTemplate, "Before");
        this.editSchemaTemplates = new JButton();
        this.editSchemaTemplates.setIcon(IconMgr.getInstance().getLabelIcon("edit"));
        this.editSchemaTemplates.addActionListener(this);
        WbSwingUtilities.adjustButtonWidth(this.editSchemaTemplates, n + 6, n + 6);
        jPanel3.add((Component)this.editSchemaTemplates, "After");
        jPanel2.add((Component)jPanel3, "After");
        this.schemaFilterEditor = EditorPanel.createTextEditor();
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.schemaInclusionFlag = new JCheckBox(ResourceMgr.getString("LblInclFilter"));
        this.schemaInclusionFlag.setToolTipText(ResourceMgr.getDescription("LblInclFilter"));
        this.schemaInclusionFlag.addActionListener(this);
        this.retrievalFilter = new JCheckBox(ResourceMgr.getString("LblRetrievalFilter"));
        this.retrievalFilter.setToolTipText(ResourceMgr.getDescription("LblRetrievalFilter"));
        this.retrievalFilter.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        jPanel4.add((Component)this.schemaInclusionFlag, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add((Component)this.retrievalFilter, gridBagConstraints);
        jPanel.add((Component)jPanel4, "South");
        jPanel.add((Component)this.schemaFilterEditor, "Center");
        jPanel.add((Component)jPanel2, "North");
        this.showSchemaFilter(connectionProfile.getSchemaFilter());
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 5));
        JLabel jLabel2 = new JLabel(ResourceMgr.getString("LblCatalogFilter"));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jLabel2, "First");
        this.catalogTemplates = new JComboBox();
        ObjectFilterTemplateStorage objectFilterTemplateStorage2 = new ObjectFilterTemplateStorage(TemplateType.catalog);
        this.catalogTemplates.setModel(objectFilterTemplateStorage2);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        this.addCatalogTemplate = new JButton();
        this.addCatalogTemplate.setIcon(IconMgr.getInstance().getLabelIcon("add"));
        this.addCatalogTemplate.addActionListener(this);
        WbSwingUtilities.adjustButtonWidth(this.addCatalogTemplate, n + 6, n + 6);
        jPanel7.add((Component)this.addCatalogTemplate, "Before");
        this.editCatalogTemplates = new JButton();
        this.editCatalogTemplates.setIcon(IconMgr.getInstance().getLabelIcon("edit"));
        WbSwingUtilities.adjustButtonWidth(this.editCatalogTemplates, n + 6, n + 6);
        jPanel7.add((Component)this.editCatalogTemplates, "After");
        jPanel6.add((Component)this.catalogTemplates, "Center");
        jPanel6.add((Component)jPanel7, "After");
        this.catalogFilterEditor = EditorPanel.createTextEditor();
        this.catalogFilterEditor.setCaretVisible(false);
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        this.catalogInclusionFlag = new JCheckBox(ResourceMgr.getString("LblInclFilter"));
        this.catalogInclusionFlag.setToolTipText(ResourceMgr.getDescription("LblInclFilter"));
        this.catalogInclusionFlag.setSelected(this.catalogFilter != null ? this.catalogFilter.isInclusionFilter() : false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 23;
        jPanel8.add((Component)this.catalogInclusionFlag, gridBagConstraints2);
        jPanel8.setPreferredSize(jPanel4.getPreferredSize());
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)this.catalogFilterEditor, "Center");
        jPanel5.add((Component)jPanel8, "South");
        this.showCatalogFilter(connectionProfile.getCatalogFilter());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        this.add((Component)jPanel, gridBagConstraints3);
        ++gridBagConstraints3.gridx;
        gridBagConstraints3.insets = new Insets(0, 20, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints3);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.insets = new Insets(10, 0, 5, 0);
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.anchor = 11;
        JLabel jLabel3 = new JLabel(ResourceMgr.getString("TxtSchemCatFilterHelp"));
        this.add((Component)jLabel3, gridBagConstraints3);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.schemaFilterEditor);
        wbTraversalPolicy.addComponent(this.catalogFilterEditor);
        wbTraversalPolicy.addComponent(this.schemaInclusionFlag);
        wbTraversalPolicy.addComponent(this.catalogInclusionFlag);
        wbTraversalPolicy.setDefaultComponent(this.schemaFilterEditor);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.setFocusCycleRoot(false);
    }

    private void showSchemaFilter(ObjectNameFilter objectNameFilter) {
        this.showFilter(objectNameFilter, this.schemaFilterEditor);
        this.retrievalFilter.setSelected(false);
        this.schemaInclusionFlag.setSelected(objectNameFilter != null ? objectNameFilter.isInclusionFilter() : false);
        this.retrievalFilter.setEnabled(this.schemaInclusionFlag.isSelected());
        if (this.retrievalFilter.isEnabled()) {
            this.retrievalFilter.setSelected(objectNameFilter != null ? objectNameFilter.isRetrievalFilter() : false);
        }
        this.schemaFilter = objectNameFilter;
    }

    private void showCatalogFilter(ObjectNameFilter objectNameFilter) {
        this.showFilter(objectNameFilter, this.catalogFilterEditor);
        this.catalogInclusionFlag.setSelected(objectNameFilter != null ? objectNameFilter.isInclusionFilter() : false);
        this.catalogFilter = objectNameFilter;
    }

    private void showFilter(ObjectNameFilter objectNameFilter, EditorPanel editorPanel) {
        editorPanel.setText("");
        if (objectNameFilter == null) {
            return;
        }
        if (objectNameFilter.getFilterExpressions() == null) {
            return;
        }
        for (String string : objectNameFilter.getFilterExpressions()) {
            editorPanel.appendLine(string + "\n");
        }
    }

    protected ObjectNameFilter getCatalogFilter() {
        int n = this.catalogFilterEditor.getLineCount();
        String string = this.catalogFilterEditor.getText().trim();
        if (n <= 0 || string.isEmpty()) {
            return null;
        }
        if (this.catalogFilter == null) {
            this.catalogFilter = new ObjectNameFilter();
        } else {
            this.catalogFilter.removeExpressions();
        }
        this.catalogFilter.setInclusionFilter(this.catalogInclusionFlag.isSelected());
        for (int i = 0; i < n; ++i) {
            String string2 = this.catalogFilterEditor.getLineText(i);
            this.catalogFilter.addExpression(this.convertSQLExpression(string2));
        }
        return this.catalogFilter;
    }

    protected ObjectNameFilter getSchemaFilter() {
        int n = this.schemaFilterEditor.getLineCount();
        String string = this.schemaFilterEditor.getText().trim();
        if (n <= 0 || string.isEmpty()) {
            return null;
        }
        if (this.schemaFilter == null) {
            this.schemaFilter = new ObjectNameFilter();
        } else {
            this.schemaFilter.removeExpressions();
        }
        this.schemaFilter.setInclusionFilter(this.schemaInclusionFlag.isSelected());
        if (this.schemaInclusionFlag.isSelected()) {
            this.schemaFilter.setIsRetrievalFilter(this.retrievalFilter.isSelected());
        } else {
            this.schemaFilter.setIsRetrievalFilter(false);
        }
        for (int i = 0; i < n; ++i) {
            String string2 = this.schemaFilterEditor.getLineText(i);
            if (this.schemaFilter.isRetrievalFilter()) {
                this.schemaFilter.addExpression(string2);
                continue;
            }
            this.schemaFilter.addExpression(this.convertSQLExpression(string2));
        }
        return this.schemaFilter;
    }

    private String convertSQLExpression(String string) {
        if (string.endsWith("%") && !(string = string.substring(0, string.length() - 1) + ".*").startsWith("^")) {
            string = "^" + string;
        }
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.schemaTemplates) {
            this.applySchemaTemplate();
        }
        if (actionEvent.getSource() == this.catalogTemplates) {
            this.applyCatalogTemplate();
        }
        if (actionEvent.getSource() == this.addSchemaTemplate) {
            this.addSchemaTemplate();
        }
        if (actionEvent.getSource() == this.addCatalogTemplate) {
            this.addCatalogTemplate();
        }
        if (actionEvent.getSource() == this.editSchemaTemplates) {
            this.editTemplates((ObjectFilterTemplateStorage)this.schemaTemplates.getModel());
        }
        if (actionEvent.getSource() == this.editCatalogTemplates) {
            this.editTemplates((ObjectFilterTemplateStorage)this.catalogTemplates.getModel());
        }
        if (actionEvent.getSource() == this.schemaInclusionFlag) {
            this.retrievalFilter.setEnabled(this.schemaInclusionFlag.isSelected());
        }
    }

    private void editTemplates(ObjectFilterTemplateStorage objectFilterTemplateStorage) {
        List<ObjectFilterTemplate> list = objectFilterTemplateStorage.getTemplates();
        TemplateListEditor templateListEditor = new TemplateListEditor();
        templateListEditor.setTemplates(list);
        boolean bl = WbSwingUtilities.getOKCancel("Manage templates", this, templateListEditor);
        if (bl) {
            objectFilterTemplateStorage.setTemplates(templateListEditor.getTemplates());
        }
    }

    private void applySchemaTemplate() {
        ObjectFilterTemplateStorage objectFilterTemplateStorage = (ObjectFilterTemplateStorage)this.schemaTemplates.getModel();
        ObjectFilterTemplate objectFilterTemplate = objectFilterTemplateStorage.getSelectedItem();
        if (objectFilterTemplate == null) {
            return;
        }
        this.showSchemaFilter(objectFilterTemplate.getFilter().createCopy());
    }

    private void applyCatalogTemplate() {
        ObjectFilterTemplateStorage objectFilterTemplateStorage = (ObjectFilterTemplateStorage)this.catalogTemplates.getModel();
        ObjectFilterTemplate objectFilterTemplate = objectFilterTemplateStorage.getSelectedItem();
        if (objectFilterTemplate == null) {
            return;
        }
        this.showCatalogFilter(objectFilterTemplate.getFilter().createCopy());
    }

    private void addSchemaTemplate() {
        ObjectNameFilter objectNameFilter = this.getSchemaFilter();
        if (objectNameFilter == null) {
            return;
        }
        ObjectFilterTemplateStorage objectFilterTemplateStorage = (ObjectFilterTemplateStorage)this.schemaTemplates.getModel();
        String string = WbSwingUtilities.getUserInput(this, "Enter a name", "Schema Filter Template");
        if (StringUtil.isNonBlank(string)) {
            objectFilterTemplateStorage.addTemplate(string, objectNameFilter.createCopy());
        }
    }

    private void addCatalogTemplate() {
        ObjectNameFilter objectNameFilter = this.getCatalogFilter();
        if (objectNameFilter == null) {
            return;
        }
        ObjectFilterTemplateStorage objectFilterTemplateStorage = (ObjectFilterTemplateStorage)this.schemaTemplates.getModel();
        String string = WbSwingUtilities.getUserInput(this, "Enter a name", "Catalog Filter Template");
        if (StringUtil.isNonBlank(string)) {
            objectFilterTemplateStorage.addTemplate(string, objectNameFilter.createCopy());
        }
    }

    private void saveTemplates() {
        ObjectFilterTemplateStorage objectFilterTemplateStorage = (ObjectFilterTemplateStorage)this.schemaTemplates.getModel();
        objectFilterTemplateStorage.saveTemplates();
        objectFilterTemplateStorage = (ObjectFilterTemplateStorage)this.catalogTemplates.getModel();
        objectFilterTemplateStorage.saveTemplates();
    }

    public static boolean editFilter(Dialog dialog, ConnectionProfile connectionProfile) {
        EditConnectionFiltersPanel editConnectionFiltersPanel = new EditConnectionFiltersPanel(connectionProfile);
        ValidatingDialog validatingDialog = new ValidatingDialog(dialog, ResourceMgr.getString("LblSchemaFilterBtn"), (JComponent)editConnectionFiltersPanel);
        editConnectionFiltersPanel.catalogFilterEditor.addKeyBinding(validatingDialog.getESCAction());
        editConnectionFiltersPanel.schemaFilterEditor.addKeyBinding(validatingDialog.getESCAction());
        boolean bl = Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.connectionfilter.window");
        if (!bl) {
            validatingDialog.setSize(400, 450);
        }
        WbSwingUtilities.center(validatingDialog, dialog);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.connectionfilter.window");
        editConnectionFiltersPanel.saveTemplates();
        if (validatingDialog.isCancelled()) {
            return false;
        }
        connectionProfile.setCatalogFilter(editConnectionFiltersPanel.getCatalogFilter());
        connectionProfile.setSchemaFilter(editConnectionFiltersPanel.getSchemaFilter());
        return true;
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        EventQueue.invokeLater(this.schemaFilterEditor::requestFocusInWindow);
    }
}

