/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import workbench.gui.components.LibListUtil;
import workbench.util.ClasspathUtil;
import workbench.util.WbFile;

public class LibraryElement {
    private final String fullPath;
    private String displayString;

    public LibraryElement(String string) {
        this(new WbFile(string));
    }

    public LibraryElement(WbFile wbFile) {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        String string = classpathUtil.getExtDir().getName();
        String string2 = wbFile.getName();
        if (string2.equalsIgnoreCase("rt.jar")) {
            this.displayString = string2;
            this.fullPath = string2;
        } else {
            LibListUtil libListUtil = new LibListUtil();
            WbFile wbFile2 = libListUtil.replacePlaceHolder(wbFile);
            if (classpathUtil.isInExtDir(wbFile2)) {
                this.fullPath = classpathUtil.getExtDir().getFullPath();
                this.displayString = string;
            } else if (wbFile2 == wbFile) {
                this.fullPath = wbFile.isAbsolute() ? wbFile.getFullPath() : wbFile.getName();
                this.displayString = wbFile.exists() ? this.fullPath : "<html><span style='color:red'><i>" + this.fullPath + "</i></span></html>";
            } else {
                this.displayString = this.fullPath = wbFile.getParent() + System.getProperty("file.separator") + wbFile.getName();
                if (!wbFile2.exists()) {
                    this.displayString = "<html><span style='color:red'><i>" + this.displayString + "</i></span></html>";
                }
            }
        }
    }

    public String getRealPath() {
        if (this.fullPath.endsWith("ext")) {
            ClasspathUtil classpathUtil = new ClasspathUtil();
            return classpathUtil.getExtDir().getFullPath();
        }
        LibListUtil libListUtil = new LibListUtil();
        WbFile wbFile = libListUtil.replacePlaceHolder(new WbFile(this.fullPath));
        return wbFile.getFullPath();
    }

    public String getPath() {
        return this.fullPath;
    }

    public String toString() {
        return this.displayString;
    }
}

