/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import workbench.db.ObjectNameFilter;
import workbench.gui.profiles.ObjectFilterTemplate;
import workbench.gui.profiles.TemplateType;
import workbench.resource.Settings;

public class ObjectFilterTemplateStorage
implements ComboBoxModel<ObjectFilterTemplate> {
    private final String prefix;
    private final List<ObjectFilterTemplate> templates;
    private ObjectFilterTemplate selectedItem;
    private List<ListDataListener> listener = new ArrayList<ListDataListener>(1);

    public ObjectFilterTemplateStorage(TemplateType templateType) {
        this.prefix = "workbench.gui.object.filter.template." + templateType.name().toLowerCase() + ".";
        List<String> list = Settings.getInstance().getKeysWithPrefix(this.prefix + "name");
        this.templates = new ArrayList<ObjectFilterTemplate>(list.size());
        for (String string : list) {
            String string2 = Settings.getInstance().getProperty(string, null);
            String string3 = this.getTemplateIndex(string);
            if (string3 == null || string2 == null) continue;
            String string4 = this.prefix + string3 + ".definition";
            String string5 = this.prefix + string3 + ".include";
            String string6 = Settings.getInstance().getProperty(string4, null);
            boolean bl = Settings.getInstance().getBoolProperty(string5, true);
            ObjectNameFilter objectNameFilter = new ObjectNameFilter();
            objectNameFilter.setExpressionList(string6);
            objectNameFilter.setInclusionFilter(bl);
            ObjectFilterTemplate objectFilterTemplate = new ObjectFilterTemplate(string2, objectNameFilter);
            this.templates.add(objectFilterTemplate);
        }
    }

    public void setTemplates(List<ObjectFilterTemplate> list) {
        this.templates.clear();
        this.templates.addAll(list);
        this.fireContentsChanged(0, this.templates.size() - 1);
    }

    public void deleteTemplates() {
        List<String> list = Settings.getInstance().getKeysWithPrefix(this.prefix + "name");
        for (String string : list) {
            String string2 = this.getTemplateIndex(string);
            if (string2 != null) {
                String string3 = this.prefix + string2 + ".definition";
                String string4 = this.prefix + string2 + ".include";
                Settings.getInstance().removeProperty(string3);
                Settings.getInstance().removeProperty(string4);
            }
            Settings.getInstance().removeProperty(string);
        }
    }

    public synchronized void saveTemplates() {
        if (this.templates == null) {
            return;
        }
        this.deleteTemplates();
        for (int i = 0; i < this.templates.size(); ++i) {
            String string = this.prefix + "name." + Integer.toString(i);
            String string2 = this.prefix + Integer.toString(i) + ".definition";
            String string3 = this.prefix + Integer.toString(i) + ".include";
            ObjectFilterTemplate objectFilterTemplate = this.templates.get(i);
            Settings.getInstance().setProperty(string, objectFilterTemplate.getName());
            Settings.getInstance().setProperty(string2, objectFilterTemplate.getFilter().getFilterString());
            Settings.getInstance().setProperty(string3, objectFilterTemplate.getFilter().isInclusionFilter());
        }
    }

    public void addTemplate(String string, ObjectNameFilter objectNameFilter) {
        ObjectFilterTemplate objectFilterTemplate = new ObjectFilterTemplate(string, objectNameFilter);
        int n = this.templates.indexOf(objectFilterTemplate);
        if (n > -1) {
            this.templates.set(n, objectFilterTemplate);
            this.fireContentsChanged(n, n);
        } else {
            this.templates.add(objectFilterTemplate);
            this.fireItemAdded();
        }
    }

    public List<ObjectFilterTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    private String getTemplateIndex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectedItem = (ObjectFilterTemplate)object;
    }

    @Override
    public ObjectFilterTemplate getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.templates.size();
    }

    @Override
    public ObjectFilterTemplate getElementAt(int n) {
        return this.templates.get(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listener.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listener.remove(listDataListener);
    }

    private void fireItemAdded() {
        this.fireContentsChanged(this.templates.size() - 1, this.templates.size() - 1);
    }

    private void fireContentsChanged(int n, int n2) {
        if (this.listener.isEmpty()) {
            return;
        }
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, n, n2);
        for (ListDataListener listDataListener : this.listener) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }
}

