/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.db.ConnectionProfile;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.menu.CutCopyPastePopup;
import workbench.gui.profiles.NewGroupAction;
import workbench.gui.profiles.ProfileFlavor;
import workbench.gui.profiles.ProfileKey;
import workbench.gui.profiles.ProfileListModel;
import workbench.gui.profiles.ProfileTreeCellRenderer;
import workbench.gui.profiles.ProfileTreeTransferHandler;
import workbench.gui.profiles.RenameGroupAction;
import workbench.interfaces.ClipboardSupport;
import workbench.interfaces.ExpandableTree;
import workbench.interfaces.FileActions;
import workbench.interfaces.GroupTree;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ProfileTree
extends JTree
implements TreeModelListener,
MouseListener,
ClipboardSupport,
ActionListener,
TreeSelectionListener,
GroupTree,
ExpandableTree {
    private ProfileListModel profileModel;
    private CutCopyPastePopup popup;
    private WbAction pasteToFolderAction;
    private WbAction renameGroup;
    private Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    private boolean allowDirectChange = true;
    private ProfileTreeTransferHandler transferHandler = new ProfileTreeTransferHandler(this);
    private NewGroupAction newGroupAction;
    private DeleteListEntryAction deleteAction;

    public ProfileTree() {
        super(ProfileListModel.emptyModel());
        this.setRootVisible(false);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        this.setCellRenderer(new ProfileTreeCellRenderer());
        this.setEditable(true);
        this.setExpandsSelectedPaths(true);
        this.addMouseListener(this);
        this.getSelectionModel().setSelectionMode(4);
        this.addTreeSelectionListener(this);
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        this.popup = new CutCopyPastePopup(this);
        this.newGroupAction = new NewGroupAction(this, "LblNewProfileGroup");
        this.deleteAction = new DeleteListEntryAction(new FileActions(){

            @Override
            public void saveItem() throws Exception {
            }

            @Override
            public void deleteItem() throws Exception {
                ProfileTree.this.deleteSelectedItem();
            }

            @Override
            public void newItem(boolean bl) {
            }
        });
        WbAction wbAction = this.popup.getPasteAction();
        wbAction.addToInputMap(inputMap, actionMap);
        wbAction = this.popup.getCopyAction();
        wbAction.addToInputMap(inputMap, actionMap);
        wbAction = this.popup.getCutAction();
        wbAction.addToInputMap(inputMap, actionMap);
        this.pasteToFolderAction = new WbAction(this, "pasteToFolder");
        this.pasteToFolderAction.removeIcon();
        this.pasteToFolderAction.initMenuDefinition("MnuTxtPasteNewFolder");
        this.popup.addAction(this.newGroupAction, true);
        this.popup.addAction(this.pasteToFolderAction, false);
        this.renameGroup = new RenameGroupAction(this);
        this.popup.addAction(this.renameGroup, false);
        this.popup.addAction(this.deleteAction, true);
        this.deleteAction.addToInputMap(inputMap, actionMap);
        this.setAutoscrolls(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(this.transferHandler);
        this.setRowHeight(0);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
    }

    public DeleteListEntryAction getDeleteAction() {
        return this.deleteAction;
    }

    public void deleteSelectedItem() throws Exception {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        if (treePathArray.length == 0) {
            return;
        }
        if (this.onlyProfilesSelected()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getPathComponent(1);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
            int n = this.getModel().getIndexOfChild(defaultMutableTreeNode, defaultMutableTreeNode2);
            if (n > 0) {
                --n;
            }
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ConnectionProfile connectionProfile = (ConnectionProfile)defaultMutableTreeNode3.getUserObject();
                this.getModel().deleteProfile(connectionProfile);
            }
            if (defaultMutableTreeNode.getChildCount() > 0) {
                Object object = this.getModel().getChild(defaultMutableTreeNode, n);
                TreePath treePath = new TreePath(new Object[]{this.getModel().getRoot(), defaultMutableTreeNode, object});
                this.selectPath(treePath);
            }
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
            if (defaultMutableTreeNode.getChildCount() > 0 && !this.checkGroupWithProfiles(defaultMutableTreeNode)) {
                return;
            }
            this.getModel().removeGroupNode(defaultMutableTreeNode);
        }
    }

    private boolean checkGroupWithProfiles(DefaultMutableTreeNode defaultMutableTreeNode) {
        List<String> list = this.getModel().getGroups();
        JPanel jPanel = new JPanel();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        JComboBox<Object> jComboBox = new JComboBox<Object>(defaultComboBoxModel);
        jComboBox.setSelectedIndex(0);
        jPanel.setLayout(new BorderLayout(0, 5));
        String string = (String)defaultMutableTreeNode.getUserObject();
        String string2 = ResourceMgr.getFormattedString("LblDeleteNonEmptyGroup", string);
        jPanel.add((Component)new JLabel(string2), "North");
        jPanel.add(jComboBox, "South");
        String[] stringArray = new String[]{ResourceMgr.getString("LblMoveProfiles"), ResourceMgr.getString("LblDeleteProfiles")};
        Dialog dialog = (Dialog)SwingUtilities.getWindowAncestor(this);
        ValidatingDialog validatingDialog = new ValidatingDialog(dialog, "SQL Workbench/J", (JComponent)jPanel, stringArray);
        WbSwingUtilities.center(validatingDialog, dialog);
        validatingDialog.setVisible(true);
        if (validatingDialog.isCancelled()) {
            return false;
        }
        int n = validatingDialog.getSelectedOption();
        if (n == 0) {
            String string3 = (String)jComboBox.getSelectedItem();
            if (string3 == null) {
                return false;
            }
            this.getModel().moveProfilesToGroup(defaultMutableTreeNode, string3);
            return true;
        }
        return n == 1;
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        if (treeModel instanceof ProfileListModel) {
            this.profileModel = (ProfileListModel)treeModel;
            treeModel.addTreeModelListener(this);
        }
    }

    @Override
    public ProfileListModel getModel() {
        if (this.profileModel == null) {
            return (ProfileListModel)super.getModel();
        }
        return this.profileModel;
    }

    @Override
    public boolean isPathEditable(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        if (treePath.getPathCount() != 2) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getAllowsChildren();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[0];
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.getAllowsChildren()) {
            String string = (String)object;
            this.renameGroup(defaultMutableTreeNode, string);
        } else if (object instanceof ConnectionProfile) {
            WbSwingUtilities.repaintLater(this);
        }
    }

    @Override
    public void expandAll() {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.profileModel.getGroupNodes()) {
            if (treePath == null) continue;
            this.expandPath(treePath);
        }
    }

    @Override
    public void collapseAll() {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.profileModel.getGroupNodes()) {
            if (treePath == null) continue;
            this.collapsePath(treePath);
        }
    }

    public void expandGroups(List list) {
        if (list == null) {
            return;
        }
        TreePath[] treePathArray = this.profileModel.getGroupNodes();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            String string = (String)defaultMutableTreeNode.getUserObject();
            if (!list.contains(string) || this.isExpanded(treePath)) continue;
            this.expandPath(treePath);
        }
    }

    public List<String> getExpandedGroupNames() {
        TreePath[] treePathArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TreePath treePath : treePathArray = this.profileModel.getGroupNodes()) {
            if (!this.isExpanded(treePath)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            String string = (String)defaultMutableTreeNode.getUserObject();
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public boolean isGroup(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        return treeNode.getAllowsChildren();
    }

    private boolean canPaste() {
        try {
            return this.getToolkit().getSystemClipboard().isDataFlavorAvailable(ProfileFlavor.FLAVOR);
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not check clipboard", throwable);
            return false;
        }
    }

    private void checkActions() {
        boolean bl = this.onlyGroupSelected();
        boolean bl2 = this.canPaste();
        boolean bl3 = this.onlyProfilesSelected();
        this.pasteToFolderAction.setEnabled(bl2);
        WbAction wbAction = this.popup.getPasteAction();
        wbAction.setEnabled(this.allowDirectChange && bl2);
        wbAction = this.popup.getCopyAction();
        wbAction.setEnabled(this.allowDirectChange && bl3);
        wbAction = this.popup.getCutAction();
        wbAction.setEnabled(this.allowDirectChange && bl3);
        this.renameGroup.setEnabled(this.allowDirectChange && bl);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.allowDirectChange) {
            return;
        }
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            TreePath treePath = this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.getSelectionCount() == 1 || this.isGroup(treePath)) {
                this.setSelectionPath(treePath);
            }
            this.checkActions();
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void selectProfile(ProfileKey profileKey) {
        this.selectProfile(profileKey, true);
    }

    public void selectProfile(ProfileKey profileKey, boolean bl) {
        if (this.profileModel == null) {
            return;
        }
        TreePath treePath = this.profileModel.getPath(profileKey);
        if (treePath == null && bl) {
            treePath = this.profileModel.getFirstProfile();
        }
        this.selectPath(treePath);
    }

    public void selectFirstProfile() {
        if (this.profileModel == null) {
            return;
        }
        this.selectPath(this.profileModel.getFirstProfile());
    }

    public boolean onlyProfilesSelected() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (!treeNode.getAllowsChildren()) continue;
            return false;
        }
        return true;
    }

    public boolean onlyGroupSelected() {
        if (this.getSelectionCount() > 1) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode.getAllowsChildren()) continue;
            return false;
        }
        return true;
    }

    protected DefaultMutableTreeNode getSelectedGroupNode() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        if (treePathArray.length != 1) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getAllowsChildren()) {
            return defaultMutableTreeNode;
        }
        return null;
    }

    public List<ConnectionProfile> getSelectedProfiles() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return Collections.emptyList();
        }
        ArrayList<ConnectionProfile> arrayList = new ArrayList<ConnectionProfile>(treePathArray.length);
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getAllowsChildren()) continue;
            arrayList.add((ConnectionProfile)defaultMutableTreeNode.getUserObject());
        }
        return arrayList;
    }

    public ConnectionProfile getSelectedProfile() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        if (treePathArray.length != 1) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ConnectionProfile) {
            ConnectionProfile connectionProfile = (ConnectionProfile)object;
            return connectionProfile;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void copy() {
        try {
            this.transferHandler.exportToClipboard(this, this.getToolkit().getSystemClipboard(), 1);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not put Profile to clipboard", throwable);
        }
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void cut() {
        try {
            this.transferHandler.exportToClipboard(this, this.getToolkit().getSystemClipboard(), 2);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not put Profile to clipboard", throwable);
        }
    }

    @Override
    public void paste() {
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            this.transferHandler.importData(new TransferHandler.TransferSupport((Component)this, transferable));
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not access clipboard", throwable);
        }
    }

    public void handleDroppedNodes(List<ConnectionProfile> list, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (n == 2) {
            defaultMutableTreeNode2 = this.profileModel.moveProfilesToGroup(list, defaultMutableTreeNode);
        } else if (n == 1) {
            defaultMutableTreeNode2 = this.profileModel.copyProfilesToGroup(list, defaultMutableTreeNode);
        }
        this.selectNode(defaultMutableTreeNode2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.addGroup();
        if (string != null) {
            this.paste();
        }
    }

    public void renameGroup() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedGroupNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        String string = (String)defaultMutableTreeNode.getUserObject();
        String string2 = WbSwingUtilities.getUserInput(SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("LblRenameProfileGroup"), string);
        if (StringUtil.isEmptyString(string2)) {
            return;
        }
        defaultMutableTreeNode.setUserObject(string2);
        this.renameGroup(defaultMutableTreeNode, string2);
    }

    private void renameGroup(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        int n = this.profileModel.getChildCount(defaultMutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.profileModel.getChild(defaultMutableTreeNode, i);
            ConnectionProfile connectionProfile = (ConnectionProfile)defaultMutableTreeNode2.getUserObject();
            connectionProfile.setGroup(string);
        }
    }

    @Override
    public String addGroup() {
        String string = WbSwingUtilities.getUserInput(SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("LblNewProfileGroup"), "");
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        List<String> list = this.profileModel.getGroups();
        if (list.contains(string)) {
            WbSwingUtilities.showErrorMessageKey(SwingUtilities.getWindowAncestor(this), "ErrGroupNotUnique");
            return null;
        }
        TreePath treePath = this.profileModel.addGroup(string);
        this.selectPath(treePath);
        return string;
    }

    public void selectPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object[] objectArray = this.profileModel.getPathToRoot(defaultMutableTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.selectPath(treePath);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.checkActions();
    }

    public void autoscroll(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + this.autoscrollInsets.left, rectangle.y + this.autoscrollInsets.top, rectangle.width - (this.autoscrollInsets.left + this.autoscrollInsets.right), rectangle.height - (this.autoscrollInsets.top + this.autoscrollInsets.bottom));
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - this.autoscrollInsets.left, point.y - this.autoscrollInsets.top, this.autoscrollInsets.left + this.autoscrollInsets.right, this.autoscrollInsets.top + this.autoscrollInsets.bottom);
            this.scrollRectToVisible(rectangle3);
        }
    }
}

