/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import workbench.gui.profiles.SshHostConfigPanel;
import workbench.resource.ResourceMgr;
import workbench.ssh.SshConfig;
import workbench.ssh.SshConfigMgr;
import workbench.ssh.SshHostConfig;
import workbench.ssh.UrlParser;
import workbench.util.StringUtil;

public class SshConfigPanel
extends JPanel
implements ActionListener {
    private JTextField dbHostname;
    private JTextField dbPort;
    private JComboBox<SshHostConfig> globalConfigDD;
    private JLabel globalConfigLabel;
    private SshHostConfigPanel hostConfigPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel labelDbHostname;
    private JLabel labelDbPort;
    private JLabel labelLocalPort;
    private JTextField localPort;
    private JCheckBox rewriteUrl;
    private SshHostConfigPanel sshHostConfigPanel1;

    public SshConfigPanel() {
        this.initComponents();
        ArrayList<SshHostConfig> arrayList = new ArrayList<SshHostConfig>();
        arrayList.add(null);
        arrayList.addAll(SshConfigMgr.getDefaultInstance().getGlobalConfigs());
        SshHostConfig[] sshHostConfigArray = arrayList.toArray(new SshHostConfig[0]);
        DefaultComboBoxModel<SshHostConfig> defaultComboBoxModel = new DefaultComboBoxModel<SshHostConfig>(sshHostConfigArray);
        this.globalConfigDD.setModel(defaultComboBoxModel);
        this.hostConfigPanel.checkAgentUsage();
        this.globalConfigDD.addActionListener(this);
    }

    public void setConfig(SshConfig sshConfig, String string) {
        UrlParser urlParser;
        this.clear();
        if (sshConfig != null) {
            int n;
            if (!this.selectHostConfig(sshConfig.getSshHostConfigName())) {
                this.hostConfigPanel.setConfig(sshConfig.getSshHostConfig());
            }
            this.dbHostname.setText(StringUtil.coalesce(sshConfig.getDbHostname(), ""));
            int n2 = sshConfig.getLocalPort();
            if (n2 > 0) {
                this.localPort.setText(Integer.toString(n2));
            }
            if ((n = sshConfig.getDbPort()) > 0) {
                this.dbPort.setText(Integer.toString(n));
            }
            this.checkHostConfig();
        }
        if (!(urlParser = new UrlParser(string)).isLocalURL()) {
            this.rewriteUrl.setSelected(true);
        }
    }

    private boolean selectHostConfig(String string) {
        if (string == null) {
            this.globalConfigDD.setSelectedIndex(0);
            return false;
        }
        ComboBoxModel<SshHostConfig> comboBoxModel = this.globalConfigDD.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            SshHostConfig sshHostConfig = (SshHostConfig)comboBoxModel.getElementAt(i);
            if (sshHostConfig == null || !sshHostConfig.getConfigName().equals(string)) continue;
            this.globalConfigDD.setSelectedItem(sshHostConfig);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.globalConfigDD) {
            this.checkHostConfig();
        }
    }

    private void checkHostConfig() {
        SshHostConfig sshHostConfig = this.getSelectedGlobalConfig();
        if (sshHostConfig != null) {
            this.hostConfigPanel.setConfig(sshHostConfig);
            this.hostConfigPanel.setEnabled(false);
        } else {
            this.hostConfigPanel.setEnabled(true);
        }
    }

    private SshHostConfig getSelectedGlobalConfig() {
        int n = this.globalConfigDD.getSelectedIndex();
        if (n <= 0) {
            return null;
        }
        return (SshHostConfig)this.globalConfigDD.getSelectedItem();
    }

    private void clear() {
        this.hostConfigPanel.clear();
        this.dbPort.setText("");
        this.dbHostname.setText("");
        this.localPort.setText("");
        this.rewriteUrl.setSelected(false);
    }

    public boolean rewriteURL() {
        return this.rewriteUrl.isSelected();
    }

    public SshConfig getConfig() {
        boolean bl = false;
        SshHostConfig sshHostConfig = this.getSelectedGlobalConfig();
        if (sshHostConfig == null) {
            sshHostConfig = this.hostConfigPanel.getConfig();
            if (sshHostConfig == null || !sshHostConfig.isValid()) {
                return null;
            }
        } else {
            bl = true;
        }
        String string = StringUtil.trimToNull(this.localPort.getText());
        SshConfig sshConfig = new SshConfig();
        if (bl) {
            sshConfig.setSshHostConfigName(sshHostConfig.getConfigName());
        } else {
            sshConfig.setHostConfig(sshHostConfig);
        }
        sshConfig.setLocalPort(StringUtil.getIntValue(string, 0));
        sshConfig.setDbHostname(StringUtil.trimToNull(this.dbHostname.getText()));
        sshConfig.setDbPort(StringUtil.getIntValue(this.dbPort.getText(), 0));
        return sshConfig;
    }

    private void initComponents() {
        this.sshHostConfigPanel1 = new SshHostConfigPanel();
        this.labelLocalPort = new JLabel();
        this.localPort = new JTextField();
        this.labelDbPort = new JLabel();
        this.labelDbHostname = new JLabel();
        this.dbHostname = new JTextField();
        this.dbPort = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.rewriteUrl = new JCheckBox();
        this.hostConfigPanel = new SshHostConfigPanel();
        this.jPanel1 = new JPanel();
        this.globalConfigDD = new JComboBox();
        this.globalConfigLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.labelLocalPort.setLabelFor(this.localPort);
        this.labelLocalPort.setText(ResourceMgr.getString("LblSshLocalPort"));
        this.labelLocalPort.setToolTipText(ResourceMgr.getString("d_LblSshLocalPort"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelLocalPort, gridBagConstraints);
        this.localPort.setToolTipText(ResourceMgr.getString("d_LblSshLocalPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.localPort, gridBagConstraints);
        this.labelDbPort.setLabelFor(this.dbHostname);
        this.labelDbPort.setText(ResourceMgr.getString("LblSshDbHostname"));
        this.labelDbPort.setToolTipText(ResourceMgr.getString("d_LblSshDbHostname"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelDbPort, gridBagConstraints);
        this.labelDbHostname.setLabelFor(this.dbPort);
        this.labelDbHostname.setText(ResourceMgr.getString("LblSshDbPort"));
        this.labelDbHostname.setToolTipText(ResourceMgr.getString("d_LblSshDbPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelDbHostname, gridBagConstraints);
        this.dbHostname.setToolTipText(ResourceMgr.getString("d_LblSshDbHostname"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.dbHostname, gridBagConstraints);
        this.dbPort.setToolTipText(ResourceMgr.getString("d_LblSshDbPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.dbPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 5, 5, 11);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.rewriteUrl.setSelected(true);
        this.rewriteUrl.setText(ResourceMgr.getString("LblSshRewriteUrl"));
        this.rewriteUrl.setToolTipText(ResourceMgr.getString("d_LblSshRewriteUrl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 1, 0, 0);
        this.add((Component)this.rewriteUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.hostConfigPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.jPanel1.add(this.globalConfigDD, gridBagConstraints);
        this.globalConfigLabel.setText("Global SSH Host Configuration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.globalConfigLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 5, 5, 11);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblSshTunnel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblSshConn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(1, 5, 3, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }
}

