/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbFilePicker;
import workbench.interfaces.Validator;
import workbench.resource.ResourceMgr;
import workbench.ssh.SshHostConfig;
import workbench.ssh.SshManager;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class SshHostConfigPanel
extends JPanel
implements DocumentListener {
    private boolean canUseAgent;
    private boolean showConfigName;
    private ChangeListener listener;
    private boolean ignoreValueChange;
    private Validator nameValidator;
    private GridBagConstraints defaultErrorConstraints;
    private JLabel errorLabel;
    private JTextField configName;
    private JTextField hostname;
    private WbFilePicker keyPassFile;
    private JLabel labelConfigName;
    private JLabel labelHost;
    private JLabel labelKeyPass;
    private JLabel labelPassword;
    private JLabel labelSshPort;
    private JLabel labelUsername;
    private JPasswordField password;
    private JTextField sshPort;
    private JCheckBox useAgent;
    private JTextField username;

    public SshHostConfigPanel() {
        this(false);
    }

    public SshHostConfigPanel(boolean bl) {
        this.initComponents();
        this.defaultErrorConstraints = new GridBagConstraints();
        this.defaultErrorConstraints.gridx = 0;
        this.defaultErrorConstraints.gridy = 0;
        this.defaultErrorConstraints.gridwidth = 0;
        this.defaultErrorConstraints.fill = 2;
        this.defaultErrorConstraints.ipadx = 0;
        this.defaultErrorConstraints.ipady = 0;
        this.defaultErrorConstraints.anchor = 17;
        this.defaultErrorConstraints.insets = new Insets(15, 5, 0, 11);
        this.errorLabel = new JLabel(ResourceMgr.getString("ErrSshConfigNotUnique"));
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.RED.brighter(), 1), new EmptyBorder(3, 5, 3, 5));
        this.errorLabel.setBorder(compoundBorder);
        this.errorLabel.setFont(this.errorLabel.getFont().deriveFont(1));
        this.errorLabel.setBackground(new Color(255, 255, 220));
        this.errorLabel.setOpaque(true);
        this.showConfigName = bl;
        if (this.showConfigName) {
            this.configName.getDocument().addDocumentListener(this);
        } else {
            this.remove(this.labelConfigName);
            this.remove(this.configName);
        }
        this.keyPassFile.setAllowMultiple(false);
        this.keyPassFile.setLastDirProperty("workbench.ssh.keypass.lastdir");
        this.keyPassFile.setToolTipText(this.labelKeyPass.getToolTipText());
    }

    public void setValidator(Validator validator) {
        this.nameValidator = validator;
    }

    public void setAgentCheckBoxEnabled(boolean bl) {
        this.canUseAgent = bl;
    }

    public void checkAgentUsage() {
        WbThread wbThread = new WbThread("Check JNA libraries"){

            @Override
            public void run() {
                SshHostConfigPanel.this.canUseAgent = SshManager.canUseAgent();
                WbSwingUtilities.invoke(() -> SshHostConfigPanel.this.setTryAgentState());
            }
        };
        wbThread.start();
    }

    private void setTryAgentState() {
        if (this.isEnabled()) {
            this.useAgent.setEnabled(this.canUseAgent);
            if (this.canUseAgent) {
                this.useAgent.setToolTipText(null);
            } else {
                this.useAgent.setToolTipText(ResourceMgr.getString("d_LblSshAgentNotAvailable"));
            }
        }
    }

    public String getConfigName() {
        if (this.showConfigName) {
            return this.configName.getText();
        }
        return null;
    }

    public void setConfig(SshHostConfig sshHostConfig) {
        try {
            this.ignoreValueChange = true;
            this.clear();
            this.setEnabled(sshHostConfig != null);
            if (sshHostConfig != null) {
                if (this.showConfigName) {
                    this.configName.setText(StringUtil.coalesce(sshHostConfig.getConfigName(), ""));
                } else {
                    this.configName.setText("");
                }
                this.hostname.setText(StringUtil.coalesce(sshHostConfig.getHostname(), ""));
                this.username.setText(StringUtil.coalesce(sshHostConfig.getUsername(), ""));
                this.password.setText(StringUtil.coalesce(sshHostConfig.getDecryptedPassword(), ""));
                this.keyPassFile.setFilename(sshHostConfig.getPrivateKeyFile());
                this.useAgent.setSelected(sshHostConfig.getTryAgent());
                int n = sshHostConfig.getSshPort();
                if (n > 0 && n != 22) {
                    this.sshPort.setText(Integer.toString(n));
                }
            }
        }
        finally {
            this.ignoreValueChange = false;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.keyPassFile.setEnabled(bl);
        if (this.showConfigName) {
            this.configName.setEnabled(bl);
        }
        this.hostname.setEnabled(bl);
        this.username.setEnabled(bl);
        this.password.setEnabled(bl);
        this.sshPort.setEnabled(bl);
        if (bl) {
            this.useAgent.setEnabled(this.canUseAgent);
        } else {
            this.useAgent.setEnabled(false);
        }
    }

    public void clear() {
        try {
            this.ignoreValueChange = true;
            this.configName.setText("");
            this.keyPassFile.setFilename("");
            this.hostname.setText("");
            this.username.setText("");
            this.password.setText("");
            this.sshPort.setText("");
            this.useAgent.setSelected(false);
        }
        finally {
            this.ignoreValueChange = false;
        }
    }

    private void syncConfig(SshHostConfig sshHostConfig) {
        sshHostConfig.setUsername(StringUtil.trimToNull(this.username.getText()));
        sshHostConfig.setHostname(StringUtil.trimToNull(this.hostname.getText()));
        sshHostConfig.setPassword(this.password.getText());
        sshHostConfig.setSshPort(StringUtil.getIntValue(this.sshPort.getText(), 0));
        sshHostConfig.setPrivateKeyFile(StringUtil.trimToNull(this.keyPassFile.getFilename()));
        sshHostConfig.setTryAgent(this.useAgent.isSelected());
        if (this.showConfigName) {
            sshHostConfig.setConfigName(StringUtil.trimToNull(this.configName.getText()));
        }
    }

    public SshHostConfig getConfig() {
        String string = StringUtil.trimToNull(this.username.getText());
        String string2 = StringUtil.trimToNull(this.hostname.getText());
        if (string == null || string2 == null) {
            return null;
        }
        SshHostConfig sshHostConfig = new SshHostConfig();
        this.syncConfig(sshHostConfig);
        return sshHostConfig;
    }

    public void addNameChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
    }

    private void nameChanged() {
        if (this.ignoreValueChange) {
            return;
        }
        this.checkName();
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this.configName.getText()));
        }
    }

    private void checkName() {
        if (this.nameValidator == null) {
            return;
        }
        boolean bl = this.nameValidator.isValid(this.configName.getText());
        if (bl) {
            this.remove(this.errorLabel);
        } else {
            this.add((Component)this.errorLabel, this.defaultErrorConstraints);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.nameChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.nameChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.nameChanged();
    }

    private void initComponents() {
        this.labelHost = new JLabel();
        this.hostname = new JTextField();
        this.labelUsername = new JLabel();
        this.username = new JTextField();
        this.labelPassword = new JLabel();
        this.password = new JPasswordField();
        this.labelSshPort = new JLabel();
        this.sshPort = new JTextField();
        this.keyPassFile = new WbFilePicker();
        this.labelKeyPass = new JLabel();
        this.useAgent = new JCheckBox();
        this.labelConfigName = new JLabel();
        this.configName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.labelHost.setLabelFor(this.hostname);
        this.labelHost.setText(ResourceMgr.getString("LblSshHost"));
        this.labelHost.setToolTipText(ResourceMgr.getString("d_LblSshHost"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelHost, gridBagConstraints);
        this.hostname.setToolTipText(ResourceMgr.getString("d_LblSshHost"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.hostname, gridBagConstraints);
        this.labelUsername.setLabelFor(this.username);
        this.labelUsername.setText(ResourceMgr.getString("LblSshUser"));
        this.labelUsername.setToolTipText(ResourceMgr.getString("d_LblSshUser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelUsername, gridBagConstraints);
        this.username.setToolTipText(ResourceMgr.getString("d_LblSshUser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.username, gridBagConstraints);
        this.labelPassword.setLabelFor(this.password);
        this.labelPassword.setText(ResourceMgr.getString("LblSshPwd"));
        this.labelPassword.setToolTipText(ResourceMgr.getString("d_LblSshPwd"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelPassword, gridBagConstraints);
        this.password.setToolTipText(ResourceMgr.getString("d_LblSshPwd"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.password, gridBagConstraints);
        this.labelSshPort.setLabelFor(this.sshPort);
        this.labelSshPort.setText(ResourceMgr.getString("LblSshPort"));
        this.labelSshPort.setToolTipText(ResourceMgr.getString("d_LblSshPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelSshPort, gridBagConstraints);
        this.sshPort.setToolTipText(ResourceMgr.getString("d_LblSshPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.sshPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.keyPassFile, gridBagConstraints);
        this.labelKeyPass.setText(ResourceMgr.getString("LblSshKeyFile"));
        this.labelKeyPass.setToolTipText(ResourceMgr.getString("d_LblSshKeyFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelKeyPass, gridBagConstraints);
        this.useAgent.setText(ResourceMgr.getString("LblSshUseAgent"));
        this.useAgent.setToolTipText(ResourceMgr.getString("d_LblSshUseAgent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 1, 0, 0);
        this.add((Component)this.useAgent, gridBagConstraints);
        this.labelConfigName.setText(ResourceMgr.getString("LblSshCfgName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelConfigName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.configName, gridBagConstraints);
    }
}

