/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import workbench.resource.GuiSettings;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.StringUtil;

public class TagListModel
implements ListModel<String> {
    private final List<String> elements;
    private final List<String> filtered;
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>(1);

    public TagListModel(Collection<String> collection) {
        this.elements = new ArrayList<String>(collection);
        this.filtered = new ArrayList<String>(this.elements.size());
        this.elements.sort(CaseInsensitiveComparator.INSTANCE);
    }

    public void clear() {
        this.elements.clear();
        this.filtered.clear();
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public String getElementAt(int n) {
        return this.elements.get(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    public synchronized void applyFilter(String string) {
        this.elements.addAll(this.filtered);
        this.filtered.clear();
        if (StringUtil.isNonEmpty(string)) {
            string = string.toLowerCase();
            for (String string2 : this.elements) {
                if (GuiSettings.getTagCompletionUseContainsFilter()) {
                    if (string2.toLowerCase().contains(string)) continue;
                    this.filtered.add(string2);
                    continue;
                }
                if (string2.toLowerCase().startsWith(string)) continue;
                this.filtered.add(string2);
            }
            this.elements.removeAll(this.filtered);
        }
        this.elements.sort(CaseInsensitiveComparator.INSTANCE);
        this.fireDataChanged();
    }

    private void fireDataChanged() {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize() - 1);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }
}

