/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import workbench.gui.actions.WbAction;
import workbench.gui.completion.CompletionSearchField;
import workbench.gui.completion.QuickSearchList;
import workbench.gui.components.StringPropertyEditor;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.profiles.TagListModel;
import workbench.interfaces.QuickFilter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class TagSearchPopup
implements FocusListener,
MouseListener,
KeyListener,
WindowListener,
QuickSearchList {
    private final String wordBoundaries = ", ";
    private CompletionSearchField searchField;
    private JTextComponent inputField;
    private JScrollPane scroll;
    private JList<String> elementList;
    private TagListModel data;
    private JWindow window;
    private QuickFilter filter;
    private boolean ignoreSearchChange;

    public TagSearchPopup(JTextComponent jTextComponent, Set<String> set) {
        this(jTextComponent, set, null);
    }

    public TagSearchPopup(JTextComponent jTextComponent, Set<String> set, QuickFilter quickFilter) {
        this.inputField = jTextComponent;
        this.filter = quickFilter;
        this.elementList = new JList();
        this.data = new TagListModel(set);
        this.elementList.setModel(this.data);
        this.elementList.setSelectionMode(2);
        this.elementList.addFocusListener(this);
        this.elementList.addMouseListener(this);
        this.elementList.addKeyListener(this);
        int n = this.data.getSize();
        this.elementList.setVisibleRowCount(n < 12 ? n + 1 : 12);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.searchField = new CompletionSearchField(this, null);
        this.searchField.addFocusListener(this);
        int n2 = (int)this.searchField.getPreferredSize().getHeight();
        int n3 = n2 / 6;
        final Insets insets = new Insets(n3, n3, n3, n3);
        JPanel jPanel2 = new JPanel(new BorderLayout()){

            @Override
            public Insets getInsets() {
                return insets;
            }
        };
        jPanel2.add((Component)this.searchField, "Center");
        this.scroll = new JScrollPane(this.elementList);
        jPanel.add((Component)this.scroll, "Center");
        this.scroll.setColumnHeaderView(jPanel2);
        this.window = new JWindow(SwingUtilities.getWindowAncestor(this.inputField));
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.searchField);
        wbTraversalPolicy.addComponent(this.elementList);
        wbTraversalPolicy.setDefaultComponent(this.searchField);
        this.elementList.setFocusable(true);
        this.elementList.setFocusTraversalKeysEnabled(false);
        this.window.setFocusCycleRoot(true);
        this.window.setFocusTraversalPolicy(wbTraversalPolicy);
        this.window.getContentPane().add(jPanel);
        this.window.addKeyListener(this);
        this.window.addWindowListener(this);
    }

    public void showPopup() {
        try {
            Cloneable cloneable;
            int n;
            int n2;
            int n3;
            String string;
            String string2 = this.inputField.getText();
            String string3 = string = this.inputField.getSelectedText();
            if (",".equals(string) && string2.endsWith(",")) {
                n3 = this.inputField.getSelectionStart();
                this.inputField.select(n3 + 1, n3 + 1);
                string3 = "";
            }
            if (StringUtil.isEmptyString(string3)) {
                string3 = StringUtil.getWordLeftOfCursor(string2, this.inputField.getCaretPosition(), ", ");
            }
            if ((n3 = this.filterListByEntry(string3)) > -1 && StringUtil.isEmptyString(this.inputField.getSelectedText()) && (n2 = this.inputField.getCaretPosition()) > (n = StringUtil.findWordBoundary(string2, this.inputField.getCaretPosition(), ", ") + 1)) {
                this.inputField.select(n, n2);
            }
            Point point = this.inputField.getLocationOnScreen();
            point.y += this.inputField.getHeight();
            Border border = this.inputField.getBorder();
            if (border != null) {
                cloneable = border.getBorderInsets(this.inputField);
                point.y -= cloneable.top;
            }
            cloneable = this.inputField.modelToView(this.inputField.getCaretPosition());
            point.x += ((Rectangle)cloneable).x;
            EventQueue.invokeLater(() -> {
                if (this.window != null) {
                    this.window.setLocation(point);
                    this.window.pack();
                    Dimension dimension = this.window.getSize();
                    int n2 = this.elementList.getWidth() * 3;
                    if (n2 > dimension.width) {
                        dimension.width = n2;
                        this.window.setSize(dimension);
                    }
                    this.window.setVisible(true);
                    this.searchField.requestFocusInWindow();
                    if (n3 > -1) {
                        this.elementList.setSelectedIndex(n3);
                    }
                }
            });
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error displaying popup window", exception);
        }
    }

    private void dispose() {
        this.data.clear();
        this.elementList.removeKeyListener(this);
        this.elementList.removeFocusListener(this);
        this.elementList.removeMouseListener(this);
        this.searchField.removeFocusListener(this);
        if (this.inputField instanceof StringPropertyEditor) {
            ((StringPropertyEditor)this.inputField).ignoreNextFocus();
        }
        this.window.removeKeyListener(this);
        this.window.removeWindowListener(this);
        this.window.setVisible(false);
        this.window.dispose();
        this.window = null;
    }

    @Override
    public void quickSearchValueSelected() {
        this.closePopup(true);
    }

    private void closePopup(boolean bl) {
        if (this.window == null) {
            return;
        }
        try {
            if (bl) {
                this.doPaste();
            }
        }
        finally {
            this.dispose();
        }
    }

    private void doPaste() {
        boolean bl;
        int n;
        List<String> list = this.elementList.getSelectedValuesList();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        String string = "";
        for (String string2 : list) {
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + string2;
        }
        if (StringUtil.isBlank(string)) {
            return;
        }
        String string3 = this.inputField.getText().trim();
        int n2 = string3.length();
        String string4 = null;
        int n3 = n = this.inputField.getCaretPosition();
        boolean bl2 = bl = this.inputField.getSelectionEnd() > this.inputField.getSelectionStart();
        if (bl) {
            this.inputField.replaceSelection(string);
        } else if (n2 == 0) {
            string4 = string;
        } else if (n >= n2) {
            string4 = string3.endsWith(",") ? (String)string3 + string : (String)string3 + "," + string;
            n3 = string4.length();
        } else {
            StringBuilder stringBuilder = new StringBuilder(string3.length() + string.length() + 1);
            stringBuilder.append(string3);
            n3 = n + string.length();
            if (n + 1 < stringBuilder.length() && stringBuilder.charAt(n + 1) != ',') {
                string = string + ",";
                ++n3;
            }
            stringBuilder.insert(n, string);
            string4 = stringBuilder.toString();
        }
        if (string4 != null) {
            this.inputField.setText(string4);
            this.inputField.select(n3, n3);
        }
        if (this.filter != null) {
            EventQueue.invokeLater(this.filter::applyQuickFilter);
        }
    }

    @Override
    public void selectMatchingEntry(String string) {
        if (this.ignoreSearchChange) {
            return;
        }
        this.data.applyFilter(string);
        if (this.data.getSize() > 0) {
            this.elementList.setSelectedIndex(0);
            this.elementList.ensureIndexIsVisible(0);
        }
    }

    private int filterListByEntry(String string) {
        this.data.applyFilter(string);
        if (this.data.getSize() > 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getOppositeComponent() != this.elementList) {
            this.closePopup(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        boolean bl = WbAction.isCtrlPressed(mouseEvent.getModifiers());
        if (n == 2 || n == 1 && !bl) {
            this.closePopup(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        int n = this.elementList.getSelectedIndex();
        int n2 = -1;
        boolean bl = WbAction.isShiftPressed(keyEvent.getModifiers());
        boolean bl2 = false;
        switch (keyEvent.getKeyCode()) {
            case 9: {
                keyEvent.consume();
                break;
            }
            case 10: {
                this.closePopup(true);
                keyEvent.consume();
                break;
            }
            case 27: {
                this.closePopup(false);
                keyEvent.consume();
                break;
            }
            case 38: {
                if (n > 0) {
                    n2 = n - 1;
                }
                if (n2 == -1) break;
                if (bl) {
                    this.elementList.addSelectionInterval(n2, n2);
                } else {
                    this.elementList.setSelectedIndex(n2);
                }
                this.elementList.ensureIndexIsVisible(n2);
                bl2 = true;
                keyEvent.consume();
                break;
            }
            case 40: {
                if (bl && ((int[])(object = this.elementList.getSelectedIndices())).length > 1) {
                    n = object[((int[])object).length - 1];
                }
                if (n < this.data.getSize() - 1) {
                    n2 = n + 1;
                }
                if (n2 == -1) break;
                if (bl) {
                    this.elementList.addSelectionInterval(n2, n2);
                } else {
                    this.elementList.setSelectedIndex(n2);
                }
                this.elementList.ensureIndexIsVisible(n2);
                bl2 = true;
                keyEvent.consume();
            }
        }
        if (bl2 && this.searchField != null) {
            try {
                this.ignoreSearchChange = true;
                object = this.elementList.getSelectedValue();
                if (object != null) {
                    this.searchField.setText((String)object);
                    this.searchField.selectAll();
                }
            }
            finally {
                this.ignoreSearchChange = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.dispose();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void closeQuickSearch() {
        this.closePopup(false);
    }
}

