/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.profiles.ObjectFilterTemplate;
import workbench.resource.IconMgr;

class TemplateListEditor
extends JPanel
implements ListSelectionListener,
ActionListener {
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private JScrollPane jScrollPane1;
    private JList templateList;

    TemplateListEditor() {
        this.initComponents();
        this.templateList.getSelectionModel().addListSelectionListener(this);
        this.btnUp.addActionListener(this);
        this.btnDown.addActionListener(this);
        this.btnRemove.addActionListener(this);
    }

    public void setTemplates(List<ObjectFilterTemplate> list) {
        DefaultListModel<ObjectFilterTemplate> defaultListModel = new DefaultListModel<ObjectFilterTemplate>();
        for (ObjectFilterTemplate objectFilterTemplate : list) {
            defaultListModel.addElement(objectFilterTemplate);
        }
        this.templateList.setModel(defaultListModel);
        this.templateList.getSelectionModel().clearSelection();
        this.checkButtons();
    }

    public List<ObjectFilterTemplate> getTemplates() {
        int n = this.templateList.getModel().getSize();
        ArrayList<ObjectFilterTemplate> arrayList = new ArrayList<ObjectFilterTemplate>(n);
        for (int i = 0; i < n; ++i) {
            ObjectFilterTemplate objectFilterTemplate = (ObjectFilterTemplate)this.templateList.getModel().getElementAt(i);
            arrayList.add(objectFilterTemplate);
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.templateList.getSelectedIndices();
        int n = -1;
        if (nArray.length == 1) {
            n = nArray[0];
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.templateList.getModel();
        int n2 = defaultListModel.getSize();
        if (actionEvent.getSource() == this.btnRemove && nArray.length > 0) {
            this.removeSelected();
        } else if (actionEvent.getSource() == this.btnUp && n > 0) {
            this.swap(n, n - 1);
        } else if (actionEvent.getSource() == this.btnDown && n > -1 && n < n2 - 1) {
            this.swap(n, n + 1);
        }
    }

    private void removeSelected() {
        int[] nArray = this.templateList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        Arrays.sort(nArray);
        DefaultListModel defaultListModel = (DefaultListModel)this.templateList.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            defaultListModel.remove(nArray[i]);
        }
    }

    private void swap(int n, int n2) {
        DefaultListModel defaultListModel = (DefaultListModel)this.templateList.getModel();
        Object e = defaultListModel.get(n);
        Object e2 = defaultListModel.get(n2);
        defaultListModel.set(n, e2);
        defaultListModel.set(n2, e);
        this.templateList.setSelectedIndex(n2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkButtons();
    }

    private void checkButtons() {
        int n = this.templateList.getSelectedIndex();
        int n2 = this.templateList.getModel().getSize();
        this.btnRemove.setEnabled(n > -1);
        this.btnUp.setEnabled(n > 0);
        this.btnDown.setEnabled(n > -1 && n < n2 - 1);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.templateList = new JList();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.setLayout(new GridBagLayout());
        this.templateList.setVerifyInputWhenFocusTarget(false);
        this.templateList.setVisibleRowCount(5);
        this.jScrollPane1.setViewportView(this.templateList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnRemove.setIcon(IconMgr.getInstance().getLabelIcon("delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnUp.setIcon(IconMgr.getInstance().getLabelIcon("Up"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(16, 8, 0, 0);
        this.add((Component)this.btnUp, gridBagConstraints);
        this.btnDown.setIcon(IconMgr.getInstance().getLabelIcon("Down"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.add((Component)this.btnDown, gridBagConstraints);
    }
}

