/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbTable;
import workbench.resource.GuiSettings;

public abstract class AbstractDialogRenderer
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
TableCellRenderer {
    protected JPanel displayPanel;
    protected Object currentValue;
    protected WbTable currentTable;
    protected int currentRow;
    protected int currentColumn;
    private Color alternateColor = GuiSettings.getAlternateRowColor();
    private Color nullColor = GuiSettings.getNullColor();
    private boolean useAlternatingColors = GuiSettings.getUseAlternateRowColor();

    public AbstractDialogRenderer() {
        this.displayPanel = this.createDisplayPanel();
    }

    protected abstract JPanel createDisplayPanel();

    public void setFont(Font font) {
        this.displayPanel.setFont(font);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getComponent(jTable, object, true, bl, n, n2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getComponent(jTable, object, bl, bl2, n, n2);
    }

    private Component getComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.displayPanel.setForeground(jTable.getSelectionForeground());
            this.displayPanel.setBackground(jTable.getSelectionBackground());
        } else {
            this.displayPanel.setForeground(jTable.getForeground());
            if (object == null && this.nullColor != null) {
                this.displayPanel.setBackground(this.nullColor);
            } else if (this.useAlternatingColors && n % 2 == 1) {
                this.displayPanel.setBackground(this.alternateColor);
            } else {
                this.displayPanel.setBackground(jTable.getBackground());
            }
        }
        if (bl2) {
            this.displayPanel.setBorder(WbSwingUtilities.FOCUSED_CELL_BORDER);
        } else {
            this.displayPanel.setBorder(WbSwingUtilities.EMPTY_BORDER);
        }
        Font font = jTable.getFont();
        this.setFont(font);
        this.currentValue = object;
        this.currentRow = n;
        this.currentColumn = n2;
        this.currentTable = (WbTable)jTable;
        this.setCurrentValue(object);
        return this.displayPanel;
    }

    protected abstract void setCurrentValue(Object var1);

    public void setBackground(Color color) {
        this.displayPanel.setBackground(color);
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.cancelCellEditing();
        boolean bl = WbAction.isCtrlPressed(actionEvent);
        boolean bl2 = WbAction.isShiftPressed(actionEvent);
        boolean bl3 = true;
        TableModel tableModel = this.currentTable.getModel();
        if (tableModel instanceof DataStoreTableModel) {
            bl3 = ((DataStoreTableModel)tableModel).getAllowEditing();
        }
        this.showEditDialog(bl3, bl, bl2);
    }

    protected abstract void showEditDialog(boolean var1, boolean var2, boolean var3);
}

