/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.io.File;
import javax.swing.JPanel;
import workbench.WbManager;
import workbench.gui.components.BlobHandler;
import workbench.gui.renderer.AbstractDialogRenderer;
import workbench.gui.renderer.ButtonDisplayPanel;
import workbench.resource.ResourceMgr;

public class BlobColumnRenderer
extends AbstractDialogRenderer {
    private ButtonDisplayPanel blobPanel;

    @Override
    protected JPanel createDisplayPanel() {
        this.blobPanel = new ButtonDisplayPanel();
        this.blobPanel.addActionListener(this);
        this.blobPanel.setToolTipText(ResourceMgr.getDescription("LblShowBlobInfo", true));
        return this.blobPanel;
    }

    @Override
    protected void setCurrentValue(Object object) {
        if (object == null) {
            this.blobPanel.setDisplayValue("");
        } else {
            this.blobPanel.setDisplayValue("(BLOB)");
        }
    }

    @Override
    protected void showEditDialog(boolean bl, boolean bl2, boolean bl3) {
        BlobHandler blobHandler = new BlobHandler();
        if (bl2) {
            blobHandler.showBlobAsText(this.currentValue);
        } else if (bl3) {
            blobHandler.showBlobAsImage(this.currentValue);
        } else {
            blobHandler.showBlobInfoDialog(WbManager.getInstance().getCurrentWindow(), this.currentValue, !bl);
        }
        if (bl) {
            File file = blobHandler.getUploadFile();
            if (file != null) {
                this.currentTable.setValueAt(file, this.currentRow, this.currentColumn);
            } else if (blobHandler.isChanged()) {
                this.currentTable.setValueAt(blobHandler.getNewValue(), this.currentRow, this.currentColumn);
            } else if (blobHandler.setToNull()) {
                this.currentTable.setValueAt(null, this.currentRow, this.currentColumn);
            }
        }
    }
}

