/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.Component;
import java.awt.Insets;
import java.io.StringReader;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import workbench.gui.WbSwingUtilities;
import workbench.gui.renderer.ToolTipRenderer;
import workbench.gui.renderer.WbRenderer;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class TextAreaRenderer
extends ToolTipRenderer
implements TableCellRenderer,
WbRenderer {
    protected JTextArea textDisplay = new JTextArea(){

        @Override
        public Insets getInsets() {
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public Insets getMargin() {
            return WbSwingUtilities.getEmptyInsets();
        }
    };
    protected boolean useStringReader;

    public TextAreaRenderer() {
        boolean bl = GuiSettings.getWrapMultilineRenderer();
        this.useStringReader = GuiSettings.getUseReaderForMultilineRenderer();
        this.textDisplay.setWrapStyleWord(bl);
        this.textDisplay.setLineWrap(bl);
        this.textDisplay.setAutoscrolls(false);
        this.textDisplay.setTabSize(Settings.getInstance().getEditorTabWidth());
        this.textDisplay.setBorder(WbSwingUtilities.EMPTY_BORDER);
    }

    @Override
    public int getHorizontalAlignment() {
        return 2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.initDisplay(jTable, object, bl, bl2, n, n2);
        this.textDisplay.setFont(jTable.getFont());
        if (bl2) {
            this.textDisplay.setBorder(WbSwingUtilities.FOCUSED_CELL_BORDER);
        } else {
            this.textDisplay.setBorder(WbSwingUtilities.EMPTY_BORDER);
        }
        this.prepareDisplay(object);
        this.textDisplay.setBackground(this.getBackgroundColor());
        this.textDisplay.setForeground(this.getForegroundColor());
        return this.textDisplay;
    }

    @Override
    public void prepareDisplay(Object object) {
        boolean bl = this.isNull = object == null;
        if (this.isNull) {
            this.displayValue = this.rendererSetup == null ? null : this.rendererSetup.nullString;
            this.textDisplay.setText(this.displayValue);
            this.textDisplay.setToolTipText(null);
        } else {
            try {
                this.displayValue = (String)object;
            }
            catch (ClassCastException classCastException) {
                this.displayValue = object.toString();
            }
            if (this.useStringReader) {
                try {
                    StringReader stringReader = new StringReader(this.displayValue);
                    this.textDisplay.read(stringReader, null);
                }
                catch (Throwable throwable) {}
            } else {
                this.textDisplay.setText(this.displayValue);
            }
            if (this.showTooltip) {
                this.textDisplay.setToolTipText(StringUtil.getMaxSubstring(this.displayValue, this.maxTooltipSize));
            }
        }
    }
}

