/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.db.objectcache.ObjectCacheStorage;
import workbench.gui.WbSwingUtilities;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ColumnSortType;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.DurationNumber;

public class CompletionOptionsPanel
extends JPanel
implements Restoreable,
ValidatingComponent {
    private JCheckBox addParens;
    private JCheckBox closePopup;
    private JComboBox completionColumnSort;
    private JComboBox completionPasteCase;
    private JCheckBox cyleEntries;
    private JCheckBox filterSearch;
    private JPanel jPanel1;
    private JLabel localStorageLabel;
    private JComboBox localStorageType;
    private JTextField maxAgeField;
    private JLabel maxAgeLabel;
    private JCheckBox partialMatch;
    private JLabel pasteLabel;
    private JLabel pasterOrderLabel;
    private JCheckBox preferUSING;
    private JCheckBox sortColumns;

    public CompletionOptionsPanel() {
        this.initComponents();
        DefaultComboBoxModel<ObjectCacheStorage> defaultComboBoxModel = new DefaultComboBoxModel<ObjectCacheStorage>(ObjectCacheStorage.values());
        this.localStorageType.setModel(defaultComboBoxModel);
        WbSwingUtilities.setMinimumSizeFromCols(this.maxAgeField);
    }

    @Override
    public void restoreSettings() {
        this.completionPasteCase.setModel(new DefaultComboBoxModel<GeneratedIdentifierCase>(GeneratedIdentifierCase.values()));
        GeneratedIdentifierCase generatedIdentifierCase = Settings.getInstance().getAutoCompletionPasteCase();
        this.completionPasteCase.setSelectedItem((Object)generatedIdentifierCase);
        this.completionColumnSort.setModel(new DefaultComboBoxModel<ColumnSortType>(ColumnSortType.values()));
        ColumnSortType columnSortType = Settings.getInstance().getAutoCompletionColumnSortType();
        this.completionColumnSort.setSelectedItem((Object)columnSortType);
        this.closePopup.setSelected(Settings.getInstance().getCloseAutoCompletionWithSearch());
        this.filterSearch.setSelected(GuiSettings.getFilterCompletionSearch());
        this.partialMatch.setSelected(GuiSettings.getPartialCompletionSearch());
        this.sortColumns.setSelected(GuiSettings.getSortCompletionColumns());
        this.cyleEntries.setSelected(GuiSettings.getCycleCompletionPopup());
        this.addParens.setSelected(Settings.getInstance().getJoinCompletionUseParens());
        this.preferUSING.setSelected(Settings.getInstance().getJoinCompletionPreferUSING());
        ObjectCacheStorage objectCacheStorage = GuiSettings.getLocalStorageForObjectCache();
        this.localStorageType.setSelectedItem((Object)objectCacheStorage);
        this.localStorageType.doLayout();
        this.maxAgeField.setText(GuiSettings.getLocalStorageMaxAge());
        WbSwingUtilities.makeEqualWidth(this.completionColumnSort, this.completionPasteCase, this.localStorageType);
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        GeneratedIdentifierCase generatedIdentifierCase = (GeneratedIdentifierCase)((Object)this.completionPasteCase.getSelectedItem());
        settings.setAutoCompletionPasteCase(generatedIdentifierCase);
        settings.setCloseAutoCompletionWithSearch(this.closePopup.isSelected());
        ColumnSortType columnSortType = (ColumnSortType)((Object)this.completionColumnSort.getSelectedItem());
        settings.setAutoCompletionColumnSort(columnSortType);
        settings.setJoinCompletionPreferUSING(this.preferUSING.isSelected());
        settings.setJoinCompletionUseParens(this.addParens.isSelected());
        GuiSettings.setFilterCompletionSearch(this.filterSearch.isSelected());
        GuiSettings.setPartialCompletionSearch(this.partialMatch.isSelected());
        GuiSettings.setSortCompletionColumns(this.sortColumns.isSelected());
        GuiSettings.setCycleCompletionPopup(this.cyleEntries.isSelected());
        ObjectCacheStorage objectCacheStorage = (ObjectCacheStorage)((Object)this.localStorageType.getSelectedItem());
        GuiSettings.setLocalStorageForObjectCache(objectCacheStorage);
        GuiSettings.setLocalStorageMaxAge(this.maxAgeField.getText().trim().toLowerCase());
    }

    @Override
    public boolean validateInput() {
        DurationNumber durationNumber = new DurationNumber();
        String string = this.maxAgeField.getText();
        if (durationNumber.isValid(string)) {
            return true;
        }
        WbSwingUtilities.showErrorMessageKey(this, "ErrInvalidAge");
        this.maxAgeField.selectAll();
        WbSwingUtilities.requestFocus(this.maxAgeField);
        return false;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    private void initComponents() {
        this.pasteLabel = new JLabel();
        this.completionPasteCase = new JComboBox();
        this.closePopup = new JCheckBox();
        this.completionColumnSort = new JComboBox();
        this.pasterOrderLabel = new JLabel();
        this.sortColumns = new JCheckBox();
        this.partialMatch = new JCheckBox();
        this.filterSearch = new JCheckBox();
        this.cyleEntries = new JCheckBox();
        this.localStorageLabel = new JLabel();
        this.localStorageType = new JComboBox();
        this.maxAgeLabel = new JLabel();
        this.maxAgeField = new JTextField();
        this.jPanel1 = new JPanel();
        this.addParens = new JCheckBox();
        this.preferUSING = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.pasteLabel.setText(ResourceMgr.getString("LblPasteCase"));
        this.pasteLabel.setToolTipText(ResourceMgr.getString("d_LblPasteCase"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.pasteLabel, gridBagConstraints);
        this.completionPasteCase.setModel(new DefaultComboBoxModel<String>(new String[]{"Lowercase", "Uppercase", "As is"}));
        this.completionPasteCase.setToolTipText(ResourceMgr.getDescription("LblPasteCase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 11, 0, 15);
        this.add((Component)this.completionPasteCase, gridBagConstraints);
        this.closePopup.setText(ResourceMgr.getString("TxtCloseCompletion"));
        this.closePopup.setToolTipText(ResourceMgr.getString("d_TxtCloseCompletion"));
        this.closePopup.setBorder(null);
        this.closePopup.setHorizontalAlignment(2);
        this.closePopup.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.closePopup, gridBagConstraints);
        this.completionColumnSort.setToolTipText(ResourceMgr.getDescription("LblPasteSort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 11, 0, 15);
        this.add((Component)this.completionColumnSort, gridBagConstraints);
        this.pasterOrderLabel.setText(ResourceMgr.getString("LblPasteSort"));
        this.pasterOrderLabel.setToolTipText(ResourceMgr.getString("d_LblPasteSort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.pasterOrderLabel, gridBagConstraints);
        this.sortColumns.setText(ResourceMgr.getString("LblCompletionSortCols"));
        this.sortColumns.setToolTipText(ResourceMgr.getString("d_LblCompletionSortCols"));
        this.sortColumns.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.sortColumns, gridBagConstraints);
        this.partialMatch.setText(ResourceMgr.getString("LblCompletionPartialMatch"));
        this.partialMatch.setToolTipText(ResourceMgr.getString("d_LblCompletionPartialMatch"));
        this.partialMatch.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.partialMatch, gridBagConstraints);
        this.filterSearch.setText(ResourceMgr.getString("LblCompletionFilterSearch"));
        this.filterSearch.setToolTipText(ResourceMgr.getString("d_LblCompletionFilterSearch"));
        this.filterSearch.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.filterSearch, gridBagConstraints);
        this.cyleEntries.setText(ResourceMgr.getString("LblCompletionCycle"));
        this.cyleEntries.setToolTipText(ResourceMgr.getString("d_LblCompletionCycle"));
        this.cyleEntries.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.cyleEntries, gridBagConstraints);
        this.localStorageLabel.setText(ResourceMgr.getString("LblLocalStorageType"));
        this.localStorageLabel.setToolTipText(ResourceMgr.getString("d_LblLocalStorageType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.localStorageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 11, 0, 15);
        this.add((Component)this.localStorageType, gridBagConstraints);
        this.maxAgeLabel.setText(ResourceMgr.getString("LblLocalMaxAge"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.maxAgeLabel, gridBagConstraints);
        this.maxAgeField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 11, 0, 15);
        this.add((Component)this.maxAgeField, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("MnuTxtAutoCompleteJoin")));
        this.jPanel1.setLayout(new GridBagLayout());
        this.addParens.setText(ResourceMgr.getString("LblJoinComplParens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel1.add((Component)this.addParens, gridBagConstraints);
        this.preferUSING.setText(ResourceMgr.getString("LblJoinComplUSING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.preferUSING, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 10);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }
}

