/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.NumberField;
import workbench.gui.help.HelpManager;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;
import workbench.util.WbNumberFormatter;

public class DataFormattingOptionsPanel
extends JPanel
implements Restoreable,
ValidatingComponent,
MouseListener {
    private JLabel dateFormatLabel;
    private JTextField dateFormatTextField;
    private JTextField decimalField;
    private JTextField decimalFormat;
    private JLabel decimalFormatLabel;
    private JLabel decimalLabel;
    private JLabel groupLabel;
    private JTextField groupSeparator;
    private JLabel helpLabel;
    private JTextField intFormat;
    private JLabel intFormatLabel;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField maxDigitsField;
    private JLabel maxDigitsLabel;
    private JLabel numberFormatHelp;
    private JCheckBox oraDateFix;
    private JTextField timeFormat;
    private JLabel timeFormatLabel;
    private JLabel timestampFormatLabel;
    private JTextField timestampFormatTextField;

    public DataFormattingOptionsPanel() {
        this.initComponents();
        WbSwingUtilities.setMinimumSize(this.decimalField, 5);
        WbSwingUtilities.setMinimumSize(this.groupSeparator, 5);
        WbSwingUtilities.setMinimumSize(this.maxDigitsField, 5);
        WbSwingUtilities.setMinimumSize(this.intFormat, 25);
        WbSwingUtilities.setMinimumSize(this.decimalFormat, 25);
        WbSwingUtilities.setMinimumSize(this.timeFormat, 25);
        WbSwingUtilities.setMinimumSize(this.timestampFormatTextField, 25);
        WbSwingUtilities.setMinimumSize(this.dateFormatTextField, 25);
    }

    @Override
    public void restoreSettings() {
        this.dateFormatTextField.setText(Settings.getInstance().getDefaultDateFormat());
        this.dateFormatTextField.setCaretPosition(0);
        this.timestampFormatTextField.setText(Settings.getInstance().getDefaultTimestampFormat());
        this.timestampFormatTextField.setCaretPosition(0);
        this.decimalField.setText(Settings.getInstance().getDecimalSymbol());
        this.timeFormat.setText(Settings.getInstance().getDefaultTimeFormat());
        this.maxDigitsField.setText(Integer.toString(Settings.getInstance().getMaxFractionDigits()));
        this.oraDateFix.setSelected(Settings.getInstance().fixOracleDateType());
        this.groupSeparator.setText(Settings.getInstance().getDecimalGroupCharacter());
        this.intFormat.setText(Settings.getInstance().getIntegerFormatString());
        this.decimalFormat.setText(Settings.getInstance().getDecimalFormatString());
    }

    @Override
    public void saveSettings() {
        Settings.getInstance().setDefaultDateFormat(this.dateFormatTextField.getText());
        Settings.getInstance().setDefaultTimeFormat(this.timeFormat.getText());
        Settings.getInstance().setDefaultTimestampFormat(this.timestampFormatTextField.getText());
        Settings.getInstance().setMaxFractionDigits(((NumberField)this.maxDigitsField).getValue());
        Settings.getInstance().setDecimalSymbol(StringUtil.trimToNull(this.decimalField.getText()));
        Settings.getInstance().setDecimalGroupCharacter(this.groupSeparator.getText());
        Settings.getInstance().setDecimalFormatString(StringUtil.trimToNull(this.decimalFormat.getText()));
        Settings.getInstance().setIntegerFormatString(StringUtil.trimToNull(this.intFormat.getText()));
        Settings.getInstance().setFixOracleDateType(this.oraDateFix.isSelected());
    }

    private char getDecimalSeparator() {
        String string = StringUtil.trimToNull(this.decimalField.getText());
        if (string == null) {
            return '.';
        }
        return string.charAt(0);
    }

    private char getGroupSymbol() {
        String string = StringUtil.trimToNull(this.groupSeparator.getText());
        if (string == null) {
            return ',';
        }
        return string.charAt(0);
    }

    @Override
    public boolean validateInput() {
        String string;
        String string2 = this.dateFormatTextField.getText();
        if (StringUtil.isNonBlank(string2) && (string = StringUtil.isDatePatternValid(string2)) != null) {
            String string3 = ResourceMgr.getFormattedString("ErrInvalidInput", this.dateFormatLabel.getText(), string);
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string3);
            return false;
        }
        string2 = this.timestampFormatTextField.getText();
        if (StringUtil.isNonBlank(string2) && (string = StringUtil.isDatePatternValid(string2)) != null) {
            String string4 = ResourceMgr.getFormattedString("ErrInvalidInput", this.timestampFormatLabel.getText(), string);
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string4);
            return false;
        }
        string2 = this.timeFormat.getText();
        if (StringUtil.isNonBlank(string2) && (string = StringUtil.isDatePatternValid(string2)) != null) {
            String string5 = ResourceMgr.getFormattedString("ErrInvalidInput", this.timeFormatLabel.getText(), string);
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string5);
            return false;
        }
        string2 = this.decimalFormat.getText();
        if (StringUtil.isNonBlank(string2)) {
            try {
                new WbNumberFormatter(string2, this.getDecimalSeparator(), this.getGroupSymbol());
            }
            catch (Throwable throwable) {
                String string6 = ResourceMgr.getFormattedString("ErrInvalidInput", this.decimalFormatLabel.getText(), throwable.getMessage());
                WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string6);
                return false;
            }
        }
        if (StringUtil.isNonBlank(string2 = this.intFormat.getText())) {
            try {
                new WbNumberFormatter(string2, this.getDecimalSeparator(), this.getGroupSymbol());
            }
            catch (Throwable throwable) {
                String string7 = ResourceMgr.getFormattedString("ErrInvalidInput", this.intFormatLabel.getText(), throwable.getMessage());
                WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string7);
                return false;
            }
        }
        return true;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    private void initComponents() {
        this.dateFormatLabel = new JLabel();
        this.dateFormatTextField = new JTextField();
        this.timestampFormatLabel = new JLabel();
        this.timestampFormatTextField = new JTextField();
        this.timeFormatLabel = new JLabel();
        this.timeFormat = new JTextField();
        this.oraDateFix = new JCheckBox();
        this.helpLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.decimalLabel = new JLabel();
        this.decimalField = new JTextField();
        this.groupSeparator = new JTextField();
        this.groupLabel = new JLabel();
        this.maxDigitsLabel = new JLabel();
        this.intFormatLabel = new JLabel();
        this.decimalFormatLabel = new JLabel();
        this.decimalFormat = new JTextField();
        this.intFormat = new JTextField();
        this.maxDigitsField = new NumberField();
        this.numberFormatHelp = new JLabel();
        this.setLayout(new GridBagLayout());
        this.dateFormatLabel.setText(ResourceMgr.getString("LblDateFormat"));
        this.dateFormatLabel.setToolTipText(ResourceMgr.getString("d_LblDateFormat"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.dateFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 7, 0, 11);
        this.add((Component)this.dateFormatTextField, gridBagConstraints);
        this.timestampFormatLabel.setText(ResourceMgr.getString("LblTimestampFormat"));
        this.timestampFormatLabel.setToolTipText(ResourceMgr.getDescription("LblTimestampFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.timestampFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 0, 11);
        this.add((Component)this.timestampFormatTextField, gridBagConstraints);
        this.timeFormatLabel.setText(ResourceMgr.getString("LblTimeFormat"));
        this.timeFormatLabel.setToolTipText(ResourceMgr.getDescription("LblTimeFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.timeFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 0, 11);
        this.add((Component)this.timeFormat, gridBagConstraints);
        this.oraDateFix.setText(ResourceMgr.getString("LblOraDataTS"));
        this.oraDateFix.setToolTipText(ResourceMgr.getString("d_LblOraDataTS"));
        this.oraDateFix.setBorder(null);
        this.oraDateFix.setDoubleBuffered(true);
        this.oraDateFix.setHorizontalAlignment(2);
        this.oraDateFix.setHorizontalTextPosition(4);
        this.oraDateFix.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.oraDateFix, gridBagConstraints);
        this.helpLabel.setText(ResourceMgr.getString("LblFmtHelp"));
        this.helpLabel.setCursor(new Cursor(12));
        this.helpLabel.addMouseListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.helpLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 8, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.decimalLabel.setText(ResourceMgr.getString("LblDecimalSymbol"));
        this.decimalLabel.setToolTipText(ResourceMgr.getDescription("LblDecimalSymbol"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.jPanel2.add((Component)this.decimalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 9);
        this.jPanel2.add((Component)this.decimalField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 9);
        this.jPanel2.add((Component)this.groupSeparator, gridBagConstraints);
        this.groupLabel.setText(ResourceMgr.getString("LblDecimalGroup"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.groupLabel, gridBagConstraints);
        this.maxDigitsLabel.setText(ResourceMgr.getString("LblMaxDigits"));
        this.maxDigitsLabel.setToolTipText(ResourceMgr.getDescription("LblMaxDigits"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.maxDigitsLabel, gridBagConstraints);
        this.intFormatLabel.setText(ResourceMgr.getString("LblIntegerFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.intFormatLabel, gridBagConstraints);
        this.decimalFormatLabel.setText(ResourceMgr.getString("LblDecimalFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel2.add((Component)this.decimalFormatLabel, gridBagConstraints);
        this.decimalFormat.setToolTipText(ResourceMgr.getString("d_LblDecimalFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 9);
        this.jPanel2.add((Component)this.decimalFormat, gridBagConstraints);
        this.intFormat.setToolTipText(ResourceMgr.getString("d_LblIntegerFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 9);
        this.jPanel2.add((Component)this.intFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 9);
        this.jPanel2.add((Component)this.maxDigitsField, gridBagConstraints);
        this.numberFormatHelp.setText(ResourceMgr.getString("LblFmtHelp"));
        this.numberFormatHelp.setCursor(new Cursor(12));
        this.numberFormatHelp.addMouseListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.numberFormatHelp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 56);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.helpLabel) {
            this.helpLabelMouseClicked(mouseEvent);
        } else if (mouseEvent.getSource() == this.numberFormatHelp) {
            this.numberFormatHelpMouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void helpLabelMouseClicked(MouseEvent mouseEvent) {
        HelpManager.showDateFormatHelp();
    }

    private void numberFormatHelpMouseClicked(MouseEvent mouseEvent) {
        HelpManager.showNumberFormatHelp();
    }
}

