/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.NumberField;
import workbench.gui.components.TextFieldWidthAdjuster;
import workbench.gui.components.WbFilePicker;
import workbench.gui.editor.BracketCompleter;
import workbench.gui.sql.FileReloadType;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.AutoFileSaveType;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.EncodingUtil;
import workbench.util.StringUtil;

public class EditorOptionsPanel
extends JPanel
implements Restoreable,
ActionListener,
ValidatingComponent {
    private JTextField autoCloseBrackets;
    private JComboBox<String> autoFileSave;
    private WbFilePicker defaultDir;
    private JLabel editorTabSizeLabel;
    private JTextField electricScroll;
    private JLabel electricScrollLabel;
    private JComboBox<String> encodings;
    private JComboBox externalLineEnding;
    private JLabel externalLineEndingLabel;
    private JCheckBox followCurrentDir;
    private JTextField historySizeField;
    private JLabel historySizeLabel;
    private JCheckBox includeFilesInHistory;
    private JComboBox internalLineEnding;
    private JLabel internalLineEndingLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextField noWordSep;
    private JLabel noWordSepLabel;
    private JLabel reloadLabel;
    private JComboBox reloadType;
    private JCheckBox rightClickMovesCursor;
    private JCheckBox storeDirInWksp;
    private JTextField tabSize;
    private JCheckBox useTabs;
    private JLabel wheelScrollLabel;
    private JTextField wheelScrollLines;

    public EditorOptionsPanel() {
        this.initComponents();
        TextFieldWidthAdjuster textFieldWidthAdjuster = new TextFieldWidthAdjuster();
        textFieldWidthAdjuster.adjustAllFields(this);
        this.defaultDir.setSelectDirectoryOnly(true);
        EncodingUtil.fetchEncodings();
    }

    @Override
    public void restoreSettings() {
        String[] stringArray = new String[]{ResourceMgr.getString("LblLTDefault"), ResourceMgr.getString("LblLTDos"), ResourceMgr.getString("LblLTUnix")};
        this.internalLineEnding.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.externalLineEnding.setModel(new DefaultComboBoxModel<String>(stringArray));
        String[] stringArray2 = new String[]{ResourceMgr.getString("LblOptNever"), ResourceMgr.getString("LblOptAuto"), ResourceMgr.getString("LblOptPrompt")};
        this.autoFileSave.setModel(new DefaultComboBoxModel<String>(stringArray2));
        AutoFileSaveType autoFileSaveType = Settings.getInstance().getAutoSaveExternalFiles();
        switch (autoFileSaveType) {
            case never: {
                this.autoFileSave.setSelectedIndex(0);
                break;
            }
            case always: {
                this.autoFileSave.setSelectedIndex(1);
                break;
            }
            default: {
                this.autoFileSave.setSelectedIndex(2);
            }
        }
        this.reloadType.setModel(new DefaultComboBoxModel<FileReloadType>(FileReloadType.values()));
        this.reloadType.doLayout();
        FileReloadType fileReloadType = GuiSettings.getReloadType();
        this.reloadType.setSelectedItem((Object)fileReloadType);
        String string = Settings.getInstance().getInteralLineEndingValue();
        this.internalLineEnding.setSelectedIndex(this.lineEndingValueToIndex(string));
        string = Settings.getInstance().getExternalLineEndingValue();
        this.externalLineEnding.setSelectedIndex(this.lineEndingValueToIndex(string));
        this.noWordSep.setText(Settings.getInstance().getEditorNoWordSep());
        this.useTabs.setSelected(Settings.getInstance().getEditorUseTabCharacter());
        this.followCurrentDir.setSelected(GuiSettings.getFollowFileDirectory());
        this.storeDirInWksp.setSelected(Settings.getInstance().getStoreScriptDirInWksp());
        File file = GuiSettings.getDefaultFileDir();
        if (file != null) {
            this.defaultDir.setFilename(file.getAbsolutePath());
        }
        this.defaultDir.setEnabled(this.followCurrentDir.isSelected());
        this.historySizeField.setText(Integer.toString(Settings.getInstance().getMaxHistorySize()));
        this.electricScroll.setText(Integer.toString(Settings.getInstance().getElectricScroll()));
        this.tabSize.setText(Settings.getInstance().getProperty("workbench.editor.tabwidth", "2"));
        this.autoCloseBrackets.setText(Settings.getInstance().getProperty("workbench.editor.completechars", ""));
        int n = GuiSettings.getWheelScrollLines();
        if (n <= 0) {
            this.wheelScrollLines.setText("");
        } else {
            this.wheelScrollLines.setText(Integer.toString(n));
        }
        WbSwingUtilities.makeEqualWidth(this.externalLineEnding, this.internalLineEnding);
        String[] stringArray3 = EncodingUtil.getEncodings();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray3);
        this.encodings.setModel(defaultComboBoxModel);
        String string2 = Settings.getInstance().getDefaultFileEncoding();
        this.encodings.setSelectedItem(string2);
    }

    private String indexToLineEndingValue(int n) {
        if (n == 1) {
            return "crlf";
        }
        if (n == 2) {
            return "lf";
        }
        return "default";
    }

    private int lineEndingValueToIndex(String string) {
        if ("crlf".equals(string)) {
            return 1;
        }
        if ("lf".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setMaxHistorySize(((NumberField)this.historySizeField).getValue());
        settings.setRightClickMovesCursor(this.rightClickMovesCursor.isSelected());
        settings.setEditorTabWidth(StringUtil.getIntValue(this.tabSize.getText(), 2));
        settings.setElectricScroll(StringUtil.getIntValue(this.electricScroll.getText(), -1));
        settings.setEditorNoWordSep(this.noWordSep.getText());
        String string = this.indexToLineEndingValue(this.internalLineEnding.getSelectedIndex());
        settings.setInternalEditorLineEnding(string);
        string = this.indexToLineEndingValue(this.externalLineEnding.getSelectedIndex());
        settings.setExternalEditorLineEnding(string);
        settings.setEditorUseTabCharacter(this.useTabs.isSelected());
        settings.setStoreScriptDirInWksp(this.storeDirInWksp.isSelected());
        GuiSettings.setDefaultFileDir(this.defaultDir.getFilename());
        GuiSettings.setFollowFileDirectory(this.followCurrentDir.isSelected());
        settings.setProperty("workbench.editor.completechars", this.autoCloseBrackets.getText());
        if (StringUtil.isNumber(this.wheelScrollLines.getText())) {
            int n = StringUtil.getIntValue(this.wheelScrollLines.getText(), -1);
            GuiSettings.setWheelScrollLines(n);
        }
        FileReloadType fileReloadType = (FileReloadType)((Object)this.reloadType.getSelectedItem());
        GuiSettings.setReloadType(fileReloadType);
        int n = this.autoFileSave.getSelectedIndex();
        switch (n) {
            case 0: {
                settings.setAutoSaveExternalFiles(AutoFileSaveType.never);
                break;
            }
            case 1: {
                settings.setAutoSaveExternalFiles(AutoFileSaveType.always);
                break;
            }
            default: {
                settings.setAutoSaveExternalFiles(AutoFileSaveType.ask);
            }
        }
        String string2 = (String)this.encodings.getSelectedItem();
        settings.setDefaultFileEncoding(string2);
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public boolean validateInput() {
        if (BracketCompleter.isValidDefinition(this.autoCloseBrackets.getText())) {
            return true;
        }
        WbSwingUtilities.showErrorMessageKey(this, "ErrAutoClsBrkt");
        EventQueue.invokeLater(this.autoCloseBrackets::requestFocusInWindow);
        return false;
    }

    private void initComponents() {
        this.editorTabSizeLabel = new JLabel();
        this.tabSize = new NumberField();
        this.historySizeLabel = new JLabel();
        this.historySizeField = new NumberField();
        this.electricScrollLabel = new JLabel();
        this.electricScroll = new NumberField();
        this.internalLineEndingLabel = new JLabel();
        this.internalLineEnding = new JComboBox();
        this.externalLineEndingLabel = new JLabel();
        this.externalLineEnding = new JComboBox();
        this.includeFilesInHistory = new JCheckBox();
        this.noWordSepLabel = new JLabel();
        this.useTabs = new JCheckBox();
        this.noWordSep = new JTextField();
        this.jPanel1 = new JPanel();
        this.followCurrentDir = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.defaultDir = new WbFilePicker();
        this.storeDirInWksp = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.autoCloseBrackets = new JTextField();
        this.wheelScrollLabel = new JLabel();
        this.wheelScrollLines = new NumberField();
        this.reloadLabel = new JLabel();
        this.reloadType = new JComboBox();
        this.rightClickMovesCursor = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.autoFileSave = new JComboBox();
        this.jLabel4 = new JLabel();
        this.encodings = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.editorTabSizeLabel.setLabelFor(this.tabSize);
        this.editorTabSizeLabel.setText(ResourceMgr.getString("LblTabWidth"));
        this.editorTabSizeLabel.setToolTipText(ResourceMgr.getString("d_LblTabWidth"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.editorTabSizeLabel, gridBagConstraints);
        this.tabSize.setColumns(4);
        this.tabSize.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.tabSize, gridBagConstraints);
        this.historySizeLabel.setText(ResourceMgr.getString("LblHistorySize"));
        this.historySizeLabel.setToolTipText(ResourceMgr.getString("d_LblHistorySize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.historySizeLabel, gridBagConstraints);
        this.historySizeField.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.historySizeField, gridBagConstraints);
        this.electricScrollLabel.setText(ResourceMgr.getString("LblSettingElectricScroll"));
        this.electricScrollLabel.setToolTipText(ResourceMgr.getString("d_LblSettingElectricScroll"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.electricScrollLabel, gridBagConstraints);
        this.electricScroll.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 8, 0, 15);
        this.add((Component)this.electricScroll, gridBagConstraints);
        this.internalLineEndingLabel.setText(ResourceMgr.getString("LblIntLineEnding"));
        this.internalLineEndingLabel.setToolTipText(ResourceMgr.getString("d_LblIntLineEnding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.internalLineEndingLabel, gridBagConstraints);
        this.internalLineEnding.setToolTipText(ResourceMgr.getDescription("LblIntLineEnding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 11, 0, 15);
        this.add((Component)this.internalLineEnding, gridBagConstraints);
        this.externalLineEndingLabel.setText(ResourceMgr.getString("LblExtLineEnding"));
        this.externalLineEndingLabel.setToolTipText(ResourceMgr.getString("d_LblExtLineEnding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.externalLineEndingLabel, gridBagConstraints);
        this.externalLineEnding.setToolTipText(ResourceMgr.getDescription("LblExtLineEnding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 11, 0, 15);
        this.add((Component)this.externalLineEnding, gridBagConstraints);
        this.includeFilesInHistory.setSelected(Settings.getInstance().getStoreFilesInHistory());
        this.includeFilesInHistory.setText(ResourceMgr.getString("TxtHistoryIncFiles"));
        this.includeFilesInHistory.setToolTipText(ResourceMgr.getString("d_TxtHistoryIncFiles"));
        this.includeFilesInHistory.setBorder(null);
        this.includeFilesInHistory.setHorizontalAlignment(2);
        this.includeFilesInHistory.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 11);
        this.add((Component)this.includeFilesInHistory, gridBagConstraints);
        this.noWordSepLabel.setLabelFor(this.noWordSep);
        this.noWordSepLabel.setText(ResourceMgr.getString("LblNoWordSep"));
        this.noWordSepLabel.setToolTipText(ResourceMgr.getString("d_LblNoWordSep"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.noWordSepLabel, gridBagConstraints);
        this.useTabs.setText(ResourceMgr.getString("LblEditorUseTabs"));
        this.useTabs.setToolTipText(ResourceMgr.getString("d_LblEditorUseTabs"));
        this.useTabs.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.useTabs, gridBagConstraints);
        this.noWordSep.setColumns(8);
        this.noWordSep.setHorizontalAlignment(2);
        this.noWordSep.setName("nowordsep");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 11, 0, 0);
        this.add((Component)this.noWordSep, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.followCurrentDir.setText(ResourceMgr.getString("LblEditorFollowDir"));
        this.followCurrentDir.setToolTipText(ResourceMgr.getString("d_LblEditorFollowDir"));
        this.followCurrentDir.setBorder(null);
        this.followCurrentDir.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.followCurrentDir, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblEditorDefaultDir"));
        this.jLabel1.setToolTipText(ResourceMgr.getString("d_LblEditorDefaultDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 11);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel1.add((Component)this.defaultDir, gridBagConstraints);
        this.storeDirInWksp.setText(ResourceMgr.getString("LblStoreScriptDirInWksp"));
        this.storeDirInWksp.setToolTipText(ResourceMgr.getString("d_LblStoreScriptDirInWksp"));
        this.storeDirInWksp.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.storeDirInWksp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 15);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.autoCloseBrackets);
        this.jLabel2.setText(ResourceMgr.getString("LblAutoCloseBrkt"));
        this.jLabel2.setToolTipText(ResourceMgr.getString("d_LblAutoCloseBrkt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.autoCloseBrackets.setColumns(8);
        this.autoCloseBrackets.setToolTipText(ResourceMgr.getString("d_LblAutoCloseBrkt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 8, 0, 15);
        this.add((Component)this.autoCloseBrackets, gridBagConstraints);
        this.wheelScrollLabel.setText(ResourceMgr.getString("LblWheelScrLines"));
        this.wheelScrollLabel.setToolTipText(ResourceMgr.getString("d_LblWheelScrLines"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.wheelScrollLabel, gridBagConstraints);
        this.wheelScrollLines.setColumns(4);
        this.wheelScrollLines.setToolTipText(ResourceMgr.getString("d_LblWheelScrLines"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.wheelScrollLines, gridBagConstraints);
        this.reloadLabel.setLabelFor(this.reloadType);
        this.reloadLabel.setText(ResourceMgr.getString("LblRldBehaviour"));
        this.reloadLabel.setToolTipText(ResourceMgr.getString("d_LblRldBehaviour"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.reloadLabel, gridBagConstraints);
        this.reloadType.setModel(new DefaultComboBoxModel<String>(new String[]{"Never", "Prompt", "Automatic"}));
        this.reloadType.setToolTipText(ResourceMgr.getString("d_LblRldBehaviour"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 11, 0, 0);
        this.add((Component)this.reloadType, gridBagConstraints);
        this.rightClickMovesCursor.setSelected(Settings.getInstance().getRightClickMovesCursor());
        this.rightClickMovesCursor.setText(ResourceMgr.getString("LblRightClickMove"));
        this.rightClickMovesCursor.setToolTipText(ResourceMgr.getString("d_LblRightClickMove"));
        this.rightClickMovesCursor.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.rightClickMovesCursor, gridBagConstraints);
        this.jLabel3.setText(ResourceMgr.getString("LblAutoSaveFiles"));
        this.jLabel3.setToolTipText(ResourceMgr.getString("d_LblAutoSaveFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.autoFileSave.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 8, 0, 0);
        this.add(this.autoFileSave, gridBagConstraints);
        this.jLabel4.setText(ResourceMgr.getString("LblFileEncoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.encodings.setModel(new DefaultComboBoxModel<String>(new String[]{"ISO-8859-1", "UTF-8"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add(this.encodings, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.followCurrentDir) {
            this.followCurrentDirActionPerformed(actionEvent);
        }
    }

    private void followCurrentDirActionPerformed(ActionEvent actionEvent) {
        this.defaultDir.setEnabled(this.followCurrentDir.isSelected());
    }
}

