/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import workbench.db.KeepAliveDaemon;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.MasterPasswordDialog;
import workbench.gui.components.WbLabelField;
import workbench.gui.settings.IconListCombobox;
import workbench.gui.settings.LoadingImage;
import workbench.interfaces.Disposable;
import workbench.interfaces.Restoreable;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.GlobalPasswordManager;
import workbench.util.MacOSHelper;
import workbench.util.WbFile;
import workbench.util.WbLocale;

public class GeneralOptionsPanel
extends JPanel
implements Restoreable,
ActionListener,
Disposable {
    private boolean removeMasterPassword = false;
    private String newMasterPassword = null;
    private JTextField alertDuration;
    private JCheckBox autoConnect;
    private JCheckBox autoSaveProfiles;
    private JCheckBox brushedMetal;
    private JLabel busyIconLabel;
    private JComboBox cancelIconCombo;
    private JLabel cancelIconLabel;
    private JComboBox checkInterval;
    private JLabel checkUpdatesLabel;
    private JCheckBox closeButtonRightSide;
    private JCheckBox confirmMultiTabClose;
    private JCheckBox confirmTabClose;
    private JCheckBox consolidateLog;
    private JCheckBox enableQuickFilter;
    private JCheckBox exitOnConnectCancel;
    private JCheckBox focusToQuickFilter;
    private JComboBox iconCombobox;
    private JPanel imagePanel;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JLabel langLabel;
    private JComboBox languageDropDown;
    private JCheckBox logAllStatements;
    private JComboBox logLevel;
    private JLabel logLevelLabel;
    private JCheckBox logMetaSQL;
    private JTextField logfileLabel;
    private JButton masterPwdButton;
    private JCheckBox obfuscateDbInfo;
    private JCheckBox onlyActiveTab;
    private JCheckBox scrollTabs;
    private JTextField settingsfilename;
    private JCheckBox showFinishAlert;
    private JCheckBox showMenuIcons;
    private JCheckBox showResultTabClose;
    private JCheckBox showTabCloseButton;
    private JCheckBox showTabIndex;
    private JCheckBox singlePageHelp;
    private JCheckBox tabLRUclose;
    private JCheckBox useSystemTray;

    public GeneralOptionsPanel() {
        String[] stringArray;
        this.initComponents();
        if (LogMgr.isTraceEnabled()) {
            stringArray = (String[])this.logLevel.getModel();
            stringArray.addElement("TRACE");
        }
        this.brushedMetal.setVisible(MacOSHelper.isMacOS());
        this.brushedMetal.setEnabled(MacOSHelper.isMacOS());
        stringArray = new String[]{ResourceMgr.getString("LblUpdCheckNever"), ResourceMgr.getString("LblUpdCheckDaily"), ResourceMgr.getString("LblUpdCheck7"), ResourceMgr.getString("LblUpdCheck14"), ResourceMgr.getString("LblUpdCheck30")};
        this.checkInterval.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.useSystemTray.setVisible(SystemTray.isSupported());
        WbSwingUtilities.repaintLater(this.iconCombobox);
        WbSwingUtilities.repaintLater(this.cancelIconCombo);
        this.useSystemTray.setEnabled(SystemTray.isSupported());
    }

    @Override
    public void restoreSettings() {
        this.logLevel.setSelectedItem(LogMgr.getLevel());
        int n = Settings.getInstance().getUpdateCheckInterval();
        if (n == 1) {
            this.checkInterval.setSelectedIndex(1);
        } else if (n == 7) {
            this.checkInterval.setSelectedIndex(2);
        } else if (n == 14) {
            this.checkInterval.setSelectedIndex(3);
        } else if (n == 30) {
            this.checkInterval.setSelectedIndex(4);
        } else {
            this.checkInterval.setSelectedIndex(0);
        }
        this.languageDropDown.removeAllItems();
        String string = Settings.getInstance().getLanguage().getLanguage();
        List<WbLocale> list = Settings.getInstance().getLanguages();
        int n2 = 0;
        int n3 = -1;
        for (WbLocale object2 : list) {
            this.languageDropDown.addItem(object2);
            if (object2.getLocale().getLanguage().equals(string)) {
                n3 = n2;
            }
            ++n2;
        }
        if (n3 != -1) {
            this.languageDropDown.setSelectedIndex(n3);
        }
        WbFile wbFile = Settings.getInstance().getConfigFile();
        String string2 = ResourceMgr.getFormattedString("LblSettingsLocation", wbFile.getFullPath());
        this.settingsfilename.setText(string2);
        this.settingsfilename.setBorder(new EmptyBorder(0, 0, 0, 0));
        WbFile wbFile2 = LogMgr.getLogfile();
        this.logfileLabel.setText(ResourceMgr.getFormattedString("LblLogLocation", wbFile2 == null ? "" : wbFile2.getFullPath()));
        this.logfileLabel.setCaretPosition(0);
        this.logfileLabel.setBorder(new EmptyBorder(1, 0, 1, 0));
        this.singlePageHelp.setSelected(Settings.getInstance().useSinglePageHelp());
        int n4 = Settings.getInstance().getIntProperty("workbench.gui.mainwindow.tabpolicy", 0);
        this.scrollTabs.setSelected(n4 == 1);
        this.confirmTabClose.setSelected(GuiSettings.getConfirmTabClose());
        this.confirmMultiTabClose.setSelected(GuiSettings.getConfirmMultipleTabClose());
        this.brushedMetal.setSelected(GuiSettings.getUseBrushedMetal());
        this.showTabCloseButton.setSelected(GuiSettings.getShowSqlTabCloseButton());
        this.showResultTabClose.setSelected(GuiSettings.getShowResultTabCloseButton());
        this.onlyActiveTab.setSelected(GuiSettings.getCloseActiveTabOnly());
        this.closeButtonRightSide.setSelected(GuiSettings.getShowCloseButtonOnRightSide());
        this.tabLRUclose.setSelected(GuiSettings.getUseLRUForTabs());
        this.showFinishAlert.setSelected(GuiSettings.showScriptFinishedAlert());
        this.useSystemTray.setEnabled(SystemTray.isSupported() && GuiSettings.showScriptFinishedAlert());
        this.useSystemTray.setSelected(GuiSettings.useSystemTrayForAlert());
        long l = GuiSettings.getScriptFinishedAlertDuration();
        String string3 = KeepAliveDaemon.getTimeDisplay(l);
        this.alertDuration.setText(string3);
        this.alertDuration.setEnabled(this.showFinishAlert.isSelected());
        this.logAllStatements.setSelected(Settings.getInstance().getLogAllStatements());
        this.logMetaSQL.setSelected(Settings.getInstance().getDebugMetadataSql());
        this.obfuscateDbInfo.setSelected(Settings.getInstance().getObfuscateDbInformation());
        this.autoSaveProfiles.setSelected(Settings.getInstance().getSaveProfilesImmediately());
        this.enableQuickFilter.setSelected(GuiSettings.enableProfileQuickFilter());
        this.focusToQuickFilter.setSelected(GuiSettings.focusToProfileQuickFilter());
        this.showMenuIcons.setSelected(GuiSettings.showMenuIcons());
        String string4 = Settings.getInstance().getProperty("workbench.gui.busyicon.name", "loading-static");
        LoadingImage loadingImage = new LoadingImage();
        loadingImage.setName(string4);
        this.iconCombobox.setSelectedItem(loadingImage);
        string4 = Settings.getInstance().getProperty("workbench.gui.cancelicon.name", "cancelling-static");
        loadingImage = new LoadingImage();
        loadingImage.setName(string4);
        this.cancelIconCombo.setSelectedItem(loadingImage);
        if (Settings.getInstance().getUseMasterPassword()) {
            this.masterPwdButton.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        } else {
            this.masterPwdButton.setIcon(null);
        }
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        GuiSettings.setShowCloseButtonOnRightSide(this.closeButtonRightSide.isSelected());
        GuiSettings.setCloseActiveTabOnly(this.onlyActiveTab.isSelected());
        GuiSettings.setShowTabCloseButton(this.showTabCloseButton.isSelected());
        GuiSettings.setShowResultTabCloseButton(this.showResultTabClose.isSelected());
        GuiSettings.setShowTabIndex(this.showTabIndex.isSelected());
        GuiSettings.setConfirmTabClose(this.confirmTabClose.isSelected());
        GuiSettings.setConfirmMultipleTabClose(this.confirmMultiTabClose.isSelected());
        GuiSettings.setEnableProfileQuickFilter(this.enableQuickFilter.isSelected());
        GuiSettings.setFocusToProfileQuickFilter(this.focusToQuickFilter.isSelected());
        GuiSettings.setShowMenuIcons(this.showMenuIcons.isSelected());
        settings.setConsolidateLogMsg(this.consolidateLog.isSelected());
        settings.setExitOnFirstConnectCancel(this.exitOnConnectCancel.isSelected());
        settings.setShowConnectDialogOnStartup(this.autoConnect.isSelected());
        settings.setLogAllStatements(this.logAllStatements.isSelected());
        settings.setDebugMetadataSql(this.logMetaSQL.isSelected());
        settings.setObfuscateDbInformation(this.obfuscateDbInfo.isSelected());
        int n = this.checkInterval.getSelectedIndex();
        switch (n) {
            case 1: {
                settings.setUpdateCheckInterval(1);
                break;
            }
            case 2: {
                settings.setUpdateCheckInterval(7);
                break;
            }
            case 3: {
                settings.setUpdateCheckInterval(14);
                break;
            }
            case 4: {
                settings.setUpdateCheckInterval(30);
                break;
            }
            default: {
                settings.setUpdateCheckInterval(-1);
            }
        }
        String string = (String)this.logLevel.getSelectedItem();
        LogMgr.setLevel(string);
        settings.setProperty("workbench.log.level", string);
        settings.setLanguage(this.getSelectedLanguage());
        settings.setUseSinglePageHelp(this.singlePageHelp.isSelected());
        if (this.scrollTabs.isSelected()) {
            settings.setProperty("workbench.gui.mainwindow.tabpolicy", 1);
        } else {
            settings.setProperty("workbench.gui.mainwindow.tabpolicy", 0);
        }
        if (this.brushedMetal.isVisible()) {
            GuiSettings.setUseBrushedMetal(this.brushedMetal.isSelected());
        }
        GuiSettings.setUseLRUForTabs(this.tabLRUclose.isSelected());
        GuiSettings.setShowScriptFinishedAlert(this.showFinishAlert.isSelected());
        String string2 = this.alertDuration.getText().trim();
        long l = KeepAliveDaemon.parseTimeInterval(string2);
        GuiSettings.setScriptFinishedAlertDuration(l);
        settings.setSaveProfilesImmediately(this.autoSaveProfiles.isSelected());
        if (SystemTray.isSupported()) {
            GuiSettings.setUseSystemTrayForAlert(this.useSystemTray.isSelected());
        }
        LoadingImage loadingImage = (LoadingImage)this.iconCombobox.getSelectedItem();
        settings.setProperty("workbench.gui.busyicon.name", loadingImage.getName());
        LoadingImage loadingImage2 = (LoadingImage)this.cancelIconCombo.getSelectedItem();
        settings.setProperty("workbench.gui.cancelicon.name", loadingImage2.getName());
        this.applyMasterPassword();
    }

    private void applyMasterPassword() {
        if (!this.removeMasterPassword && this.newMasterPassword == null) {
            return;
        }
        try {
            WbSwingUtilities.showWaitCursorOnWindow(this);
            if (this.removeMasterPassword) {
                GlobalPasswordManager.getInstance().applyNewPassword(null);
            } else {
                GlobalPasswordManager.getInstance().applyNewPassword(this.newMasterPassword);
            }
        }
        finally {
            WbSwingUtilities.showDefaultCursorOnWindow(this);
        }
    }

    @Override
    public void dispose() {
        ((IconListCombobox)this.iconCombobox).done();
        ((IconListCombobox)this.cancelIconCombo).done();
    }

    private Locale getSelectedLanguage() {
        WbLocale wbLocale = (WbLocale)this.languageDropDown.getSelectedItem();
        return wbLocale.getLocale();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.consolidateLog = new JCheckBox();
        this.exitOnConnectCancel = new JCheckBox();
        this.autoConnect = new JCheckBox();
        this.singlePageHelp = new JCheckBox();
        this.brushedMetal = new JCheckBox();
        this.autoSaveProfiles = new JCheckBox();
        this.enableQuickFilter = new JCheckBox();
        this.showMenuIcons = new JCheckBox();
        this.focusToQuickFilter = new JCheckBox();
        this.masterPwdButton = new JButton();
        this.settingsfilename = new WbLabelField();
        this.jPanel1 = new JPanel();
        this.showTabIndex = new JCheckBox();
        this.scrollTabs = new JCheckBox();
        this.confirmTabClose = new JCheckBox();
        this.confirmMultiTabClose = new JCheckBox();
        this.showTabCloseButton = new JCheckBox();
        this.showResultTabClose = new JCheckBox();
        this.onlyActiveTab = new JCheckBox();
        this.closeButtonRightSide = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.tabLRUclose = new JCheckBox();
        this.imagePanel = new JPanel();
        this.iconCombobox = new IconListCombobox();
        this.busyIconLabel = new JLabel();
        this.cancelIconCombo = new IconListCombobox();
        this.cancelIconLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.logLevelLabel = new JLabel();
        this.logLevel = new JComboBox();
        this.jSeparator4 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.showFinishAlert = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.alertDuration = new JTextField();
        this.useSystemTray = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.langLabel = new JLabel();
        this.languageDropDown = new JComboBox();
        this.checkUpdatesLabel = new JLabel();
        this.checkInterval = new JComboBox();
        this.logAllStatements = new JCheckBox();
        this.logMetaSQL = new JCheckBox();
        this.jSeparator5 = new JSeparator();
        this.logfileLabel = new WbLabelField();
        this.obfuscateDbInfo = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.consolidateLog.setSelected(Settings.getInstance().getConsolidateLogMsg());
        this.consolidateLog.setText(ResourceMgr.getString("LblConsolidateLog"));
        this.consolidateLog.setToolTipText(ResourceMgr.getString("d_LblConsolidateLog"));
        this.consolidateLog.setBorder(null);
        this.consolidateLog.setHorizontalAlignment(2);
        this.consolidateLog.setHorizontalTextPosition(4);
        this.consolidateLog.setIconTextGap(5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 4, 0);
        this.jPanel2.add((Component)this.consolidateLog, gridBagConstraints);
        this.exitOnConnectCancel.setSelected(Settings.getInstance().getExitOnFirstConnectCancel());
        this.exitOnConnectCancel.setText(ResourceMgr.getString("LblExitOnConnectCancel"));
        this.exitOnConnectCancel.setToolTipText(ResourceMgr.getString("d_LblExitOnConnectCancel"));
        this.exitOnConnectCancel.setBorder(null);
        this.exitOnConnectCancel.setHorizontalAlignment(2);
        this.exitOnConnectCancel.setHorizontalTextPosition(4);
        this.exitOnConnectCancel.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.exitOnConnectCancel, gridBagConstraints);
        this.autoConnect.setSelected(Settings.getInstance().getShowConnectDialogOnStartup());
        this.autoConnect.setText(ResourceMgr.getString("LblShowConnect"));
        this.autoConnect.setToolTipText(ResourceMgr.getString("d_LblShowConnect"));
        this.autoConnect.setBorder(null);
        this.autoConnect.setHorizontalAlignment(2);
        this.autoConnect.setHorizontalTextPosition(4);
        this.autoConnect.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.autoConnect, gridBagConstraints);
        this.singlePageHelp.setText(ResourceMgr.getString("LblHelpSingle"));
        this.singlePageHelp.setToolTipText(ResourceMgr.getString("d_LblHelpSingle"));
        this.singlePageHelp.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 4, 0);
        this.jPanel2.add((Component)this.singlePageHelp, gridBagConstraints);
        this.brushedMetal.setText(ResourceMgr.getString("LblBrushedMetal"));
        this.brushedMetal.setToolTipText(ResourceMgr.getString("d_LblBrushedMetal"));
        this.brushedMetal.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 4, 0);
        this.jPanel2.add((Component)this.brushedMetal, gridBagConstraints);
        this.autoSaveProfiles.setSelected(Settings.getInstance().getConsolidateLogMsg());
        this.autoSaveProfiles.setText(ResourceMgr.getString("LblAutoSaveProfiles"));
        this.autoSaveProfiles.setToolTipText(ResourceMgr.getString("d_LblAutoSaveProfiles"));
        this.autoSaveProfiles.setBorder(null);
        this.autoSaveProfiles.setHorizontalAlignment(2);
        this.autoSaveProfiles.setHorizontalTextPosition(4);
        this.autoSaveProfiles.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.autoSaveProfiles, gridBagConstraints);
        this.enableQuickFilter.setText(ResourceMgr.getString("LblProfileQuickFilter"));
        this.enableQuickFilter.setToolTipText(ResourceMgr.getString("d_LblProfileQuickFilter"));
        this.enableQuickFilter.setBorder(null);
        this.enableQuickFilter.setHorizontalAlignment(2);
        this.enableQuickFilter.setHorizontalTextPosition(4);
        this.enableQuickFilter.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.enableQuickFilter, gridBagConstraints);
        this.showMenuIcons.setText(ResourceMgr.getString("LblShowMenuIcons"));
        this.showMenuIcons.setToolTipText(ResourceMgr.getString("d_LblShowMenuIcons"));
        this.showMenuIcons.setBorder(null);
        this.showMenuIcons.setHorizontalAlignment(2);
        this.showMenuIcons.setHorizontalTextPosition(4);
        this.showMenuIcons.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.showMenuIcons, gridBagConstraints);
        this.focusToQuickFilter.setText(ResourceMgr.getString("LblProfileQuickFilterFocus"));
        this.focusToQuickFilter.setToolTipText(ResourceMgr.getString("d_LblProfileQuickFilterFocus"));
        this.focusToQuickFilter.setBorder(null);
        this.focusToQuickFilter.setHorizontalAlignment(2);
        this.focusToQuickFilter.setHorizontalTextPosition(4);
        this.focusToQuickFilter.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 4, 0);
        this.jPanel2.add((Component)this.focusToQuickFilter, gridBagConstraints);
        this.masterPwdButton.setText(ResourceMgr.getString("LblMasterPwd"));
        this.masterPwdButton.setHorizontalTextPosition(10);
        this.masterPwdButton.setIconTextGap(8);
        this.masterPwdButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.jPanel2.add((Component)this.masterPwdButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.settingsfilename.setText("Settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.settingsfilename, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.showTabIndex.setSelected(GuiSettings.getShowTabIndex());
        this.showTabIndex.setText(ResourceMgr.getString("LblShowTabIndex"));
        this.showTabIndex.setToolTipText(ResourceMgr.getString("d_LblShowTabIndex"));
        this.showTabIndex.setBorder(null);
        this.showTabIndex.setHorizontalAlignment(2);
        this.showTabIndex.setHorizontalTextPosition(4);
        this.showTabIndex.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 1, 0);
        this.jPanel1.add((Component)this.showTabIndex, gridBagConstraints);
        this.scrollTabs.setText(ResourceMgr.getString("LblScrolTabs"));
        this.scrollTabs.setToolTipText(ResourceMgr.getString("d_LblScrolTabs"));
        this.scrollTabs.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 0, 0);
        this.jPanel1.add((Component)this.scrollTabs, gridBagConstraints);
        this.confirmTabClose.setText(ResourceMgr.getString("LblConfirmTabClose"));
        this.confirmTabClose.setToolTipText(ResourceMgr.getString("d_LblConfirmTabClose"));
        this.confirmTabClose.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 1, 0);
        this.jPanel1.add((Component)this.confirmTabClose, gridBagConstraints);
        this.confirmMultiTabClose.setText(ResourceMgr.getString("LblConfirmMultiTabClose"));
        this.confirmMultiTabClose.setToolTipText(ResourceMgr.getString("d_LblConfirmMultiTabClose"));
        this.confirmMultiTabClose.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.confirmMultiTabClose, gridBagConstraints);
        this.showTabCloseButton.setText(ResourceMgr.getString("LblShowTabClose"));
        this.showTabCloseButton.setToolTipText(ResourceMgr.getString("d_LblShowTabClose"));
        this.showTabCloseButton.setBorder(null);
        this.showTabCloseButton.setHorizontalAlignment(2);
        this.showTabCloseButton.setHorizontalTextPosition(4);
        this.showTabCloseButton.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.jPanel1.add((Component)this.showTabCloseButton, gridBagConstraints);
        this.showResultTabClose.setText(ResourceMgr.getString("LblShowResultClose"));
        this.showResultTabClose.setToolTipText(ResourceMgr.getString("d_LblShowResultClose"));
        this.showResultTabClose.setBorder(null);
        this.showResultTabClose.setHorizontalAlignment(2);
        this.showResultTabClose.setHorizontalTextPosition(4);
        this.showResultTabClose.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 16, 2, 0);
        this.jPanel1.add((Component)this.showResultTabClose, gridBagConstraints);
        this.onlyActiveTab.setText(ResourceMgr.getString("LblCloseActive"));
        this.onlyActiveTab.setToolTipText(ResourceMgr.getString("d_LblCloseActive"));
        this.onlyActiveTab.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        this.jPanel1.add((Component)this.onlyActiveTab, gridBagConstraints);
        this.closeButtonRightSide.setText(ResourceMgr.getString("LblCloseOnRight"));
        this.closeButtonRightSide.setToolTipText(ResourceMgr.getString("d_LblCloseOnRight"));
        this.closeButtonRightSide.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 16, 5, 0);
        this.jPanel1.add((Component)this.closeButtonRightSide, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 3, 0);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.tabLRUclose.setText(ResourceMgr.getString("LblTabOrderLRU"));
        this.tabLRUclose.setToolTipText(ResourceMgr.getString("d_LblTabOrderLRU"));
        this.tabLRUclose.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.tabLRUclose, gridBagConstraints);
        this.imagePanel.setLayout(new GridBagLayout());
        this.iconCombobox.setModel(IconListCombobox.getBusyIcons());
        this.iconCombobox.setToolTipText(ResourceMgr.getString("d_LblBusyIcon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.imagePanel.add((Component)this.iconCombobox, gridBagConstraints);
        this.busyIconLabel.setLabelFor(this.iconCombobox);
        this.busyIconLabel.setText(ResourceMgr.getString("LblBusyIcon"));
        this.busyIconLabel.setToolTipText(ResourceMgr.getString("d_LblBusyIcon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.imagePanel.add((Component)this.busyIconLabel, gridBagConstraints);
        this.cancelIconCombo.setModel(IconListCombobox.getCancelIcons());
        this.cancelIconCombo.setToolTipText(ResourceMgr.getString("d_LblBusyIcon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.imagePanel.add((Component)this.cancelIconCombo, gridBagConstraints);
        this.cancelIconLabel.setLabelFor(this.cancelIconCombo);
        this.cancelIconLabel.setText(ResourceMgr.getString("LblCancelIcon"));
        this.cancelIconLabel.setToolTipText(ResourceMgr.getString("d_LblCancelIcon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.imagePanel.add((Component)this.cancelIconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 12, 1, 0);
        this.jPanel1.add((Component)this.imagePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 3, 0);
        this.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.logLevelLabel.setText(ResourceMgr.getString("LblLogLevel"));
        this.logLevelLabel.setToolTipText(ResourceMgr.getString("d_LblLogLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.logLevelLabel, gridBagConstraints);
        this.logLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"ERROR", "WARNING", "INFO", "DEBUG"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.logLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jSeparator4, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.showFinishAlert.setText(ResourceMgr.getString("LblShowScriptEndAlert"));
        this.showFinishAlert.setBorder(null);
        this.showFinishAlert.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.showFinishAlert, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblScriptEndAlertDuration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 19, 0, 0);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.alertDuration.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.jPanel4.add((Component)this.alertDuration, gridBagConstraints);
        this.useSystemTray.setText(ResourceMgr.getString("LblAlertSysTray"));
        this.useSystemTray.setBorder(null);
        this.useSystemTray.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel4.add((Component)this.useSystemTray, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.langLabel.setText(ResourceMgr.getString("LblLanguage"));
        this.langLabel.setToolTipText(ResourceMgr.getString("d_LblLanguage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel5.add((Component)this.langLabel, gridBagConstraints);
        this.languageDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German"}));
        this.languageDropDown.setToolTipText(ResourceMgr.getDescription("LblLanguage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 10, 0, 8);
        this.jPanel5.add((Component)this.languageDropDown, gridBagConstraints);
        this.checkUpdatesLabel.setText(ResourceMgr.getString("LblCheckForUpdate"));
        this.checkUpdatesLabel.setToolTipText(ResourceMgr.getString("d_LblCheckForUpdate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 7, 0, 1);
        this.jPanel5.add((Component)this.checkUpdatesLabel, gridBagConstraints);
        this.checkInterval.setModel(new DefaultComboBoxModel<String>(new String[]{"never", "daily", "7 days", "14 days", "30 days"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 7, 0, 1);
        this.jPanel5.add((Component)this.checkInterval, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.logAllStatements.setText(ResourceMgr.getString("LblLogAllSql"));
        this.logAllStatements.setToolTipText(ResourceMgr.getString("d_LblLogAllSql"));
        this.logAllStatements.setBorder(null);
        this.logAllStatements.setHorizontalAlignment(2);
        this.logAllStatements.setHorizontalTextPosition(4);
        this.logAllStatements.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        this.add((Component)this.logAllStatements, gridBagConstraints);
        this.logMetaSQL.setText(ResourceMgr.getString("LblLogMetaSql"));
        this.logMetaSQL.setToolTipText(ResourceMgr.getString("d_LblLogMetaSql"));
        this.logMetaSQL.setBorder(null);
        this.logMetaSQL.setHorizontalAlignment(2);
        this.logMetaSQL.setHorizontalTextPosition(4);
        this.logMetaSQL.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        this.add((Component)this.logMetaSQL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.jSeparator5, gridBagConstraints);
        this.logfileLabel.setText("Logfile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.logfileLabel, gridBagConstraints);
        this.obfuscateDbInfo.setText(ResourceMgr.getString("LblObfuscateDbInfo"));
        this.obfuscateDbInfo.setToolTipText(ResourceMgr.getString("d_LblObfuscateDbInfo"));
        this.obfuscateDbInfo.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.obfuscateDbInfo, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.masterPwdButton) {
            this.masterPwdButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.showFinishAlert) {
            this.showFinishAlertActionPerformed(actionEvent);
        }
    }

    private void showFinishAlertActionPerformed(ActionEvent actionEvent) {
        this.alertDuration.setEnabled(this.showFinishAlert.isSelected());
        this.useSystemTray.setEnabled(SystemTray.isSupported() && this.showFinishAlert.isSelected());
    }

    private void masterPwdButtonActionPerformed(ActionEvent actionEvent) {
        if (!GlobalPasswordManager.getInstance().showPasswordPrompt(true)) {
            return;
        }
        Dialog dialog = (Dialog)WbSwingUtilities.getWindowAncestor(this);
        MasterPasswordDialog masterPasswordDialog = new MasterPasswordDialog(dialog);
        Settings.getInstance().restoreWindowSize(masterPasswordDialog);
        WbSwingUtilities.center(masterPasswordDialog, dialog);
        masterPasswordDialog.setVisible(true);
        if (masterPasswordDialog.wasCancelled()) {
            return;
        }
        if (masterPasswordDialog.doRemoveMasterPassword()) {
            this.removeMasterPassword = true;
            this.newMasterPassword = null;
            this.masterPwdButton.setIcon(null);
            return;
        }
        this.masterPwdButton.setIcon(IconMgr.getInstance().getLabelIcon("tick"));
        this.newMasterPassword = masterPasswordDialog.getMasterPassword();
        this.removeMasterPassword = false;
    }
}

