/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbToolbar;
import workbench.gui.profiles.SshHostConfigPanel;
import workbench.interfaces.FileActions;
import workbench.interfaces.Restoreable;
import workbench.interfaces.Validator;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.ssh.SshConfigMgr;
import workbench.ssh.SshHostConfig;
import workbench.util.StringUtil;

public class GlobalSshHostsPanel
extends JPanel
implements Restoreable,
ListSelectionListener,
FileActions,
PropertyChangeListener,
ChangeListener,
Validator {
    private JList hostList;
    private SshHostConfigPanel hostConfig;
    private WbToolbar toolbar;
    private DefaultListModel<SshHostConfig> configs;
    private boolean ignoreValueChanged = false;

    public GlobalSshHostsPanel() {
        this.setLayout(new BorderLayout());
        this.hostList = new JList();
        this.hostList.setSelectionMode(0);
        this.hostList.setBorder(new EmptyBorder(2, 2, 2, 2));
        int n = WbSwingUtilities.calculateCharWidth(this.hostList, 16);
        Dimension dimension = this.hostList.getPreferredSize();
        JScrollPane jScrollPane = new JScrollPane(this.hostList);
        jScrollPane.setPreferredSize(new Dimension(n, dimension.height));
        this.toolbar = new WbToolbar();
        this.toolbar.add(new NewListEntryAction(this));
        this.toolbar.add(new DeleteListEntryAction(this));
        this.toolbar.setBorder(DividerBorder.BOTTOM_DIVIDER);
        this.hostConfig = new SshHostConfigPanel(true);
        this.hostConfig.setAgentCheckBoxEnabled(true);
        this.hostConfig.setEnabled(false);
        this.hostConfig.addNameChangeListener(this);
        this.hostConfig.setValidator(this);
        this.add((Component)this.toolbar, "North");
        this.add((Component)jScrollPane, "West");
        this.add((Component)this.hostConfig, "Center");
    }

    @Override
    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        int n = this.hostList.getSelectedIndex();
        return this.validateName(string, n);
    }

    public boolean validateName(String string, int n) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        int n2 = this.configs.getSize();
        for (int i = 0; i < n2; ++i) {
            if (n != -1 && i == n || !string.equalsIgnoreCase(this.configs.get(i).getConfigName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SshHostConfig sshHostConfig = (SshHostConfig)this.hostList.getSelectedValue();
        if (sshHostConfig != null) {
            sshHostConfig.setConfigName(this.hostConfig.getConfigName());
            this.hostList.repaint();
        }
    }

    @Override
    public void saveSettings() {
        this.applyConfig();
        ArrayList<SshHostConfig> arrayList = new ArrayList<SshHostConfig>();
        Enumeration<SshHostConfig> enumeration = this.configs.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        SshConfigMgr.getDefaultInstance().setConfigs(arrayList);
        SshConfigMgr.getDefaultInstance().saveGlobalConfig();
    }

    @Override
    public void restoreSettings() {
        this.configs = new DefaultListModel();
        List<SshHostConfig> list = SshConfigMgr.getDefaultInstance().getGlobalConfigs();
        for (SshHostConfig sshHostConfig : list) {
            this.configs.addElement(sshHostConfig.createCopy());
        }
        this.hostList.setModel(this.configs);
        this.hostList.addListSelectionListener(this);
        this.hostList.setSelectedIndex(0);
    }

    private void applyConfig() {
        SshHostConfig sshHostConfig = this.hostConfig.getConfig();
        this.replaceConfig(sshHostConfig);
    }

    private void replaceConfig(SshHostConfig sshHostConfig) {
        if (sshHostConfig == null) {
            return;
        }
        for (int i = 0; i < this.configs.size(); ++i) {
            SshHostConfig sshHostConfig2 = this.configs.get(i);
            if (!StringUtil.equalStringIgnoreCase(sshHostConfig2.getConfigName(), sshHostConfig.getConfigName())) continue;
            this.configs.setElementAt(sshHostConfig, i);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.ignoreValueChanged) {
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.applyConfig();
        int n = this.hostList.getSelectedIndex();
        if (n > -1 & n < this.configs.size()) {
            SshHostConfig sshHostConfig = this.configs.getElementAt(n);
            if (sshHostConfig != null) {
                this.hostConfig.setConfig(sshHostConfig);
            }
        } else {
            this.hostConfig.setConfig(null);
        }
    }

    @Override
    public void saveItem() throws Exception {
    }

    @Override
    public void deleteItem() throws Exception {
        int n = this.hostList.getSelectedIndex();
        if (n > -1) {
            this.configs.remove(n);
        }
        if (this.hostList.getModel().getSize() == 0) {
            this.hostConfig.setConfig(null);
            this.hostConfig.setEnabled(false);
        }
        this.hostList.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newItem(boolean bl) {
        try {
            this.applyConfig();
            String string = "SSH Host";
            int n = 2;
            while (!this.validateName(string, -1)) {
                string = string + " " + n;
                ++n;
            }
            SshHostConfig sshHostConfig = new SshHostConfig(string);
            this.ignoreValueChanged = true;
            this.configs.addElement(sshHostConfig);
            this.hostList.setSelectedIndex(this.configs.size() - 1);
            this.hostConfig.setConfig(sshHostConfig);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not create new SSH configuration", exception);
        }
        finally {
            this.ignoreValueChanged = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.hostList.repaint();
        }
    }
}

