/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.WbButton;
import workbench.gui.help.HelpManager;
import workbench.gui.settings.OptionPanelPage;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class SettingsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
WindowListener,
ValidatingComponent {
    private JButton cancelButton;
    private JButton helpButton;
    private JPanel content;
    private JList pageList;
    private JPanel currentPanel;
    private JButton okButton;
    private JDialog dialog;
    private EscAction escAction;
    private List<OptionPanelPage> pages = new ArrayList<OptionPanelPage>();

    public SettingsPanel() {
        super(new BorderLayout());
        this.pages.add(new OptionPanelPage("GeneralOptionsPanel", "LblSettingsGeneral"));
        this.pages.add(new OptionPanelPage("EditorOptionsPanel", "LblSettingsEditor"));
        this.pages.add(new OptionPanelPage("SqlExecOptionsPanel", "LblSqlExecOptions"));
        this.pages.add(new OptionPanelPage("MacroOptionsPanel", "LblMacros"));
        this.pages.add(new OptionPanelPage("BookmarkOptionsPanel", "LblBookmarkOptions"));
        this.pages.add(new OptionPanelPage("EditorColorsPanel", "LblEditorColors"));
        this.pages.add(new OptionPanelPage("HighlightSettingsPanel", "LblHighlightOptions"));
        this.pages.add(new OptionPanelPage("FontOptionsPanel", "LblSettingsFonts"));
        this.pages.add(new OptionPanelPage("CompletionOptionsPanel", "LblCompletionOptions"));
        this.pages.add(new OptionPanelPage("WorkspaceOptions", "LblSettingsWorkspace"));
        this.pages.add(new OptionPanelPage("BackupOptions", "LblBackups"));
        this.pages.add(new OptionPanelPage("DataDisplayOptions", "LblSettingsDataDisplay"));
        this.pages.add(new OptionPanelPage("DataFormattingOptionsPanel", "LblSettingsDataFormat"));
        this.pages.add(new OptionPanelPage("DataColorOptions", "LblDataColors"));
        this.pages.add(new OptionPanelPage("DataEditOptionsPanel", "LblDataEdit"));
        this.pages.add(new OptionPanelPage("DbExplorerOptionsPanel", "LblSettingsDbExplorer"));
        this.pages.add(new OptionPanelPage("DbTreeOptionsPanel", "LblTreeOptions"));
        this.pages.add(new OptionPanelPage("WindowTitleOptionsPanel", "LblSettingsWinTitle"));
        this.pages.add(new OptionPanelPage("FormatterOptionsPanel", "LblSqlFormat"));
        this.pages.add(new OptionPanelPage("SqlGenerationOptionsPanel", "LblSqlGeneration"));
        this.pages.add(new OptionPanelPage("ExternalToolsPanel", "LblExternalTools"));
        this.pages.add(new OptionPanelPage("GlobalSshHostsPanel", "LblSshGlobalCfg"));
        this.pages.add(new OptionPanelPage("LnFOptionsPanel", "LblLnFOptions"));
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.pageList.getSelectedIndex();
        try {
            WbSwingUtilities.showWaitCursor(this);
            OptionPanelPage optionPanelPage = this.pages.get(n);
            JPanel jPanel = optionPanelPage.getPanel();
            if (this.currentPanel != null) {
                this.content.remove(this.currentPanel);
            }
            this.content.add((Component)jPanel, "Center");
            this.content.validate();
            this.content.repaint();
            this.currentPanel = jPanel;
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    private void initComponents() {
        AbstractListModel abstractListModel = new AbstractListModel(){

            @Override
            public Object getElementAt(int n) {
                return SettingsPanel.this.pages.get(n);
            }

            @Override
            public int getSize() {
                return SettingsPanel.this.pages.size();
            }
        };
        this.pageList = new JList(abstractListModel);
        this.pageList.setSelectionMode(0);
        this.pageList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.pageList);
        jScrollPane.setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(2, 2, 2, 2)));
        this.content = new JPanel(new BorderLayout());
        this.content.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.content.add((Component)jScrollPane, "West");
        this.okButton = new WbButton(ResourceMgr.getString("LblOK"));
        this.cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
        this.helpButton = new JButton(ResourceMgr.getString("LblHelp"));
        WbSwingUtilities.makeEqualWidth(this.okButton, this.cancelButton, this.helpButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.helpButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 0, 7, 10);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(7, 0, 7, 4);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.add((Component)this.content, "Center");
        this.add((Component)jPanel, "South");
    }

    private void saveSettings() {
        for (OptionPanelPage optionPanelPage : this.pages) {
            optionPanelPage.saveSettings();
        }
    }

    public void showSettingsDialog(JFrame jFrame) {
        this.dialog = new JDialog((Frame)jFrame, true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setTitle(ResourceMgr.getString("TxtSettingsDialogTitle"));
        this.dialog.getContentPane().add(this);
        this.dialog.addWindowListener(this);
        int n = Settings.getInstance().getWindowWidth(this.getClass().getName());
        int n2 = Settings.getInstance().getWindowHeight(this.getClass().getName());
        if (n > 0 && n2 > 0) {
            this.dialog.setSize(n, n2);
        } else {
            this.pageList.setSelectedIndex(11);
            this.dialog.pack();
            int n3 = this.dialog.getSize().height;
            this.pageList.setSelectedIndex(5);
            this.dialog.pack();
            int n4 = this.dialog.getSize().width;
            this.dialog.setSize(n4, n3);
            WbSwingUtilities.scale(this.dialog, 1.02, 1.02);
        }
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.escAction = new EscAction(this.dialog, this);
        WbSwingUtilities.center(this.dialog, jFrame);
        this.pageList.setSelectedIndex(0);
        WbSwingUtilities.requestFocus(this.pageList);
        this.dialog.setVisible(true);
    }

    private void closeWindow() {
        Settings.getInstance().setWindowSize(this.getClass().getName(), this.dialog.getWidth(), this.dialog.getHeight());
        for (OptionPanelPage optionPanelPage : this.pages) {
            optionPanelPage.dispose();
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escAction || actionEvent.getSource() == this.cancelButton) {
            this.closeWindow();
        } else if (actionEvent.getSource() == this.okButton) {
            if (this.validateInput()) {
                this.saveSettings();
                this.closeWindow();
            }
        } else if (actionEvent.getSource() == this.helpButton) {
            HelpManager.showOptionsHelp();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public boolean validateInput() {
        int n = 0;
        while (n < this.pages.size()) {
            OptionPanelPage optionPanelPage = this.pages.get(n);
            int n2 = n++;
            if (optionPanelPage.validateInput()) continue;
            SwingUtilities.invokeLater(() -> this.pageList.setSelectedIndex(n2));
            return false;
        }
        return true;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }
}

