/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import javax.swing.KeyStroke;
import workbench.resource.ShortcutDefinition;
import workbench.resource.StoreableKeyStroke;

class ShortcutDisplay {
    public static final int TYPE_DEFAULT_KEY = 1;
    public static final int TYPE_PRIMARY_KEY = 2;
    public static final int TYPE_ALTERNATE_KEY = 3;
    private boolean isModified = false;
    private int displayType;
    private ShortcutDefinition shortcut;
    private boolean clearKey = false;
    private boolean resetToDefault = false;
    private StoreableKeyStroke newKey = null;

    ShortcutDisplay(ShortcutDefinition shortcutDefinition, int n) {
        this.shortcut = shortcutDefinition;
        this.displayType = n;
    }

    public ShortcutDefinition getShortcut() {
        return this.shortcut;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isCleared() {
        return this.clearKey;
    }

    public void clearKey() {
        this.newKey = null;
        this.clearKey = true;
        this.isModified = true;
        this.resetToDefault = false;
    }

    public void setNewKey(KeyStroke keyStroke) {
        this.newKey = new StoreableKeyStroke(keyStroke);
        this.isModified = true;
        this.resetToDefault = false;
        this.clearKey = false;
    }

    public StoreableKeyStroke getNewKey() {
        return this.newKey;
    }

    public boolean isMappedTo(KeyStroke keyStroke) {
        boolean bl = false;
        if (this.newKey != null) {
            bl = this.newKey.equals(keyStroke);
        }
        if (!bl) {
            bl = this.shortcut.isMappedTo(keyStroke);
        }
        return bl;
    }

    public boolean doReset() {
        return this.resetToDefault;
    }

    public void resetToDefault() {
        this.isModified = true;
        this.newKey = null;
        this.clearKey = false;
        this.resetToDefault = true;
    }

    public String toString() {
        StoreableKeyStroke storeableKeyStroke = null;
        switch (this.displayType) {
            case 1: {
                storeableKeyStroke = this.shortcut.getDefaultKey();
                break;
            }
            case 2: {
                if (this.clearKey) {
                    storeableKeyStroke = null;
                    break;
                }
                if (this.resetToDefault) {
                    storeableKeyStroke = this.shortcut.getDefaultKey();
                    break;
                }
                if (this.newKey == null) {
                    storeableKeyStroke = this.shortcut.getActiveKey();
                    break;
                }
                storeableKeyStroke = this.newKey;
                break;
            }
            case 3: {
                storeableKeyStroke = this.shortcut.getAlternateKey();
            }
        }
        if (storeableKeyStroke == null) {
            return "";
        }
        return storeableKeyStroke.toString();
    }
}

