/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ActionRegistration;
import workbench.gui.actions.EscAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbTable;
import workbench.gui.settings.ActionDisplay;
import workbench.gui.settings.ActionDisplayRenderer;
import workbench.gui.settings.KeyboardMapper;
import workbench.gui.settings.ShortcutDisplay;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.resource.ShortcutDefinition;
import workbench.resource.ShortcutManager;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroManager;
import workbench.storage.DataStore;

public class ShortcutEditor
extends JPanel
implements ActionListener,
ListSelectionListener,
WindowListener,
MouseListener {
    private static final String KEY_WINDOW_SIZE = "workbench.shortcuteditor";
    private WbTable keysTable;
    private DataStore definitions;
    private DataStoreTableModel model;
    private JDialog window;
    private Frame parent;
    private JButton okButton;
    private JButton cancelButton;
    private JButton assignButton;
    private JButton resetButton;
    private JButton resetAllButton;
    private JButton clearButton;
    private String escActionCommand;

    public ShortcutEditor(Frame frame) {
        this.parent = frame;
        ActionRegistration.registerActions();
    }

    public void showWindow() {
        WbSwingUtilities.showWaitCursor(this.parent);
        this.window = new JDialog(this.parent, ResourceMgr.getString("LblConfigureShortcutWindowTitle"), true);
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.keysTable = new WbTable(false, false, false);
        this.keysTable.useMultilineTooltip(false);
        this.keysTable.setShowPopupMenu(true);
        this.keysTable.setAutoResizeMode(4);
        this.keysTable.getExportAction().setLastDirKey("workbench.shortcuteditor.lastDir");
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.keysTable);
        jPanel.add((Component)jScrollPane, "Center");
        EscAction escAction = new EscAction(this.window, this);
        this.escActionCommand = escAction.getActionName();
        this.createModel();
        this.keysTable.setRowSelectionAllowed(true);
        this.keysTable.getSelectionModel().setSelectionMode(0);
        this.keysTable.setAdjustToColumnLabel(true);
        ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this.keysTable);
        columnWidthOptimizer.optimizeAllColWidth(80, -1, true);
        this.keysTable.addMouseListener(this);
        this.cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
        this.cancelButton.addActionListener(this);
        this.okButton = new WbButton(ResourceMgr.getString("LblOK"));
        this.okButton.addActionListener(this);
        WbSwingUtilities.makeEqualWidth(this.okButton, this.cancelButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        this.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 5, 10);
        this.assignButton = new WbButton(ResourceMgr.getString("LblAssignShortcut"));
        this.assignButton.setToolTipText(ResourceMgr.getDescription("LblAssignShortcut"));
        this.assignButton.addActionListener(this);
        this.assignButton.setEnabled(false);
        jPanel3.add((Component)this.assignButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.clearButton = new WbButton(ResourceMgr.getString("LblClearShortcut"));
        this.clearButton.setToolTipText(ResourceMgr.getDescription("LblClearShortcut"));
        this.clearButton.addActionListener(this);
        this.clearButton.setEnabled(false);
        jPanel3.add((Component)this.clearButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.resetButton = new WbButton(ResourceMgr.getString("LblResetShortcut"));
        this.resetButton.setToolTipText(ResourceMgr.getDescription("LblResetShortcut"));
        this.resetButton.addActionListener(this);
        this.resetButton.setEnabled(false);
        jPanel3.add((Component)this.resetButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 10, 5, 10);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.resetAllButton = new WbButton(ResourceMgr.getString("LblResetAllShortcuts"));
        this.resetAllButton.setToolTipText(ResourceMgr.getDescription("LblResetAllShortcuts"));
        this.resetAllButton.addActionListener(this);
        jPanel3.add((Component)this.resetAllButton, gridBagConstraints);
        jPanel.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel();
        Dimension dimension = new Dimension(1, 20);
        jPanel4.setMinimumSize(dimension);
        jPanel4.setPreferredSize(dimension);
        jPanel4.setBorder(new DividerBorder(32));
        jPanel.add((Component)jPanel4, "South");
        jPanel4 = new JPanel();
        dimension = new Dimension(5, 1);
        jPanel4.setMinimumSize(dimension);
        jPanel4.setPreferredSize(dimension);
        jPanel.add((Component)jPanel4, "West");
        jPanel4 = new JPanel();
        dimension = new Dimension(1, 5);
        jPanel4.setMinimumSize(dimension);
        jPanel4.setPreferredSize(dimension);
        jPanel.add((Component)jPanel4, "North");
        this.add((Component)jPanel, "Center");
        this.window.getContentPane().add(this);
        if (!Settings.getInstance().restoreWindowSize(this.window, KEY_WINDOW_SIZE)) {
            this.window.setSize(600, 400);
        }
        WbSwingUtilities.center(this.window, this.parent);
        WbSwingUtilities.showDefaultCursor(this.parent);
        this.window.setVisible(true);
    }

    private void createModel() {
        ShortcutManager shortcutManager = ShortcutManager.getInstance();
        Collection<ShortcutDefinition> collection = shortcutManager.getDefinitions();
        String[] stringArray = new String[]{ResourceMgr.getString("LblKeyDefCommandCol"), ResourceMgr.getString("LblKeyDefKeyCol"), ResourceMgr.getString("LblKeyDefDefaultCol")};
        int[] nArray = new int[]{12, 1111, 1111};
        this.definitions = new DataStore(stringArray, nArray);
        for (ShortcutDefinition shortcutDefinition : collection) {
            int n = this.definitions.addRow();
            String string = shortcutDefinition.getActionClass();
            String string2 = shortcutManager.getActionNameForClass(string);
            String string3 = shortcutManager.getTooltip(string);
            ActionDisplay actionDisplay = new ActionDisplay(string2, string3);
            this.definitions.setValue(n, 0, (Object)actionDisplay);
            this.definitions.setValue(n, 1, (Object)new ShortcutDisplay(shortcutDefinition, 2));
            this.definitions.setValue(n, 2, (Object)new ShortcutDisplay(shortcutDefinition, 1));
        }
        this.definitions.sortByColumn(0, true);
        this.definitions.resetStatus();
        this.model = new DataStoreTableModel(this.definitions);
        this.model.setAllowEditing(false);
        this.keysTable.setModel(this.model, true);
        TableColumn tableColumn = this.keysTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new ActionDisplayRenderer());
        this.keysTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.closeWindow();
        } else if (object == this.okButton) {
            this.saveShortcuts();
            this.closeWindow();
        } else if (object == this.assignButton) {
            this.assignKey();
        } else if (object == this.resetButton) {
            this.resetCurrentKey();
        } else if (object == this.resetAllButton) {
            this.resetAllKeys();
        } else if (object == this.clearButton) {
            this.clearKey();
        } else if (actionEvent.getActionCommand().equals(this.escActionCommand)) {
            this.closeWindow();
        }
    }

    private void saveSettings() {
        Settings.getInstance().storeWindowSize(this.window, KEY_WINDOW_SIZE);
    }

    private void saveShortcuts() {
        ShortcutManager shortcutManager = ShortcutManager.getInstance();
        int n = this.definitions.getRowCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ShortcutDisplay shortcutDisplay = (ShortcutDisplay)this.definitions.getValue(i, 1);
            ShortcutDefinition shortcutDefinition = shortcutDisplay.getShortcut();
            if (!shortcutDisplay.isModified()) continue;
            bl = true;
            if (shortcutDisplay.isCleared()) {
                shortcutManager.removeShortcut(shortcutDefinition.getActionClass());
                continue;
            }
            if (shortcutDisplay.doReset()) {
                shortcutManager.resetToDefault(shortcutDefinition.getActionClass());
                continue;
            }
            shortcutManager.assignKey(shortcutDefinition.getActionClass(), shortcutDisplay.getNewKey().getKeyStroke());
        }
        if (bl) {
            shortcutManager.updateActions();
            shortcutManager.fireShortcutsChanged();
        }
    }

    private void closeWindow() {
        this.saveSettings();
        this.window.setVisible(false);
        this.window.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = listSelectionEvent.getFirstIndex() >= 0;
        this.resetButton.setEnabled(bl);
        this.assignButton.setEnabled(bl);
        this.clearButton.setEnabled(bl);
    }

    private void assignKey() {
        int n = this.keysTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        KeyStroke keyStroke = KeyboardMapper.getKeyStroke(this);
        if (keyStroke != null) {
            String string;
            Object object;
            ShortcutDisplay shortcutDisplay = (ShortcutDisplay)this.definitions.getValue(n, 1);
            String string2 = shortcutDisplay.getShortcut().getActionClass();
            WbAction wbAction = ShortcutManager.getInstance().getActionForClass(string2);
            int n2 = this.findKey(keyStroke);
            if (!wbAction.allowDuplicate() && n2 > -1) {
                object = (ShortcutDisplay)this.definitions.getValue(n2, 1);
                string = ((ShortcutDisplay)object).getShortcut().getActionClass();
                WbAction wbAction2 = ShortcutManager.getInstance().getActionForClass(string);
                if (!wbAction2.allowDuplicate()) {
                    String string3 = this.definitions.getValueAsString(n2, 0);
                    String string4 = ResourceMgr.getFormattedString("MsgShortcutAlreadyAssigned", string3);
                    boolean bl = WbSwingUtilities.getYesNo(this, string4);
                    if (!bl) {
                        return;
                    }
                    ((ShortcutDisplay)object).clearKey();
                    this.model.fireTableRowsUpdated(n2, n2);
                }
            }
            object = MacroManager.getInstance().getMacroForKeyStroke(keyStroke);
            if (!wbAction.allowDuplicate() && object != null) {
                string = ResourceMgr.getFormattedString("MsgShortcutMacroAlreadyAssigned", ((MacroDefinition)object).getName());
                boolean bl = WbSwingUtilities.getYesNo(this, string);
                if (!bl) {
                    return;
                }
                ((MacroDefinition)object).setShortcut(null);
            }
            if (keyStroke.equals(GuiSettings.getExpansionKey())) {
                WbSwingUtilities.showErrorMessageKey(this, "MsgShortcutExpansion");
                return;
            }
            shortcutDisplay.setNewKey(keyStroke);
            this.model.fireTableRowsUpdated(n, n);
        }
    }

    private void clearKey() {
        int n = this.keysTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ShortcutDisplay shortcutDisplay = (ShortcutDisplay)this.definitions.getValue(n, 1);
        shortcutDisplay.clearKey();
        this.model.fireTableRowsUpdated(n, n);
    }

    private void resetCurrentKey() {
        int n = this.keysTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        ShortcutDisplay shortcutDisplay = (ShortcutDisplay)this.definitions.getValue(n, 1);
        shortcutDisplay.resetToDefault();
        this.model.fireTableRowsUpdated(n, n);
        WbSwingUtilities.repaintNow(this);
    }

    private void resetAllKeys() {
        int n = this.keysTable.getSelectedRow();
        int n2 = this.keysTable.getRowCount();
        for (int i = 0; i < n2; ++i) {
            ShortcutDisplay shortcutDisplay = (ShortcutDisplay)this.definitions.getValue(i, 1);
            shortcutDisplay.resetToDefault();
        }
        this.model.fireTableDataChanged();
        if (n > -1) {
            this.keysTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    private int findKey(KeyStroke keyStroke) {
        int n = this.definitions.getRowCount();
        for (int i = 0; i < n; ++i) {
            ShortcutDisplay shortcutDisplay = (ShortcutDisplay)this.definitions.getValue(i, 1);
            if (shortcutDisplay.isCleared() || !shortcutDisplay.isMappedTo(keyStroke)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.keysTable && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.assignKey();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

