/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.dbobjects.TableDataPanel;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.ToolWindow;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;

public class DetachedResultWindow
extends JPanel
implements WindowListener,
ToolWindow {
    private static int instanceCount;
    private final TableDataPanel data;
    private final int id = ++instanceCount;
    private JFrame window;
    private SqlPanel sourcePanel;
    private JButton attachButton;
    private JButton closeButton;

    public DetachedResultWindow(DwPanel dwPanel, SqlPanel sqlPanel) {
        super(new BorderLayout(0, 0));
        WbConnection wbConnection;
        this.sourcePanel = sqlPanel;
        this.data = new TableDataPanel();
        this.data.showRefreshButton(true);
        this.attachButton = new JButton(ResourceMgr.getString("LblAttachResult"));
        this.attachButton.addActionListener(actionEvent -> this.reAttach());
        if (GuiSettings.showCloseButtonForDetachedResults()) {
            this.closeButton = new JButton(ResourceMgr.getString("LblClose"));
            this.attachButton.addActionListener(actionEvent -> this.close());
        }
        this.data.addButtons(this.attachButton, this.closeButton);
        this.add((Component)this.data, "Center");
        this.data.displayData(dwPanel.getDataStore(), dwPanel.getLastExecutionTime());
        String string = dwPanel.getDataStore().getResultName();
        if (StringUtil.isBlank(string)) {
            string = ResourceMgr.getString("LblTabResult") + " " + NumberStringCache.getNumberString(this.id);
        }
        if ((wbConnection = dwPanel.getDataStore().getOriginalConnection()) != null) {
            string = string + " (" + wbConnection.getCurrentUser() + "@" + wbConnection.getUrl() + ")";
        }
        this.window = new JFrame(string);
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)this, "Center");
        ResourceMgr.setWindowIcons((Window)this.window, "data");
        Window window = SwingUtilities.getWindowAncestor(sqlPanel);
        int n = (int)((double)window.getWidth() * 0.7);
        int n2 = (int)((double)window.getHeight() * 0.7);
        if (!Settings.getInstance().restoreWindowSize(this.window, this.getClass().getName())) {
            this.window.setSize(n, n2);
        }
        WbSwingUtilities.center(this.window, window);
        this.window.addWindowListener(this);
        this.sourcePanel.registerToolWindow(this);
    }

    private void close() {
        this.sourcePanel.unregisterToolWindow(this);
        this.doClose();
    }

    private void reAttach() {
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            WbSwingUtilities.invoke(() -> {
                try {
                    MainWindow mainWindow = WbSwingUtilities.getMainWindow(this.sourcePanel);
                    int n = mainWindow.getIndexForPanel(Optional.of(this.sourcePanel));
                    if (n > -1) {
                        mainWindow.selectTab(n);
                    }
                }
                catch (Exception exception) {
                    LogMgr.logError(callerInfo, "Could not re-attach result", exception);
                }
            });
            this.sourcePanel.showData(this.data.getData().getDataStore());
            this.sourcePanel.unregisterToolWindow(this);
            this.window.removeWindowListener(this);
            this.doClose();
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Could not re-attach result", exception);
        }
    }

    public void refreshAutomatically(int n) {
        this.data.refreshAutomatically(n);
    }

    public void showWindow() {
        if (this.window != null) {
            this.window.setVisible(true);
        }
    }

    protected void saveSettings() {
        Settings.getInstance().storeWindowSize(this.window, this.getClass().getName());
    }

    private void doClose() {
        this.saveSettings();
        this.window.setVisible(false);
        this.window.dispose();
        this.window = null;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.sourcePanel.unregisterToolWindow(this);
        this.doClose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (this.data != null) {
            this.data.dispose();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void closeWindow() {
        this.doClose();
    }

    @Override
    public void activate() {
        if (this.window != null) {
            this.window.requestFocus();
        }
    }

    @Override
    public JFrame getWindow() {
        return this.window;
    }

    @Override
    public void disconnect() {
        String string;
        int n;
        if (this.data != null) {
            this.data.detachConnection();
        }
        if (this.window != null && (n = (string = this.window.getTitle()).indexOf(" (")) > -1) {
            string = string.substring(0, n);
            this.window.setTitle(string);
        }
    }

    @Override
    public WbConnection getConnection() {
        return null;
    }
}

