/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.SelectionDisplay;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbTextLabel;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.EditorStatusbar;
import workbench.interfaces.StatusBar;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.DurationFormatter;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class DwStatusBar
extends JPanel
implements StatusBar,
EditorStatusbar,
ActionListener {
    private final JTextField tfRowCount;
    protected WbTextLabel tfStatus;
    private final JTextField tfMaxRows;
    private String readyMsg;
    private JTextField tfTimeout;
    private final WbTextLabel execTime;
    private JLabel editorStatus;
    private JLabel maxRowsLabel;
    private final JPanel infoPanel;
    private static final int DEFAULT_FIELD_HEIGHT = 18;
    private static final Border MAX_ROWS_BORDER = new EmptyBorder(0, 0, 0, 1);
    private static final Insets MAX_ROWS_INSETS = new Insets(0, 2, 0, 2);
    private final int timerInterval = Settings.getInstance().getIntProperty("workbench.gui.execution.timer.interval", 1000);
    private final boolean showTimer = Settings.getInstance().getBoolProperty("workbench.gui.execution.timer.enabled", true);
    private long timerStarted;
    private Timer executionTimer;
    private boolean timerRunning;
    private String editorLinePrefix;
    private String editorColPrefix;
    private SelectionDisplay selectionDisplay;
    private final DurationFormatter durationFormatter = new DurationFormatter();
    private static final Border DEFAULT_BORDER = new EmptyBorder(0, 2, 0, 2);

    public DwStatusBar(boolean bl, boolean bl2) {
        super(new BorderLayout());
        this.tfRowCount = new JTextField();
        this.tfMaxRows = new JTextField(6);
        Font font = this.tfMaxRows.getFont();
        FontMetrics fontMetrics = null;
        if (font != null) {
            fontMetrics = this.tfMaxRows.getFontMetrics(font);
        }
        int n = fontMetrics == null ? 0 : fontMetrics.getHeight() + 2;
        n = Math.min(18, n);
        int n2 = n + 4;
        Dimension dimension = new Dimension(40, n);
        this.tfMaxRows.setEditable(true);
        this.tfMaxRows.setMaximumSize(dimension);
        this.tfMaxRows.setMargin(MAX_ROWS_INSETS);
        this.tfMaxRows.setText("0");
        this.tfMaxRows.setName("maxrows");
        this.tfMaxRows.setToolTipText(ResourceMgr.getDescription("TxtMaxRows"));
        this.tfMaxRows.setHorizontalAlignment(4);
        this.tfMaxRows.addMouseListener(new TextComponentMouseListener());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new LineBorder(Color.LIGHT_GRAY, 1), new EmptyBorder(1, 1, 1, 1));
        this.tfMaxRows.setBorder(compoundBorder);
        this.setMaximumSize(new Dimension(32768, n2));
        this.setMinimumSize(new Dimension(80, n2));
        this.setPreferredSize(null);
        this.tfRowCount.setEditable(false);
        this.tfRowCount.setHorizontalAlignment(4);
        this.tfRowCount.setBorder(MAX_ROWS_BORDER);
        this.tfRowCount.setDisabledTextColor(this.tfRowCount.getForeground());
        this.tfRowCount.setMargin(new Insets(0, 15, 0, 10));
        this.tfRowCount.setMinimumSize(dimension);
        this.tfRowCount.setPreferredSize(null);
        this.tfRowCount.setAutoscrolls(false);
        this.tfRowCount.setEnabled(false);
        this.tfStatus = new WbTextLabel();
        this.add((Component)this.tfStatus, "Center");
        this.infoPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.infoPanel.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.infoPanel.setMaximumSize(new Dimension(300, n));
        this.setBorder(DEFAULT_BORDER);
        this.execTime = new WbTextLabel();
        this.execTime.setMininumCharacters(8);
        this.execTime.setHorizontalAlignment(4);
        this.execTime.setToolTipText(ResourceMgr.getString("MsgTotalSqlTime"));
        if (this.showTimer) {
            this.executionTimer = new Timer(this.timerInterval, this);
        }
        if (bl2) {
            this.editorStatus = new JLabel();
            this.editorStatus.setHorizontalAlignment(0);
            int n3 = fontMetrics == null ? 85 : fontMetrics.stringWidth("L:999 C:999");
            dimension = new Dimension(n3 + 4, n);
            this.editorStatus.setMinimumSize(dimension);
            this.editorStatus.setBorder(new CompoundBorder(new DividerBorder(1), new EmptyBorder(0, 3, 0, 3)));
            this.editorStatus.setToolTipText(ResourceMgr.getDescription("LblEditorStatus"));
            this.infoPanel.add(this.editorStatus);
            this.editorColPrefix = ResourceMgr.getString("LblEditorPosCol");
            this.editorLinePrefix = ResourceMgr.getString("LblEditorPosLine");
        }
        compoundBorder = new CompoundBorder(new DividerBorder(3), new EmptyBorder(0, 3, 0, 3));
        this.execTime.setBorder(compoundBorder);
        this.infoPanel.add(this.execTime);
        if (bl) {
            JLabel jLabel = new JLabel(" " + ResourceMgr.getString("LblQueryTimeout") + " ");
            this.infoPanel.add(jLabel);
            this.tfTimeout = new JTextField(3);
            this.tfTimeout.setBorder(compoundBorder);
            this.tfTimeout.setMargin(new Insets(0, 2, 0, 2));
            this.tfTimeout.setToolTipText(ResourceMgr.getDescription("LblQueryTimeout"));
            this.tfTimeout.setHorizontalAlignment(4);
            this.tfTimeout.addMouseListener(new TextComponentMouseListener());
            jLabel.setToolTipText(this.tfTimeout.getToolTipText());
            this.infoPanel.add(this.tfTimeout);
        }
        this.maxRowsLabel = new JLabel(" " + ResourceMgr.getString("LblMaxRows") + " ");
        this.maxRowsLabel.setToolTipText(this.tfRowCount.getToolTipText());
        this.infoPanel.add(this.maxRowsLabel);
        this.infoPanel.add(this.tfMaxRows);
        this.infoPanel.add(this.tfRowCount);
        this.add((Component)this.infoPanel, "East");
        this.readyMsg = GuiSettings.showStatusbarReadyMessage() ? ResourceMgr.getString("MsgReady") : "";
        this.clearStatusMessage();
    }

    public void removeMaxRows() {
        if (this.tfMaxRows != null) {
            this.infoPanel.remove(this.tfMaxRows);
            this.infoPanel.remove(this.maxRowsLabel);
        }
    }

    private void initSelectionDisplay() {
        if (this.selectionDisplay == null) {
            this.selectionDisplay = new SelectionDisplay();
            this.infoPanel.add((Component)this.selectionDisplay, 0);
        }
    }

    public void addTextSelectionDisplay(EditorPanel editorPanel) {
        this.initSelectionDisplay();
        this.selectionDisplay.setTextClient(editorPanel);
    }

    public void removeTextSelectionDisplay(EditorPanel editorPanel) {
        if (this.selectionDisplay == null) {
            return;
        }
        this.selectionDisplay.removeTextClient(editorPanel);
    }

    public void removeSelectionIndicator(JTable jTable) {
        if (this.selectionDisplay == null) {
            return;
        }
        this.selectionDisplay.removeClient(jTable);
    }

    public void showSelectionIndicator(JTable jTable) {
        this.initSelectionDisplay();
        this.selectionDisplay.setClient(jTable);
    }

    public void setReadyMsg(String string) {
        this.readyMsg = string == null ? "" : string;
    }

    public void clearExecutionTime() {
        this.execTime.setText("");
        this.execTime.repaint();
    }

    @Override
    public void setEditorLocation(int n, int n2) {
        if (this.editorStatus == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.editorLinePrefix);
        stringBuilder.append(NumberStringCache.getNumberString(n));
        stringBuilder.append(' ');
        stringBuilder.append(this.editorColPrefix);
        stringBuilder.append(NumberStringCache.getNumberString(n2));
        this.editorStatus.setText(stringBuilder.toString());
    }

    public void executionStart() {
        if (!this.showTimer) {
            return;
        }
        this.timerStarted = System.currentTimeMillis();
        this.executionTimer.setInitialDelay(this.timerInterval);
        this.executionTimer.setDelay(this.timerInterval);
        this.timerRunning = true;
        this.executionTimer.start();
    }

    public void executionEnd() {
        if (!this.showTimer) {
            return;
        }
        this.timerRunning = false;
        this.executionTimer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.timerRunning) {
            return;
        }
        long l = System.currentTimeMillis() - this.timerStarted;
        this.setExecTimeText(this.durationFormatter.formatDuration(l, Settings.getInstance().getDurationFormat(), false));
    }

    public void setExecutionTime(long l) {
        if (this.timerRunning) {
            this.executionEnd();
        }
        this.setExecTimeText(this.durationFormatter.formatDuration(l));
    }

    private void setExecTimeText(String string) {
        EventQueue.invokeLater(() -> this.execTime.setText(string));
    }

    public void setRowcount(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(20);
        if (n3 > 0) {
            stringBuilder.append(' ');
            stringBuilder.append(NumberStringCache.getNumberString(n));
            stringBuilder.append('-');
            stringBuilder.append(NumberStringCache.getNumberString(n2));
            stringBuilder.append('/');
            stringBuilder.append(NumberStringCache.getNumberString(n3));
        }
        this.setRowcountText(stringBuilder.toString());
    }

    private void setRowcountText(String string) {
        EventQueue.invokeLater(() -> {
            this.tfRowCount.setText(string);
            this.validate();
        });
    }

    public void clearRowcount() {
        this.setRowcountText("");
    }

    @Override
    public String getText() {
        return this.tfStatus.getText();
    }

    @Override
    public void setStatusMessage(final String string, final int n) {
        this.setStatusMessage(string);
        if (n > 0) {
            WbThread wbThread = new WbThread("ClearStatusMessage"){

                @Override
                public void run() {
                    WbThread.sleepSilently(n);
                    String string2 = DwStatusBar.this.getText();
                    if (string.equals(string2)) {
                        DwStatusBar.this.clearStatusMessage();
                    }
                }
            };
            wbThread.start();
        }
    }

    @Override
    public void setStatusMessage(String string) {
        if (string == null) {
            return;
        }
        this.tfStatus.setText(string);
    }

    public void forcePaint() {
        this.tfStatus.forcePaint();
    }

    @Override
    public final void clearStatusMessage() {
        this.setStatusMessage(this.readyMsg);
    }

    public void setQueryTimeout(int n) {
        if (this.tfTimeout != null) {
            this.tfTimeout.setText(NumberStringCache.getNumberString(n));
        }
    }

    public int getQueryTimeout() {
        if (this.tfTimeout == null) {
            return 0;
        }
        return StringUtil.getIntValue(this.tfTimeout.getText(), 0);
    }

    public void setMaxRows(int n) {
        this.tfMaxRows.setText(NumberStringCache.getNumberString(n));
    }

    public int getMaxRows() {
        if (this.tfMaxRows == null) {
            return 0;
        }
        return StringUtil.getIntValue(this.tfMaxRows.getText(), 0);
    }

    public void selectMaxRowsField() {
        this.tfMaxRows.selectAll();
        this.tfMaxRows.requestFocusInWindow();
    }

    @Override
    public void doRepaint() {
        this.forcePaint();
    }
}

