/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapContent;
import workbench.WbManager;
import workbench.db.QuoteHandler;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ColumnSelectionAction;
import workbench.gui.actions.CommentAction;
import workbench.gui.actions.FileReloadAction;
import workbench.gui.actions.FileSaveAction;
import workbench.gui.actions.FileSaveAsAction;
import workbench.gui.actions.FindAction;
import workbench.gui.actions.FindNextAction;
import workbench.gui.actions.FindPreviousAction;
import workbench.gui.actions.FormatSqlAction;
import workbench.gui.actions.JumpToLineAction;
import workbench.gui.actions.MatchBracketAction;
import workbench.gui.actions.OpenFileAction;
import workbench.gui.actions.RedoAction;
import workbench.gui.actions.ReplaceAction;
import workbench.gui.actions.ToggleCommentAction;
import workbench.gui.actions.UnCommentAction;
import workbench.gui.actions.UndoAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.EncodingDropDown;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbFileChooser;
import workbench.gui.components.WbMenuItem;
import workbench.gui.dbobjects.objecttree.EditorDropHandler;
import workbench.gui.dbobjects.objecttree.ObjectTreeTransferable;
import workbench.gui.editor.AnsiSQLTokenMarker;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.SearchAndReplace;
import workbench.gui.editor.SyntaxDocument;
import workbench.gui.editor.TextFormatter;
import workbench.gui.editor.TokenMarker;
import workbench.gui.sql.FileReloadType;
import workbench.gui.sql.YesNoCancelResult;
import workbench.interfaces.FilenameChangeListener;
import workbench.interfaces.FontChangedListener;
import workbench.interfaces.FormattableSql;
import workbench.interfaces.SqlTextContainer;
import workbench.interfaces.TextFileContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.MemoryWatcher;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class EditorPanel
extends JEditTextArea
implements FontChangedListener,
DropTargetListener,
SqlTextContainer,
TextFileContainer,
FormattableSql {
    private static final Border DEFAULT_BORDER = BorderFactory.createEtchedBorder(1);
    private AnsiSQLTokenMarker sqlTokenMarker;
    private static final int SQL_EDITOR = 0;
    private static final int TEXT_EDITOR = 1;
    private int editorType;
    private FormatSqlAction formatSql;
    private final SearchAndReplace replacer;
    protected UndoAction undo;
    protected RedoAction redo;
    protected OpenFileAction fileOpen;
    protected FileSaveAsAction fileSaveAs;
    private boolean allowReformatOnReadonly;
    protected FileSaveAction fileSave;
    protected FileReloadAction fileReloadAction;
    private final ColumnSelectionAction columnSelection;
    private final MatchBracketAction matchBracket;
    private final ToggleCommentAction toggleCommentAction;
    private final CommentAction commentAction;
    private final UnCommentAction unCommentAction;
    private final JumpToLineAction jumpToLineAction;
    private final List<FilenameChangeListener> filenameChangeListeners = new ArrayList<FilenameChangeListener>();
    private WbFile currentFile;
    private boolean saveInProgress;
    private boolean loadInProgress;
    private long fileModifiedTime;
    private String fileEncoding;
    private Set<String> dbFunctions;
    private Set<String> dbDatatypes;
    private DelimiterDefinition alternateDelimiter;
    private String dbId;
    private QuoteHandler quoteHandler = QuoteHandler.STANDARD_HANDLER;
    private boolean allowFileLoading = true;

    public static EditorPanel createSqlEditor() {
        AnsiSQLTokenMarker ansiSQLTokenMarker = new AnsiSQLTokenMarker();
        EditorPanel editorPanel = new EditorPanel(ansiSQLTokenMarker);
        editorPanel.editorType = 0;
        editorPanel.sqlTokenMarker = ansiSQLTokenMarker;
        return editorPanel;
    }

    public static EditorPanel createTextEditor() {
        EditorPanel editorPanel = new EditorPanel(null);
        editorPanel.editorType = 1;
        return editorPanel;
    }

    public EditorPanel(TokenMarker tokenMarker) {
        this.setDoubleBuffered(true);
        this.setBorder(DEFAULT_BORDER);
        this.setTabSize(Settings.getInstance().getEditorTabWidth());
        this.setCaretBlinkEnabled(true);
        this.fileSave = new FileSaveAction(this);
        this.fileSave.setEnabled(false);
        this.fileSaveAs = new FileSaveAsAction(this);
        this.addPopupMenuItem(this.fileSave, true);
        this.addPopupMenuItem(this.fileSaveAs, false);
        this.fileOpen = new OpenFileAction(this);
        this.addPopupMenuItem(this.fileOpen, false);
        this.jumpToLineAction = new JumpToLineAction(this);
        this.fileReloadAction = new FileReloadAction(this);
        this.fileReloadAction.setEnabled(false);
        this.replacer = new SearchAndReplace(this, this);
        this.addKeyBinding(this.getFindAction());
        this.addKeyBinding(this.getFindPreviousAction());
        this.addKeyBinding(this.getFindNextAction());
        this.addKeyBinding(this.getReplaceAction());
        this.addKeyBinding(this.getJumpToLineAction());
        if (tokenMarker != null) {
            this.setTokenMarker(tokenMarker);
        }
        this.setMaximumSize(null);
        this.setPreferredSize(null);
        this.columnSelection = new ColumnSelectionAction(this);
        this.matchBracket = new MatchBracketAction(this);
        this.addKeyBinding(this.matchBracket);
        this.toggleCommentAction = new ToggleCommentAction(this);
        this.commentAction = new CommentAction(this);
        this.unCommentAction = new UnCommentAction(this);
        this.addKeyBinding(this.toggleCommentAction);
        this.addKeyBinding(this.commentAction);
        this.addKeyBinding(this.unCommentAction);
        this.undo = new UndoAction(this);
        this.redo = new RedoAction(this);
        this.addKeyBinding(this.undo);
        this.addKeyBinding(this.redo);
        Settings.getInstance().addFontChangedListener(this);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.electricscroll", new String[0]);
        this.setRightClickMovesCursor(Settings.getInstance().getRightClickMovesCursor());
        new DropTarget(this, 1, this);
    }

    public void setAllowFileLoading(boolean bl) {
        this.allowFileLoading = bl;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.painter != null) {
            this.painter.invalidate();
        }
    }

    public void disableSqlHighlight() {
        this.setTokenMarker(null);
    }

    public void enableSqlHighlight() {
        if (this.sqlTokenMarker == null) {
            this.sqlTokenMarker = new AnsiSQLTokenMarker();
        }
        this.setTokenMarker(this.sqlTokenMarker);
    }

    public void setDatabaseConnection(WbConnection wbConnection) {
        this.dbFunctions = CollectionUtil.caseInsensitiveSet();
        this.dbDatatypes = CollectionUtil.caseInsensitiveSet();
        this.alternateDelimiter = Settings.getInstance().getAlternateDelimiter(wbConnection, null);
        AnsiSQLTokenMarker ansiSQLTokenMarker = this.getSqlTokenMarker();
        if (ansiSQLTokenMarker == null) {
            return;
        }
        if (wbConnection != null) {
            this.quoteHandler = wbConnection.getMetadata();
            boolean bl = wbConnection.getMetadata().isMySql();
            ansiSQLTokenMarker.setIsMySQL(bl);
            if (bl && Settings.getInstance().getBoolProperty("workbench.editor.mysql.usehashcomment", false)) {
                this.commentChar = "#";
            }
            ansiSQLTokenMarker.setIsMicrosoft(wbConnection.getMetadata().isSqlServer());
            this.dbId = wbConnection.getDbSettings().getDbId();
        } else {
            this.dbId = null;
            this.commentChar = "--";
            this.quoteHandler = QuoteHandler.STANDARD_HANDLER;
        }
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper(this.dbId);
        this.dbFunctions.addAll(sqlKeywordHelper.getSqlFunctions());
        this.dbDatatypes.addAll(sqlKeywordHelper.getDataTypes());
        ansiSQLTokenMarker.initKeywordMap(sqlKeywordHelper.getKeywords(), this.dbDatatypes, sqlKeywordHelper.getOperators(), this.dbFunctions);
    }

    @Override
    protected QuoteHandler getQuoteHandler() {
        return this.quoteHandler;
    }

    @Override
    public void fontChanged(String string, Font font) {
        if (string.equals("editor")) {
            this.setFont(font);
        }
    }

    public AnsiSQLTokenMarker getSqlTokenMarker() {
        TokenMarker tokenMarker = this.getTokenMarker();
        if (tokenMarker instanceof AnsiSQLTokenMarker) {
            return (AnsiSQLTokenMarker)tokenMarker;
        }
        return null;
    }

    @Override
    public int getStartInLine(int n) {
        int n2 = this.getLineOfOffset(n);
        int n3 = this.getLineStartOffset(n2);
        return n - n3;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        WbSwingUtilities.invokeLater(this::checkFileChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFileChange() {
        if (this.currentFile == null) {
            return;
        }
        if (this.saveInProgress) {
            return;
        }
        if (this.loadInProgress) {
            return;
        }
        try {
            this.loadInProgress = true;
            long l = this.currentFile.lastModified();
            int n = Settings.getInstance().getIntProperty("workbench.gui.editor.reload.check.mindiff", 2000);
            if (Math.abs(l - this.fileModifiedTime) > (long)n) {
                String string = this.getCurrentFileName();
                FileReloadType fileReloadType = GuiSettings.getReloadType();
                if (fileReloadType != FileReloadType.none) {
                    LogMgr.logDebug(new CallerInfo(){}, "File " + string + " has been modified externally. currentFileTime=" + l + ", saved lastModifiedTime=" + this.fileModifiedTime);
                }
                if (fileReloadType == FileReloadType.automatic) {
                    this.reloadCurrentFile();
                    this.statusBar.setStatusMessage(ResourceMgr.getFormattedString("MsgFileReloaded", string), 5000);
                } else if (fileReloadType == FileReloadType.prompt) {
                    boolean bl = WbSwingUtilities.getYesNo(this, ResourceMgr.getFormattedString("MsgReloadFile", string));
                    if (bl) {
                        this.reloadCurrentFile();
                    } else {
                        this.fileModifiedTime = l;
                    }
                }
            }
        }
        finally {
            this.loadInProgress = false;
        }
    }

    @Override
    public boolean isModifiedAfter(long l) {
        boolean bl = super.isModifiedAfter(l);
        return bl || this.hasFileLoaded() && this.fileModifiedTime > l;
    }

    public void showFindOnPopupMenu() {
        this.addPopupMenuItem(this.getFindAction(), true);
        this.addPopupMenuItem(this.getFindNextAction(), false);
        this.addPopupMenuItem(this.getReplaceAction(), false);
    }

    public MatchBracketAction getMatchBracketAction() {
        return this.matchBracket;
    }

    public ColumnSelectionAction getColumnSelection() {
        return this.columnSelection;
    }

    public UndoAction getUndoAction() {
        return this.undo;
    }

    public RedoAction getRedoAction() {
        return this.redo;
    }

    public final JumpToLineAction getJumpToLineAction() {
        return this.jumpToLineAction;
    }

    protected final FindPreviousAction getFindPreviousAction() {
        return this.replacer.getFindPreviousAction();
    }

    protected final FindAction getFindAction() {
        return this.replacer.getFindAction();
    }

    protected final FindNextAction getFindNextAction() {
        return this.replacer.getFindNextAction();
    }

    protected final ReplaceAction getReplaceAction() {
        return this.replacer.getReplaceAction();
    }

    public SearchAndReplace getReplacer() {
        return this.replacer;
    }

    public FileSaveAction getFileSaveAction() {
        return this.fileSave;
    }

    public FileSaveAsAction getFileSaveAsAction() {
        return this.fileSaveAs;
    }

    public FormatSqlAction getFormatSqlAction() {
        return this.formatSql;
    }

    public FileReloadAction getReloadAction() {
        return this.fileReloadAction;
    }

    public OpenFileAction getOpenFileAction() {
        return this.fileOpen;
    }

    public void showFormatSql() {
        if (this.formatSql != null) {
            return;
        }
        this.formatSql = new FormatSqlAction(this);
        this.addKeyBinding(this.formatSql);
        this.addPopupMenuItem(this.formatSql, true);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.getReplaceAction().setEnabled(bl);
        this.fileOpen.setEnabled(bl);
        if (!bl) {
            Component[] componentArray;
            for (Component component : componentArray = this.popup.getComponents()) {
                WbMenuItem wbMenuItem;
                if (!(component instanceof WbMenuItem) || (wbMenuItem = (WbMenuItem)component).getAction() != this.fileOpen) continue;
                this.popup.remove(component);
                return;
            }
        }
    }

    public void setAllowReformatOnReadonly(boolean bl) {
        this.allowReformatOnReadonly = bl;
    }

    @Override
    public void reformatSql() {
        if (!this.allowReformatOnReadonly && !this.isEditable()) {
            return;
        }
        try {
            WbSwingUtilities.showWaitCursor(this);
            TextFormatter textFormatter = new TextFormatter(this.dbId);
            textFormatter.formatSql(this, this.alternateDelimiter);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    public final void removePopupMenuItem(WbAction wbAction) {
        if (this.popup == null) {
            return;
        }
        if (wbAction == null) {
            return;
        }
        int n = this.popup.getComponentCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            Component component = this.popup.getComponent(i);
            if (!(component instanceof JMenuItem) || (jMenuItem = (JMenuItem)component).getAction() != wbAction) continue;
            n2 = i;
            break;
        }
        if (n2 > -1) {
            this.popup.remove(n2);
        }
        this.removeKeyBinding(wbAction);
    }

    public final void addPopupMenuItem(WbAction wbAction, boolean bl) {
        if (this.popup == null) {
            return;
        }
        this.popup.addAction(wbAction, bl);
        this.addKeyBinding(wbAction);
    }

    @Override
    public void dispose() {
        super.dispose();
        Settings.getInstance().removeFontChangedListener(this);
        this.clearUndoBuffer();
        if (this.popup != null) {
            this.popup.dispose();
        }
        this.popup = null;
        this.stopBlinkTimer();
        if (this.painter != null) {
            this.painter.dispose();
        }
        if (this.inputHandler != null) {
            this.inputHandler.dispose();
        }
        WbAction.dispose(this.columnSelection, this.toggleCommentAction, this.commentAction, this.fileOpen, this.fileReloadAction, this.fileSave, this.fileSaveAs, this.formatSql, this.jumpToLineAction, this.matchBracket, this.redo, this.unCommentAction, this.undo);
        this.replacer.dispose();
        this.quoteHandler = null;
        this.setDocument(new SyntaxDocument());
    }

    @Override
    public String getSelectedStatement() {
        String string = this.getSelectedText();
        if (string == null || string.length() == 0) {
            return this.getText();
        }
        return string;
    }

    @Override
    public boolean closeFile(boolean bl) {
        if (this.currentFile == null) {
            return false;
        }
        this.currentFile = null;
        if (bl) {
            this.setCaretPosition(0);
            this.reset();
        }
        this.fireFilenameChanged(null);
        return true;
    }

    protected void checkFileActions() {
        boolean bl = this.hasFileLoaded();
        this.fileSave.setEnabled(bl);
        this.fileReloadAction.setEnabled(bl);
    }

    public void fireFilenameChanged(String string) {
        this.checkFileActions();
        for (FilenameChangeListener filenameChangeListener : this.filenameChangeListeners) {
            filenameChangeListener.fileNameChanged(this, string);
        }
    }

    public void addFilenameChangeListener(FilenameChangeListener filenameChangeListener) {
        if (filenameChangeListener == null) {
            return;
        }
        this.filenameChangeListeners.add(filenameChangeListener);
    }

    public void removeFilenameChangeListener(FilenameChangeListener filenameChangeListener) {
        if (filenameChangeListener == null) {
            return;
        }
        this.filenameChangeListeners.remove(filenameChangeListener);
    }

    @Override
    public MainWindow getMainWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof MainWindow) {
            return (MainWindow)window;
        }
        return null;
    }

    public boolean reloadFile() {
        if (this.saveInProgress) {
            return false;
        }
        if (this.loadInProgress) {
            return false;
        }
        try {
            this.loadInProgress = true;
            boolean bl = this.reloadCurrentFile();
            return bl;
        }
        finally {
            this.loadInProgress = false;
        }
    }

    private boolean reloadCurrentFile() {
        int n;
        if (!this.hasFileLoaded()) {
            return false;
        }
        if (this.isModified()) {
            String string = ResourceMgr.getString("MsgConfirmUnsavedReload");
            n = WbSwingUtilities.getYesNo(this, string = StringUtil.replace(string, "%filename%", this.getCurrentFileName())) ? 1 : 0;
            if (n == 0) {
                return false;
            }
        }
        n = this.getCaretPosition();
        boolean bl = this.readFile(this.currentFile, this.fileEncoding);
        if (bl) {
            this.setCaretPosition(n);
        }
        return bl;
    }

    public boolean hasFileLoaded() {
        String string = this.getCurrentFileName();
        return StringUtil.isNonEmpty(string);
    }

    public int checkAndSaveFile() {
        return this.checkAndSaveFile(true);
    }

    public int checkAndSaveFile(boolean bl) {
        if (!this.hasFileLoaded()) {
            return 0;
        }
        int n = 0;
        if (this.isModified()) {
            boolean bl2;
            String string = ResourceMgr.getFormattedString("MsgConfirmUnsavedEditorFile", this.getCurrentFileName());
            n = bl ? WbSwingUtilities.getYesNoCancel(this, string) : ((bl2 = WbSwingUtilities.getYesNo(this, string)) ? 0 : 1);
            if (n == 0) {
                this.saveCurrentFile();
            }
            if (n == -1) {
                n = 2;
            }
        }
        return n;
    }

    public YesNoCancelResult canCloseFile() {
        int n = this.checkAndSaveFile();
        if (n == 0) {
            return YesNoCancelResult.yes;
        }
        if (n == 1) {
            return YesNoCancelResult.no;
        }
        return YesNoCancelResult.cancel;
    }

    public boolean readFile(File file) {
        return this.readFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean readFile(File file, String string) {
        boolean bl;
        block18: {
            if (file == null) {
                return false;
            }
            if (!file.exists()) {
                return false;
            }
            if (file.length() >= 0x2AAAAAAAL) {
                WbSwingUtilities.showErrorMessageKey(this, "MsgFileTooBig");
                return false;
            }
            bl = false;
            this.selectNone();
            BufferedReader bufferedReader = null;
            SyntaxDocument syntaxDocument = null;
            if (StringUtil.isEmptyString(string) && Settings.getInstance().getEditorDetectEncoding()) {
                string = FileUtil.detectFileEncoding(file);
            }
            if (StringUtil.isEmptyString(string)) {
                string = Settings.getInstance().getDefaultFileEncoding();
                LogMgr.logWarning(new CallerInfo(){}, "No encoding specified or detected for file \"" + file.getAbsolutePath() + "\". Using default encoding: " + string);
            }
            this.setCaretPosition(0);
            this.clearCurrentDocument();
            try {
                bufferedReader = EncodingUtil.createBufferedReader(file, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LogMgr.logError(new CallerInfo(){}, "Unsupported encoding: " + string + " requested.", unsupportedEncodingException);
                WbSwingUtilities.showErrorMessage(this, ResourceMgr.getFormattedString("ErrWrongEncoding", string));
                boolean bl2 = false;
                this.resetModified();
                FileUtil.closeQuietely(bufferedReader);
                this.fileModifiedTime = this.currentFile.lastModified();
                return bl2;
            }
            try {
                GapContent gapContent = new GapContent((int)file.length() + 1500);
                syntaxDocument = new SyntaxDocument(gapContent);
                syntaxDocument.suspendUndo();
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder(5000);
                boolean bl3 = false;
                int n2 = FileUtil.readLines(bufferedReader, stringBuilder, 50, "\n");
                while (n2 > 0) {
                    syntaxDocument.insertString(n, stringBuilder.toString(), null);
                    n += stringBuilder.length();
                    stringBuilder.setLength(0);
                    n2 = FileUtil.readLines(bufferedReader, stringBuilder, 50, "\n");
                    if (!MemoryWatcher.isMemoryLow(true)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    syntaxDocument.reset();
                    bl = false;
                    WbManager.getInstance().showLowMemoryError();
                } else {
                    syntaxDocument.resumeUndo();
                    this.setDocument(syntaxDocument);
                    this.currentFile = new WbFile(file);
                    this.fileEncoding = string;
                    bl = true;
                    this.fireFilenameChanged(file.getAbsolutePath());
                }
                this.checkFileActions();
            }
            catch (IOException | BadLocationException exception) {
                LogMgr.logError(new CallerInfo(){}, "Error reading file " + file.getAbsolutePath(), exception);
                this.resetModified();
                FileUtil.closeQuietely(bufferedReader);
                this.fileModifiedTime = this.currentFile.lastModified();
                break block18;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (syntaxDocument != null) {
                    syntaxDocument.reset();
                }
                System.gc();
                WbManager.getInstance().showOutOfMemoryError();
                bl = false;
                {
                    catch (Throwable throwable) {
                        this.resetModified();
                        FileUtil.closeQuietely(bufferedReader);
                        this.fileModifiedTime = this.currentFile.lastModified();
                        throw throwable;
                    }
                }
                this.resetModified();
                FileUtil.closeQuietely(bufferedReader);
                this.fileModifiedTime = this.currentFile.lastModified();
            }
            this.resetModified();
            FileUtil.closeQuietely(bufferedReader);
            this.fileModifiedTime = this.currentFile.lastModified();
        }
        return bl;
    }

    @Override
    public boolean saveCurrentFile() {
        boolean bl;
        try {
            if (this.currentFile != null) {
                this.saveFile(this.currentFile);
                bl = true;
            } else {
                bl = this.saveFile();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean saveFile() {
        FileFilter fileFilter;
        boolean bl = false;
        File file = OpenFileAction.getLastSQLDir(this.getMainWindow());
        if (this.editorType == 0) {
            file = OpenFileAction.getLastSQLDir(this.getMainWindow());
            fileFilter = ExtensionFileFilter.getSqlFileFilter();
        } else {
            file = new File(Settings.getInstance().getLastEditorDir());
            fileFilter = ExtensionFileFilter.getTextFileFilter();
        }
        WbFileChooser wbFileChooser = new WbFileChooser(file);
        wbFileChooser.setSelectedFile(this.currentFile);
        wbFileChooser.addChoosableFileFilter(fileFilter);
        EncodingDropDown encodingDropDown = new EncodingDropDown(this.fileEncoding != null ? this.fileEncoding : Settings.getInstance().getDefaultFileEncoding());
        encodingDropDown.setBorder(new EmptyBorder(0, 5, 0, 0));
        wbFileChooser.setAccessory(encodingDropDown);
        int n = wbFileChooser.showSaveDialog(SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            try {
                String string = encodingDropDown.getEncoding();
                if (StringUtil.isEmptyString(string)) {
                    string = FileUtil.detectFileEncoding(wbFileChooser.getSelectedFile());
                }
                this.saveFile(wbFileChooser.getSelectedFile(), string, Settings.getInstance().getExternalEditorLineEnding());
                if (this.allowFileLoading) {
                    this.fireFilenameChanged(this.getCurrentFileName());
                }
                file = wbFileChooser.getCurrentDirectory();
                if (this.editorType == 0) {
                    OpenFileAction.storeLastSQLDir(this.getMainWindow(), file);
                } else {
                    Settings.getInstance().setLastEditorDir(file.getAbsolutePath());
                }
                bl = true;
            }
            catch (IOException iOException) {
                WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("ErrSavingFile") + "\n" + ExceptionUtil.getDisplay(iOException));
                bl = false;
            }
        }
        return bl;
    }

    public void saveFile(File file) throws IOException {
        this.saveFile(file, this.fileEncoding, Settings.getInstance().getExternalEditorLineEnding());
    }

    public void saveFile(File file, String string) throws IOException {
        this.saveFile(file, string, Settings.getInstance().getExternalEditorLineEnding());
    }

    public void saveFile(File file, String string, String string2) throws IOException {
        if (string == null) {
            string = Settings.getInstance().getDefaultFileEncoding();
        }
        boolean bl = Settings.getInstance().getTrimTrailingSpaces();
        Writer writer = null;
        try {
            this.saveInProgress = true;
            String string3 = file.getAbsolutePath();
            int n = string3.indexOf(46);
            if (n < 0) {
                string3 = string3 + ".sql";
                file = new File(string3);
            }
            writer = EncodingUtil.createWriter(file, string, false);
            int n2 = this.getLineCount();
            for (int i = 0; i < n2; ++i) {
                String string4 = this.getLineText(i);
                int n3 = 0;
                if (bl) {
                    string4 = StringUtil.rtrim(string4);
                    n3 = string4.length();
                } else {
                    n3 = StringUtil.getRealLineLength(string4);
                }
                if (n3 > 0) {
                    writer.write(string4, 0, n3);
                    writer.write(string2);
                    continue;
                }
                if (i >= n2 - 1) continue;
                writer.write(string2);
            }
            if (this.allowFileLoading) {
                this.currentFile = new WbFile(file);
                this.fileEncoding = string;
                this.fileModifiedTime = this.currentFile.lastModified();
                this.resetModified();
            }
        }
        catch (IOException iOException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error saving file", iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(writer);
                this.saveInProgress = false;
                throw throwable;
            }
        }
        FileUtil.closeQuietely(writer);
        this.saveInProgress = false;
    }

    @Override
    public File getCurrentFile() {
        return this.currentFile;
    }

    public String getCurrentFileEncoding() {
        if (this.currentFile == null) {
            return null;
        }
        return this.fileEncoding;
    }

    public String getCurrentFileName() {
        if (this.currentFile == null) {
            return null;
        }
        return this.currentFile.getFullPath();
    }

    public ToggleCommentAction getToggleCommentAction() {
        return this.toggleCommentAction;
    }

    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    public UnCommentAction getUnCommentAction() {
        return this.unCommentAction;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("workbench.editor.electricscroll".equals(propertyChangeEvent.getPropertyName())) {
            this.setElectricScroll(Settings.getInstance().getElectricScroll());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.isEditable()) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(1);
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list != null && list.size() == 1) {
                    File file = (File)list.get(0);
                    if (this.canCloseFile() != YesNoCancelResult.cancel) {
                        this.readFile(file);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    } else {
                        dropTargetDropEvent.getDropTargetContext().dropComplete(false);
                    }
                } else {
                    dropTargetDropEvent.getDropTargetContext().dropComplete(false);
                    Window window = SwingUtilities.getWindowAncestor(this);
                    EventQueue.invokeLater(() -> {
                        window.toFront();
                        window.requestFocus();
                        WbSwingUtilities.showErrorMessageKey(window, "ErrNoMultipleDrop");
                    });
                }
            } else if (transferable.isDataFlavorSupported(ObjectTreeTransferable.DATA_FLAVOR)) {
                ObjectTreeTransferable objectTreeTransferable = (ObjectTreeTransferable)transferable.getTransferData(ObjectTreeTransferable.DATA_FLAVOR);
                EditorDropHandler editorDropHandler = new EditorDropHandler(this);
                editorDropHandler.handleDrop(objectTreeTransferable, dropTargetDropEvent.getLocation());
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                WbSwingUtilities.requestFocus(this);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            LogMgr.logDebug(new CallerInfo(){}, "Error when processing drop event", exception);
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

