/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;
import workbench.db.PkDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.FlatButton;
import workbench.gui.components.NumberField;
import workbench.gui.components.RowHighlighter;
import workbench.gui.components.SelectionHandler;
import workbench.gui.components.TableRowHeader;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbLabel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbarButton;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.NullableEditor;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ResultSetter;
import workbench.interfaces.StatusBar;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.LookupDataLoader;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.SortDefinition;
import workbench.storage.filter.ContainsComparator;
import workbench.storage.filter.DataRowExpression;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;
import workbench.util.WbThread;

public class LookupValuePicker
extends JPanel
implements KeyListener,
ValidatingComponent,
MouseListener,
Restoreable,
Reloadable,
ActionListener {
    private JTextField filterValue;
    private JRadioButton doFilter;
    private JRadioButton doSearch;
    private ButtonGroup buttonGroup;
    private NumberField maxRows;
    private WbTable lookupData;
    private final LookupDataLoader lookupLoader;
    private WbScrollPane scroll;
    private JPanel statusPanel;
    private JLabel statusBar;
    private JLabel rowCount;
    private WbConnection dbConnection;
    private ValidatingDialog dialog;
    private final Map<String, Object> currentValues = new HashMap<String, Object>();
    private SelectionHandler selectionHandler;
    private boolean multiSelect;

    public LookupValuePicker(WbConnection wbConnection, LookupDataLoader lookupDataLoader, Map<String, Object> map, boolean bl) {
        super(new GridBagLayout());
        this.lookupLoader = lookupDataLoader;
        this.dbConnection = wbConnection;
        this.multiSelect = bl;
        if (map != null) {
            this.currentValues.putAll(map);
        }
        this.filterValue = new JTextField();
        this.filterValue.addKeyListener(this);
        this.filterValue.addActionListener(this);
        this.filterValue.setToolTipText(ResourceMgr.getString("d_LblFkFilterValue"));
        this.lookupData = new WbTable(false, false, false){

            @Override
            protected JPopupMenu getHeaderPopup() {
                return this.createLimitedHeaderPopup();
            }
        };
        if (bl) {
            this.lookupData.setSelectionMode(2);
        } else {
            this.lookupData.setSelectionMode(0);
        }
        this.lookupData.setReadOnly(true);
        this.lookupData.setRendererSetup(new RendererSetup(false));
        this.lookupData.addMouseListener(this);
        this.lookupData.setColumnSelectionAllowed(false);
        this.lookupData.setRowSelectionAllowed(true);
        this.lookupData.getHeaderRenderer().setUnderlinePK(true);
        this.selectionHandler = new SelectionHandler(this.lookupData);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FocusTraversalPolicy focusTraversalPolicy = LookupValuePicker.this.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(LookupValuePicker.this, LookupValuePicker.this.lookupData);
                component.requestFocusInWindow();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FocusTraversalPolicy focusTraversalPolicy = LookupValuePicker.this.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentBefore(LookupValuePicker.this, LookupValuePicker.this.lookupData);
                component.requestFocusInWindow();
            }
        };
        InputMap inputMap = this.lookupData.getInputMap(0);
        inputMap.put(WbSwingUtilities.TAB, "picker-next-comp");
        inputMap.put(WbSwingUtilities.SHIFT_TAB, "picker-prev-comp");
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookupValuePicker.this.selectValue();
            }
        };
        this.lookupData.configureEnterKeyAction(abstractAction3);
        this.lookupData.getActionMap().put("picker-next-comp", abstractAction);
        this.lookupData.getActionMap().put("picker-prev-comp", abstractAction2);
        this.scroll = new WbScrollPane(this.lookupData);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.doFilter = new JRadioButton(ResourceMgr.getString("LblFkPickerFilter"));
        this.doFilter.setToolTipText(ResourceMgr.getDescription("LblFkPickerFilter"));
        this.doFilter.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.doSearch = new JRadioButton(ResourceMgr.getString("LblFkPickerSelect"));
        this.doSearch.setToolTipText(ResourceMgr.getDescription("LblFkPickerSelect"));
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.doFilter);
        this.buttonGroup.add(this.doSearch);
        boolean bl2 = Settings.getInstance().getBoolProperty("workbench.gui.lookupvaluepicker.usefilter", true);
        if (bl2) {
            this.doFilter.setSelected(true);
        } else {
            this.doSearch.setSelected(true);
        }
        jPanel.add(this.doFilter);
        jPanel.add(this.doSearch);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        WbLabel wbLabel = new WbLabel();
        wbLabel.setTextByKey("LblFkFilterValue");
        wbLabel.setLabelFor(this.filterValue);
        wbLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        jPanel2.add((Component)wbLabel, "West");
        jPanel2.add((Component)this.filterValue, "Center");
        jPanel2.add((Component)jPanel, "First");
        FlatButton flatButton = new FlatButton(new ReloadAction(this));
        flatButton.setText(null);
        flatButton.setMargin(WbToolbarButton.SMALL_MARGIN);
        jPanel2.add((Component)flatButton, "After");
        this.statusPanel = this.createStatusPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add((Component)this.scroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.fill = 2;
        this.add((Component)this.statusPanel, gridBagConstraints);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.filterValue);
        wbTraversalPolicy.addComponent(this.lookupData);
        wbTraversalPolicy.addComponent(this.maxRows);
        this.setFocusCycleRoot(true);
        this.lookupData.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
    }

    private JPanel createStatusPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 2, 0, 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.statusBar = new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.statusBar, gridBagConstraints);
        this.rowCount = new JLabel("   ");
        this.rowCount.setIconTextGap(2);
        this.rowCount.setBorder(new CompoundBorder(new DividerBorder(1), new EmptyBorder(0, 5, 0, 0)));
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.rowCount, gridBagConstraints);
        JLabel jLabel = new JLabel(" " + ResourceMgr.getString("LblMaxRows") + " ");
        jLabel.setBorder(new DividerBorder(1));
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.maxRows = new NumberField(6);
        WbSwingUtilities.setMinimumSize(this.maxRows, 6);
        gridBagConstraints.insets = WbSwingUtilities.getEmptyInsets();
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.maxRows, gridBagConstraints);
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(1), new EmptyBorder(1, 5, 1, 1));
        jPanel.setBorder(compoundBorder);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.filterValue && this.doSearch.isSelected()) {
            this.loadData(false);
        }
    }

    private int highlightCurrentValues() {
        Object object2;
        int n;
        if (this.currentValues.isEmpty()) {
            return -1;
        }
        int n3 = -1;
        int n4 = this.lookupData.getRowCount();
        DataStore dataStore = this.lookupData.getDataStore();
        Map<String, String> map = this.lookupLoader.getForeignkeyMap();
        for (n = 0; n < n4; ++n) {
            object2 = dataStore.getRowData(n);
            int n5 = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Object object3 = this.currentValues.get(entry.getValue());
                Object v = object2.get(entry.getKey());
                if (!RowData.objectsAreEqual(v, object3)) continue;
                ++n5;
            }
            if (n5 != map.size()) continue;
            n3 = n;
            break;
        }
        if (n3 > -1) {
            n = n3;
            object2 = (n2, string, object) -> {
                String string2 = (String)map.get(string);
                return n2 == n && this.currentValues.containsKey(string2);
            };
            this.lookupData.applyHighlightExpression((RowHighlighter)object2);
        }
        return n3;
    }

    @Override
    public void reload() {
        this.loadData(false);
    }

    @Override
    public void restoreSettings() {
        int n = Settings.getInstance().getIntProperty("workbench.gui.lookupvalue.picker.maxrows", 150);
        this.maxRows.setText(Integer.toString(n));
    }

    @Override
    public void saveSettings() {
        Settings.getInstance().setProperty("workbench.gui.lookupvalue.picker.maxrows", this.maxRows.getText());
    }

    protected void resetFilter() {
        this.lookupData.resetFilter();
    }

    private void setStatusText(String string) {
        WbSwingUtilities.invoke(() -> this.statusBar.setText(string));
    }

    protected void fixStatusBarHeight() {
        Dimension dimension = this.statusBar.getPreferredSize();
        this.statusBar.setMinimumSize(dimension);
        this.statusBar.setText("");
    }

    private String getSqlSearchExpression() {
        if (this.doFilter.isSelected()) {
            return null;
        }
        String string = this.filterValue.getText().trim();
        if (string.isEmpty()) {
            return null;
        }
        String string2 = this.dbConnection.getDbSettings().getLowerFunctionTemplate();
        if (string2 != null) {
            string = string.toLowerCase();
        }
        return "%" + string + "%";
    }

    public void loadData(final boolean bl) {
        WbThread wbThread = new WbThread("LookupPickerRetrieval"){

            @Override
            public void run() {
                LookupValuePicker.this._loadData(bl);
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadData(boolean bl) {
        try {
            this.setStatusText(ResourceMgr.getString("MsgRetrieving"));
            WbSwingUtilities.showWaitCursorOnWindow(this);
            boolean bl2 = Settings.getInstance().getBoolProperty("workbench.gui.lookupvaluepicker.useorderby", true);
            DataStore dataStore = this.lookupLoader.getLookupData(this.dbConnection, this.maxRows.getValue(), this.getSqlSearchExpression(), bl2);
            PkDefinition pkDefinition = this.lookupLoader.getPK();
            ResultInfo resultInfo = dataStore.getResultInfo();
            SortDefinition sortDefinition = new SortDefinition();
            for (String string : pkDefinition.getColumns()) {
                int n = resultInfo.findColumn(string);
                if (n <= -1) continue;
                resultInfo.getColumn(n).setIsPkColumn(true);
                sortDefinition.addSortColumn(n, true);
            }
            EventQueue.invokeLater(() -> {
                DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
                dataStoreTableModel.setAllowEditing(false);
                dataStoreTableModel.setSortDefinition(sortDefinition);
                this.lookupData.setModel(dataStoreTableModel, true);
                if (GuiSettings.getShowTableRowNumbers()) {
                    TableRowHeader.showRowHeader(this.lookupData);
                }
                int n = this.highlightCurrentValues();
                if (!bl || n < 0) {
                    n = 0;
                }
                this.selectionHandler.selectRow(n);
                int n2 = dataStore.getRowCount();
                int n3 = this.maxRows.getValue();
                this.rowCount.setText(ResourceMgr.getFormattedString("MsgRows", n2).replaceAll("[\\(\\)]", ""));
                if (n2 >= n3) {
                    this.rowCount.setIcon(IconMgr.getInstance().getLabelIcon("alert"));
                } else {
                    this.rowCount.setIcon(null);
                }
                this.statusPanel.doLayout();
                if (this.doFilter.isSelected()) {
                    this.filterValue.requestFocusInWindow();
                } else {
                    this.lookupData.requestFocusInWindow();
                }
            });
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not load lookup data", sQLException);
        }
        finally {
            this.setStatusText("");
            WbSwingUtilities.showDefaultCursorOnWindow(this);
        }
    }

    public List<Map<String, Object>> getSelectedPKValues() {
        int[] nArray = this.lookupData.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return Collections.emptyList();
        }
        PkDefinition pkDefinition = this.lookupLoader.getPK();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(1);
        List<String> list = pkDefinition.getColumns();
        DataStore dataStore = this.lookupData.getDataStore();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : list) {
                Object object = dataStore.getValue(n, string);
                hashMap.put(string, object);
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    protected void applyFilter() {
        ContainsComparator containsComparator = new ContainsComparator();
        DataRowExpression dataRowExpression = new DataRowExpression(containsComparator, this.filterValue.getText());
        dataRowExpression.setIgnoreCase(true);
        this.lookupData.applyFilter(dataRowExpression);
        this.selectionHandler.selectRow(0);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.doFilter.isSelected()) {
            return;
        }
        EventQueue.invokeLater(() -> {
            if (keyEvent.getKeyChar() == '\n') {
                this.selectValue();
            } else if (keyEvent.getKeyChar() == '\u001b') {
                this.resetFilter();
            } else {
                this.applyFilter();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.filterValue && keyEvent.getModifiers() == 0) {
            if (keyEvent.getKeyCode() == 27 && StringUtil.isNonBlank(this.filterValue.getText())) {
                keyEvent.consume();
                this.resetFilter();
            } else {
                this.selectionHandler.handleKeyPressed(keyEvent);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public boolean validateInput() {
        if (this.multiSelect) {
            return this.lookupData.getSelectedRowCount() > 0;
        }
        return this.lookupData.getSelectedRowCount() == 1;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        this.restoreSettings();
        this.fixStatusBarHeight();
        this.loadData(true);
    }

    public void selectValue() {
        this.dialog.approveAndClose();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selectValue();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void pickValue(final JComponent jComponent, final ResultSetter resultSetter, final WbConnection wbConnection, final String string, final TableIdentifier tableIdentifier, final boolean bl) {
        WbThread wbThread = new WbThread("RetrieveLookupFk"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WbSwingUtilities.showWaitCursor(jComponent);
                LookupValuePicker.showStatusMessage(jComponent, "MsgFkDeps", 0);
                TableIdentifier tableIdentifier2 = null;
                LookupDataLoader lookupDataLoader = new LookupDataLoader(tableIdentifier, string);
                try {
                    lookupDataLoader.retrieveReferencedTable(wbConnection);
                    tableIdentifier2 = lookupDataLoader.getLookupTable();
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not retrieve lookup information", sQLException);
                }
                finally {
                    LookupValuePicker.showStatusMessage(jComponent, null, 0);
                    WbSwingUtilities.showDefaultCursor(jComponent);
                }
                if (tableIdentifier2 != null) {
                    EventQueue.invokeLater(() -> LookupValuePicker.showDialog(jComponent, resultSetter, wbConnection, tableIdentifier, lookupDataLoader, bl));
                } else {
                    LookupValuePicker.showNotFound(jComponent);
                }
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showDialog(JComponent jComponent, ResultSetter resultSetter, WbConnection wbConnection, TableIdentifier tableIdentifier, LookupDataLoader lookupDataLoader, boolean bl) {
        try {
            ValidatingDialog validatingDialog;
            WbSwingUtilities.showWaitCursor(jComponent);
            TableIdentifier tableIdentifier2 = lookupDataLoader.getLookupTable();
            List<String> list = lookupDataLoader.getReferencingColumns();
            String string = "(" + StringUtil.listToString(list, ',') + ")";
            LookupValuePicker lookupValuePicker = new LookupValuePicker(wbConnection, lookupDataLoader, resultSetter.getFKValues(list), bl);
            JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(jComponent);
            String string2 = ResourceMgr.getFormattedString("MsgFkPickVal", tableIdentifier.getRawTableName() + string, tableIdentifier2.getTableExpression());
            lookupValuePicker.dialog = validatingDialog = new ValidatingDialog((Frame)jFrame, string2, (JComponent)lookupValuePicker);
            if (!Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.lookupvaluepicker")) {
                validatingDialog.setSize(450, 350);
            }
            WbSwingUtilities.center(validatingDialog, jFrame);
            validatingDialog.setVisible(true);
            Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.lookupvaluepicker");
            lookupValuePicker.saveSettings();
            if (!validatingDialog.isCancelled()) {
                List<Map<String, Object>> list2 = lookupValuePicker.getSelectedPKValues();
                resultSetter.setResult(list2, lookupDataLoader.getForeignkeyMap());
            }
        }
        finally {
            WbSwingUtilities.showDefaultCursor(jComponent);
        }
    }

    public static void openPicker(final WbTable wbTable) {
        int n = wbTable.getEditingColumn();
        if (n == -1) {
            return;
        }
        final int n2 = wbTable.getEditingRow();
        DataStore dataStore = wbTable.getDataStore();
        WbConnection wbConnection = dataStore.getOriginalConnection();
        if (!WbSwingUtilities.isConnectionIdle(wbTable, wbConnection)) {
            return;
        }
        final String string = wbTable.getColumnName(n);
        dataStore.checkUpdateTable();
        TableIdentifier tableIdentifier = dataStore.getUpdateTable();
        if (tableIdentifier == null) {
            LogMgr.logWarning(new CallerInfo(){}, "No update table available for the current table. Cannot open FK dialog");
            return;
        }
        ResultSetter resultSetter = new ResultSetter(){

            @Override
            public Map<String, Object> getFKValues(List<String> list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(list.size());
                for (String string2 : list) {
                    int n = wbTable.getColumnIndex(string2);
                    if (n <= -1) continue;
                    hashMap.put(string2, wbTable.getValueAt(n2, n));
                }
                return hashMap;
            }

            @Override
            public void setResult(List<Map<String, Object>> list, Map<String, String> map) {
                JComponent jComponent = (JComponent)wbTable.getEditorComponent();
                JTextComponent jTextComponent = jComponent instanceof JTextComponent ? (JTextComponent)jComponent : (jComponent instanceof NullableEditor ? ((NullableEditor)((Object)jComponent)).getEditor() : null);
                Map<String, Object> map2 = list.get(0);
                for (Map.Entry<String, Object> entry : map2.entrySet()) {
                    String string3 = entry.getKey();
                    String string2 = map.get(string3);
                    int n = wbTable.getColumnIndex(string2);
                    Object object = entry.getValue();
                    if (string2.equals(string) && jTextComponent != null) {
                        jTextComponent.setText(object == null ? "" : WbDateFormatter.getDisplayValue(object));
                    }
                    if (n <= -1) continue;
                    wbTable.setValueAt(object, n2, n);
                }
            }
        };
        LookupValuePicker.pickValue(wbTable, resultSetter, wbConnection, string, tableIdentifier, false);
    }

    private static void showNotFound(JComponent jComponent) {
        LookupValuePicker.showStatusMessage(jComponent, "MsgComplNoFK", 2500);
    }

    private static void showStatusMessage(JComponent jComponent, String string, int n) {
        WbSwingUtilities.invoke(() -> LookupValuePicker._showStatusMessage(jComponent, string, n));
    }

    private static void _showStatusMessage(JComponent jComponent, String string, int n) {
        StatusBar statusBar = null;
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof StatusBar)) continue;
            statusBar = (StatusBar)((Object)container);
            break;
        }
        if (statusBar == null) {
            return;
        }
        if (string == null) {
            statusBar.clearStatusMessage();
            statusBar.doRepaint();
        } else {
            String string2 = ResourceMgr.getString(string);
            if (n > 0) {
                statusBar.setStatusMessage(string2, n);
            } else {
                statusBar.setStatusMessage(string2);
                statusBar.doRepaint();
            }
        }
    }
}

