/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import workbench.gui.settings.ExternalFileHandling;
import workbench.gui.sql.PanelType;
import workbench.gui.sql.SqlPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.WbProperties;
import workbench.util.WbWorkspace;

public class PanelWorkspaceHandler {
    private SqlPanel client;

    public PanelWorkspaceHandler(SqlPanel sqlPanel) {
        this.client = sqlPanel;
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        if (this.client.hasFileLoaded()) {
            this.client.closeFile(true, false);
        }
        this.client.reset();
        try {
            wbWorkspace.readHistoryData(n, this.client.sqlHistory);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not read history data for index=" + n);
            this.client.clearSqlHistory();
        }
        this.client.setTabName(wbWorkspace.getTabTitle(n));
        WbProperties wbProperties = wbWorkspace.getSettings();
        int n2 = wbProperties.getIntProperty("tab" + n + ".divider.location", 200);
        this.client.setDividerLocation(n2);
        n2 = wbProperties.getIntProperty("tab" + n + ".divider.lastlocation", 0);
        this.client.contentPanel.setLastDividerLocation(n2);
        int n3 = wbWorkspace.getMaxRows(n);
        this.client.statusBar.setMaxRows(n3);
        n3 = wbWorkspace.getQueryTimeout(n);
        this.client.statusBar.setQueryTimeout(n3);
        this.client.invalidate();
        this.client.doLayout();
        String string = wbWorkspace.getExternalFileName(n);
        boolean bl = false;
        if (string != null) {
            String string2 = wbWorkspace.getExternalFileEncoding(n);
            bl = this.client.readFile(string, string2);
        }
        if (bl) {
            int n4 = wbWorkspace.getExternalFileCursorPos(n);
            if (n4 > -1 && n4 < this.client.editor.getText().length()) {
                this.client.editor.setCaretPosition(n4);
            }
        } else {
            try {
                this.client.sqlHistory.showCurrent();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when showing current history entry", exception);
            }
        }
        boolean bl2 = wbProperties.getBoolProperty("tab" + n + ".append.results", false);
        boolean bl3 = wbProperties.getBoolProperty("tab" + n + ".locked", false);
        this.client.setLocked(bl3);
        this.client.setAppendResults(bl2);
        this.client.updateAppendAction();
        this.client.editor.clearUndoBuffer();
        this.client.editor.resetModified();
        this.client.editor.invalidate();
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        String string;
        if (!this.client.hasFileLoaded() || this.client.hasFileLoaded() && Settings.getInstance().getFilesInWorkspaceHandling() != ExternalFileHandling.none) {
            this.client.storeStatementInHistory();
            wbWorkspace.addHistoryEntry(n, this.client.getHistory());
        }
        WbProperties wbProperties = wbWorkspace.getSettings();
        String string2 = "tab" + n;
        int n2 = this.client.contentPanel.getDividerLocation();
        int n3 = this.client.contentPanel.getLastDividerLocation();
        wbProperties.setProperty(string2 + ".divider.location", Integer.toString(n2));
        wbProperties.setProperty(string2 + ".divider.lastlocation", Integer.toString(n3));
        wbProperties.setProperty(string2 + ".append.results", Boolean.toString(this.client.getAppendResults()));
        wbProperties.setProperty(string2 + ".locked", Boolean.toString(this.client.isLocked()));
        wbProperties.setProperty(string2 + ".type", PanelType.sqlPanel.toString());
        wbWorkspace.setMaxRows(n, this.client.statusBar.getMaxRows());
        wbWorkspace.setQueryTimeout(n, this.client.statusBar.getQueryTimeout());
        if (this.client.hasFileLoaded() && Settings.getInstance().getFilesInWorkspaceHandling() == ExternalFileHandling.link) {
            wbWorkspace.setExternalFileName(n, this.client.getCurrentFileName());
            wbWorkspace.setExternalFileCursorPos(n, this.client.editor.getCaretPosition());
            wbWorkspace.setExternalFileEncoding(n, this.client.editor.getCurrentFileEncoding());
        }
        if ((string = this.client.getTabName()) == null) {
            string = ResourceMgr.getDefaultTabLabel();
        }
        wbWorkspace.setTabTitle(n, string);
    }
}

