/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import workbench.db.ColumnIdentifier;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.MultilineWrapAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.BlobHandler;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbDocument;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.renderer.ButtonDisplayPanel;
import workbench.gui.renderer.DateColumnRenderer;
import workbench.gui.renderer.NumberColumnRenderer;
import workbench.gui.renderer.WbRenderer;
import workbench.gui.renderer.WrapEnabledEditor;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.FormNavigation;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.SqlUtil;

public class RecordFormPanel
extends JPanel
implements ValidatingComponent,
ActionListener {
    private ResultInfo fieldDef;
    private JComponent[] inputControls;
    private WbRenderer[] renderer;
    private BlobHandler[] blobHandlers;
    private int currentRow;
    private WbTable data;
    private int toFocus;

    public RecordFormPanel(WbTable wbTable, int n) {
        this(wbTable, n, 0);
    }

    public RecordFormPanel(WbTable wbTable, int n, int n2) {
        super(new BorderLayout());
        this.fieldDef = wbTable.getDataStore().getResultInfo();
        this.data = wbTable;
        this.toFocus = n2 >= 0 ? n2 : 0;
        this.currentRow = n;
        this.buildEntryForm();
        this.showRecord(n);
    }

    public DataStore getDataStore() {
        if (this.data == null) {
            return null;
        }
        return this.data.getDataStore();
    }

    protected void buildEntryForm() {
        WbSwingUtilities.invoke(this::_buildEntryForm);
    }

    public boolean isEditingAllow() {
        boolean bl = true;
        TableModel tableModel = this.data.getModel();
        if (tableModel instanceof DataStoreTableModel) {
            bl = ((DataStoreTableModel)tableModel).getAllowEditing();
        }
        return bl;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    protected void _buildEntryForm() {
        Object object;
        if (this.fieldDef == null) {
            return;
        }
        this.removeAll();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.0;
        this.inputControls = new JComponent[this.fieldDef.getColumnCount()];
        this.blobHandlers = new BlobHandler[this.inputControls.length];
        Color color = GuiSettings.getRequiredFieldColor();
        Insets insets = new Insets(5, 0, 5, 0);
        Insets insets2 = new Insets(0, 10, 5, 5);
        Font font = Settings.getInstance().getDataFont(true);
        if (font == null) {
            font = UIManager.getFont("TextField.font");
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = GuiSettings.getDefaultFormFieldWidth();
        int n2 = fontMetrics != null ? fontMetrics.getMaxAdvance() : 12;
        int n3 = fontMetrics != null ? fontMetrics.getHeight() + 5 : 16;
        int n4 = n2 * n;
        int n5 = n3 * GuiSettings.getDefaultFormFieldLines();
        Dimension dimension = new Dimension(n4, n5);
        boolean bl = this.isEditingAllow();
        boolean bl2 = GuiSettings.getHighlightRequiredFields() && color != null;
        for (int i = 0; i < this.fieldDef.getColumnCount(); ++i) {
            JComponent jComponent;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = insets;
            gridBagConstraints.anchor = 12;
            object = this.fieldDef.getColumn(i);
            JLabel jLabel = new JLabel(((ColumnIdentifier)object).getColumnName());
            jLabel.setToolTipText(((ColumnIdentifier)object).getDbmsType());
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = insets2;
            gridBagConstraints.anchor = 18;
            JComponent jComponent2 = null;
            if (SqlUtil.isMultiLineColumn((ColumnIdentifier)object)) {
                jComponent = new JTextArea(new WbDocument()){

                    @Override
                    protected Document createDefaultModel() {
                        return new WbDocument();
                    }

                    @Override
                    public void read(Reader reader, Object object) throws IOException {
                        EditorKit editorKit = this.getUI().getEditorKit(this);
                        Document document = this.createDefaultModel();
                        if (object != null) {
                            document.putProperty("stream", object);
                        }
                        try {
                            editorKit.read(reader, document, 0);
                            this.setDocument(document);
                        }
                        catch (BadLocationException badLocationException) {
                            throw new IOException(badLocationException.getMessage());
                        }
                    }
                };
                WrapEnabledEditor wrapEnabledEditor = arg_0 -> RecordFormPanel.lambda$_buildEntryForm$0((JTextArea)jComponent, arg_0);
                ((JTextComponent)jComponent).setEditable(bl);
                TextComponentMouseListener textComponentMouseListener = new TextComponentMouseListener();
                textComponentMouseListener.addAction(new MultilineWrapAction(wrapEnabledEditor, (JTextComponent)jComponent, null));
                jComponent.addMouseListener(textComponentMouseListener);
                ((JTextArea)jComponent).setLineWrap(false);
                this.inputControls[i] = jComponent;
                JScrollPane jScrollPane = new JScrollPane(jComponent, 20, 30);
                jScrollPane.setMinimumSize(dimension);
                jScrollPane.setPreferredSize(dimension);
                this.inputControls[i].setFont(font);
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
                jComponent2 = jScrollPane;
            } else if (SqlUtil.isBlobType(((ColumnIdentifier)object).getDataType())) {
                jComponent = new JButton(" (BLOB) ");
                ((AbstractButton)jComponent).addActionListener(this);
                this.inputControls[i] = jComponent;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weighty = 0.0;
                jComponent2 = this.inputControls[i];
            } else {
                jComponent = new JTextField(new WbDocument(), null, n);
                ((JTextComponent)jComponent).setEditable(bl);
                TextComponentMouseListener.addListener(new JTextComponent[]{jComponent});
                this.inputControls[i] = jComponent;
                this.inputControls[i].setFont(font);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weighty = 0.0;
                jComponent2 = this.inputControls[i];
            }
            if (i == this.fieldDef.getColumnCount() - 1) {
                gridBagConstraints.weighty = 1.0;
            }
            jPanel.add((Component)jComponent2, gridBagConstraints);
            if (bl2 && !((ColumnIdentifier)object).isNullable()) {
                this.inputControls[i].setBackground(color);
            }
            ++gridBagConstraints.gridy;
        }
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        for (JComponent jComponent : this.inputControls) {
            wbTraversalPolicy.addComponent(jComponent);
        }
        object = new JScrollPane(jPanel, 20, 30);
        ((JScrollPane)object).setWheelScrollingEnabled(true);
        JScrollBar jScrollBar = ((JScrollPane)object).getVerticalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setUnitIncrement(n3 * 2);
            jScrollBar.setBlockIncrement(n3 * 10);
        }
        ((JComponent)object).setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(10, 5, 10, 5)));
        this.add((Component)object, "Center");
        wbTraversalPolicy.setDefaultComponent(this.inputControls[0]);
        this.initRenderer();
        this.add((Component)new FormNavigation(this), "South");
    }

    private void initRenderer() {
        if (this.fieldDef == null) {
            return;
        }
        if (this.inputControls == null) {
            return;
        }
        this.renderer = new WbRenderer[this.inputControls.length];
        Settings settings = Settings.getInstance();
        boolean bl = settings.useVariableLengthTimeFractions();
        String string = settings.getDefaultDateFormat();
        DateColumnRenderer dateColumnRenderer = new DateColumnRenderer(string, false);
        String string2 = settings.getDefaultTimestampFormat();
        DateColumnRenderer dateColumnRenderer2 = new DateColumnRenderer(string2, bl);
        int n = settings.getMaxFractionDigits();
        char c = settings.getDecimalSymbol().charAt(0);
        NumberColumnRenderer numberColumnRenderer = new NumberColumnRenderer(n, c);
        for (int i = 0; i < this.fieldDef.getColumnCount(); ++i) {
            int n2 = this.fieldDef.getColumnType(i);
            if (SqlUtil.isNumberType(n2)) {
                this.renderer[i] = numberColumnRenderer;
                continue;
            }
            if (n2 == 91) {
                this.renderer[i] = dateColumnRenderer;
                continue;
            }
            if (n2 != 93) continue;
            this.renderer[i] = dateColumnRenderer2;
        }
    }

    public void showRecord(int n) {
        this.currentRow = n;
        WbSwingUtilities.invoke(this::_showRecord);
    }

    protected void _showRecord() {
        for (int i = 0; i < this.fieldDef.getColumnCount(); ++i) {
            JTextComponent jTextComponent;
            Object object = this.data.getValueAt(this.currentRow, this.getTableColumn(i));
            if (object == null) {
                if (this.inputControls[i] instanceof JTextComponent) {
                    ((JTextComponent)this.inputControls[i]).setText("");
                }
                if (!(this.inputControls[i] instanceof ButtonDisplayPanel)) continue;
                ((ButtonDisplayPanel)this.inputControls[i]).setDisplayValue(null);
                continue;
            }
            if (SqlUtil.isBlobType(this.fieldDef.getColumnType(i))) {
                this.blobHandlers[i] = null;
                continue;
            }
            String string = null;
            if (this.renderer[i] != null) {
                this.renderer[i].prepareDisplay(object);
                string = this.renderer[i].getDisplayValue();
            } else {
                string = object.toString();
            }
            if (this.inputControls[i] instanceof JTextArea) {
                jTextComponent = (JTextArea)this.inputControls[i];
                this.setText(jTextComponent, string);
                jTextComponent.setCaretPosition(0);
                continue;
            }
            if (!(this.inputControls[i] instanceof JTextComponent)) continue;
            jTextComponent = (JTextComponent)this.inputControls[i];
            jTextComponent.setText(string);
            jTextComponent.setCaretPosition(0);
        }
        this.resetDocuments();
    }

    private void setText(JTextComponent jTextComponent, String string) {
        if (GuiSettings.getUseReaderForMultilineRenderer()) {
            StringReader stringReader = new StringReader(string);
            try {
                jTextComponent.read(stringReader, null);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not set value using StringReader", throwable);
                jTextComponent.setText(string);
            }
        } else {
            jTextComponent.setText(string);
        }
    }

    protected void resetDocuments() {
        for (JComponent jComponent : this.inputControls) {
            if (!(jComponent instanceof JTextComponent)) continue;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            WbDocument wbDocument = (WbDocument)jTextComponent.getDocument();
            wbDocument.resetModified();
        }
    }

    public boolean isChanged() {
        boolean bl = false;
        for (int i = 0; i < this.inputControls.length; ++i) {
            Serializable serializable;
            Object object;
            if (this.inputControls[i] instanceof JTextComponent) {
                object = (JTextComponent)this.inputControls[i];
                serializable = (WbDocument)((JTextComponent)object).getDocument();
                bl = bl || serializable.isModified();
                continue;
            }
            if (!(this.inputControls[i] instanceof JButton) || (object = this.blobHandlers[i]) == null) continue;
            serializable = ((BlobHandler)object).getUploadFile();
            if (serializable != null) {
                bl = true;
                continue;
            }
            if (((BlobHandler)object).isChanged()) {
                bl = true;
                continue;
            }
            if (!((BlobHandler)object).setToNull()) continue;
            bl = true;
        }
        return bl;
    }

    public void applyChanges() {
        for (int i = 0; i < this.inputControls.length; ++i) {
            Serializable serializable;
            Object object;
            if (this.inputControls[i] instanceof JTextComponent) {
                object = (JTextComponent)this.inputControls[i];
                serializable = (WbDocument)((JTextComponent)object).getDocument();
                if (!serializable.isModified()) continue;
                String string = ((JTextComponent)object).getText();
                this.data.setValueAt(string, this.currentRow, this.getTableColumn(i));
                continue;
            }
            if (!(this.inputControls[i] instanceof JButton) || (object = this.blobHandlers[i]) == null) continue;
            serializable = ((BlobHandler)object).getUploadFile();
            if (serializable != null) {
                this.data.setValueAt(serializable, this.currentRow, this.getTableColumn(i));
                continue;
            }
            if (((BlobHandler)object).isChanged()) {
                this.data.setValueAt(((BlobHandler)object).getNewValue(), this.currentRow, this.getTableColumn(i));
                continue;
            }
            if (!((BlobHandler)object).setToNull()) continue;
            this.data.setValueAt(null, this.currentRow, this.getTableColumn(i));
        }
    }

    private int getTableColumn(int n) {
        int n2 = this.data.isStatusColumnVisible() ? 1 : 0;
        int n3 = n + n2;
        int n4 = this.data.convertColumnIndexToView(n3);
        return n4;
    }

    private boolean startEdit() {
        DwPanel dwPanel = null;
        for (Container container = this.data.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof DwPanel)) continue;
            dwPanel = (DwPanel)container;
            break;
        }
        if (dwPanel != null) {
            return dwPanel.startEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateInput() {
        if (!this.isChanged()) {
            return true;
        }
        DataStoreTableModel dataStoreTableModel = this.data.getDataStoreTableModel();
        try {
            if (!this.startEdit()) {
                boolean bl = false;
                return bl;
            }
            dataStoreTableModel.setShowConverterError(false);
            this.applyChanges();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during validate", exception);
            WbSwingUtilities.showErrorMessage(exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            dataStoreTableModel.setShowConverterError(true);
        }
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        if (this.inputControls == null) {
            return;
        }
        EventQueue.invokeLater(this.inputControls[this.toFocus]::requestFocusInWindow);
    }

    private int getColumnIndexFor(Component component) {
        for (int i = 0; i < this.inputControls.length; ++i) {
            if (this.inputControls[i] != component) continue;
            return i;
        }
        return -1;
    }

    private void showBlob(int n, boolean bl, boolean bl2) {
        Object object = null;
        if (this.blobHandlers[n] == null) {
            this.blobHandlers[n] = new BlobHandler();
            object = this.data.getValueAt(this.currentRow, n);
        } else {
            File file = this.blobHandlers[n].getUploadFile();
            if (file != null) {
                object = file;
            } else if (this.blobHandlers[n].isChanged()) {
                object = this.blobHandlers[n].getNewValue();
            } else if (this.blobHandlers[n].setToNull()) {
                object = null;
            }
        }
        if (bl) {
            this.blobHandlers[n].showBlobAsText(object);
        } else if (bl2) {
            this.blobHandlers[n].showBlobAsImage(object);
        } else {
            this.blobHandlers[n].showBlobInfoDialog(null, object, !this.isEditingAllow());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent;
        int n;
        boolean bl = WbAction.isCtrlPressed(actionEvent);
        boolean bl2 = WbAction.isShiftPressed(actionEvent);
        Object object = actionEvent.getSource();
        if (object instanceof JComponent && (n = this.getColumnIndexFor(jComponent = (JComponent)object)) > -1) {
            this.showBlob(n, bl, bl2);
        }
    }

    private static /* synthetic */ void lambda$_buildEntryForm$0(JTextArea jTextArea, boolean bl) {
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
    }
}

