/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.EventQueue;
import workbench.gui.sql.EditorPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class SqlHistoryEntry {
    private String text;
    private int cursorPos;
    private int selectionStart;
    private int selectionEnd;

    public SqlHistoryEntry(String string, int n, int n2, int n3) {
        this.setText(string);
        int n4 = this.text.length();
        this.cursorPos = n > n4 ? n4 - 1 : (n < 0 ? 0 : n);
        this.selectionStart = n2 < 0 ? 0 : n2;
        this.selectionEnd = n3 > n4 ? n4 - 1 : n3;
    }

    public SqlHistoryEntry(String string) {
        this.setText(string);
        this.cursorPos = -1;
        this.selectionStart = -1;
        this.selectionEnd = -1;
    }

    public String getText() {
        return this.text;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void applyTo(EditorPanel editorPanel) {
        this.applyTo(editorPanel, Settings.getInstance().getBoolProperty("workbench.gui.history.center", false));
    }

    public void applyTo(EditorPanel editorPanel, boolean bl) {
        if (editorPanel == null) {
            return;
        }
        try {
            editorPanel.setText(this.text);
            if (this.selectionStart > -1 && this.selectionEnd > this.selectionStart && this.selectionEnd < editorPanel.getDocumentLength()) {
                editorPanel.select(this.selectionStart, this.selectionEnd);
            } else {
                editorPanel.setCaretPosition(this.cursorPos > -1 ? this.cursorPos : 0);
            }
            if (bl) {
                EventQueue.invokeLater(() -> {
                    int n = editorPanel.getCaretLine();
                    editorPanel.centerLine(n);
                });
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error applying " + this.toString(), exception);
        }
    }

    public String toString() {
        return "{" + StringUtil.getMaxSubstring(this.text, 40) + ", Cursor=" + this.cursorPos + ", Selection=[" + this.selectionStart + "," + this.selectionEnd + "]}";
    }

    public int hashCode() {
        int n = 3;
        n = 97 * n + (this.text != null ? this.text.hashCode() : 0);
        n = 97 * n + this.cursorPos;
        n = 97 * n + this.selectionStart;
        n = 97 * n + this.selectionEnd;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SqlHistoryEntry)) {
            return false;
        }
        SqlHistoryEntry sqlHistoryEntry = (SqlHistoryEntry)object;
        if (this.text.equals(sqlHistoryEntry.text)) {
            return this.cursorPos == sqlHistoryEntry.cursorPos && this.selectionEnd == sqlHistoryEntry.selectionEnd && this.selectionStart == sqlHistoryEntry.selectionStart;
        }
        return false;
    }

    private void setText(String string) {
        this.text = string == null ? "" : string;
    }
}

