/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.toolbar;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import workbench.gui.actions.WbAction;

public class ActionListModel
extends AbstractListModel {
    private List objects;

    public ActionListModel(List list) {
        this.objects = new ArrayList(list);
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    public void set(int n, Object object) {
        this.objects.set(n, object);
        this.fireContentsChanged(this, n, n);
    }

    public void addItem(int n, Object object) {
        this.objects.add(n, object);
        this.fireContentsChanged(this, n, n);
    }

    public void addItem(Object object) {
        boolean bl = this.objects.add(object);
        if (bl) {
            int n = this.objects.size() - 1;
            this.fireContentsChanged(this, n, n);
        }
    }

    public void removeItem(int n) {
        this.objects.remove(n);
        this.fireContentsChanged(this, n, n);
    }

    @Override
    public Object getElementAt(int n) {
        return this.objects.get(n);
    }

    public List<WbAction> getActions() {
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>();
        for (Object e : this.objects) {
            if (!(e instanceof WbAction)) continue;
            WbAction wbAction = (WbAction)e;
            arrayList.add(wbAction);
        }
        return arrayList;
    }

    public String getToolbarCommands() {
        StringBuilder stringBuilder = new StringBuilder(this.objects.size() * 20);
        for (Object e : this.objects) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            if (e instanceof String) {
                stringBuilder.append("$sep$");
                continue;
            }
            if (!(e instanceof WbAction)) continue;
            WbAction wbAction = (WbAction)e;
            stringBuilder.append(wbAction.getActionCommand());
        }
        return stringBuilder.toString();
    }
}

