/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.toolbar;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.border.Border;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DividerBorder;
import workbench.resource.IconMgr;

public class ActionRenderer
extends DefaultListCellRenderer {
    private Border separator = new DividerBorder(32);

    public ActionRenderer() {
        this.setIconTextGap(10);
        this.setHorizontalTextPosition(4);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (object instanceof String) {
            this.setText(" ");
            this.setBorder(this.separator);
            this.setIcon(null);
        } else if (object instanceof WbAction) {
            WbAction wbAction = (WbAction)object;
            this.setText(wbAction.getMenuLabel());
            String string = wbAction.getIconKey();
            ImageIcon imageIcon = null;
            if (wbAction.hasCustomIcon()) {
                String string2 = wbAction.getCustomIconFile();
                int n2 = IconMgr.getInstance().getSizeForLabel();
                imageIcon = IconMgr.getInstance().getExternalImage(string2, n2);
            } else if (string != null) {
                imageIcon = IconMgr.getInstance().getLabelIcon(string);
            }
            this.setIcon(imageIcon);
            this.setToolTipText(wbAction.getToolTipText());
        }
        return this;
    }
}

