/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DropType;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.datacopy.DataCopier;
import workbench.db.importer.DataImporter;
import workbench.db.importer.DeleteType;
import workbench.db.importer.ImportDMLStatementBuilder;
import workbench.db.importer.ImportMode;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.ProducerFactory;
import workbench.db.importer.TableStatements;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.AutoCompletionAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.EditWindow;
import workbench.gui.components.FlatButton;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbSplitPane;
import workbench.gui.dialogs.dataimport.ImportFileDialog;
import workbench.gui.help.HelpManager;
import workbench.gui.profiles.ProfileSelectionDialog;
import workbench.gui.sql.EditorPanel;
import workbench.gui.tools.ColumnMapper;
import workbench.gui.tools.TableSelectorPanel;
import workbench.interfaces.StatusBar;
import workbench.interfaces.ToolWindow;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.wbcommands.CommandTester;
import workbench.sql.wbcommands.CommonArgs;
import workbench.storage.RowActionMonitor;
import workbench.util.DurationFormatter;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class DataPumper
extends JPanel
implements ActionListener,
WindowListener,
PropertyChangeListener,
RowActionMonitor,
ToolWindow,
StatusBar {
    private static int instanceCount;
    private int windowId;
    private File sourceFile;
    private ProducerFactory fileImporter;
    private DataCopier copier;
    private ConnectionProfile sourceProfile;
    private ConnectionProfile targetProfile;
    protected WbConnection sourceConnection;
    protected WbConnection targetConnection;
    protected AutoCompletionAction completionAction;
    private JFrame window;
    private ColumnMapper columnMapper;
    private final String copyMsg = ResourceMgr.getString("MsgCopyingRow");
    protected boolean copyRunning;
    private EditorPanel sqlEditor;
    private boolean supportsBatch;
    private Timer executionTimer;
    private long timerStarted;
    private final int timerInterval = 1000;
    private final DurationFormatter durationFormatter = new DurationFormatter();
    boolean isConnecting = false;
    protected JTextField batchSize;
    protected JLabel batchSizeLabel;
    protected JPanel buttonPanel;
    protected JButton cancelButton;
    protected JButton checkQueryButton;
    protected JButton closeButton;
    protected JTextField commitEvery;
    protected JLabel commitLabel;
    protected JPanel connectionPanel;
    protected JCheckBox continueOnErrorCbx;
    protected JCheckBox deleteTargetCbx;
    protected JCheckBox dropTargetCbx;
    protected JLabel execTime;
    protected JButton helpButton;
    protected JCheckBox ignoreDropError;
    protected JCheckBox ignoreIdentityCbx;
    protected JLabel jLabel1;
    protected JLabel jLabel2;
    protected JLabel jLabel3;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanel3;
    protected JPanel jPanel4;
    protected JPanel jPanel5;
    protected JPanel jPanel6;
    protected JPanel jPanel7;
    protected JSplitPane jSplitPane1;
    protected JPanel mapperPanel;
    protected JComboBox modeComboBox;
    protected JLabel modeLabel;
    protected JButton openFileButton;
    protected JPanel optionsPanel;
    protected JTextField postTableStmt;
    protected JTextField preTableStmt;
    protected JButton selectSourceButton;
    protected JButton selectTargetButton;
    protected JButton showLogButton;
    protected JButton showWbCommand;
    protected JLabel sourceHeader;
    protected JPanel sourcePanel;
    protected JLabel sourceProfileLabel;
    protected JPanel sourceProfilePanel;
    protected TableSelectorPanel sourceTable;
    protected JLabel sqlEditorLabel;
    protected JPanel sqlPanel;
    protected JButton startButton;
    protected JLabel statusLabel;
    protected JLabel targetHeader;
    protected JPanel targetPanel;
    protected JLabel targetProfileLabel;
    protected JPanel targetProfilePanel;
    protected TableSelectorPanel targetTable;
    protected JPanel updateOptionPanel;
    protected JCheckBox useQueryCbx;
    protected JPanel wherePanel;

    public DataPumper() {
        this(null, null);
    }

    public DataPumper(ConnectionProfile connectionProfile, ConnectionProfile connectionProfile2) {
        this.windowId = ++instanceCount;
        this.sourceProfile = connectionProfile;
        this.targetProfile = connectionProfile2;
        this.initComponents();
        this.updateImportModes();
        this.execTime.setHorizontalAlignment(4);
        WbSwingUtilities.setMinimumSize(this.execTime, 10);
        this.execTime.setText("");
        CompoundBorder compoundBorder = new CompoundBorder(new DividerBorder(1), new EmptyBorder(0, 3, 0, 0));
        this.execTime.setBorder(compoundBorder);
        this.executionTimer = new Timer(1000, this);
        WbSwingUtilities.makeEqualWidth(this.cancelButton, this.closeButton, this.startButton, this.showLogButton, this.showWbCommand, this.helpButton);
        this.sourceTable.setAutoSyncVisible(false);
        this.commitEvery.setMinimumSize(this.commitEvery.getPreferredSize());
        this.batchSize.setMinimumSize(this.batchSize.getPreferredSize());
        this.selectSourceButton.addActionListener(this);
        this.selectTargetButton.addActionListener(this);
        this.openFileButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.updateDisplay();
        this.startButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.showLogButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.columnMapper = new ColumnMapper();
        this.mapperPanel.setLayout(new BorderLayout());
        this.mapperPanel.add((Component)this.columnMapper, "Center");
        this.updateOptionPanel.setBorder(new DividerBorder(1));
        this.checkQueryButton.addActionListener(this);
        this.showWbCommand.addActionListener(this);
        this.useQueryCbx.addActionListener(this);
        this.sqlEditor = EditorPanel.createSqlEditor();
        this.sqlEditor.showFormatSql();
        this.completionAction = new AutoCompletionAction(this.sqlEditor, this);
        this.wherePanel.add(this.sqlEditor);
        this.showWbCommand.setEnabled(false);
        this.batchSize.setEnabled(false);
        this.sourceTable.setTableDropDownName("sourceTable");
        this.targetTable.setTableDropDownName("targetTable");
        WbSwingUtilities.makeEqualSize(this.openFileButton, this.selectSourceButton, this.selectTargetButton);
    }

    @Override
    public JFrame getWindow() {
        return this.window;
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        if (this.sourceProfile != null) {
            settings.setLastConnection("workbench.datapumper.source.lastprofile", this.sourceProfile);
        }
        if (this.targetProfile != null) {
            settings.setLastConnection("workbench.datapumper.target.lastprofile", this.targetProfile);
        }
        settings.setProperty("workbench.datapumper.divider", this.jSplitPane1.getDividerLocation());
        settings.setProperty("workbench.datapumper.continue", Boolean.toString(this.continueOnErrorCbx.isSelected()));
        settings.setProperty("workbench.datapumper.commitevery", this.commitEvery.getText());
        settings.setProperty("workbench.datapumper.usequery", Boolean.toString(this.useQueryCbx.isSelected()));
        settings.setProperty("workbench.datapumper.updatemode", (String)this.modeComboBox.getSelectedItem());
        settings.setProperty("workbench.datapumper.alwayssynctables", this.targetTable.isAutoSyncSelected());
        String string = this.sqlEditor.getText();
        if (string != null && string.length() > 0) {
            settings.setProperty("workbench.datapumper.where", string);
        } else {
            settings.setProperty("workbench.datapumper.where", "");
        }
        settings.storeWindowSize(this.window, "workbench.datapumper.window");
        settings.storeWindowPosition(this.window, "workbench.datapumper.window");
        settings.setProperty("workbench.datapumper.batchsize", this.getBatchSize());
    }

    @Override
    public void activate() {
        this.window.setVisible(true);
        this.window.toFront();
    }

    @Override
    public WbConnection getConnection() {
        return null;
    }

    public void restoreSettings() {
        int n;
        String string;
        int n2;
        Settings settings = Settings.getInstance();
        boolean bl = settings.getBoolProperty("workbench.datapumper.continue", false);
        this.continueOnErrorCbx.setSelected(bl);
        if (!settings.restoreWindowSize(this.window, "workbench.datapumper.window")) {
            this.window.setSize(800, 600);
        }
        if ((n2 = settings.getIntProperty("workbench.datapumper.commitevery", 0)) > 0) {
            this.commitEvery.setText(Integer.toString(n2));
        }
        if ((string = settings.getProperty("workbench.datapumper.where", null)) != null && string.length() > 0) {
            this.sqlEditor.setText(string);
        }
        if ((n = settings.getIntProperty("workbench.datapumper.divider", -1)) == -1 && (n = this.jSplitPane1.getHeight() / 2) < 10) {
            n = 100;
        }
        this.jSplitPane1.setDividerLocation(n);
        boolean bl2 = settings.getBoolProperty("workbench.datapumper.usequery", false);
        this.useQueryCbx.setSelected(bl2);
        String string2 = settings.getProperty("workbench.datapumper.updatemode", "insert");
        this.modeComboBox.setSelectedItem(string2);
        this.checkType();
        int n3 = settings.getIntProperty("workbench.datapumper.batchsize", -1);
        if (n3 > 0) {
            this.batchSize.setText(Integer.toString(n3));
        }
        settings.getBoolProperty("workbench.datapumper.alwayssynctables", true);
        this.targetTable.setAutoSyncSelected(Settings.getInstance().getBoolProperty("workbench.datapumper.alwayssynctables", true));
    }

    private void selectInputFile() {
        ImportFileDialog importFileDialog = new ImportFileDialog(this);
        importFileDialog.setLastDirConfigKey("workbench.datapumper.lastdir");
        boolean bl = importFileDialog.selectInput(ResourceMgr.getString("TxtWindowTitleSelectImportFile"), "datapumper");
        if (!bl) {
            return;
        }
        if (this.sourceProfile != null) {
            this.disconnectSource();
        }
        this.sourceFile = importFileDialog.getSelectedFile();
        this.sourceTable.reset();
        this.sourceTable.setEnabled(false);
        this.useQueryCbx.setSelected(false);
        this.useQueryCbx.setEnabled(false);
        this.sqlEditor.setEnabled(false);
        this.useQueryCbx.setVisible(false);
        this.useQueryCbx.setVisible(false);
        this.sqlEditor.setVisible(false);
        this.fileImporter = new ProducerFactory(this.sourceFile);
        this.fileImporter.setTextOptions(importFileDialog.getTextOptions());
        this.fileImporter.setGeneralOptions(importFileDialog.getGeneralOptions());
        this.fileImporter.setType(importFileDialog.getImportType());
        this.checkType();
        this.modeComboBox.setSelectedItem(importFileDialog.getGeneralOptions().getMode());
        this.updateSourceDisplay();
        if (this.targetProfile != null) {
            this.initColumnMapper();
        }
    }

    public void startTimer() {
        this.timerStarted = System.currentTimeMillis();
        this.executionTimer.setInitialDelay(1000);
        this.executionTimer.setDelay(1000);
        this.executionTimer.start();
        this.execTime.setText("");
    }

    public void stopTimer() {
        this.executionTimer.stop();
    }

    @Override
    public void setStatusMessage(String string) {
        this.statusLabel.setText(string);
    }

    @Override
    public void setStatusMessage(String string, int n) {
        this.statusLabel.setText(string);
    }

    @Override
    public void clearStatusMessage() {
        this.statusLabel.setText("");
    }

    @Override
    public void doRepaint() {
        this.statusLabel.repaint();
    }

    @Override
    public String getText() {
        return this.statusLabel.getText();
    }

    private void updateTargetDisplay() {
        String string = ResourceMgr.getString("LblDPTargetProfile");
        if (this.targetProfile != null) {
            this.targetProfileLabel.setText(string + ": " + this.targetProfile.getName());
        } else {
            this.targetProfileLabel.setText(string + ": " + ResourceMgr.getString("LblPleaseSelect"));
        }
        this.updateWindowTitle();
    }

    private void updateSourceDisplay() {
        String string = ResourceMgr.getString("LblDPSourceProfile");
        if (this.sourceProfile != null) {
            this.sourceProfileLabel.setText(string + ": " + this.sourceProfile.getName());
        } else if (this.sourceFile != null) {
            this.sourceProfileLabel.setText(ResourceMgr.getString("LblDPSourceFile") + ": " + this.sourceFile.getAbsolutePath());
        } else {
            this.sourceProfileLabel.setText(string + ": " + ResourceMgr.getString("LblPleaseSelect"));
        }
        this.updateWindowTitle();
    }

    private void updateDisplay() {
        this.updateSourceDisplay();
        this.updateTargetDisplay();
        this.updateWindowTitle();
    }

    protected void updateWindowTitle() {
        if (this.targetProfile != null && (this.sourceProfile != null || this.sourceFile != null) && this.window != null) {
            String string = ResourceMgr.getString("TxtWindowTitleDataPumper");
            String string2 = "";
            if (this.sourceProfile != null) {
                string2 = this.sourceProfile.getName();
            } else if (this.sourceFile != null) {
                string2 = this.sourceFile.getName();
            }
            string = string + " [" + string2 + " -> " + this.targetProfile.getName() + "]";
            if (this.copier != null && this.copyRunning) {
                string = "\u00bb " + string;
            }
            this.window.setTitle(string);
        }
    }

    protected void checkConnections() {
        this.connectSource(this.sourceProfile);
        this.connectTarget(this.targetProfile);
    }

    private void connectSource(final ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return;
        }
        WbThread wbThread = new WbThread("DataPumper source connection"){

            @Override
            public void run() {
                DataPumper.this.doConnectSource(connectionProfile);
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectSource(ConnectionProfile connectionProfile) {
        this.disconnectSource();
        this.sourceProfile = connectionProfile;
        this.isConnecting = true;
        String string = ResourceMgr.getFormattedString("MsgConnectingTo", this.sourceProfile.getName());
        this.sourceProfileLabel.setIcon(IconMgr.getInstance().getLabelIcon("wait"));
        this.sourceProfileLabel.setText(string);
        try {
            this.sourceConnection = ConnectionMgr.getInstance().getConnection(this.sourceProfile, "Dp-Source" + this.windowId);
            this.sourceConnection.getMetadata().disableOutput();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when connecting to profile: " + (this.sourceProfile == null ? "n/a" : this.sourceProfile.getName()), exception);
            this.sourceProfile = null;
            WbSwingUtilities.showFriendlyErrorMessage(this, ResourceMgr.getString("ErrConnectFailed"), ExceptionUtil.getDisplay(exception));
        }
        finally {
            this.sourceProfileLabel.setIcon(null);
            this.updateSourceDisplay();
        }
        this.sourceFile = null;
        this.fileImporter = null;
        this.checkType();
        if (this.useQueryCbx.isSelected()) {
            this.initColumnMapper();
        }
        if (this.sourceConnection != null) {
            this.sourceTable.setEnabled(true);
            this.sourceTable.setChangeListener(this, "source-table");
            WbThread wbThread = new WbThread("Retrieve source tables"){

                @Override
                public void run() {
                    try {
                        LogMgr.logDebug(new CallerInfo(){}, "Source connection established retrieving tables.");
                        DataPumper.this.sourceTable.setConnection(DataPumper.this.sourceConnection);
                        DataPumper.this.completionAction.setConnection(DataPumper.this.sourceConnection);
                    }
                    finally {
                        DataPumper.this.isConnecting = false;
                    }
                }
            };
            wbThread.start();
        } else {
            this.isConnecting = false;
        }
    }

    private void connectTarget(final ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return;
        }
        WbThread wbThread = new WbThread("DataPumper target connection"){

            @Override
            public void run() {
                DataPumper.this.doConnectTarget(connectionProfile);
            }
        };
        wbThread.start();
    }

    private void updateImportModes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ImportMode.insert.getArgumentString());
        arrayList.add(ImportMode.update.getArgumentString());
        arrayList.add(ImportMode.insertUpdate.getArgumentString());
        arrayList.add(ImportMode.updateInsert.getArgumentString());
        if (ImportDMLStatementBuilder.supportsInsertIgnore(this.targetConnection)) {
            arrayList.add(ImportMode.insertIgnore.getArgumentString());
        }
        if (ImportDMLStatementBuilder.supportsUpsert(this.targetConnection)) {
            arrayList.add(ImportMode.upsert.getArgumentString());
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.modeComboBox.setModel(defaultComboBoxModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectTarget(ConnectionProfile connectionProfile) {
        this.isConnecting = true;
        this.disconnectTarget();
        this.targetProfile = connectionProfile;
        String string = ResourceMgr.getFormattedString("MsgConnectingTo", this.targetProfile.getName());
        this.targetProfileLabel.setText(string);
        this.targetProfileLabel.setIcon(IconMgr.getInstance().getLabelIcon("wait"));
        try {
            this.targetConnection = ConnectionMgr.getInstance().getConnection(this.targetProfile, "Dp-Target" + this.windowId);
            this.targetConnection.getMetadata().disableOutput();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when connecting to profile: " + this.targetProfile.getName(), exception);
            this.targetProfile = null;
            WbSwingUtilities.showFriendlyErrorMessage(this, ResourceMgr.getString("ErrConnectFailed"), ExceptionUtil.getDisplay(exception));
        }
        finally {
            this.targetProfileLabel.setIcon(null);
            this.updateTargetDisplay();
        }
        if (this.targetConnection != null) {
            this.targetTable.setChangeListener(this, "target-table");
            this.supportsBatch = this.targetConnection.getMetadata().supportsBatchUpdates();
            this.checkUseBatch();
            this.checkType();
            this.updateImportModes();
            WbThread wbThread = new WbThread("Retrieve target tables"){

                @Override
                public void run() {
                    try {
                        LogMgr.logDebug(new CallerInfo(){}, "Target connection established retrieving tables.");
                        DataPumper.this.targetTable.setConnection(DataPumper.this.targetConnection);
                    }
                    finally {
                        DataPumper.this.isConnecting = false;
                    }
                }
            };
            wbThread.start();
        } else {
            this.isConnecting = false;
        }
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.connectionPanel = new JPanel();
        this.sourcePanel = new JPanel();
        this.sourceHeader = new JLabel();
        this.sourceProfilePanel = new JPanel();
        this.sourceProfileLabel = new JLabel();
        this.selectSourceButton = new FlatButton();
        this.openFileButton = new FlatButton();
        this.sourceTable = new TableSelectorPanel();
        this.targetPanel = new JPanel();
        this.targetHeader = new JLabel();
        this.targetProfilePanel = new JPanel();
        this.targetProfileLabel = new JLabel();
        this.selectTargetButton = new FlatButton();
        this.targetTable = new TableSelectorPanel();
        this.jSplitPane1 = new WbSplitPane();
        this.mapperPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.sqlPanel = new JPanel();
        this.wherePanel = new JPanel();
        this.sqlEditorLabel = new JLabel();
        this.useQueryCbx = new JCheckBox();
        this.checkQueryButton = new FlatButton();
        this.updateOptionPanel = new JPanel();
        this.commitLabel = new JLabel();
        this.commitEvery = new JTextField();
        this.continueOnErrorCbx = new JCheckBox();
        this.deleteTargetCbx = new JCheckBox();
        this.ignoreIdentityCbx = new JCheckBox();
        this.dropTargetCbx = new JCheckBox();
        this.modeComboBox = new JComboBox();
        this.modeLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.batchSizeLabel = new JLabel();
        this.batchSize = new JTextField();
        this.ignoreDropError = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.preTableStmt = new JTextField();
        this.postTableStmt = new JTextField();
        this.buttonPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.startButton = new WbButton();
        this.cancelButton = new JButton();
        this.jPanel4 = new JPanel();
        this.showLogButton = new JButton();
        this.showWbCommand = new JButton();
        this.jPanel5 = new JPanel();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.jPanel7 = new JPanel();
        this.statusLabel = new JLabel();
        this.execTime = new JLabel();
        this.setLayout(new GridBagLayout());
        this.connectionPanel.setLayout(new GridLayout(1, 0, 2, 5));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.sourceHeader.setBackground(new Color(255, 255, 255));
        this.sourceHeader.setHorizontalAlignment(0);
        this.sourceHeader.setText("<html><b>" + ResourceMgr.getString("LblSourceConnection") + "</b></html>");
        this.sourceHeader.setBorder(BorderFactory.createEmptyBorder(10, 1, 10, 1));
        this.sourceHeader.setMinimumSize(new Dimension(25, 22));
        this.sourceHeader.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.sourcePanel.add((Component)this.sourceHeader, gridBagConstraints);
        this.sourceProfilePanel.setLayout(new GridBagLayout());
        this.sourceProfileLabel.setText("Source Profile");
        this.sourceProfileLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.sourceProfilePanel.add((Component)this.sourceProfileLabel, gridBagConstraints);
        this.selectSourceButton.setText("...");
        this.selectSourceButton.setMaximumSize(new Dimension(22, 22));
        this.selectSourceButton.setMinimumSize(new Dimension(22, 22));
        this.selectSourceButton.setName("selectSource");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.sourceProfilePanel.add((Component)this.selectSourceButton, gridBagConstraints);
        this.openFileButton.setIcon(IconMgr.getInstance().getLabelIcon("Open"));
        this.openFileButton.setToolTipText(ResourceMgr.getString("d_DataPumperOpenFile"));
        this.openFileButton.setIconTextGap(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.sourceProfilePanel.add((Component)this.openFileButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.sourcePanel.add((Component)this.sourceProfilePanel, gridBagConstraints);
        this.sourceTable.setMinimumSize(new Dimension(25, 50));
        this.sourceTable.setPreferredSize(new Dimension(25, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.sourcePanel.add((Component)this.sourceTable, gridBagConstraints);
        this.connectionPanel.add(this.sourcePanel);
        this.targetPanel.setLayout(new GridBagLayout());
        this.targetHeader.setBackground(new Color(255, 255, 255));
        this.targetHeader.setHorizontalAlignment(0);
        this.targetHeader.setText("<html><b>" + ResourceMgr.getString("LblTargetConnection") + "</b></html>");
        this.targetHeader.setBorder(BorderFactory.createEmptyBorder(10, 1, 10, 1));
        this.targetHeader.setMinimumSize(new Dimension(25, 22));
        this.targetHeader.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.targetPanel.add((Component)this.targetHeader, gridBagConstraints);
        this.targetProfilePanel.setLayout(new GridBagLayout());
        this.targetProfileLabel.setHorizontalAlignment(2);
        this.targetProfileLabel.setText("Target Profile");
        this.targetProfileLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.targetProfilePanel.add((Component)this.targetProfileLabel, gridBagConstraints);
        this.selectTargetButton.setText("...");
        this.selectTargetButton.setName("selectTarget");
        this.selectTargetButton.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.targetProfilePanel.add((Component)this.selectTargetButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.targetPanel.add((Component)this.targetProfilePanel, gridBagConstraints);
        this.targetTable.setToolTipText("");
        this.targetTable.setMinimumSize(new Dimension(25, 50));
        this.targetTable.setPreferredSize(new Dimension(25, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.targetPanel.add((Component)this.targetTable, gridBagConstraints);
        this.connectionPanel.add(this.targetPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 0, 3);
        this.add((Component)this.connectionPanel, gridBagConstraints);
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setTopComponent(this.mapperPanel);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.sqlPanel.setLayout(new GridBagLayout());
        this.wherePanel.setLayout(new BorderLayout());
        this.sqlEditorLabel.setText(ResourceMgr.getString("LblDPAdditionalWhere"));
        this.wherePanel.add((Component)this.sqlEditorLabel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 4, 1);
        this.sqlPanel.add((Component)this.wherePanel, gridBagConstraints);
        this.useQueryCbx.setText(ResourceMgr.getString("LblDPUseSQLSource"));
        this.useQueryCbx.setToolTipText(ResourceMgr.getString("d_LblDPUseSQLSource"));
        this.useQueryCbx.setHorizontalAlignment(2);
        this.useQueryCbx.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.sqlPanel.add((Component)this.useQueryCbx, gridBagConstraints);
        this.checkQueryButton.setText(ResourceMgr.getString("LblDPCheckQuery"));
        this.checkQueryButton.setToolTipText(ResourceMgr.getString("d_LblDPCheckQuery"));
        this.checkQueryButton.setEnabled(false);
        this.checkQueryButton.setMargin(new Insets(2, 5, 2, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.sqlPanel.add((Component)this.checkQueryButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel2.add((Component)this.sqlPanel, gridBagConstraints);
        this.updateOptionPanel.setLayout(new GridBagLayout());
        this.commitLabel.setHorizontalAlignment(2);
        this.commitLabel.setText(ResourceMgr.getString("LblDPCommitEvery"));
        this.commitLabel.setToolTipText(ResourceMgr.getString("d_LblDPCommitEvery"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.updateOptionPanel.add((Component)this.commitLabel, gridBagConstraints);
        this.commitEvery.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 0);
        this.updateOptionPanel.add((Component)this.commitEvery, gridBagConstraints);
        this.continueOnErrorCbx.setText(ResourceMgr.getString("MsgDPContinueOnError"));
        this.continueOnErrorCbx.setToolTipText(ResourceMgr.getString("d_MsgDPContinueOnError"));
        this.continueOnErrorCbx.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.updateOptionPanel.add((Component)this.continueOnErrorCbx, gridBagConstraints);
        this.deleteTargetCbx.setText(ResourceMgr.getString("LblDeleteTargetTable"));
        this.deleteTargetCbx.setToolTipText(ResourceMgr.getString("d_LblDeleteTargetTable"));
        this.deleteTargetCbx.setHorizontalTextPosition(4);
        this.deleteTargetCbx.setName("deleteTargetCbx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        this.updateOptionPanel.add((Component)this.deleteTargetCbx, gridBagConstraints);
        this.ignoreIdentityCbx.setText(ResourceMgr.getString("LblIgnoreIdentity"));
        this.ignoreIdentityCbx.setToolTipText(ResourceMgr.getString("d_LblIgnoreIdentity"));
        this.ignoreIdentityCbx.setHorizontalTextPosition(4);
        this.ignoreIdentityCbx.setName("deleteTargetCbx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.updateOptionPanel.add((Component)this.ignoreIdentityCbx, gridBagConstraints);
        this.dropTargetCbx.setText(ResourceMgr.getString("LblDPDropTable"));
        this.dropTargetCbx.setToolTipText(ResourceMgr.getString("d_LblDPDropTable"));
        this.dropTargetCbx.setEnabled(false);
        this.dropTargetCbx.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.updateOptionPanel.add((Component)this.dropTargetCbx, gridBagConstraints);
        this.modeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"insert", "update", "insert,update", "update,insert"}));
        this.modeComboBox.setName("modeSelector");
        this.modeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPumper.this.modeComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.updateOptionPanel.add((Component)this.modeComboBox, gridBagConstraints);
        this.modeLabel.setText(ResourceMgr.getString("LblDPMode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.updateOptionPanel.add((Component)this.modeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weighty = 1.0;
        this.updateOptionPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblDPUpdateOptions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 7, 0, 5);
        this.updateOptionPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.batchSizeLabel.setHorizontalAlignment(2);
        this.batchSizeLabel.setText(ResourceMgr.getString("LblBatchSize"));
        this.batchSizeLabel.setToolTipText(ResourceMgr.getString("d_LblBatchSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.updateOptionPanel.add((Component)this.batchSizeLabel, gridBagConstraints);
        this.batchSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 0);
        this.updateOptionPanel.add((Component)this.batchSize, gridBagConstraints);
        this.ignoreDropError.setText(ResourceMgr.getString("LblIgnoreDropErrors"));
        this.ignoreDropError.setToolTipText(ResourceMgr.getString("d_LblIgnoreDropErrors"));
        this.ignoreDropError.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.updateOptionPanel.add((Component)this.ignoreDropError, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblBeforeTable"));
        this.jLabel2.setToolTipText(ResourceMgr.getString("d_LblBeforeTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 8, 0, 0);
        this.updateOptionPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(ResourceMgr.getString("LblAfterTable"));
        this.jLabel3.setToolTipText(ResourceMgr.getString("d_LblAfterTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.updateOptionPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.preTableStmt.setToolTipText(ResourceMgr.getString("d_LblBeforeTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(8, 4, 0, 20);
        this.updateOptionPanel.add((Component)this.preTableStmt, gridBagConstraints);
        this.postTableStmt.setToolTipText(ResourceMgr.getString("d_LblAfterTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 20);
        this.updateOptionPanel.add((Component)this.postTableStmt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.updateOptionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.optionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 2, 0, 2);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.startButton.setText(ResourceMgr.getString("LblStartDataPumper"));
        this.startButton.setEnabled(false);
        this.startButton.setName("startButton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel3.add((Component)this.startButton, gridBagConstraints);
        this.cancelButton.setText(ResourceMgr.getString("LblCancelCopy"));
        this.cancelButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.buttonPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.showLogButton.setText(ResourceMgr.getString("LblShowDataPumperLog"));
        this.showLogButton.setEnabled(false);
        this.jPanel4.add((Component)this.showLogButton, new GridBagConstraints());
        this.showWbCommand.setText(ResourceMgr.getString("LblShowScript"));
        this.showWbCommand.setToolTipText(ResourceMgr.getString("d_LblShowScript"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.showWbCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.4;
        this.buttonPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.helpButton.setText(ResourceMgr.getString("LblHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.helpButton, gridBagConstraints);
        this.closeButton.setText(ResourceMgr.getString("LblClose"));
        this.closeButton.setName("closeButton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 11, 0, 2);
        this.jPanel5.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.2;
        this.buttonPanel.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 0, 8, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.jPanel7.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.statusLabel, gridBagConstraints);
        this.execTime.setText("00:00:00");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel7.add((Component)this.execTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jPanel7, gridBagConstraints);
    }

    private void modeComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.modeComboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        ImportMode importMode = DataImporter.getModeValue(string);
        if (DataImporter.isDeleteTableAllowed(importMode)) {
            this.deleteTargetCbx.setEnabled(true);
        } else {
            this.deleteTargetCbx.setSelected(false);
            this.deleteTargetCbx.setEnabled(false);
        }
        this.checkUseBatch();
    }

    public void showWindow() {
        this.showWindow(null);
    }

    public void showWindow(MainWindow mainWindow) {
        this.window = new JFrame(ResourceMgr.getString("TxtWindowTitleDataPumper")){

            @Override
            public void setVisible(boolean bl) {
                if (!bl) {
                    DataPumper.this.saveSettings();
                }
                super.setVisible(bl);
            }
        };
        this.window.setDefaultCloseOperation(0);
        ResourceMgr.setWindowIcons((Window)this.window, "datapumper");
        this.window.getContentPane().add(this);
        this.restoreSettings();
        this.window.addWindowListener(this);
        WbManager.getInstance().registerToolWindow(this);
        if (mainWindow == null) {
            if (!Settings.getInstance().restoreWindowPosition(this.window, "workbench.datapumper.window")) {
                WbSwingUtilities.center(this.window, null);
            }
        } else {
            WbSwingUtilities.center(this.window, mainWindow);
        }
        this.window.setVisible(true);
        EventQueue.invokeLater(this::checkConnections);
    }

    private void disconnectTarget() {
        if (this.targetConnection == null) {
            return;
        }
        try {
            String string = ResourceMgr.getString("MsgDisconnecting");
            this.targetProfileLabel.setText(string);
            this.targetProfileLabel.setIcon(IconMgr.getInstance().getLabelIcon("wait"));
            this.targetTable.removeChangeListener();
            this.targetConnection.disconnect();
            this.targetTable.setConnection(null);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error disconnecting target connection", exception);
        }
        finally {
            this.targetConnection = null;
            this.targetProfile = null;
            this.updateTargetDisplay();
            this.targetProfileLabel.setIcon(null);
        }
    }

    private void disconnectSource() {
        if (this.sourceConnection == null) {
            return;
        }
        try {
            String string = ResourceMgr.getString("MsgDisconnecting");
            this.sourceProfileLabel.setText(string);
            this.sourceProfileLabel.setIcon(IconMgr.getInstance().getLabelIcon("wait"));
            this.sourceTable.removeChangeListener();
            this.sourceConnection.disconnect();
            this.sourceTable.setConnection(null);
            this.completionAction.setConnection(null);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error disconnecting source connection", exception);
        }
        finally {
            this.sourceConnection = null;
            this.sourceProfile = null;
            this.updateSourceDisplay();
            this.sourceProfileLabel.setIcon(null);
        }
    }

    private void selectTargetConnection() {
        ConnectionProfile connectionProfile = this.selectConnection("workbench.datapumper.target.lastprofile");
        this.connectTarget(connectionProfile);
    }

    private void selectSourceConnection() {
        ConnectionProfile connectionProfile = this.selectConnection("workbench.datapumper.source.lastprofile");
        this.connectSource(connectionProfile);
    }

    private ConnectionProfile selectConnection(String string) {
        ConnectionProfile connectionProfile = null;
        try {
            WbSwingUtilities.showWaitCursor(this.window);
            ProfileSelectionDialog profileSelectionDialog = new ProfileSelectionDialog((Frame)this.window, true, string);
            WbSwingUtilities.center(profileSelectionDialog, this.window);
            WbSwingUtilities.showDefaultCursor(this.window);
            profileSelectionDialog.setVisible(true);
            connectionProfile = profileSelectionDialog.getSelectedProfile();
            boolean bl = profileSelectionDialog.isCancelled();
            if (!bl) {
                connectionProfile = profileSelectionDialog.getSelectedProfile();
                if (connectionProfile != null) {
                    Settings.getInstance().setProperty(string, connectionProfile.getName());
                } else {
                    LogMgr.logError(new CallerInfo(){}, "NULL Profile selected!", null);
                }
            }
            profileSelectionDialog.setVisible(false);
            profileSelectionDialog.dispose();
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error during connect", throwable);
            connectionProfile = null;
        }
        return connectionProfile;
    }

    private void checkUseBatch() {
        String string;
        if (this.supportsBatch && ("insert".equals(string = (String)this.modeComboBox.getSelectedItem()) || "update".equals(string))) {
            this.batchSize.setEnabled(this.supportsBatch);
            return;
        }
        this.batchSize.setEnabled(false);
        this.batchSize.setText("");
    }

    private void showHelp() {
        HelpManager.showDataPumperHelp();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.closeWindow();
        } else if (actionEvent.getSource() == this.helpButton) {
            this.showHelp();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelCopy();
        } else if (actionEvent.getSource() == this.selectTargetButton) {
            this.selectTargetConnection();
        } else if (actionEvent.getSource() == this.openFileButton) {
            this.selectInputFile();
        } else if (actionEvent.getSource() == this.selectSourceButton) {
            this.selectSourceConnection();
        } else if (actionEvent.getSource() == this.showWbCommand) {
            this.showCopyCommand();
        } else if (actionEvent.getSource() == this.startButton) {
            if (this.copyRunning) {
                this.cancelCopy();
            } else if (this.columnMapper != null) {
                this.startCopy();
            }
        } else if (actionEvent.getSource() == this.useQueryCbx) {
            this.resetColumnMapper();
            this.checkType();
        } else if (actionEvent.getSource() == this.checkQueryButton) {
            this.initColumnMapper();
        } else if (actionEvent.getSource() == this.showLogButton) {
            this.showLog();
        } else if (actionEvent.getSource() == this.executionTimer) {
            long l = System.currentTimeMillis() - this.timerStarted;
            this.execTime.setText(this.durationFormatter.formatDuration(l, Settings.getInstance().getDurationFormat(), false));
        }
    }

    private void checkType() {
        String string;
        boolean bl = this.useQueryCbx.isSelected();
        boolean bl2 = !bl && this.fileImporter == null;
        this.sourceTable.setEnabled(bl2);
        TableIdentifier tableIdentifier = this.targetTable.getSelectedTable();
        boolean bl3 = this.fileImporter == null;
        this.sqlEditor.setEnabled(bl3);
        this.checkQueryButton.setEnabled(bl3 && bl && tableIdentifier != null);
        this.targetTable.allowNewTable(bl3);
        if (bl) {
            if (tableIdentifier == null) {
                this.statusLabel.setText(ResourceMgr.getString("MsgTargetRequired"));
            } else {
                this.statusLabel.setText("");
            }
        } else {
            this.statusLabel.setText("");
        }
        this.useQueryCbx.setVisible(bl3);
        this.useQueryCbx.setEnabled(bl3);
        this.sqlEditor.setVisible(bl3);
        this.checkQueryButton.setVisible(bl3);
        this.sqlEditorLabel.setVisible(bl3);
        if (bl) {
            this.sqlEditorLabel.setText(ResourceMgr.getString("LblDPQueryText"));
        } else {
            this.sqlEditorLabel.setText(ResourceMgr.getString("LblDPAdditionalWhere"));
        }
        if (!bl && this.isSelectQuery() && WbSwingUtilities.getYesNo(this, string = ResourceMgr.getString("MsgDPRemoveQuery"))) {
            this.sqlEditor.setText("");
        }
    }

    private boolean isSelectQuery() {
        String string = SqlUtil.getSqlVerb(this.sqlEditor.getText());
        return string.equalsIgnoreCase("select");
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.copyRunning) {
            this.cancelCopy();
        }
        this.closeWindow();
    }

    @Override
    public void closeWindow() {
        this.done();
        if (this.window != null) {
            this.window.removeWindowListener(this);
            this.window.dispose();
        }
    }

    @Override
    public void disconnect() {
        this.disconnectSource();
        this.disconnectTarget();
    }

    public void done() {
        this.saveSettings();
        this.sourceProfile = null;
        this.targetProfile = null;
        this.columnMapper.resetData();
        this.columnMapper = null;
        WbThread wbThread = new WbThread("DataPumper disconnect thread"){

            @Override
            public void run() {
                DataPumper.this.disconnect();
                DataPumper.this.unregister();
            }
        };
        wbThread.start();
    }

    protected void unregister() {
        WbManager.getInstance().unregisterToolWindow(this);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        TableIdentifier tableIdentifier = this.targetTable.getSelectedTable();
        TableIdentifier tableIdentifier2 = this.sourceTable.getSelectedTable();
        this.checkType();
        if (propertyChangeEvent.getSource() == this.sourceTable && tableIdentifier2 != null) {
            if (tableIdentifier != null && tableIdentifier.isNewTable()) {
                this.targetTable.resetNewTableItem();
                tableIdentifier = null;
            }
            if (tableIdentifier == null || this.targetTable.isAutoSyncSelected()) {
                this.targetTable.findAndSelectTable(tableIdentifier2.getTableName());
            }
        } else if (propertyChangeEvent.getSource() == this.targetTable && tableIdentifier != null && tableIdentifier2 == null) {
            this.sourceTable.findAndSelectTable(tableIdentifier.getTableName());
        }
        if (tableIdentifier != null && tableIdentifier.isNewTable() && (string = tableIdentifier.getTableName()) == null) {
            String string2 = null;
            if (tableIdentifier2 != null) {
                string2 = tableIdentifier2.getTableName();
            }
            if ((string = WbSwingUtilities.getUserInput(this, ResourceMgr.getString("TxtEnterNewTableName"), string2)) != null) {
                tableIdentifier.parseTableIdentifier(string);
                this.targetTable.repaint();
            }
        }
        if (this.hasSource() && tableIdentifier != null) {
            EventQueue.invokeLater(this::initColumnMapper);
        } else {
            this.startButton.setEnabled(false);
            this.showWbCommand.setEnabled(false);
            this.columnMapper.resetData();
            this.dropTargetCbx.setEnabled(false);
            this.ignoreDropError.setEnabled(false);
        }
    }

    public boolean hasSource() {
        if (this.useQueryCbx.isSelected()) {
            return this.sqlEditor.getText().length() > 0;
        }
        if (this.fileImporter != null) {
            return true;
        }
        return this.sourceTable.getSelectedTable() != null;
    }

    private List<ColumnIdentifier> getResultSetColumns() {
        if (this.sourceConnection == null) {
            return null;
        }
        String string = this.sqlEditor.getText();
        List<ColumnIdentifier> list = null;
        try {
            list = SqlUtil.getResultSetColumns(string, this.sourceConnection);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error when retrieving ResultSet definition for source SQL", sQLException);
            WbSwingUtilities.showErrorMessage(this, sQLException.getMessage());
        }
        return list;
    }

    private void resetColumnMapper() {
        this.columnMapper.resetData();
    }

    private List<ColumnIdentifier> getKeyColumns() {
        ColumnMapper.MappingDefinition mappingDefinition = this.columnMapper.getMapping();
        if (mappingDefinition == null) {
            return Collections.emptyList();
        }
        int n = mappingDefinition.targetColumns.length;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        for (int i = 0; i < n; ++i) {
            if (!mappingDefinition.targetColumns[i].isPkColumn()) continue;
            arrayList.add(mappingDefinition.targetColumns[i]);
        }
        return arrayList;
    }

    private void showImportCommand() {
        if (this.fileImporter == null || this.targetProfile == null) {
            return;
        }
        StringBuilder stringBuilder = null;
        try {
            this.initImporter();
            stringBuilder = this.fileImporter.getWbCommand();
            this.appendGeneralImportOptions(stringBuilder, "WbImport".length());
            stringBuilder.append(";\n");
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error creating SQL command", exception);
            stringBuilder = new StringBuilder(ExceptionUtil.getDisplay(exception));
        }
        EditWindow editWindow = new EditWindow((Frame)this.window, ResourceMgr.getString("MsgWindowTitleDPScript"), stringBuilder.toString(), "workbench.datapumper.scriptwindow", true);
        editWindow.setVisible(true);
        editWindow.dispose();
    }

    private void appendGeneralImportOptions(StringBuilder stringBuilder, int n) {
        int n2;
        String string = StringUtil.padRight("", n + 1);
        CommonArgs.appendArgument(stringBuilder, "ignoreIdentityColumns", Boolean.toString(this.ignoreIdentityCbx.isSelected()), string);
        String string2 = (String)this.modeComboBox.getSelectedItem();
        if (!"insert".equals(string2)) {
            CommonArgs.appendArgument(stringBuilder, "mode", string2, string);
            List<ColumnIdentifier> list = this.getKeyColumns();
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                stringBuilder.append("\n");
                stringBuilder.append(string);
                stringBuilder.append("-keyColumns=");
                while (iterator.hasNext()) {
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)iterator.next();
                    stringBuilder.append(columnIdentifier.getColumnName());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(',');
                }
            }
        }
        CommonArgs.appendArgument(stringBuilder, "deleteTarget", Boolean.toString(this.deleteTargetCbx.isSelected()), string);
        CommonArgs.appendArgument(stringBuilder, "continueOnError", Boolean.toString(this.continueOnErrorCbx.isSelected()), string);
        int n3 = this.getBatchSize();
        if (n3 > 0) {
            CommonArgs.appendArgument(stringBuilder, "batchSize", Integer.toString(n3), string);
        }
        if (n3 <= 0 && (n2 = StringUtil.getIntValue(this.commitEvery.getText(), -1)) > 0) {
            CommonArgs.appendArgument(stringBuilder, "commitEvery", Integer.toString(n2), string);
        }
        if (StringUtil.isNonBlank(this.preTableStmt.getText())) {
            CommonArgs.appendArgument(stringBuilder, "preTableStatement", "\"" + this.preTableStmt.getText() + "\"", string);
        }
        if (StringUtil.isNonBlank(this.postTableStmt.getText())) {
            CommonArgs.appendArgument(stringBuilder, "postTableStatement", "\"" + this.postTableStmt.getText() + "\"", string);
        }
    }

    private void showCopyCommand() {
        ColumnMapper.MappingDefinition mappingDefinition;
        if (this.fileImporter != null) {
            this.showImportCommand();
            return;
        }
        if (this.sourceProfile == null || this.targetProfile == null) {
            return;
        }
        if (!this.hasSource()) {
            return;
        }
        CommandTester commandTester = new CommandTester();
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append(commandTester.formatVerb("WbCopy"));
        stringBuilder.append(" -sourceProfile=");
        String string = "\n       ";
        String string2 = this.sourceProfile.getName();
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        stringBuilder.append(string2);
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        stringBuilder.append(string);
        stringBuilder.append("-sourceGroup=");
        string2 = this.sourceProfile.getGroup();
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        stringBuilder.append(string2);
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        string2 = this.targetProfile.getName();
        stringBuilder.append(string);
        stringBuilder.append("-targetProfile=");
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        stringBuilder.append(string2);
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        stringBuilder.append(string);
        stringBuilder.append("-targetGroup=");
        string2 = this.targetProfile.getGroup();
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        stringBuilder.append(string2);
        if (string2.indexOf(32) > -1) {
            stringBuilder.append('\'');
        }
        TableIdentifier tableIdentifier = this.targetTable.getSelectedTable();
        if (this.targetProfile == null) {
            return;
        }
        String string3 = tableIdentifier.getTableExpression(this.targetConnection);
        stringBuilder.append(string);
        stringBuilder.append("-targetTable=");
        stringBuilder.append(string3);
        if (tableIdentifier.isNewTable()) {
            stringBuilder.append(string);
            stringBuilder.append("-createTarget=true");
            if (this.dropTargetCbx.isSelected()) {
                stringBuilder.append(string);
                stringBuilder.append("-dropTarget=true");
            }
            if (this.ignoreDropError.isSelected()) {
                stringBuilder.append(string);
                stringBuilder.append("-ignoreDropErrors=true");
            }
        }
        if ((mappingDefinition = this.columnMapper.getMapping()) == null) {
            return;
        }
        int n = mappingDefinition.targetColumns.length;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(n * 20);
        if (this.useQueryCbx.isSelected()) {
            String string4 = this.sqlEditor.getText();
            stringBuilder.append(string);
            stringBuilder.append("-sourceQuery=\"");
            stringBuilder.append(string4);
            stringBuilder.append('\"');
        } else {
            tableIdentifier = this.sourceTable.getSelectedTable();
            if (tableIdentifier == null) {
                return;
            }
            string2 = tableIdentifier.getTableExpression(this.sourceConnection);
            stringBuilder.append(string);
            stringBuilder.append("-sourceTable=");
            if (string2.indexOf(32) > -1) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(string2);
            if (string2.indexOf(32) > -1) {
                stringBuilder.append('\"');
            }
            if (StringUtil.isNonBlank(string2 = this.sqlEditor.getText())) {
                stringBuilder.append(string);
                stringBuilder.append("-sourceWhere=\"");
                stringBuilder.append(string2);
                stringBuilder.append('\"');
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("-columns='");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            String string5 = mappingDefinition.sourceColumns[i].getColumnName();
            String string6 = mappingDefinition.targetColumns[i].getColumnName();
            if (!this.useQueryCbx.isSelected()) {
                stringBuffer.append(string5);
                stringBuffer.append('/');
            }
            stringBuffer.append(string6);
            if (string5.equalsIgnoreCase(string6)) continue;
            bl = false;
        }
        stringBuffer.append('\'');
        if (!bl || mappingDefinition.hasSkippedColumns) {
            stringBuilder.append(stringBuffer);
        }
        this.appendGeneralImportOptions(stringBuilder, "WbCopy".length());
        stringBuilder.append("\n;");
        EditWindow editWindow = new EditWindow((Frame)this.window, ResourceMgr.getString("MsgWindowTitleDPScript"), stringBuilder.toString(), "workbench.datapumper.scriptwindow", true);
        editWindow.setVisible(true);
        editWindow.dispose();
    }

    protected int getBatchSize() {
        int n = -1;
        if (this.batchSize.isEnabled()) {
            n = StringUtil.getIntValue(this.batchSize.getText(), -1);
        }
        return n;
    }

    protected void initColumnMapper() {
        if (this.sourceConnection == null && this.fileImporter == null || this.targetConnection == null || !this.hasSource()) {
            this.startButton.setEnabled(false);
            this.showWbCommand.setEnabled(false);
            return;
        }
        TableIdentifier tableIdentifier = this.targetTable.getSelectedTable();
        if (tableIdentifier == null) {
            this.startButton.setEnabled(false);
            this.showWbCommand.setEnabled(false);
            return;
        }
        boolean bl = this.useQueryCbx.isSelected();
        try {
            List<ColumnIdentifier> list = null;
            if (bl) {
                list = this.getResultSetColumns();
            } else if (this.fileImporter != null) {
                list = this.fileImporter.getFileColumns();
            } else {
                TableIdentifier tableIdentifier2 = this.sourceTable.getSelectedTable();
                list = this.sourceConnection.getMetadata().getTableColumns(tableIdentifier2);
            }
            boolean bl2 = tableIdentifier.isNewTable();
            this.columnMapper.setAllowTargetEditing(bl2);
            this.dropTargetCbx.setEnabled(bl2);
            this.ignoreDropError.setEnabled(bl2);
            if (bl2) {
                this.columnMapper.defineColumns(list, list, false, bl);
            } else {
                List<ColumnIdentifier> list2 = this.targetConnection.getMetadata().getTableColumns(tableIdentifier);
                boolean bl3 = this.fileImporter != null;
                this.columnMapper.defineColumns(list, list2, bl3, bl);
            }
            this.columnMapper.setAllowSourceEditing(!bl && !bl2);
            this.startButton.setEnabled(true);
            this.showWbCommand.setEnabled(true);
        }
        catch (Exception exception) {
            WbSwingUtilities.showFriendlyErrorMessage(this, this.window.getTitle(), ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Error when intializing column mapper", exception);
        }
    }

    private void cancelCopy() {
        this.statusLabel.setText(ResourceMgr.getString("MsgCancellingCopy"));
        this.statusLabel.repaint();
        this.cancelButton.setEnabled(false);
        WbThread wbThread = new WbThread("DataPumper cancel"){

            @Override
            public void run() {
                DataPumper.this.doCancel();
            }
        };
        wbThread.start();
    }

    protected void doCancel() {
        if (this.copier != null) {
            this.copier.cancel();
        }
        EventQueue.invokeLater(() -> {
            this.cancelButton.setEnabled(false);
            this.startButton.setEnabled(true);
            this.copyRunning = false;
            this.updateWindowTitle();
            this.statusLabel.setText(ResourceMgr.getString("MsgCopyCancelled"));
            this.statusLabel.repaint();
        });
    }

    private void initImporter() throws Exception {
        this.fileImporter.setConnection(this.targetConnection);
        List<ColumnIdentifier> list = this.columnMapper.getMappingForImport();
        this.fileImporter.setTargetTable(this.targetTable.getSelectedTable());
        this.fileImporter.setImportColumns(list);
        ImportOptions importOptions = this.fileImporter.getGeneralOptions();
        if (importOptions != null) {
            importOptions.setMode((String)this.modeComboBox.getSelectedItem());
        }
    }

    private void startCopy() {
        if (this.targetConnection == null || this.sourceConnection == null && this.fileImporter == null) {
            return;
        }
        if (this.columnMapper == null) {
            return;
        }
        TableIdentifier tableIdentifier = this.targetTable.getSelectedTable();
        ColumnMapper.MappingDefinition mappingDefinition = this.columnMapper.getMapping();
        if (!this.createCopier()) {
            return;
        }
        DropType dropType = DropType.none;
        if (this.dropTargetCbx.isSelected()) {
            dropType = DropType.regular;
        }
        boolean bl = this.ignoreDropError.isSelected();
        try {
            String string;
            this.copyRunning = true;
            this.startTimer();
            String string2 = string = tableIdentifier.isNewTable() ? "default" : null;
            if (this.fileImporter != null) {
                this.initImporter();
                this.copier.setProducer(this.fileImporter.getProducer(), this.targetConnection, this.targetTable.getSelectedTable());
                int n = DataImporter.estimateReportIntervalFromFileSize(this.fileImporter.getSourceFile());
                this.copier.setReportInterval(n);
            } else if (this.useQueryCbx.isSelected()) {
                this.copier.copyFromQuery(this.sourceConnection, this.targetConnection, this.sqlEditor.getText(), tableIdentifier, Arrays.asList(mappingDefinition.targetColumns), string, dropType, bl, false);
            } else {
                boolean bl2 = false;
                String string3 = null;
                TableIdentifier tableIdentifier2 = this.sourceTable.getSelectedTable();
                if (this.isSelectQuery()) {
                    WbSwingUtilities.showErrorMessageKey(this, "MsgDPIgnoreSelect");
                    bl2 = true;
                }
                if (!bl2) {
                    string3 = this.sqlEditor.getText();
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n = mappingDefinition.sourceColumns.length;
                for (int i = 0; i < n; ++i) {
                    hashMap.put(mappingDefinition.sourceColumns[i].getColumnName(), mappingDefinition.targetColumns[i].getColumnName());
                }
                this.copier.copyFromTable(this.sourceConnection, this.targetConnection, tableIdentifier2, tableIdentifier, hashMap, string3, string, dropType, bl, false);
            }
            this.copier.startBackgroundCopy();
            this.showLogButton.setEnabled(false);
            this.startButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            this.updateWindowTitle();
        }
        catch (Exception exception) {
            this.copyRunning = false;
            this.showLogButton.setEnabled(true);
            this.startButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
            LogMgr.logError(new CallerInfo(){}, "Could not execute copy process", exception);
            this.statusLabel.setText(ResourceMgr.getString("MsgCopyFinishedWithErrors"));
        }
    }

    public boolean isRunning() {
        return this.copyRunning;
    }

    private boolean createCopier() {
        ColumnMapper.MappingDefinition mappingDefinition = this.columnMapper.getMapping();
        if (mappingDefinition == null) {
            return false;
        }
        this.copier = new DataCopier();
        if (this.deleteTargetCbx.isSelected()) {
            this.copier.setDeleteTarget(DeleteType.delete);
        } else {
            this.copier.setDeleteTarget(DeleteType.none);
        }
        this.copier.setContinueOnError(this.continueOnErrorCbx.isSelected());
        String string = (String)this.modeComboBox.getSelectedItem();
        List<ColumnIdentifier> list = this.getKeyColumns();
        this.copier.setKeyColumns(list);
        if (string.contains("update") && list.isEmpty()) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrDPNoKeyColumns");
            return false;
        }
        if (list.size() == mappingDefinition.targetColumns.length && string.contains("update")) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrDPUpdateOnlyKeyColumns");
            return false;
        }
        this.copier.setMode(string);
        int n = this.getBatchSize();
        int n2 = StringUtil.getIntValue(this.commitEvery.getText(), -1);
        if (n <= 0) {
            this.copier.setCommitEvery(n2);
        }
        if (n > 0) {
            this.copier.setUseBatch(true);
            this.copier.setBatchSize(n);
            if (n2 > 0) {
                this.copier.setCommitBatch(true);
            }
        }
        this.copier.setRowActionMonitor(this);
        this.copier.setReportInterval(10);
        TableStatements tableStatements = new TableStatements(this.preTableStmt.getText(), this.postTableStmt.getText());
        this.copier.setPerTableStatements(tableStatements);
        this.copier.setIgnoreIdentityColumns(this.ignoreIdentityCbx.isSelected());
        return true;
    }

    @Override
    public void setCurrentObject(String string, long l, long l2) {
        this.updateMonitor(l);
    }

    @Override
    public void setCurrentRow(long l, long l2) {
        this.updateMonitor(l);
    }

    private void updateMonitor(long l) {
        EventQueue.invokeLater(() -> {
            if (l == 1L) {
                this.updateWindowTitle();
            }
            this.statusLabel.setText(this.copyMsg + " " + l);
            this.statusLabel.repaint();
        });
    }

    @Override
    public void saveCurrentType(String string) {
    }

    @Override
    public void restoreType(String string) {
    }

    @Override
    public int getMonitorType() {
        return 7;
    }

    @Override
    public void setMonitorType(int n) {
    }

    @Override
    public void jobFinished() {
        this.stopTimer();
        this.copyRunning = false;
        if (this.copier.isSuccess()) {
            String string = this.copier.getRowsInsertedMessage();
            String string2 = this.copier.getRowsUpdatedMessage();
            StringBuilder stringBuilder = new StringBuilder(50);
            if (string != null) {
                stringBuilder.append(string);
                if (string2 != null) {
                    stringBuilder.append(", ");
                    stringBuilder.append(string2);
                }
            } else if (string2 != null && string2.length() > 0) {
                stringBuilder.append(string2);
            } else {
                long l = this.copier.getAffectedRows();
                stringBuilder.append(l);
                stringBuilder.append(' ');
                stringBuilder.append(ResourceMgr.getString("MsgCopyNumRows"));
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, " - ");
            }
            if (this.copier.hasWarnings()) {
                this.statusLabel.setText(ResourceMgr.getString("MsgCopyFinishedWithWarning") + stringBuilder);
            } else {
                this.statusLabel.setText(ResourceMgr.getString("MsgCopyFinishedWithSuccess") + stringBuilder);
            }
        } else {
            this.statusLabel.setText(ResourceMgr.getString("MsgCopyFinishedWithErrors"));
        }
        this.startButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        if (this.copier.hasWarnings() || !this.copier.isSuccess()) {
            this.showLogButton.setEnabled(true);
        }
        this.updateWindowTitle();
        if (!this.copier.isSuccess()) {
            EventQueue.invokeLater(this::showLog);
        }
    }

    protected void showLog() {
        if (this.copier == null) {
            return;
        }
        CharSequence charSequence = null;
        try {
            charSequence = this.copier.getAllMessages();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when retrieving log information", exception);
            charSequence = ExceptionUtil.getDisplay(exception);
        }
        EditWindow editWindow = new EditWindow((Frame)this.window, ResourceMgr.getString("MsgWindowTitleDPLog"), charSequence == null ? "" : charSequence.toString(), "workbench.datapumper.logwindow");
        editWindow.setVisible(true);
        editWindow.dispose();
    }
}

