/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.db.ObjectNameSorter;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class TableSelectorPanel
extends JPanel
implements ItemListener,
ActionListener {
    private WbConnection dbConnection;
    private String currentSchema;
    protected TableIdentifier currentTable;
    private PropertyChangeListener client;
    private String clientPropName;
    private boolean allowNewTable = false;
    private TableIdentifier newTableId = new TableIdentifier();
    private JCheckBox autoSync;
    private JButton editNewTableNameButton;
    private JPanel jPanel1;
    private JButton refreshButton;
    private JLabel schemaLabel;
    private JComboBox schemaSelector;
    private JLabel tableLabel;
    private JComboBox tableSelector;

    public TableSelectorPanel() {
        this.initComponents();
        this.schemaLabel.setText(ResourceMgr.getString("LblSchema"));
        this.tableLabel.setText(ResourceMgr.getString("LblTable"));
        this.tableSelector.setMaximumRowCount(15);
        this.editNewTableNameButton.setVisible(false);
        this.autoSync.setText(ResourceMgr.getString("LblDPAutoSyncTarget"));
        this.autoSync.setToolTipText(ResourceMgr.getDescription("LblDPAutoSyncTarget"));
        WbSwingUtilities.makeEqualSize(this.refreshButton, this.editNewTableNameButton);
        WbSwingUtilities.makeEqualHeight(this.refreshButton, this.tableSelector, this.schemaSelector);
    }

    public void reset() {
        this.schemaSelector.removeItemListener(this);
        this.tableSelector.removeItemListener(this);
        this.schemaSelector.removeAllItems();
        this.tableSelector.removeAllItems();
    }

    public boolean isAutoSyncSelected() {
        if (this.autoSync.isVisible()) {
            return this.autoSync.isSelected();
        }
        return false;
    }

    public void setAutoSyncSelected(boolean bl) {
        if (this.autoSync.isVisible()) {
            this.autoSync.setSelected(bl);
        }
    }

    public void setAutoSyncVisible(boolean bl) {
        this.autoSync.setVisible(bl);
        this.autoSync.setEnabled(bl);
    }

    public void resetNewTableItem() {
        if (this.newTableId != null) {
            this.newTableId.setNewTable(true);
            this.newTableId.parseTableIdentifier(null);
            this.newTableId.setSchema(null);
            WbSwingUtilities.repaintNow(this);
        }
    }

    public void allowNewTable(boolean bl) {
        this.allowNewTable = bl;
        this.editNewTableNameButton.removeActionListener(this);
        int n = this.tableSelector.getItemCount();
        if (n > 0) {
            this.tableSelector.removeItemListener(this);
            if (this.allowNewTable) {
                int n2 = -1;
                for (int i = 0; i < n; ++i) {
                    Object e = this.tableSelector.getItemAt(i);
                    if (!(e instanceof TableIdentifier)) continue;
                    n2 = i;
                    break;
                }
                if (n2 == -1) {
                    this.tableSelector.addItem(this.newTableId);
                }
            } else {
                this.tableSelector.removeItem(this.newTableId);
            }
            this.tableSelector.addItemListener(this);
        }
        this.editNewTableNameButton.setVisible(bl);
        if (bl) {
            this.editNewTableNameButton.addActionListener(this);
        }
    }

    public void removeChangeListener() {
        this.client = null;
        this.clientPropName = null;
    }

    public void setChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        this.client = propertyChangeListener;
        this.clientPropName = string;
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.refreshButton.setEnabled(this.dbConnection != null);
        if (this.dbConnection != null) {
            this.retrieveSchemas();
        } else {
            this.reset();
        }
    }

    public void setTableDropDownName(String string) {
        this.tableSelector.setName(string);
    }

    public void retrieveSchemas() {
        WbSwingUtilities.invoke(this::_retrieveSchemas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retrieveSchemas() {
        try {
            WbSwingUtilities.showWaitCursor(this);
            StringBuilder stringBuilder = new StringBuilder(this.dbConnection.getMetadata().getSchemaTerm().toLowerCase());
            stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
            this.schemaLabel.setText(stringBuilder.toString());
            this.schemaSelector.removeItemListener(this);
            this.tableSelector.removeItemListener(this);
            this.schemaSelector.removeAllItems();
            this.tableSelector.removeAllItems();
            this.schemaSelector.addItem("*");
            this.currentSchema = null;
            List<String> list = this.dbConnection.getMetadata().getSchemas();
            String string = this.dbConnection.getMetadata().getCurrentSchema();
            for (String string2 : list) {
                if (StringUtil.isEmptyString(string2)) continue;
                this.schemaSelector.addItem(string2);
                if (string == null || !string2.equalsIgnoreCase(string)) continue;
                this.currentSchema = string2;
            }
            if (this.currentSchema != null) {
                this.schemaSelector.setSelectedItem(this.currentSchema);
            } else {
                this.schemaSelector.setSelectedIndex(0);
            }
            this.retrieveTables();
            this.schemaSelector.addItemListener(this);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve schema list", exception);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.schemaSelector.setEnabled(bl);
        this.tableSelector.setEnabled(bl);
        if (bl) {
            this.tableLabel.setForeground(Color.BLACK);
            this.schemaLabel.setForeground(Color.BLACK);
        } else {
            this.tableLabel.setForeground(Color.DARK_GRAY);
            this.schemaLabel.setForeground(Color.DARK_GRAY);
        }
        if (!bl) {
            this.tableSelector.setSelectedItem(null);
            this.schemaSelector.setSelectedItem(null);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTables() {
        try {
            this.tableSelector.removeItemListener(this);
            List<TableIdentifier> list = this.dbConnection.getMetadata().getSelectableObjectsList(null, this.currentSchema);
            list.sort(new ObjectNameSorter());
            this.tableSelector.removeAllItems();
            if (this.allowNewTable) {
                this.tableSelector.addItem(this.newTableId);
            }
            for (TableIdentifier tableIdentifier : list) {
                if (this.dbConnection.getMetadata().isSequenceType(tableIdentifier.getType())) continue;
                tableIdentifier.setShowTablenameOnly(true);
                this.tableSelector.addItem(tableIdentifier);
            }
            this.editNewTableNameButton.setEnabled(false);
            this.tableSelector.setSelectedItem(null);
            TableIdentifier tableIdentifier = this.currentTable;
            this.currentTable = null;
            this.firePropertyChange(tableIdentifier, null);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve table list", exception);
        }
        finally {
            this.tableSelector.addItemListener(this);
        }
    }

    public TableIdentifier getSelectedTable() {
        if (!this.isEnabled()) {
            return null;
        }
        Object object = this.tableSelector.getSelectedItem();
        if (object == null) {
            return null;
        }
        TableIdentifier tableIdentifier = (TableIdentifier)object;
        if (!"*".equals(this.currentSchema)) {
            String string = this.dbConnection.getMetadata().quoteObjectname(this.currentSchema);
            tableIdentifier.setSchema(string);
        }
        return tableIdentifier;
    }

    public void findAndSelectTable(String string) {
        if (string == null) {
            return;
        }
        int n = this.tableSelector.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string2 = null;
            Object e = this.tableSelector.getItemAt(i);
            if (e instanceof TableIdentifier) {
                string2 = ((TableIdentifier)e).getTableName();
            }
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            this.tableSelector.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.schemaSelector) {
            this.currentSchema = (String)this.schemaSelector.getSelectedItem();
            if (this.currentSchema != null) {
                this.retrieveTables();
            }
            this.newTableId.setSchema(this.currentSchema);
        } else if (itemEvent.getSource() == this.tableSelector) {
            TableIdentifier tableIdentifier = this.currentTable;
            this.currentTable = this.getSelectedTable();
            if (this.currentTable != null) {
                this.editNewTableNameButton.setEnabled(this.currentTable.isNewTable());
            } else {
                this.editNewTableNameButton.setEnabled(false);
            }
            EventQueue.invokeLater(() -> this.firePropertyChange(tableIdentifier, this.currentTable));
        }
    }

    private void firePropertyChange(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2) {
        if (this.client == null) {
            return;
        }
        if (tableIdentifier == null && tableIdentifier2 == null) {
            return;
        }
        if (tableIdentifier != null && tableIdentifier2 != null && tableIdentifier.equals(tableIdentifier2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, this.clientPropName, tableIdentifier, tableIdentifier2);
        this.client.propertyChange(propertyChangeEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.editNewTableNameButton && (object = this.tableSelector.getSelectedItem()) instanceof TableIdentifier) {
            TableIdentifier tableIdentifier = (TableIdentifier)object;
            String string = tableIdentifier.getTableName();
            string = WbSwingUtilities.getUserInput(this, ResourceMgr.getString("TxtEnterNewTableName"), string);
            if (string != null) {
                tableIdentifier.parseTableIdentifier(string);
                this.tableSelector.repaint();
            }
        }
    }

    private void initComponents() {
        this.schemaSelector = new JComboBox();
        this.tableSelector = new JComboBox();
        this.schemaLabel = new JLabel();
        this.editNewTableNameButton = new FlatButton();
        this.refreshButton = new FlatButton();
        this.jPanel1 = new JPanel();
        this.tableLabel = new JLabel();
        this.autoSync = new JCheckBox();
        this.setMinimumSize(new Dimension(68, 65));
        this.setPreferredSize(new Dimension(68, 65));
        this.setLayout(new GridBagLayout());
        this.schemaSelector.setAlignmentX(0.0f);
        this.schemaSelector.setAlignmentY(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.schemaSelector, gridBagConstraints);
        this.tableSelector.setMaximumRowCount(0);
        this.tableSelector.setAlignmentX(0.0f);
        this.tableSelector.setAlignmentY(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tableSelector, gridBagConstraints);
        this.schemaLabel.setText("jLabel1");
        this.schemaLabel.setVerticalAlignment(1);
        this.schemaLabel.setMaximumSize(new Dimension(32768, 21));
        this.schemaLabel.setMinimumSize(new Dimension(34, 21));
        this.schemaLabel.setPreferredSize(new Dimension(34, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.add((Component)this.schemaLabel, gridBagConstraints);
        this.editNewTableNameButton.setIcon(IconMgr.getInstance().getLabelIcon("rename"));
        this.editNewTableNameButton.setToolTipText(ResourceMgr.getString("LblEditNewTableName"));
        this.editNewTableNameButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.editNewTableNameButton, gridBagConstraints);
        this.refreshButton.setIcon(IconMgr.getInstance().getLabelIcon("Refresh"));
        this.refreshButton.setToolTipText("");
        this.refreshButton.setEnabled(false);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSelectorPanel.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.refreshButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.tableLabel.setText("jLabel1");
        this.tableLabel.setVerticalAlignment(1);
        this.tableLabel.setMaximumSize(new Dimension(32768, 21));
        this.tableLabel.setMinimumSize(new Dimension(34, 21));
        this.tableLabel.setPreferredSize(new Dimension(34, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.tableLabel, gridBagConstraints);
        this.autoSync.setText("jCheckBox1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.autoSync, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        this.retrieveSchemas();
    }
}

