/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import workbench.gui.components.WbStatusLabel;
import workbench.resource.ResourceMgr;
import workbench.util.BrowserLauncher;
import workbench.util.UpdateVersion;
import workbench.util.VersionNumber;
import workbench.util.WbVersionReader;

public class VersionCheckDialog
extends JDialog
implements ActionListener,
MouseListener {
    private WbVersionReader versionReader;
    private JButton closeButton;
    private JLabel devVersion;
    private JLabel devVersionLabel;
    private JLabel headingLabel;
    private JSeparator jSeparator2;
    private JLabel stableVersion;
    private JLabel stableVersionLabel;
    private JLabel statusLabel;
    private JLabel yourVersion;
    private JLabel yourVersionLabel;

    public VersionCheckDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.closeButton.addActionListener(this);
        Font font = this.headingLabel.getFont().deriveFont(1);
        this.headingLabel.setFont(font);
        this.headingLabel.setText(ResourceMgr.getString("LblReadingVersion"));
        this.headingLabel.addMouseListener(this);
        this.headingLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.stableVersion.setText(" " + ResourceMgr.getString("LblNotAvailable"));
        this.devVersion.setText(" " + ResourceMgr.getString("LblNotAvailable"));
        this.statusLabel.setText(" " + ResourceMgr.getString("LblReadingVersion"));
    }

    private void startRetrieveVersions() {
        this.readVersion();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.startRetrieveVersions();
        }
        super.setVisible(bl);
    }

    protected void readVersion() {
        this.versionReader = new WbVersionReader(this);
        this.versionReader.startCheckThread();
    }

    private void checkDisplay() {
        UpdateVersion updateVersion = this.versionReader.getAvailableUpdate();
        String string = ResourceMgr.getString("LblVersionUpToDate");
        if (!this.versionReader.success()) {
            string = ResourceMgr.getString("LblVersionReadError");
        } else if (updateVersion == UpdateVersion.stable) {
            this.stableVersion.setBackground(Color.YELLOW);
            string = ResourceMgr.getString("LblVersionNewStableAvailable");
        } else if (updateVersion == UpdateVersion.devBuild) {
            this.devVersion.setBackground(Color.YELLOW);
            string = ResourceMgr.getString("LblVersionNewDevAvailable");
        }
        this.statusLabel.setText(string);
    }

    private void initComponents() {
        this.yourVersionLabel = new JLabel();
        this.yourVersion = new JLabel();
        this.closeButton = new JButton();
        this.stableVersionLabel = new JLabel();
        this.stableVersion = new JLabel();
        this.devVersionLabel = new JLabel();
        this.devVersion = new JLabel();
        this.statusLabel = new WbStatusLabel();
        this.headingLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.setTitle(ResourceMgr.getString("TxtWindowTitleVersionCheck"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VersionCheckDialog.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.yourVersionLabel.setText(ResourceMgr.getString("LblYourVersion"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this.yourVersionLabel, gridBagConstraints);
        this.yourVersion.setBackground(Color.white);
        this.yourVersion.setText(" " + ResourceMgr.getBuildInfo());
        this.yourVersion.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.getContentPane().add((Component)this.yourVersion, gridBagConstraints);
        this.closeButton.setText(ResourceMgr.getString("LblClose"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 5);
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.stableVersionLabel.setText(ResourceMgr.getString("LblStableVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.getContentPane().add((Component)this.stableVersionLabel, gridBagConstraints);
        this.stableVersion.setBackground(Color.white);
        this.stableVersion.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.getContentPane().add((Component)this.stableVersion, gridBagConstraints);
        this.devVersionLabel.setText(ResourceMgr.getString("LblDevVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.getContentPane().add((Component)this.devVersionLabel, gridBagConstraints);
        this.devVersion.setBackground(Color.white);
        this.devVersion.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.getContentPane().add((Component)this.devVersion, gridBagConstraints);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setMinimumSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(9, 3, 0, 3);
        this.getContentPane().add((Component)this.statusLabel, gridBagConstraints);
        this.headingLabel.setBackground(new Color(255, 255, 255));
        this.headingLabel.setHorizontalAlignment(0);
        this.headingLabel.setText(ResourceMgr.getString("LblVersionsAvailable"));
        this.headingLabel.setHorizontalTextPosition(0);
        this.headingLabel.setMinimumSize(new Dimension(150, 25));
        this.headingLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 2, 5, 2);
        this.getContentPane().add((Component)this.headingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.setSize(new Dimension(386, 196));
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.versionReader) {
            if (this.versionReader.success()) {
                this.stableVersion.setText(" " + ResourceMgr.getString("TxtBuild") + " " + this.versionReader.getStableBuildNumber() + " (" + this.versionReader.getStableBuildDate() + ")");
                String string = this.versionReader.getDevBuildDate();
                VersionNumber versionNumber = this.versionReader.getDevBuildNumber();
                if (string != null && versionNumber.isValid()) {
                    this.devVersion.setText(" " + ResourceMgr.getString("TxtBuild") + " " + versionNumber + " (" + string + ")");
                }
            } else {
                this.stableVersion.setText(" " + ResourceMgr.getString("LblNotAvailable"));
                this.devVersion.setText(" " + ResourceMgr.getString("LblNotAvailable"));
            }
            this.headingLabel.setText(ResourceMgr.getString("LblVersionsAvailable"));
            this.headingLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.checkDisplay();
        } else if (actionEvent.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.headingLabel && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            try {
                BrowserLauncher.openURL("https://www.sql-workbench.eu");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

