/*
 * Decompiled with CFR 0.152.
 */
package workbench.liquibase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import workbench.liquibase.ChangeSetIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.DelimiterDefinition;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.MessageBuffer;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class LiquibaseParser {
    private final WbFile changeLog;
    private String fileEncoding;
    private MessageBuffer messages;
    private final String TAG_CHANGESET = "changeSet";
    private final String TAG_SQLFILE = "sqlFile";
    private final String TAG_SQL = "sql";
    private final String TAG_CREATEPROC = "createProcedure";
    private final ParserType sqlParserType;

    public LiquibaseParser(WbFile wbFile) {
        this(wbFile, "UTF-8", new MessageBuffer(), ParserType.Standard);
    }

    public LiquibaseParser(WbFile wbFile, String string, MessageBuffer messageBuffer, ParserType parserType) {
        this.changeLog = wbFile;
        this.fileEncoding = string;
        this.messages = messageBuffer;
        this.sqlParserType = parserType;
    }

    public List<String> getContentFromChangeSet(ChangeSetIdentifier ... changeSetIdentifierArray) throws IOException, SAXException {
        return this.getContentFromChangeSet(changeSetIdentifierArray == null ? null : Arrays.asList(changeSetIdentifierArray));
    }

    public List<String> getContentFromChangeSet(List<ChangeSetIdentifier> list) throws IOException, SAXException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.changeLog);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("changeSet");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                List<String> list2;
                Node node = nodeList.item(i);
                ChangeSetIdentifier changeSetIdentifier = this.getChangeSetId(node);
                if (!this.isChangeSetIncluded(list, changeSetIdentifier) || !(node instanceof Element) || (list2 = this.getContent((Element)node)) == null) continue;
                arrayList.addAll(list2);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not parse file: " + this.changeLog.getFullPath(), exception);
        }
        return arrayList;
    }

    public List<ChangeSetIdentifier> getChangeSets() {
        ArrayList<ChangeSetIdentifier> arrayList = new ArrayList<ChangeSetIdentifier>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.changeLog);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("changeSet");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                ChangeSetIdentifier changeSetIdentifier = this.getChangeSetId(node);
                arrayList.add(changeSetIdentifier);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not parse file: " + this.changeLog.getFullPath(), exception);
        }
        return arrayList;
    }

    private List<String> getContent(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if ("sql".equals(string) || "createProcedure".equals(string)) {
                boolean bl = false;
                if ("sql".equals(string)) {
                    bl = this.getSplitAttribute(element2);
                }
                DelimiterDefinition delimiterDefinition = this.getDelimiter(element2);
                if (bl) {
                    arrayList.addAll(this.splitStatements(element2.getTextContent(), delimiterDefinition));
                } else {
                    arrayList.add(element2.getTextContent());
                }
            }
            if (!"sqlFile".equals(string)) continue;
            arrayList.addAll(this.getContentFromSqlFile(element2));
        }
        return arrayList;
    }

    private List<String> splitStatements(String string, DelimiterDefinition delimiterDefinition) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ScriptParser scriptParser = new ScriptParser(string, this.sqlParserType);
        scriptParser.setAlternateDelimiter(delimiterDefinition);
        int n = scriptParser.getSize();
        for (int i = 0; i < n; ++i) {
            arrayList.add(scriptParser.getCommand(i));
        }
        return arrayList;
    }

    private List<String> getContentFromSqlFile(Element element) {
        String string = element.getAttribute("path");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtil.isEmptyString(string)) {
            return arrayList;
        }
        String string2 = element.getAttribute("encoding");
        if (StringUtil.isEmptyString(string2)) {
            string2 = this.fileEncoding;
        }
        if (StringUtil.isEmptyString(string2)) {
            string2 = EncodingUtil.getDefaultEncoding();
        }
        DelimiterDefinition delimiterDefinition = this.getDelimiter(element);
        boolean bl = StringUtil.stringToBool(element.getAttribute("relativeToChangelogFile"));
        boolean bl2 = this.getSplitAttribute(element);
        WbFile wbFile = new WbFile(string);
        WbFile wbFile2 = bl || !wbFile.isAbsolute() ? new WbFile(this.changeLog.getParentFile(), string) : new WbFile(string);
        if (wbFile2.exists()) {
            List<String> list = this.readSqlFile(wbFile2, delimiterDefinition, string2, bl2);
            arrayList.addAll(list);
        } else {
            String string3 = ResourceMgr.getFormattedString("ErrFileNotFound", string);
            this.messages.append(string3);
            LogMgr.logError(new CallerInfo(){}, "sqlFile=\"" + string + "\" not found!", null);
        }
        return arrayList;
    }

    private boolean getSplitAttribute(Element element) {
        String string = element.getAttribute("splitStatements");
        if (StringUtil.isBlank(string)) {
            return true;
        }
        return Boolean.parseBoolean(string);
    }

    private DelimiterDefinition getDelimiter(Element element) {
        String string = element.getAttribute("endDelimiter");
        if (StringUtil.isBlank(string)) {
            return null;
        }
        DelimiterDefinition delimiterDefinition = new DelimiterDefinition(string);
        if (delimiterDefinition.isStandard()) {
            return null;
        }
        return delimiterDefinition;
    }

    private ChangeSetIdentifier getChangeSetId(Node node) {
        NodeList nodeList;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("author").getTextContent();
        String string2 = namedNodeMap.getNamedItem("id").getTextContent();
        ChangeSetIdentifier changeSetIdentifier = new ChangeSetIdentifier(string, string2);
        if (node instanceof Element && (nodeList = ((Element)node).getElementsByTagName("comment")) != null && nodeList.getLength() == 1) {
            String string3 = nodeList.item(0).getTextContent();
            changeSetIdentifier.setComment(string3);
        }
        return changeSetIdentifier;
    }

    private boolean isChangeSetIncluded(List<ChangeSetIdentifier> list, ChangeSetIdentifier changeSetIdentifier) {
        if (changeSetIdentifier == null) {
            return false;
        }
        if (CollectionUtil.isEmpty(list)) {
            return true;
        }
        for (ChangeSetIdentifier changeSetIdentifier2 : list) {
            if (!changeSetIdentifier.isEqualTo(changeSetIdentifier2)) continue;
            return true;
        }
        return false;
    }

    private List<String> readSqlFile(WbFile wbFile, DelimiterDefinition delimiterDefinition, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (bl) {
                ScriptParser scriptParser = new ScriptParser(this.sqlParserType);
                scriptParser.setDelimiter(delimiterDefinition);
                scriptParser.setFile(wbFile, string);
                int n = scriptParser.getSize();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(scriptParser.getCommand(i));
                }
            } else {
                String string2 = FileUtil.readFile(wbFile, string);
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            this.messages.append(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Could not read sqlFile=\"" + wbFile.getFullPath() + "\"", exception);
        }
        return arrayList;
    }
}

