/*
 * Decompiled with CFR 0.152.
 */
package workbench.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggingEvent;
import workbench.WbManager;
import workbench.log.Log4JLoggerFactory;
import workbench.log.LogLevel;
import workbench.log.LogListener;
import workbench.log.WbLogger;
import workbench.util.StringUtil;

public class Log4JLogger
extends Logger
implements WbLogger {
    static boolean debug = false;
    static boolean useReflectionClass = true;
    private List<LogListener> listenerList = new ArrayList<LogListener>(1);
    protected static LoggerFactory loggerFactory = new Log4JLoggerFactory();
    private String fqcn = Log4JLogger.class.getName();

    public Log4JLogger(String string) {
        super(string);
        String string2 = Log4JLoggerFactory.getLoggerFqcn().getCanonicalName();
        this.setFqcn(string2);
        if (debug) {
            System.out.println("New logger for class " + string + " @(" + string2 + ")");
        }
    }

    protected void forcedLog(String string, Priority priority, Object object, Throwable throwable) {
        this.callAppenders(new LoggingEvent(this.fqcn, (Category)this, priority, object, throwable));
    }

    public final void setFqcn(String string) {
        this.fqcn = string;
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public static Logger getLogger(String string) {
        return LogManager.getLogger((String)string, (LoggerFactory)loggerFactory);
    }

    public static Logger getLogger(Class clazz) {
        return LogManager.getLogger((String)clazz.getCanonicalName(), (LoggerFactory)loggerFactory);
    }

    private LogLevel toWbLevel(Level level) {
        if (level == Level.DEBUG) {
            return LogLevel.debug;
        }
        if (level == Level.ERROR) {
            return LogLevel.error;
        }
        if (level == Level.INFO) {
            return LogLevel.info;
        }
        if (level == Level.WARN) {
            return LogLevel.warning;
        }
        if (level == Level.TRACE) {
            return LogLevel.trace;
        }
        return LogLevel.error;
    }

    @Override
    public void setRootLevel(LogLevel logLevel) {
    }

    @Override
    public LogLevel getRootLevel() {
        return this.toWbLevel(Log4JLogger.getRootLogger().getLevel());
    }

    public static WbLogger getLogger() {
        String string = Log4JLogger.getCallerClassName();
        if (debug) {
            System.out.println("callerClass in getLogger(): " + string);
        }
        if (string != null) {
            Logger logger = Log4JLogger.getLogger(string);
            if (!(logger instanceof Log4JLogger)) {
                System.err.println("Please don't define LoggerClasses without the correct loggerFactory");
                return null;
            }
            return (Log4JLogger)logger;
        }
        return (Log4JLogger)Log4JLogger.getLogger(Log4JLogger.class);
    }

    private static String getCallerClassName() {
        StackTraceElement[] stackTraceElementArray;
        if (useReflectionClass) {
            try {
                return Log4JLogger.getCallerClass(5).getName();
            }
            catch (Throwable throwable) {
                System.err.println("Could not get caller class using Reflection.getCallerClass(). Using getStackTrace() instead");
                useReflectionClass = false;
            }
        }
        if ((stackTraceElementArray = Thread.currentThread().getStackTrace()) != null && stackTraceElementArray.length > 4) {
            return stackTraceElementArray[5].getClassName();
        }
        return Log4JLogger.class.getName();
    }

    public static Class getCallerClass(int n) {
        Class[] classArray = null;
        try {
            classArray = new SecurityManager(){

                public Class[] getClassContext() {
                    return super.getClassContext();
                }
            }.getClassContext();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] != Log4JLogger.class) continue;
                return classArray[n + i];
            }
        } else {
            try {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (Class.forName(stackTraceElementArray[i].getClassName()) != Log4JLogger.class) continue;
                    return Class.forName(stackTraceElementArray[n + i].getClassName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void logMessage(LogLevel logLevel, Object object, CharSequence charSequence, Throwable throwable) {
        switch (logLevel) {
            case trace: {
                this.trace(charSequence, throwable);
                break;
            }
            case debug: {
                this.debug(charSequence, throwable);
                break;
            }
            case info: {
                this.info(charSequence, throwable);
                break;
            }
            case warning: {
                this.warn(charSequence, throwable);
                break;
            }
            default: {
                this.error(charSequence, throwable);
            }
        }
        if (this.levelEnabled(logLevel)) {
            this.notifyListener(charSequence);
        }
    }

    @Override
    public void setMessageFormat(String string) {
    }

    @Override
    public void logToSystemError(boolean bl) {
    }

    @Override
    public File getCurrentFile() {
        Logger logger = Log4JLogger.getLogger("workbench.log.LogMgr");
        File file = this.findLogFile(logger);
        if (file == null) {
            file = this.findLogFile(Logger.getRootLogger());
        }
        return file;
    }

    private File findLogFile(Logger logger) {
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            FileAppender fileAppender;
            String string;
            Appender appender = (Appender)enumeration.nextElement();
            if (!(appender instanceof FileAppender) || (string = (fileAppender = (FileAppender)appender).getFile()) == null) continue;
            return new File(string);
        }
        return null;
    }

    @Override
    public void setOutputFile(File file, int n, int n2) {
        Logger logger = Log4JLogger.getLogger(this.getClass());
        logger.info((Object)"=================== Log started ===================");
        String string = System.getProperty("log4j.configuration");
        if (StringUtil.isNonBlank(string)) {
            logger.info((Object)("Log4J initialized from: " + string));
        }
    }

    @Override
    public void shutdownWbLog() {
        Log4JLogger.getLogger(this.getClass()).info((Object)"=================== Log stopped ===================");
        if (WbManager.shouldDoSystemExit()) {
            LogManager.shutdown();
        }
    }

    @Override
    public boolean levelEnabled(LogLevel logLevel) {
        Logger logger = Logger.getRootLogger();
        switch (logLevel) {
            case trace: {
                return logger.isTraceEnabled();
            }
            case debug: {
                return logger.isDebugEnabled();
            }
            case info: {
                return logger.isInfoEnabled();
            }
            case warning: {
                return logger.isEnabledFor((Priority)Level.WARN);
            }
        }
        return true;
    }

    private void notifyListener(CharSequence charSequence) {
        for (LogListener logListener : this.listenerList) {
            if (logListener == null) continue;
            logListener.messageLogged(charSequence);
        }
    }

    @Override
    public void addLogListener(LogListener logListener) {
        this.listenerList.add(logListener);
    }

    @Override
    public void removeLogListener(LogListener logListener) {
        this.listenerList.remove(logListener);
    }
}

