/*
 * Decompiled with CFR 0.152.
 */
package workbench.log;

import java.io.File;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import workbench.log.CallerInfo;
import workbench.log.Log4JHelper;
import workbench.log.Log4JLogger;
import workbench.log.LogLevel;
import workbench.log.LogListener;
import workbench.log.SimpleLogger;
import workbench.log.WbLogger;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.WbFile;

public class LogMgr {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static WbLogger logger = null;
    private static boolean useLog4J;

    public static synchronized void init(boolean bl) {
        boolean bl2 = useLog4J = bl && Log4JHelper.isLog4JAvailable();
        if (!bl) {
            LogMgr.getLogger();
        }
    }

    public static WbFile getLogfile() {
        File file = LogMgr.getLogger().getCurrentFile();
        if (file == null) {
            return null;
        }
        return new WbFile(file);
    }

    public static void setMessageFormat(String string) {
        LogMgr.getLogger().setMessageFormat(string);
    }

    public static void logToSystemError(boolean bl) {
        LogMgr.getLogger().logToSystemError(bl);
    }

    public static String getLevel() {
        return LogMgr.getLogger().getRootLevel().toString();
    }

    public static void setLevel(String string) {
        LogMgr.getLogger().setRootLevel(LogLevel.getLevel(string));
    }

    public static void shutdown() {
        LogMgr.getLogger().shutdownWbLog();
    }

    public static void setOutputFile(File file, int n, int n2) {
        LogMgr.getLogger().setOutputFile(file, n, n2);
    }

    public static boolean isInfoEnabled() {
        return LogMgr.getLogger().levelEnabled(LogLevel.info);
    }

    public static boolean isDebugEnabled() {
        return LogMgr.getLogger().levelEnabled(LogLevel.debug);
    }

    public static boolean isTraceEnabled() {
        return LogMgr.getLogger().levelEnabled(LogLevel.trace);
    }

    public static void logDebug(CallerInfo callerInfo, CharSequence charSequence) {
        LogMgr.getLogger().logMessage(LogLevel.debug, callerInfo, charSequence, null);
    }

    public static void logMetadataSql(CallerInfo callerInfo, String string, CharSequence charSequence, Object ... objectArray) {
        if (LogMgr.isDebugEnabled() || Settings.getInstance().getDebugMetadataSql()) {
            String string2 = "Retrieving " + string + " using:\n" + SqlUtil.replaceParameters(charSequence, objectArray);
            LogMgr.getLogger().logMessage(LogLevel.debug, callerInfo, string2, null);
        }
    }

    public static void logMetadataError(CallerInfo callerInfo, Throwable throwable, String string, CharSequence charSequence, Object ... objectArray) {
        String string2 = "Error retrieving " + string + " using:\n" + SqlUtil.replaceParameters(charSequence, objectArray);
        LogMgr.getLogger().logMessage(LogLevel.error, callerInfo, string2, throwable);
    }

    public static void logTrace(CallerInfo callerInfo, CharSequence charSequence) {
        LogMgr.getLogger().logMessage(LogLevel.trace, callerInfo, charSequence, null);
    }

    public static void logTrace(CallerInfo callerInfo, CharSequence charSequence, Throwable throwable) {
        LogMgr.getLogger().logMessage(LogLevel.trace, callerInfo, charSequence, throwable);
    }

    public static void logDebug(CallerInfo callerInfo, CharSequence charSequence, Throwable throwable) {
        LogMgr.getLogger().logMessage(LogLevel.debug, callerInfo, charSequence, throwable);
        LogMgr.logChainedException(LogLevel.debug, throwable);
    }

    public static void logInfo(CallerInfo callerInfo, CharSequence charSequence) {
        LogMgr.getLogger().logMessage(LogLevel.info, callerInfo, charSequence, null);
    }

    public static void logInfo(CallerInfo callerInfo, CharSequence charSequence, Throwable throwable) {
        LogMgr.getLogger().logMessage(LogLevel.info, callerInfo, charSequence, throwable);
    }

    public static void logWarning(CallerInfo callerInfo, CharSequence charSequence) {
        LogMgr.getLogger().logMessage(LogLevel.warning, callerInfo, charSequence, null);
    }

    public static void logWarning(CallerInfo callerInfo, CharSequence charSequence, Throwable throwable) {
        LogMgr.getLogger().logMessage(LogLevel.warning, callerInfo, charSequence, throwable);
        LogMgr.logChainedException(LogLevel.warning, throwable);
    }

    public static void logError(CallerInfo callerInfo, CharSequence charSequence, Throwable throwable) {
        LogMgr.getLogger().logMessage(LogLevel.error, callerInfo, charSequence, throwable);
        LogMgr.logChainedException(LogLevel.error, throwable);
    }

    public static void logUserSqlError(CallerInfo callerInfo, String string, Throwable throwable) {
        String string2 = "Error executing:\n" + string + "\n  ";
        if (throwable instanceof SQLFeatureNotSupportedException) {
            LogMgr.logError(callerInfo, string2, throwable);
        } else if (throwable instanceof SQLException && !LogMgr.getLogger().levelEnabled(LogLevel.debug)) {
            string2 = string2 + ExceptionUtil.getDisplay(throwable);
            LogMgr.logError(callerInfo, string2, null);
        } else {
            LogMgr.logError(callerInfo, string2, throwable);
        }
    }

    public static void logChainedException(LogLevel logLevel, Throwable throwable) {
        if (LogMgr.getLogger().levelEnabled(logLevel) && throwable instanceof SQLException) {
            for (SQLException sQLException = ((SQLException)throwable).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                LogMgr.getLogger().logMessage(LogLevel.error, "Chained exception", ExceptionUtil.getDisplay(sQLException), null);
            }
        }
    }

    public static void addLogListener(LogListener logListener) {
        LogMgr.getLogger().addLogListener(logListener);
    }

    public static void removeLogListener(LogListener logListener) {
        LogMgr.getLogger().removeLogListener(logListener);
    }

    private static synchronized WbLogger getLogger() {
        if (useLog4J) {
            try {
                return Log4JLogger.getLogger();
            }
            catch (Throwable throwable) {
                System.err.println("Could not create Log4J getLogger(). Using SimpleLogger!");
                throwable.printStackTrace(System.err);
                useLog4J = false;
            }
        }
        if (logger == null) {
            logger = new SimpleLogger();
        }
        return logger;
    }
}

