/*
 * Decompiled with CFR 0.152.
 */
package workbench.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingFormatArgumentException;
import workbench.log.LogLevel;
import workbench.log.LogListener;
import workbench.log.WbLogger;
import workbench.util.ExceptionUtil;
import workbench.util.FileVersioner;
import workbench.util.StringUtil;

public class SimpleLogger
implements WbLogger {
    public static final String DEFAULT_FORMAT = "{timestamp} {type} {message} {error}";
    public static final String DEFAULT_DEBUG_FORMAT = "{timestamp} {type} {source} {message} {error}";
    private LogLevel level = LogLevel.info;
    private PrintStream logOut = null;
    private boolean logSystemErr = false;
    private String messageFormat;
    private File currentFile;
    private List<LogListener> listenerList = new ArrayList<LogListener>(1);

    @Override
    public void setMessageFormat(String string) {
        if (string == null) {
            return;
        }
        this.messageFormat = string.replace("{type}", "%1$-5s");
        this.messageFormat = this.messageFormat.replace("{timestamp}", "%2$tF %2$tT");
        this.messageFormat = this.messageFormat.replace("{source}", "%3$s");
        this.messageFormat = this.messageFormat.replace("{message}", "%4$s");
        this.messageFormat = this.messageFormat.replace("{error}", "%5$s");
    }

    @Override
    public void logToSystemError(boolean bl) {
        this.logSystemErr = bl;
    }

    @Override
    public void setRootLevel(LogLevel logLevel) {
        boolean bl = this.level != logLevel;
        this.level = logLevel;
        if (bl && this.level == LogLevel.debug) {
            this.setMessageFormat(DEFAULT_DEBUG_FORMAT);
        }
    }

    @Override
    public LogLevel getRootLevel() {
        return this.level;
    }

    @Override
    public File getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public void setOutputFile(File file, int n, int n2) {
        if (file == null) {
            System.err.println("setOutputFile() called with a NULL file!");
            return;
        }
        if (this.currentFile != null && file.equals(this.currentFile)) {
            return;
        }
        try {
            if (this.logOut != null) {
                this.logOut.close();
                this.logOut = null;
            }
            if (file.exists() && file.length() > (long)n) {
                FileVersioner fileVersioner = new FileVersioner(n2);
                fileVersioner.createBackup(file);
                file.delete();
            }
            this.logOut = new PrintStream((OutputStream)new FileOutputStream(file, true), true, "UTF-8");
            this.currentFile = file;
            this.logMessage(LogLevel.info, null, "=================== Log started ===================", null);
        }
        catch (Throwable throwable) {
            this.logOut = null;
            this.logSystemErr = true;
            System.err.println("Error when opening logfile=" + file.getAbsolutePath());
            throwable.printStackTrace(System.err);
        }
    }

    @Override
    public void shutdownWbLog() {
        if (this.logOut != null) {
            this.logMessage(LogLevel.info, null, "=================== Log stopped ===================", null);
            this.logOut.close();
            this.logOut = null;
            this.logSystemErr = false;
        }
    }

    @Override
    public boolean levelEnabled(LogLevel logLevel) {
        return this.level.compareTo(logLevel) >= 0;
    }

    @Override
    public synchronized void logMessage(LogLevel logLevel, Object object, CharSequence charSequence, Throwable throwable) {
        if (!this.levelEnabled(logLevel)) {
            return;
        }
        CharSequence charSequence2 = this.formatMessage(logLevel, object, charSequence, throwable);
        if (this.logOut != null) {
            this.logOut.append(charSequence2);
            this.logOut.append(StringUtil.LINE_TERMINATOR);
            this.logOut.flush();
        }
        if (this.logSystemErr) {
            System.err.println(charSequence2);
        }
        this.notifyListener(charSequence2);
    }

    private CharSequence formatMessage(LogLevel logLevel, Object object, CharSequence charSequence, Throwable throwable) {
        if (this.messageFormat == null) {
            return charSequence;
        }
        try {
            if (throwable != null) {
                boolean bl = logLevel.compareTo(LogLevel.error) >= 0;
                String string = ExceptionUtil.getDisplay(throwable, bl);
                return String.format(this.messageFormat, new Object[]{logLevel, new Date(), object == null ? "" : object, charSequence, string});
            }
            return String.format(this.messageFormat, new Object[]{logLevel, new Date(), object == null ? "" : object, charSequence, ""});
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            System.err.println("Error formatting message using: " + this.messageFormat);
            missingFormatArgumentException.printStackTrace();
            return charSequence;
        }
    }

    private void notifyListener(CharSequence charSequence) {
        for (LogListener logListener : this.listenerList) {
            if (logListener == null) continue;
            logListener.messageLogged(charSequence);
        }
    }

    @Override
    public void addLogListener(LogListener logListener) {
        if (logListener != null) {
            this.listenerList.add(logListener);
        }
    }

    @Override
    public void removeLogListener(LogListener logListener) {
        this.listenerList.remove(logListener);
    }
}

