/*
 * Decompiled with CFR 0.152.
 */
package workbench.print;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import workbench.util.StringUtil;

public class RenderUtils {
    private static final String WORD_BOUNDARIES = ";,-=";

    public static List<String> wrap(String string, FontMetrics fontMetrics, int n) {
        List<String> list = StringUtil.getLines(string);
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string2 : list) {
            RenderUtils.wrapLineInto(string2, arrayList, fontMetrics, n);
        }
        return arrayList;
    }

    private static void wrapLineInto(String string, List<String> list, FontMetrics fontMetrics, int n) {
        int n2 = string.length();
        int n3 = fontMetrics.stringWidth(string);
        while (n2 > 0 && n3 > n) {
            int n4;
            int n5 = n2 * n / n3;
            String string2 = string.substring(0, n5).trim();
            if ((n3 = fontMetrics.stringWidth(string2)) > n) {
                n4 = RenderUtils.findBreakBefore(string, n5);
            } else {
                n4 = RenderUtils.findBreakAfter(string, n5);
                if (n4 != -1 && fontMetrics.stringWidth(string2 = string.substring(0, n4).trim()) > n) {
                    n4 = RenderUtils.findBreakBefore(string, n5);
                }
            }
            if (n4 == -1) {
                n4 = n5;
            }
            list.add(string.substring(0, n4).trim());
            string = string.substring(n4).trim();
            n2 = string.length();
            n3 = fontMetrics.stringWidth(string);
        }
        if (n2 > 0) {
            list.add(string);
        }
    }

    private static int findBreakBefore(String string, int n) {
        for (int i = n; i >= 0; --i) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c) && WORD_BOUNDARIES.indexOf(c) <= -1) continue;
            return i;
        }
        return -1;
    }

    private static int findBreakAfter(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c) && WORD_BOUNDARIES.indexOf(c) <= -1) continue;
            return i;
        }
        return -1;
    }
}

