/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import javax.swing.KeyStroke;
import workbench.resource.StoreableKeyStroke;

public class ShortcutDefinition {
    private String actionClass;
    private StoreableKeyStroke currentKey;
    private StoreableKeyStroke defaultKey;
    private StoreableKeyStroke alternateKey;
    private boolean shortcutRemoved;

    public ShortcutDefinition() {
    }

    public ShortcutDefinition(String string) {
        this.setActionClass(string);
    }

    public void setShortcutRemoved(boolean bl) {
        this.shortcutRemoved = bl;
        if (bl) {
            this.clearKeyStroke();
        }
    }

    public boolean isMappedTo(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return false;
        }
        KeyStroke keyStroke2 = this.getActiveKeyStroke();
        if (keyStroke2 != null) {
            return keyStroke2.equals(keyStroke);
        }
        return false;
    }

    public boolean getShortcutRemoved() {
        return this.shortcutRemoved;
    }

    public void clearKeyStroke() {
        this.currentKey = null;
    }

    public KeyStroke getDefaultKeyStroke() {
        if (this.defaultKey != null) {
            return this.defaultKey.getKeyStroke();
        }
        return null;
    }

    public void setAlternateKey(StoreableKeyStroke storeableKeyStroke) {
        this.alternateKey = storeableKeyStroke;
    }

    public KeyStroke getAlternateKeyStroke() {
        if (this.alternateKey != null) {
            return this.alternateKey.getKeyStroke();
        }
        return null;
    }

    public void setCurrentKey(StoreableKeyStroke storeableKeyStroke) {
        this.currentKey = storeableKeyStroke;
    }

    public StoreableKeyStroke getCurrentKey() {
        return this.currentKey;
    }

    public KeyStroke getCurrentKeyStroke() {
        if (this.currentKey == null) {
            return null;
        }
        return this.currentKey.getKeyStroke();
    }

    public void assignKey(KeyStroke keyStroke) {
        this.assignKey(new StoreableKeyStroke(keyStroke));
    }

    public void assignKey(StoreableKeyStroke storeableKeyStroke) {
        this.currentKey = storeableKeyStroke;
        this.shortcutRemoved = false;
    }

    public void assignDefaultKey(KeyStroke keyStroke) {
        this.defaultKey = new StoreableKeyStroke(keyStroke);
    }

    public StoreableKeyStroke getDefaultKey() {
        return this.defaultKey;
    }

    public void assignAlternateKey(KeyStroke keyStroke) {
        this.alternateKey = new StoreableKeyStroke(keyStroke);
    }

    public StoreableKeyStroke getAlternateKey() {
        return this.alternateKey;
    }

    public boolean hasDefault() {
        return this.defaultKey != null;
    }

    public boolean isCustomized() {
        if (this.defaultKey == null && this.currentKey == null) {
            return false;
        }
        if (this.defaultKey == null && this.currentKey != null) {
            return true;
        }
        if (this.defaultKey != null && this.currentKey == null) {
            return this.shortcutRemoved;
        }
        return !this.currentKey.equals(this.defaultKey);
    }

    public void resetToDefault() {
        this.shortcutRemoved = false;
        this.currentKey = null;
    }

    public KeyStroke getActiveKeyStroke() {
        if (this.shortcutRemoved) {
            return null;
        }
        if (this.currentKey != null) {
            return this.currentKey.getKeyStroke();
        }
        if (this.defaultKey != null) {
            return this.defaultKey.getKeyStroke();
        }
        return null;
    }

    public StoreableKeyStroke getActiveKey() {
        if (this.shortcutRemoved) {
            return null;
        }
        if (this.currentKey != null) {
            return this.currentKey;
        }
        return this.defaultKey;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public final void setActionClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ClassName cannot be null");
        }
        this.actionClass = string;
    }

    public String toString() {
        StoreableKeyStroke storeableKeyStroke;
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.actionClass);
        StoreableKeyStroke storeableKeyStroke2 = storeableKeyStroke = this.currentKey != null ? this.currentKey : this.defaultKey;
        if (storeableKeyStroke != null) {
            stringBuilder.append(" [");
            stringBuilder.append(storeableKeyStroke.toString());
            stringBuilder.append(']');
        } else {
            stringBuilder.append("[no shortcut]");
        }
        if (this.isCustomized()) {
            stringBuilder.append(" (customized)");
        }
        return stringBuilder.toString();
    }
}

