/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import workbench.WbManager;
import workbench.console.ConsolePrompter;
import workbench.console.ConsoleSettings;
import workbench.console.ConsoleStatusBar;
import workbench.console.DataStorePrinter;
import workbench.console.RowDisplay;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.components.GenericRowMonitor;
import workbench.gui.profiles.ProfileKey;
import workbench.interfaces.ExecutionController;
import workbench.interfaces.ParameterPrompter;
import workbench.interfaces.ResultLogger;
import workbench.interfaces.ResultSetConsumer;
import workbench.interfaces.ScriptErrorHandler;
import workbench.interfaces.SqlHistoryProvider;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ErrorReportLevel;
import workbench.sql.ExecutionStatus;
import workbench.sql.MessagePriority;
import workbench.sql.OutputPrinter;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.sql.wbcommands.ConnectionDescriptor;
import workbench.sql.wbcommands.InvalidConnectionDescriptor;
import workbench.sql.wbcommands.WbConnect;
import workbench.ssh.SshConfig;
import workbench.ssh.SshException;
import workbench.ssh.SshHostConfig;
import workbench.storage.DataStore;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.CollectionUtil;
import workbench.util.DurationFormatter;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileDialogUtil;
import workbench.util.MessageBuffer;
import workbench.util.Replacer;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbStringTokenizer;

public class BatchRunner
implements PropertyChangeListener {
    public static final String CMD_LINE_PROFILE_NAME = "$Wb$CommandLineProfile";
    private List<String> filenames;
    private StatementRunner stmtRunner;
    private WbConnection connection;
    private boolean abortOnError;
    private String successScript;
    private String errorScript;
    private DelimiterDefinition delimiter;
    private boolean showResultSets;
    private boolean showTiming = true;
    private ExecutionStatus status = ExecutionStatus.Success;
    private ConnectionProfile profile;
    private ResultLogger resultDisplay;
    private boolean cancelExecution;
    private RowActionMonitor rowMonitor;
    private boolean verboseLogging = true;
    private boolean checkEscapedQuotes;
    private String encoding;
    private boolean showProgress;
    private PrintStream console = System.out;
    private boolean consolidateMessages;
    private boolean showStatementWithResult = true;
    private boolean showSummary;
    private boolean showRowCounts = this.showSummary = this.verboseLogging;
    private boolean optimizeCols = true;
    private boolean showStatementTiming = true;
    private boolean printStatements;
    private String connectionId = "BatchRunner";
    private String command;
    private boolean storeErrorMessages;
    private MessageBuffer errors;
    private final List<DataStore> queryResults = new ArrayList<DataStore>();
    private Replacer replacer;
    private boolean isBusy;
    private ErrorDescriptor lastError;
    private int errorStatementIndex;
    private ScriptErrorHandler retryHandler;
    private int maxDisplaySize = Integer.MAX_VALUE;

    public BatchRunner() {
        this.stmtRunner = new StatementRunner();
        this.stmtRunner.setUseMessageLoggerForResult(false);
        this.stmtRunner.setErrorReportLevel(ErrorReportLevel.full);
        this.stmtRunner.addChangeListener(this);
    }

    public BatchRunner(String string) {
        this();
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(string, ",", false, "\"'", false);
        List<String> list = wbStringTokenizer.getAllTokens();
        this.filenames = new ArrayList<String>(list.size());
        for (String string2 : list) {
            this.filenames.add(string2.trim());
        }
    }

    public BatchRunner(List<WbFile> list) {
        this();
        this.filenames = new ArrayList<String>(list.size());
        for (File file : list) {
            this.filenames.add(file.getAbsolutePath());
        }
    }

    public void done() {
        if (this.errors != null) {
            this.errors.clear();
        }
        this.queryResults.clear();
        this.stmtRunner.done();
    }

    public void setMaxColumnDisplayLength(int n) {
        this.maxDisplaySize = n;
    }

    public void setRetryHandler(ScriptErrorHandler scriptErrorHandler) {
        this.retryHandler = scriptErrorHandler;
    }

    public void setTraceOutput(OutputPrinter outputPrinter) {
        this.stmtRunner.setMessagePrinter(outputPrinter);
    }

    public void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    public void setStoreErrors(boolean bl) {
        this.storeErrorMessages = bl;
    }

    public void setPrintStatements(boolean bl) {
        this.printStatements = bl;
    }

    public void setErrorStatementLogging(ErrorReportLevel errorReportLevel) {
        this.stmtRunner.setErrorReportLevel(errorReportLevel);
    }

    public ErrorDescriptor getLastError() {
        return this.lastError;
    }

    public int getLastErrorStatementIndex() {
        return this.errorStatementIndex;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void setBaseDir(String string) {
        this.stmtRunner.setBaseDir(string);
    }

    public void setHistoryProvider(SqlHistoryProvider sqlHistoryProvider) {
        this.stmtRunner.setHistoryProvider(sqlHistoryProvider);
    }

    public void setUseSavepoint(boolean bl) {
        this.stmtRunner.setUseSavepoint(bl);
    }

    public void setConnectionId(String string) {
        this.connectionId = string;
    }

    public WbConnection getConnection() {
        return this.connection;
    }

    public boolean hasPendingActions() {
        return this.stmtRunner.hasPendingActions();
    }

    public SqlCommand getCommand(String string) {
        return this.stmtRunner.cmdMapper.getCommandToUse(string);
    }

    public void addCommand(SqlCommand sqlCommand) {
        this.stmtRunner.cmdMapper.addCommand(sqlCommand);
    }

    public void setExecutionController(ExecutionController executionController) {
        this.stmtRunner.setExecutionController(executionController);
    }

    public void setParameterPrompter(ParameterPrompter parameterPrompter) {
        this.stmtRunner.setParameterPrompter(parameterPrompter);
    }

    public void setConsole(PrintStream printStream) {
        this.console = printStream;
    }

    public void setShowDataLoading(boolean bl) {
        this.stmtRunner.setShowDataLoadingProgress(bl);
    }

    public void setShowStatementWithResult(boolean bl) {
        this.showStatementWithResult = bl;
    }

    public void showResultSets(boolean bl) {
        this.showResultSets = bl;
    }

    public void setOptimizeColWidths(boolean bl) {
        this.optimizeCols = bl;
    }

    public void setShowStatementSummary(boolean bl) {
        this.showSummary = bl;
    }

    public void setShowRowCounts(boolean bl) {
        this.showRowCounts = bl;
    }

    public boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean bl) {
        this.verboseLogging = bl;
        this.showSummary = bl;
        this.stmtRunner.setVerboseLogging(bl);
        this.showTiming = this.verboseLogging;
        this.showRowCounts = bl;
    }

    public void setConsolidateLog(boolean bl) {
        this.consolidateMessages = bl;
    }

    public void setIgnoreDropErrors(boolean bl) {
        this.stmtRunner.setIgnoreDropErrors(bl);
    }

    public ConnectionProfile getProfile() {
        return this.profile;
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public void setProfile(ConnectionProfile connectionProfile) {
        this.profile = connectionProfile;
    }

    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        if (delimiterDefinition != null) {
            this.delimiter = delimiterDefinition;
        }
    }

    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.stmtRunner.setConnection(this.connection);
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public boolean wasCancelled() {
        return this.cancelExecution;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
        if (!this.showProgress) {
            this.setRowMonitor(null);
        } else if (this.rowMonitor == null && !WbManager.getInstance().isGUIMode()) {
            this.setRowMonitor(new GenericRowMonitor(new ConsoleStatusBar()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.stmtRunner) {
            this.connection = this.stmtRunner.getConnection();
        }
    }

    public static void loginPrompt(ConnectionProfile connectionProfile, ExecutionController executionController) {
        Object object;
        boolean bl = connectionProfile.needsPasswordPrompt();
        if (connectionProfile.getPromptForUsername()) {
            if (executionController == null) {
                LogMgr.logError(new CallerInfo(){}, "A login prompt is needed but no ExecutionController was provided.", new NullPointerException("No ExecutionController"));
                return;
            }
            object = executionController.getInput(ResourceMgr.getString("LblUsername"));
            connectionProfile.setTemporaryUsername((String)object);
            connectionProfile.setInputPassword(null);
            bl = true;
        }
        if (bl) {
            if (executionController == null) {
                LogMgr.logError(new CallerInfo(){}, "A passwort prompt is needed but no ExecutionController was provided.", null);
                return;
            }
            object = executionController.getPassword(ResourceMgr.getFormattedString("MsgInputPwd", connectionProfile.getUrlInfo()));
            connectionProfile.setInputPassword((String)object);
        }
        if (connectionProfile.needsSSHPasswordPrompt()) {
            object = connectionProfile.getSshConfig().getSshHostConfig();
            String string = ((SshHostConfig)object).getPrivateKeyFile() == null ? "MsgInputSshPwd" : "MsgInputSshPassPhrase";
            String string2 = executionController.getPassword(ResourceMgr.getString(string));
            ((SshHostConfig)object).setTemporaryPassword(string2);
        }
    }

    public void connect() throws SQLException, ClassNotFoundException, SshException {
        this.connection = null;
        if (this.profile == null) {
            LogMgr.logWarning(new CallerInfo(){}, "No profile defined, proceeding without a connection.");
            this.status = ExecutionStatus.Success;
            return;
        }
        BatchRunner.loginPrompt(this.profile, this.stmtRunner.getExecutionController());
        try {
            ConnectionMgr connectionMgr = ConnectionMgr.getInstance();
            WbConnection wbConnection = connectionMgr.getConnection(this.profile, this.connectionId);
            this.setConnection(wbConnection);
            String string = wbConnection.getDisplayString();
            LogMgr.logInfo(new CallerInfo(){}, ResourceMgr.getFormattedString("MsgBatchConnectOk", wbConnection.getDisplayString()));
            if (this.verboseLogging) {
                this.printMessage(ResourceMgr.getFormattedString("MsgBatchConnectOk", string));
                String string2 = wbConnection.getWarnings();
                if (!StringUtil.isEmptyString(string2) && !wbConnection.getProfile().isHideWarnings()) {
                    this.printMessage(string2);
                    LogMgr.logWarning(new CallerInfo(){}, "Connection returned warnings: " + string2);
                }
            }
            this.status = ExecutionStatus.Success;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = ResourceMgr.getString("ErrDriverNotFound");
            string = StringUtil.replace(string, "%class%", this.profile.getDriverclass());
            LogMgr.logError(new CallerInfo(){}, string, null);
            this.printMessage(string);
            this.status = ExecutionStatus.Error;
            throw classNotFoundException;
        }
        catch (SQLException sQLException) {
            this.status = ExecutionStatus.Error;
            LogMgr.logError(new CallerInfo(){}, "Connection failed", sQLException);
            this.printMessage(ResourceMgr.getString("ErrConnectFailed"));
            this.printMessage(ExceptionUtil.getDisplay(sQLException));
            throw sQLException;
        }
    }

    public void setMaxRows(int n) {
        if (this.stmtRunner != null) {
            this.stmtRunner.setMaxRows(n);
        }
    }

    public void setPersistentConnect(boolean bl) {
        WbConnect wbConnect = (WbConnect)this.getCommand("WbConnect");
        wbConnect.setPersistentChange(bl);
    }

    public List<DataStore> getQueryResults() {
        return this.queryResults;
    }

    public boolean isSuccess() {
        return this.status != ExecutionStatus.Error;
    }

    public void setSuccessScript(String string) {
        if (string == null) {
            return;
        }
        WbFile wbFile = new WbFile(string);
        if (wbFile.exists() && !wbFile.isDirectory()) {
            this.successScript = string;
        } else {
            LogMgr.logWarning(new CallerInfo(){}, "File '" + string + "' specified for success script not found. No success script is used!");
            this.successScript = null;
        }
    }

    public void setErrorScript(String string) {
        if (string == null) {
            return;
        }
        WbFile wbFile = new WbFile(string);
        if (wbFile.exists() && !wbFile.isDirectory()) {
            this.errorScript = string;
        } else {
            LogMgr.logWarning(new CallerInfo(){}, "File '" + string + "' specified for error script not found. No error script is used!");
            this.errorScript = null;
        }
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
        this.stmtRunner.setRowMonitor(this.rowMonitor);
    }

    public void setScriptToRun(String string) {
        this.command = string;
    }

    protected void runScript() {
        try {
            this.status = this.runScript(this.command);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, ResourceMgr.getString("MsgBatchStatementError"), exception);
            String string = ExceptionUtil.getDisplay(exception);
            if (this.showProgress) {
                this.printMessage("");
            }
            this.printMessage(ResourceMgr.getString("TxtError") + ": " + string);
            this.status = ExecutionStatus.Error;
        }
    }

    public void execute() {
        this.queryResults.clear();
        try {
            if (CollectionUtil.isNonEmpty(this.filenames)) {
                this.runFiles();
            } else {
                this.runScript();
            }
        }
        finally {
            this.stmtRunner.done();
        }
    }

    protected void runFiles() {
        Object object;
        int n = this.filenames.size();
        String string = "batchRunnerFileLoop";
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
            this.rowMonitor.saveCurrentType(string);
        }
        CallerInfo callerInfo = new CallerInfo(){};
        int n2 = 0;
        for (String string2 : this.filenames) {
            String string3;
            ++n2;
            WbFile wbFile = new WbFile(string2);
            if (this.rowMonitor != null) {
                this.rowMonitor.restoreType(string);
                this.rowMonitor.setCurrentObject(string2, n2, n);
            }
            try {
                String string4 = ResourceMgr.getString("MsgBatchProcessingFile") + " " + wbFile.getFullPath();
                LogMgr.logInfo(new CallerInfo(){}, string4);
                if (this.resultDisplay != null && this.verboseLogging) {
                    this.resultDisplay.appendToLog(string4);
                    this.resultDisplay.appendToLog("\n");
                }
                string3 = wbFile.getAbsoluteFile().getParent();
                this.setBaseDir(string3);
                this.status = this.executeScript(wbFile);
            }
            catch (Exception exception) {
                this.status = ExecutionStatus.Error;
                LogMgr.logError(callerInfo, ResourceMgr.getString("MsgBatchScriptFileError") + " " + string2, exception);
                string3 = null;
                string3 = exception instanceof FileNotFoundException ? ResourceMgr.getFormattedString("ErrFileNotFound", string2) : exception.getMessage();
                if (this.showProgress) {
                    this.printMessage("");
                }
                this.printMessage(ResourceMgr.getString("TxtError") + ": " + string3);
            }
            if (this.status != ExecutionStatus.Error || !this.abortOnError) continue;
            break;
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        if (this.abortOnError && this.status == ExecutionStatus.Error) {
            try {
                if (this.errorScript != null) {
                    object = new WbFile(this.errorScript);
                    LogMgr.logInfo(callerInfo, ResourceMgr.getString("MsgBatchExecutingErrorScript") + " " + ((WbFile)object).getFullPath());
                    this.executeScript((WbFile)object);
                }
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, ResourceMgr.getString("MsgBatchScriptFileError") + " " + this.errorScript, exception);
            }
        } else {
            try {
                if (this.successScript != null) {
                    object = new WbFile(this.successScript);
                    LogMgr.logInfo(callerInfo, ResourceMgr.getString("MsgBatchExecutingSuccessScript") + " " + ((WbFile)object).getFullPath());
                    this.executeScript((WbFile)object);
                }
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, ResourceMgr.getString("MsgBatchScriptFileError") + " " + this.successScript, exception);
            }
        }
    }

    public String getMessages() {
        if (this.errors == null) {
            return null;
        }
        return this.errors.getBuffer().toString();
    }

    public void cancel() {
        this.cancelExecution = true;
        if (this.stmtRunner != null) {
            this.stmtRunner.cancel();
        }
    }

    public void abort() {
        this.cancelExecution = true;
        if (this.stmtRunner != null) {
            this.stmtRunner.abort();
        }
    }

    public ResultSetConsumer getResultSetConsumer() {
        if (this.stmtRunner != null) {
            return this.stmtRunner.getConsumer();
        }
        return null;
    }

    public void setResultSetConsumer(ResultSetConsumer resultSetConsumer) {
        if (this.stmtRunner != null) {
            this.stmtRunner.setConsumer(resultSetConsumer);
        }
    }

    private ScriptParser createParser() {
        ScriptParser scriptParser = new ScriptParser(ParserType.getTypeFromConnection(this.connection));
        if (this.delimiter == null) {
            DelimiterDefinition delimiterDefinition = Settings.getInstance().getAlternateDelimiter(this.connection, null);
            scriptParser.setDelimiters(DelimiterDefinition.STANDARD_DELIMITER, delimiterDefinition);
        } else if (scriptParser.supportsMixedDelimiter()) {
            scriptParser.setAlternateDelimiter(this.delimiter);
        } else {
            scriptParser.setDelimiters(this.delimiter, null);
        }
        scriptParser.setCheckEscapedQuotes(this.checkEscapedQuotes);
        return scriptParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionStatus executeScript(WbFile wbFile) throws IOException {
        try {
            this.isBusy = true;
            ScriptParser scriptParser = this.createParser();
            scriptParser.setFile(wbFile, this.encoding);
            ExecutionStatus executionStatus = this.executeScript(scriptParser);
            return executionStatus;
        }
        finally {
            this.isBusy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionStatus runScript(String string) throws IOException {
        ScriptParser scriptParser = this.createParser();
        scriptParser.setScript(string);
        try {
            this.isBusy = true;
            this.status = this.executeScript(scriptParser);
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
            ExecutionStatus executionStatus = this.status;
            return executionStatus;
        }
        finally {
            this.isBusy = false;
        }
    }

    private ExecutionStatus executeScript(ScriptParser scriptParser) throws IOException {
        String string;
        this.status = ExecutionStatus.Success;
        this.errors = null;
        this.cancelExecution = false;
        int n = 0;
        int n2 = 1;
        long l = System.currentTimeMillis();
        scriptParser.startIterator();
        long l2 = 0L;
        long l3 = 0L;
        CallerInfo callerInfo = new CallerInfo(){};
        this.lastError = null;
        this.errorStatementIndex = -1;
        boolean bl = false;
        int n3 = 0;
        int n4 = scriptParser.getStatementCount();
        String string2 = string = n4 > 0 ? ResourceMgr.getString("TxtBatchProcess") : ResourceMgr.getString("TxtBatchProcessUnknown");
        if (scriptParser.getScriptFile() != null && Settings.getInstance().showScriptNameForInclude()) {
            string = string + " (" + scriptParser.getScriptFile().getName() + ")";
        }
        String string3 = null;
        while ((string3 = scriptParser.getNextCommand()) != null) {
            boolean bl2 = false;
            if (string3.isEmpty()) continue;
            try {
                if (this.replacer != null) {
                    string3 = this.replacer.replace(string3);
                }
                if (this.printStatements) {
                    this.printMessage(string3.trim());
                }
                if (this.rowMonitor != null && n % n2 == 0) {
                    String string4 = MessageFormat.format(string, n + 1, n4);
                    this.rowMonitor.setCurrentObject(string4, n, n4);
                    if (n >= 100) {
                        n2 = 10;
                    }
                }
                long l4 = System.currentTimeMillis();
                StatementRunnerResult statementRunnerResult = this.stmtRunner.runStatement(string3);
                long l5 = System.currentTimeMillis();
                this.stmtRunner.statementDone();
                this.status = ExecutionStatus.Success;
                if (statementRunnerResult != null) {
                    String string5;
                    statementRunnerResult.setExecutionDuration(l5 - l4);
                    this.status = statementRunnerResult.getStatus();
                    boolean bl3 = statementRunnerResult.hasMessages();
                    MessagePriority messagePriority = statementRunnerResult.getMessagePriority();
                    String string6 = string5 = bl3 ? statementRunnerResult.getMessages().toString() : "";
                    if (this.status == ExecutionStatus.Error) {
                        this.lastError = statementRunnerResult.getErrorDescriptor();
                        if (this.lastError != null) {
                            this.lastError.setScriptFile(scriptParser.getScriptFile());
                        }
                        this.errorStatementIndex = n3;
                        ++l3;
                        if (scriptParser.getScriptFile() != null) {
                            string5 = string5 + "\n" + ResourceMgr.getFormattedString("MsgInFile", scriptParser.getScriptFile().getFullPath());
                        }
                        string5 = string5 + "\n";
                        if (this.retryHandler != null && !bl) {
                            if (this.lastError == null) {
                                this.lastError = new ErrorDescriptor();
                                this.lastError.setErrorMessage(string5);
                            }
                            int n5 = this.retryHandler.scriptErrorPrompt(n3, this.lastError, scriptParser, 0);
                            switch (n5) {
                                case 2042: {
                                    bl = true;
                                    break;
                                }
                                case 3042: {
                                    bl2 = true;
                                    break;
                                }
                                case 2: {
                                    bl = false;
                                    bl2 = false;
                                    this.cancelExecution = true;
                                }
                            }
                        }
                        if (this.storeErrorMessages) {
                            if (this.errors == null) {
                                this.errors = new MessageBuffer();
                            }
                            this.errors.appendNewLine();
                            this.errors.append(string5);
                        }
                        if (bl) {
                            bl2 = true;
                        }
                    } else {
                        if (statementRunnerResult.hasWarning() && StringUtil.isNonBlank(string5)) {
                            LogMgr.logWarning(callerInfo, string5);
                        }
                        l2 += statementRunnerResult.getTotalUpdateCount();
                    }
                    this.printResults(string3, statementRunnerResult);
                    if (bl3 && (this.stmtRunner.getVerboseLogging() || this.status == ExecutionStatus.Error || messagePriority == MessagePriority.high)) {
                        if (!this.consolidateMessages) {
                            if (!this.showResultSets) {
                                this.printMessage("");
                            }
                            this.printMessage(string5);
                        }
                    } else if (statementRunnerResult.hasWarning() && this.stmtRunner.getVerboseLogging()) {
                        String string7 = this.stmtRunner.getParsingUtil().getSqlVerb(string3);
                        String string8 = StringUtil.replace(ResourceMgr.getString("MsgStmtCompletedWarn"), "%verb%", string7);
                        this.printMessage("\n" + string8);
                    }
                    ++n;
                    if (this.showTiming && this.showStatementTiming && !this.consolidateMessages) {
                        this.printMessage(statementRunnerResult.getTimingMessage());
                    }
                }
                if (statementRunnerResult != null && statementRunnerResult.stopScript()) {
                    String string9 = ResourceMgr.getString("MsgScriptCancelled");
                    this.printMessage(string9);
                    break;
                }
                if (this.cancelExecution) {
                    if (!this.verboseLogging) break;
                    this.printMessage(ResourceMgr.getString("MsgStatementCancelled"));
                    break;
                }
                ++n3;
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, ResourceMgr.getString("MsgBatchStatementError") + " " + string3, exception);
                this.printMessage(ExceptionUtil.getDisplay(exception));
                this.status = ExecutionStatus.Error;
                break;
            }
            if (this.status != ExecutionStatus.Error || !this.abortOnError || bl2) continue;
            break;
        }
        long l6 = System.currentTimeMillis();
        if (this.showSummary) {
            StringBuilder stringBuilder = new StringBuilder(50);
            WbFile wbFile = scriptParser.getScriptFile();
            if (wbFile != null) {
                stringBuilder.append(wbFile.getFullPath());
                stringBuilder.append(": ");
            }
            stringBuilder.append(ResourceMgr.getFormattedString("MsgTotalStatementsExecuted", n));
            stringBuilder.append('\n');
            if (this.resultDisplay == null) {
                stringBuilder.insert(0, '\n');
            }
            this.printMessage(stringBuilder.toString());
        }
        if (this.consolidateMessages) {
            if (l3 > 0L) {
                this.printMessage((this.resultDisplay == null ? "\n" : "") + ResourceMgr.getFormattedString("MsgTotalStatementsFailed", l3));
            }
            if (this.verboseLogging) {
                this.printMessage(ResourceMgr.getFormattedString("MsgRowsAffected", l2));
            }
        }
        scriptParser.done();
        if (this.showTiming) {
            long l7 = l6 - l;
            DurationFormatter durationFormatter = new DurationFormatter();
            boolean bl4 = l7 < 60000L;
            String string10 = durationFormatter.formatDuration(l7, Settings.getInstance().getDurationFormat(), bl4);
            String string11 = ResourceMgr.getString("MsgExecTime") + " " + string10;
            this.printMessage(string11);
        }
        return this.status;
    }

    private void printResults(String string, StatementRunnerResult statementRunnerResult) {
        RowDisplay rowDisplay;
        if (!this.showResultSets) {
            return;
        }
        if (statementRunnerResult == null) {
            return;
        }
        if (!statementRunnerResult.isSuccess()) {
            return;
        }
        if (!statementRunnerResult.hasDataStores()) {
            return;
        }
        List<DataStore> list = statementRunnerResult.getDataStores();
        if (this.console == null) {
            for (DataStore dataStore : list) {
                this.queryResults.add(dataStore);
            }
            return;
        }
        if (this.showStatementWithResult && !this.printStatements) {
            this.console.println(string.trim());
        }
        boolean bl = (rowDisplay = ConsoleSettings.getInstance().getNextRowDisplay()) != null && rowDisplay == RowDisplay.SingleLine;
        boolean bl2 = statementRunnerResult.getShowRowCount() && this.showRowCounts;
        for (int i = 0; i < list.size(); ++i) {
            DataStore dataStore = list.get(i);
            if (dataStore == null) continue;
            DataStorePrinter dataStorePrinter = new DataStorePrinter(dataStore);
            dataStorePrinter.setMaxDisplaySize(this.maxDisplaySize);
            dataStorePrinter.setFormatColumns(this.optimizeCols);
            dataStorePrinter.setPrintRowCount(bl2);
            dataStorePrinter.setPrintRowsAsLine(bl);
            dataStorePrinter.printTo(this.console);
            if (i >= list.size() - 1) continue;
            this.console.println();
        }
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        if (string == null) {
            this.encoding = null;
        } else {
            if (!EncodingUtil.isEncodingSupported(string)) {
                throw new UnsupportedEncodingException(string + " encoding not supported!");
            }
            this.encoding = EncodingUtil.cleanupEncoding(string);
        }
    }

    public void setShowTiming(boolean bl) {
        this.showTiming = bl;
        this.showStatementTiming = bl;
    }

    public void setShowStatementTiming(boolean bl) {
        this.showStatementTiming = bl;
    }

    public boolean getAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean bl) {
        this.abortOnError = bl;
    }

    public void setCheckEscapedQuotes(boolean bl) {
        this.checkEscapedQuotes = bl;
    }

    public void setMessageLogger(ResultLogger resultLogger) {
        this.resultDisplay = resultLogger;
        if (this.stmtRunner != null) {
            this.stmtRunner.setMessageLogger(resultLogger);
        }
    }

    private void printMessage(String string) {
        if (string == null) {
            return;
        }
        if (this.resultDisplay == null) {
            if (string.length() > 0) {
                System.out.print('\r');
                System.out.println(string);
            }
        } else {
            this.resultDisplay.appendToLog(string);
            this.resultDisplay.appendToLog("\n");
        }
    }

    public static boolean hasConnectionArgument(ArgumentParser argumentParser) {
        if (!argumentParser.hasArguments()) {
            return false;
        }
        if (argumentParser.isArgPresent("connection")) {
            return true;
        }
        if (argumentParser.isArgPresent("url")) {
            return true;
        }
        if (argumentParser.isArgPresent("username")) {
            return true;
        }
        if (argumentParser.isArgPresent("driverjar")) {
            return true;
        }
        if (argumentParser.isArgPresent("driver")) {
            return true;
        }
        return argumentParser.isArgPresent("password");
    }

    public static ConnectionProfile createCmdLineProfile(ArgumentParser argumentParser) throws InvalidConnectionDescriptor {
        return BatchRunner.createCmdLineProfile(argumentParser, null, null, true);
    }

    public static ConnectionProfile createCmdLineProfile(ArgumentParser argumentParser, boolean bl) throws InvalidConnectionDescriptor {
        return BatchRunner.createCmdLineProfile(argumentParser, null, null, bl);
    }

    public static ConnectionProfile createCmdLineProfile(ArgumentParser argumentParser, WbConnection wbConnection, String string) throws InvalidConnectionDescriptor {
        return BatchRunner.createCmdLineProfile(argumentParser, wbConnection, string, true);
    }

    public static ConnectionProfile createCmdLineProfile(ArgumentParser argumentParser, WbConnection wbConnection, String string, boolean bl) throws InvalidConnectionDescriptor {
        Object object;
        String string2;
        String string3;
        Object object2;
        String string4;
        if (!BatchRunner.hasConnectionArgument(argumentParser)) {
            return null;
        }
        ConnectionProfile connectionProfile = null;
        String string5 = argumentParser.getValue("url");
        String string6 = null;
        if (bl && (string6 = argumentParser.getValue("driver")) == null) {
            string6 = argumentParser.getValue("driverclass");
        }
        if ((string4 = argumentParser.getValue("connection")) == null) {
            if (string5 == null) {
                LogMgr.logWarning(new CallerInfo(){}, "Cannot connect using command line settings without a connection URL!", null);
                return null;
            }
            if (string6 == null && bl) {
                string6 = ConnectionDescriptor.findDriverClassFromUrl(string5);
            }
            if (string6 == null && bl) {
                LogMgr.logWarning(new CallerInfo(){}, "Cannot connect using command line settings without a driver class!", null);
                return null;
            }
            object2 = argumentParser.getValue("username");
            string3 = argumentParser.getValue("password");
            string2 = argumentParser.getValue("driverjar");
            if (string2 != null && bl) {
                object = new WbFile(string2);
                ConnectionMgr.getInstance().registerDriver(string6, ((WbFile)object).getFullPath());
            }
            connectionProfile = ConnectionProfile.createEmptyProfile();
            connectionProfile.setDriverclass(string6);
            connectionProfile.setUrl(string5);
            if (argumentParser.isArgPresent("password")) {
                connectionProfile.setPassword(string3);
                connectionProfile.setStorePassword(true);
            } else {
                connectionProfile.setStorePassword(false);
            }
            connectionProfile.setUsername((String)object2);
        } else {
            object2 = new ConnectionDescriptor();
            connectionProfile = ((ConnectionDescriptor)object2).parseDefinition(string4, wbConnection);
        }
        try {
            Serializable serializable;
            object2 = argumentParser.getValue("autocommit");
            string3 = argumentParser.getValue("workspace");
            string2 = argumentParser.getValue("altDelimiter");
            object = argumentParser.getValue("connectionName", CMD_LINE_PROFILE_NAME);
            DelimiterDefinition delimiterDefinition = DelimiterDefinition.parseCmdLineArgument(string2);
            boolean bl2 = argumentParser.getBoolean("trimCharData", false);
            boolean bl3 = argumentParser.getBoolean("rollbackOnDisconnect", false);
            boolean bl4 = argumentParser.getBoolean("separateConnection", true);
            boolean bl5 = argumentParser.getBoolean("ignoreDropErrors", false);
            Map<String, String> map = argumentParser.getMapValue("connectionProperties");
            connectionProfile.setTemporaryProfile(true);
            connectionProfile.setName((String)object);
            connectionProfile.setDriverName(null);
            connectionProfile.setStoreExplorerSchema(false);
            connectionProfile.setRollbackBeforeDisconnect(bl3);
            connectionProfile.setIgnoreDropErrors(bl5);
            connectionProfile.setAlternateDelimiter(delimiterDefinition);
            connectionProfile.setTrimCharData(bl2);
            connectionProfile.setUseSeparateConnectionPerTab(bl4);
            connectionProfile.setEmptyStringIsNull(argumentParser.getBoolean("emptyStringIsNull", false));
            connectionProfile.setRemoveComments(argumentParser.getBoolean("removeComments", false));
            connectionProfile.setDetectOpenTransaction(argumentParser.getBoolean("checkUncommitted", false));
            connectionProfile.setReadOnly(argumentParser.getBoolean("readOnly", false));
            connectionProfile.setHideWarnings(argumentParser.getBoolean("hideWarnings", false));
            int n = argumentParser.getIntValue("fetchSize", -1);
            if (n > -1) {
                connectionProfile.setDefaultFetchSize(n);
            }
            if (map != null && map.size() > 0) {
                serializable = new Properties();
                ((Properties)serializable).putAll(map);
                connectionProfile.setConnectionProperties((Properties)serializable);
            }
            connectionProfile.setSshConfig(BatchRunner.getSshConfig(argumentParser));
            if (!StringUtil.isEmptyString(string3)) {
                serializable = new WbFile(string3 = FileDialogUtil.replaceConfigDir(string3));
                if (!((File)serializable).exists() && !((File)serializable).isAbsolute()) {
                    serializable = new WbFile(Settings.getInstance().getConfigDir(), string3);
                }
                if (((File)serializable).exists()) {
                    connectionProfile.setWorkspaceFile(((File)serializable).getAbsolutePath());
                }
            }
            if (!StringUtil.isEmptyString((CharSequence)object2)) {
                connectionProfile.setAutocommit(StringUtil.stringToBool((String)object2));
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error creating temporary profile", exception);
            connectionProfile = null;
        }
        return connectionProfile;
    }

    private static SshConfig getSshConfig(ArgumentParser argumentParser) {
        String string = argumentParser.getValue("sshHost");
        String string2 = argumentParser.getValue("sshUser");
        String string3 = argumentParser.getValue("sshPassword");
        String string4 = argumentParser.getValue("sshPrivateKey");
        String string5 = argumentParser.getValue("sshLocalPort");
        String string6 = argumentParser.getValue("sshPort");
        String string7 = argumentParser.getValue("sshDBPort");
        String string8 = argumentParser.getValue("sshDBHost");
        if (string != null && string2 != null) {
            SshHostConfig sshHostConfig = new SshHostConfig();
            sshHostConfig.setUsername(string2);
            sshHostConfig.setHostname(string);
            sshHostConfig.setPassword(string3);
            sshHostConfig.setPrivateKeyFile(string4);
            sshHostConfig.setSshPort(StringUtil.getIntValue(string6, 0));
            SshConfig sshConfig = new SshConfig();
            sshConfig.setHostConfig(sshHostConfig);
            sshConfig.setLocalPort(StringUtil.getIntValue(string5, 0));
            sshConfig.setDbPort(StringUtil.getIntValue(string7, 0));
            sshConfig.setDbHostname(string8);
            return sshConfig;
        }
        return null;
    }

    public static BatchRunner createBatchRunner(ArgumentParser argumentParser) {
        return BatchRunner.createBatchRunner(argumentParser, true);
    }

    public static BatchRunner createBatchRunner(ArgumentParser argumentParser, boolean bl) {
        Object object;
        Object object2;
        CharSequence charSequence;
        String string = argumentParser.getValue("script");
        String string2 = argumentParser.getValue("command");
        if (bl && StringUtil.isBlank(string) && StringUtil.isBlank(string2)) {
            return null;
        }
        String string3 = argumentParser.getValue("profile");
        boolean bl2 = true;
        bl2 = argumentParser.isArgPresent("abortOnError") ? argumentParser.getBoolean("abortOnError", true) : !argumentParser.getBoolean("continueOnError", false);
        boolean bl3 = argumentParser.getBoolean("displayResult");
        boolean bl4 = argumentParser.getBoolean("showProgress", false);
        boolean bl5 = argumentParser.getBoolean("consolidateMessages", false);
        String string4 = argumentParser.getValue("encoding");
        ConnectionProfile connectionProfile = null;
        if (string3 == null) {
            try {
                connectionProfile = BatchRunner.createCmdLineProfile(argumentParser);
            }
            catch (InvalidConnectionDescriptor invalidConnectionDescriptor) {
                LogMgr.logError(new CallerInfo(){}, "Invalid connection descriptor specified", invalidConnectionDescriptor);
            }
        } else {
            charSequence = argumentParser.getValue("profilegroup");
            object2 = new ProfileKey(StringUtil.trimQuotes(string3), StringUtil.trimQuotes((String)charSequence));
            connectionProfile = ConnectionMgr.getInstance().getProfile((ProfileKey)object2);
            if (connectionProfile == null) {
                String string5 = ResourceMgr.getFormattedString("ErrProfileNotFound", object2);
                LogMgr.logError(new CallerInfo(){}, string5, null);
            } else {
                boolean bl6 = argumentParser.getBoolean("readOnly", false);
                if (bl6) {
                    connectionProfile.setReadOnly(bl6);
                    connectionProfile.resetChangedFlags();
                }
                if (argumentParser.isArgPresent("ignoreDropErrors")) {
                    connectionProfile.setIgnoreDropErrors(argumentParser.getBoolean("ignoreDropErrors"));
                }
            }
        }
        if (argumentParser.hasUnknownArguments()) {
            charSequence = new StringBuilder(ResourceMgr.getString("ErrUnknownParameter"));
            if (!WbManager.getInstance().isGUIMode()) {
                ((StringBuilder)charSequence).append(' ');
                ((StringBuilder)charSequence).append(argumentParser.getUnknownArguments());
                System.err.println(((StringBuilder)charSequence).toString());
            }
            LogMgr.logWarning(new CallerInfo(){}, ((StringBuilder)charSequence).toString());
        }
        charSequence = argumentParser.getValue("cleanupSuccess");
        object2 = argumentParser.getValue("cleanupError");
        boolean bl7 = argumentParser.getBoolean("feedback", true);
        boolean bl8 = argumentParser.getBoolean("interactive", false);
        BatchRunner batchRunner = null;
        if (StringUtil.isNonBlank(string)) {
            batchRunner = new BatchRunner(string);
        } else {
            batchRunner = new BatchRunner();
            batchRunner.setScriptToRun(string2);
        }
        batchRunner.showResultSets(bl3);
        try {
            batchRunner.setEncoding(string4);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Invalid encoding '" + string4 + "' specified. Using platform default'", null);
        }
        batchRunner.setAbortOnError(bl2);
        batchRunner.setErrorScript((String)object2);
        batchRunner.setSuccessScript((String)charSequence);
        batchRunner.setProfile(connectionProfile);
        batchRunner.setVerboseLogging(bl7);
        if (!bl7) {
            batchRunner.setShowStatementSummary(false);
            batchRunner.setShowStatementWithResult(false);
        }
        batchRunner.setConsolidateLog(bl5);
        batchRunner.setShowProgress(bl4);
        if (bl8) {
            object = new ConsolePrompter();
            batchRunner.setExecutionController((ExecutionController)object);
            batchRunner.setParameterPrompter((ParameterPrompter)object);
        }
        batchRunner.showTiming = argumentParser.isArgNotPresent("showTiming") && argumentParser.isArgPresent("feedback") && !bl7 ? false : argumentParser.getBoolean("showTiming", true);
        object = DelimiterDefinition.parseCmdLineArgument(argumentParser.getValue("delimiter"));
        if (object != null) {
            batchRunner.setDelimiter((DelimiterDefinition)object);
        }
        return batchRunner;
    }
}

