/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.interfaces.ToolWindow;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.util.ClassFinder;
import workbench.util.InitHook;
import workbench.util.StringUtil;

public class CommandRegistry {
    private static final String PACKAGE_NAME = "workbench.extensions";
    private final List<Class> commands = new ArrayList<Class>();
    private final List<Class> guiExtensions = new ArrayList<Class>();
    private List<String> verbs;

    public static CommandRegistry getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    private CommandRegistry() {
    }

    public synchronized List<String> getVerbs() {
        if (this.verbs == null) {
            this.initVerbs();
        }
        return Collections.unmodifiableList(this.verbs);
    }

    private void initVerbs() {
        List<SqlCommand> list = this.getCommands();
        this.verbs = new ArrayList<String>(list.size());
        for (SqlCommand sqlCommand : list) {
            this.verbs.addAll(sqlCommand.getAllVerbs());
        }
    }

    public synchronized List<SqlCommand> getCommands() {
        ArrayList<SqlCommand> arrayList = new ArrayList<SqlCommand>(this.commands.size());
        for (Class clazz : this.commands) {
            try {
                SqlCommand sqlCommand = (SqlCommand)clazz.newInstance();
                arrayList.add(sqlCommand);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not create instance of: " + clazz.getCanonicalName(), throwable);
            }
        }
        return arrayList;
    }

    public synchronized void scanForExtensions() {
        long l = System.currentTimeMillis();
        this.commands.clear();
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            List<Class> list = ClassFinder.getClasses(PACKAGE_NAME);
            for (Class clazz : list) {
                LogMgr.logDebug(callerInfo, "Found class " + clazz.getName());
                if (SqlCommand.class.isAssignableFrom(clazz)) {
                    this.commands.add(clazz);
                    continue;
                }
                if (!InitHook.class.isAssignableFrom(clazz)) continue;
                LogMgr.logDebug(callerInfo, "Calling init() on class " + clazz.getName());
                InitHook initHook = (InitHook)clazz.newInstance();
                initHook.init();
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logInfo(callerInfo, "Found " + this.commands.size() + " commands in " + l2 + "ms");
        }
        catch (Exception exception) {
            LogMgr.logWarning(callerInfo, "Error when scanning for exentensions", exception);
        }
    }

    public ToolWindow getGuiExtension(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if (!string.startsWith(PACKAGE_NAME)) {
            string = "workbench.extensions." + string;
        }
        ToolWindow toolWindow = null;
        for (Class clazz : this.guiExtensions) {
            try {
                if (!string.equals(clazz.getCanonicalName())) continue;
                toolWindow = (ToolWindow)clazz.newInstance();
                break;
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not create instance of: " + clazz.getCanonicalName(), throwable);
            }
        }
        return toolWindow;
    }

    public synchronized void scanForGuiExtensions() {
        long l = System.currentTimeMillis();
        this.guiExtensions.clear();
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            List<Class> list = ClassFinder.getClasses(PACKAGE_NAME);
            for (Class clazz : list) {
                LogMgr.logDebug(callerInfo, "Found class " + clazz.getName());
                if (!ToolWindow.class.isAssignableFrom(clazz)) continue;
                this.guiExtensions.add(clazz);
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(callerInfo, "Found " + this.guiExtensions.size() + " commands in " + l2 + "ms");
        }
        catch (Exception exception) {
            LogMgr.logWarning(callerInfo, "Error when scanning for exentensions", exception);
        }
    }

    private static class LazyInstanceHolder {
        protected static final CommandRegistry INSTANCE = new CommandRegistry();

        private LazyInstanceHolder() {
        }
    }
}

