/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import workbench.sql.DelimiterDefinition;
import workbench.util.StringUtil;

public class ScriptCommandDefinition {
    private final String command;
    private final int textStartPosInScript;
    private final int textEndPosInScript;
    private int whiteSpaceStart = -1;
    private int indexInScript;
    private DelimiterDefinition delimiterUsed;
    private boolean delimiterNeeded;

    public ScriptCommandDefinition(String string, int n, int n2) {
        this(string, n, n2, -1);
    }

    public ScriptCommandDefinition(String string, int n, int n2, int n3) {
        this.command = StringUtil.rtrim(string);
        this.textStartPosInScript = n;
        this.textEndPosInScript = n2;
        this.indexInScript = n3;
    }

    public void setWhitespaceStart(int n) {
        if (n != this.textStartPosInScript) {
            this.whiteSpaceStart = n;
        }
    }

    public String getSQL() {
        return this.command;
    }

    public int getWhitespaceStart() {
        if (this.whiteSpaceStart != -1) {
            return this.whiteSpaceStart;
        }
        return this.textStartPosInScript;
    }

    public int getStartPositionInScript() {
        return this.textStartPosInScript;
    }

    public int getEndPositionInScript() {
        return this.textEndPosInScript;
    }

    public int getIndexInScript() {
        return this.indexInScript;
    }

    public void setIndexInScript(int n) {
        this.indexInScript = n;
    }

    public boolean getDelimiterNeeded() {
        return this.delimiterNeeded;
    }

    public void setDelimiterNeeded(boolean bl) {
        this.delimiterNeeded = bl;
    }

    public DelimiterDefinition getDelimiterUsed() {
        return this.delimiterUsed;
    }

    public void setDelimiterUsed(DelimiterDefinition delimiterDefinition) {
        this.delimiterUsed = delimiterDefinition;
    }

    public String toString() {
        if (this.command == null) {
            return "[" + this.textStartPosInScript + "," + this.textEndPosInScript + "]";
        }
        return this.command;
    }
}

