/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import workbench.RunMode;
import workbench.WbManager;
import workbench.db.ConnectionProfile;
import workbench.db.DbSettings;
import workbench.db.ErrorPositionReader;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.interfaces.ParameterPrompter;
import workbench.interfaces.ResultLogger;
import workbench.interfaces.ResultSetConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.CommandMapper;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ErrorReportLevel;
import workbench.sql.ResultProcessor;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.storage.DataStore;
import workbench.storage.DefaultRefCursorConsumer;
import workbench.storage.RefCursorConsumer;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.ArgumentValue;
import workbench.util.CollectionUtil;
import workbench.util.DdlObjectInfo;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class SqlCommand {
    protected Statement currentStatement;
    protected WbConnection currentConnection;
    protected boolean isCancelled;
    protected RowActionMonitor rowMonitor;
    protected boolean isUpdatingCommand;
    protected ErrorReportLevel errorLevel;
    protected ResultLogger messageLogger;
    protected StatementRunner runner;
    protected int queryTimeout;
    protected int maxRows;
    protected DataStore currentRetrievalData;
    protected ParameterPrompter prompter;
    protected ArgumentParser cmdLine;
    protected boolean includeStatementInError;
    protected boolean showDataLoading = true;
    protected boolean alwaysBufferResults;
    protected boolean useMessageLoggerForResults = true;

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    public void setMessageLogger(ResultLogger resultLogger) {
        this.messageLogger = resultLogger;
    }

    public ArgumentParser getArgumentParser() {
        return this.cmdLine;
    }

    public void setUseMessageLoggerForResults(boolean bl) {
        this.useMessageLoggerForResults = bl;
    }

    protected StatementRunnerResult createResult() {
        return this.createResult(null);
    }

    protected StatementRunnerResult createResult(String string) {
        if (this.useMessageLoggerForResults) {
            return new StatementRunnerResult(string, this.messageLogger);
        }
        return new StatementRunnerResult(string);
    }

    public void setErrorReportLevel(ErrorReportLevel errorReportLevel) {
        this.errorLevel = errorReportLevel;
    }

    public ErrorReportLevel getErrorReportLevel() {
        return this.errorLevel;
    }

    public boolean isWbCommand() {
        return false;
    }

    public void setAlwaysBufferResults(boolean bl) {
        this.alwaysBufferResults = bl;
    }

    public String getParameterHelp() {
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = Integer.MIN_VALUE;
        for (String object : this.cmdLine.getRegisteredArguments()) {
            if (object.length() <= n) continue;
            n = object.length();
        }
        n += 3;
        n = Math.max(10, n);
        stringBuilder.append("Parameters for " + this.getVerb() + "\n\n");
        String string = String.format("%-" + n + "s %-20s %s\n", "NAME", "TYPE", "VALUES");
        stringBuilder.append(string);
        stringBuilder.append(StringUtil.padRight("-", string.length(), '-') + "\n");
        for (String string2 : this.cmdLine.getRegisteredArguments()) {
            if (string2.equalsIgnoreCase("help")) continue;
            Collection<ArgumentValue> collection = this.cmdLine.getAllowedValues(string2);
            ArgumentType argumentType = this.cmdLine.getArgumentType(string2);
            String string3 = "";
            if (argumentType == ArgumentType.ListArgument) {
                if (CollectionUtil.isNonEmpty(collection)) {
                    boolean bl = true;
                    for (ArgumentValue argumentValue : collection) {
                        if (!bl) {
                            string3 = string3 + ", ";
                        }
                        if (bl) {
                            bl = false;
                        }
                        string3 = string3 + argumentValue.getDisplay();
                    }
                }
            } else if (argumentType == ArgumentType.BoolArgument) {
                string3 = "true,false";
            }
            stringBuilder.append(String.format("%-" + n + "s %-20s %s \n", new Object[]{"-" + string2, argumentType, string3}));
        }
        return stringBuilder.toString();
    }

    protected WbFile findXsltFile(String string) {
        WbFile wbFile;
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if (!string.toLowerCase().endsWith(".xslt")) {
            string = string + ".xslt";
        }
        if ((wbFile = new WbFile(string)).exists()) {
            return wbFile;
        }
        if (wbFile.isAbsolute()) {
            return wbFile;
        }
        Object[] objectArray = new File[]{new WbFile(this.getBaseDir()), Settings.getInstance().getDefaultXsltDirectory()};
        WbFile wbFile2 = FileUtil.searchFile(string, (File[])objectArray);
        if (wbFile2 != null && wbFile2.exists()) {
            LogMgr.logInfo(new CallerInfo(){}, "Found XSLT file \"" + string + "\" in directory: " + wbFile2.getParentFile().getAbsolutePath());
        } else {
            LogMgr.logError(new CallerInfo(){}, "XSLT file \"" + string + "\" not found in " + Arrays.toString(objectArray), null);
        }
        return wbFile2;
    }

    protected File getXsltBaseDir() {
        String string;
        String string2 = string = this.runner == null ? null : this.runner.getBaseDir();
        if (string == null) {
            return Settings.getInstance().getDefaultXsltDirectory();
        }
        return new File(string);
    }

    protected SqlParsingUtil getParsingUtil() {
        return SqlParsingUtil.getInstance(this.currentConnection);
    }

    protected String getBaseDir() {
        String string;
        String string2 = string = this.runner == null ? null : this.runner.getBaseDir();
        if (string == null) {
            string = ".";
        }
        return string;
    }

    protected int getMacroClientId() {
        if (this.runner == null) {
            return Integer.MIN_VALUE;
        }
        return this.runner.getMacroClientId();
    }

    protected String getDefaultSuccessMessage(StatementRunnerResult statementRunnerResult) {
        String string;
        DbSettings dbSettings;
        String string2 = this.getVerb();
        if (StringUtil.isEmptyString(string2) && statementRunnerResult != null) {
            string2 = this.getParsingUtil().getSqlVerb(statementRunnerResult.getSourceCommand());
        }
        DbSettings dbSettings2 = dbSettings = this.currentConnection != null ? this.currentConnection.getDbSettings() : null;
        if (dbSettings != null && !dbSettings.showSuccessMessageForVerb(string2)) {
            return null;
        }
        String string3 = string = statementRunnerResult == null ? null : this.getSuccessMessage(string2, statementRunnerResult.getSourceCommand());
        if (string != null) {
            return string;
        }
        String string4 = null;
        if (this.currentConnection != null) {
            string4 = this.currentConnection.getDbId();
        }
        if ((string = ResourceMgr.getDynamicString("MsgStmtSuccess", string2, string4)) != null) {
            return string;
        }
        if (StringUtil.isEmptyString(string2)) {
            string2 = ResourceMgr.getString("TxtStatement");
        }
        return ResourceMgr.getFormattedString("MsgKnownStatementOK", string2);
    }

    protected String getSuccessMessage(String string, String string2) {
        String string3;
        DdlObjectInfo ddlObjectInfo = SqlUtil.getDDLObjectInfo(string2, this.currentConnection);
        if (ddlObjectInfo != null && (string3 = this.getSuccessMessage(ddlObjectInfo, string)) != null) {
            return string3;
        }
        return null;
    }

    protected String getSuccessMessage(DdlObjectInfo ddlObjectInfo, String string) {
        if ("DROP".equals(string)) {
            if (ddlObjectInfo == null || ddlObjectInfo.getObjectType() == null) {
                return ResourceMgr.getString("MsgGenDropSuccess");
            }
            if (StringUtil.isNonBlank(ddlObjectInfo.getObjectName())) {
                return ResourceMgr.getFormattedString("MsgDropSuccess", ddlObjectInfo.getDisplayType(), ddlObjectInfo.getObjectName());
            }
            return ResourceMgr.getFormattedString("MsgDropTypeSuccess", ddlObjectInfo.getObjectType());
        }
        if ("CREATE".equals(string) || "RECREATE".equals(string)) {
            if (ddlObjectInfo == null || ddlObjectInfo.getObjectType() == null) {
                return ResourceMgr.getString("MsgGenCreateSuccess");
            }
            if (StringUtil.isNonBlank(ddlObjectInfo.getObjectName())) {
                return ResourceMgr.getFormattedString("MsgCreateSuccess", ddlObjectInfo.getDisplayType(), ddlObjectInfo.getObjectName());
            }
            String string2 = ddlObjectInfo.getObjectType();
            if ("INDEX".equals(string2)) {
                string2 = ddlObjectInfo.getDisplayType();
            }
            return ResourceMgr.getFormattedString("MsgCreateTypeSuccess", string2);
        }
        if ("ALTER".equals(string) && ddlObjectInfo != null) {
            String string3 = ddlObjectInfo.getObjectType();
            if (ddlObjectInfo.getObjectName() != null) {
                string3 = string3 + " " + ddlObjectInfo.getObjectName();
            }
            return ResourceMgr.getFormattedString("MsgDMLSuccess", string, string3);
        }
        if ("ANALYZE".equals(string) && ddlObjectInfo != null) {
            String string4 = this.currentConnection.getMetadata().adjustObjectnameCase(ddlObjectInfo.getObjectName());
            return ResourceMgr.getFormattedString("MsgObjectAnalyzed", StringUtil.capitalize(ddlObjectInfo.getObjectType()), string4);
        }
        return null;
    }

    protected void appendSuccessMessage(StatementRunnerResult statementRunnerResult) {
        if (statementRunnerResult.wasConsumed()) {
            return;
        }
        String string = this.getDefaultSuccessMessage(statementRunnerResult);
        if (string != null) {
            statementRunnerResult.addMessage(string);
        }
    }

    public void setParameterPrompter(ParameterPrompter parameterPrompter) {
        this.prompter = parameterPrompter;
    }

    public void setShowDataLoading(boolean bl) {
        this.showDataLoading = bl;
    }

    protected void appendOutput(StatementRunnerResult statementRunnerResult) {
        String string = this.currentConnection.getOutputMessages();
        boolean bl = "hide".equals(this.runner.getSessionAttribute("server_messages"));
        if (StringUtil.isNonBlank(string)) {
            if (statementRunnerResult.hasMessages()) {
                statementRunnerResult.addMessageNewLine();
            }
            if (!bl) {
                statementRunnerResult.addMessageByKey("TxtServerOutput");
            }
            statementRunnerResult.addMessage(string);
        }
    }

    protected boolean appendWarnings(StatementRunnerResult statementRunnerResult, boolean bl) {
        if (this.runner == null || this.runner.getHideWarnings()) {
            return false;
        }
        CharSequence charSequence = SqlUtil.getWarnings(this.currentConnection, this.currentStatement);
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        if (statementRunnerResult.hasMessages()) {
            statementRunnerResult.addMessageNewLine();
        }
        if (bl && charSequence.length() > 7 && !charSequence.subSequence(0, 7).toString().equalsIgnoreCase("Warning")) {
            statementRunnerResult.addMessageByKey("TxtWarnings");
        }
        statementRunnerResult.addWarning(charSequence);
        statementRunnerResult.addMessageNewLine();
        return true;
    }

    protected void setUnknownMessage(StatementRunnerResult statementRunnerResult, ArgumentParser argumentParser, String string) {
        if (!this.cmdLine.hasUnknownArguments()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(ResourceMgr.getString("ErrUnknownParameter"));
        stringBuilder.append(' ');
        stringBuilder.append(this.cmdLine.getUnknownArguments());
        statementRunnerResult.addErrorMessage(stringBuilder.toString());
        if (!WbManager.getInstance().isBatchMode() && string != null) {
            statementRunnerResult.addMessageNewLine();
            statementRunnerResult.addMessage(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        CallerInfo callerInfo = new CallerInfo(){};
        SqlCommand sqlCommand = this;
        synchronized (sqlCommand) {
            this.isCancelled = true;
            if (this.currentRetrievalData != null) {
                this.currentRetrievalData.cancelRetrieve();
            }
            SqlUtil.cancelStatement(callerInfo, this.currentStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        SqlCommand sqlCommand = this;
        synchronized (sqlCommand) {
            if (this.currentStatement != null) {
                try {
                    this.currentStatement.clearBatch();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.currentStatement.clearWarnings();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.currentConnection.clearWarnings();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.currentStatement.close();
                }
                catch (Throwable throwable) {
                    LogMgr.logError(new CallerInfo(){}, "Error when closing the current statement for: " + this.getClass().getSimpleName(), throwable);
                }
            }
            this.currentStatement = null;
            this.isCancelled = false;
            this.currentRetrievalData = null;
        }
    }

    public void setStatementRunner(StatementRunner statementRunner) {
        this.runner = statementRunner;
    }

    public boolean isModeSupported(RunMode runMode) {
        return true;
    }

    public boolean shouldEndTransaction() {
        return false;
    }

    protected boolean isConnectionRequired() {
        return true;
    }

    protected void setMaxRowsForStatement(Statement statement) {
        try {
            statement.setMaxRows(this.maxRows >= 0 ? this.maxRows : 0);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "The JDBC driver does not support the setMaxRows() function! (" + throwable.getMessage() + ")");
        }
    }

    public boolean displayHelp(StatementRunnerResult statementRunnerResult) {
        if (this.cmdLine.getBoolean("help")) {
            statementRunnerResult.addMessage(this.getParameterHelp());
            statementRunnerResult.setSuccess();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        this.currentStatement = this.currentConnection.createStatement();
        this.isCancelled = false;
        string = this.getSqlToExecute(string);
        String string2 = this.getParsingUtil().getSqlVerb(string);
        statementRunnerResult.ignoreUpdateCounts(this.currentConnection.getDbSettings().verbsWithoutUpdateCount().contains(string2));
        if (this.runner.useSavepointForDML()) {
            this.runner.setSavepoint();
        }
        if (this.currentConnection.getDbSettings().useMaxRows(string2)) {
            this.setMaxRowsForStatement(this.currentStatement);
        }
        try {
            boolean bl = this.currentStatement.execute(string);
            if (bl && this.shouldCallGetMoreResultsFirst(string2)) {
                bl = this.currentStatement.getMoreResults();
            }
            statementRunnerResult.setSuccess();
            this.processResults(statementRunnerResult, bl);
            this.appendSuccessMessage(statementRunnerResult);
            this.runner.releaseSavepoint();
        }
        catch (Exception exception) {
            this.runner.rollbackSavepoint();
            this.processResults(statementRunnerResult, false);
            this.addErrorInfo(statementRunnerResult, string, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string, exception);
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    private boolean shouldCallGetMoreResultsFirst(String string) {
        if (string == null) {
            return false;
        }
        if (this.currentConnection == null) {
            return false;
        }
        if (this.currentConnection.getMetadata().isOracle() && OracleUtils.fixPLSQLResultSetBug()) {
            return string.equalsIgnoreCase("begin") || string.equalsIgnoreCase("declare");
        }
        return false;
    }

    protected void processResults(StatementRunnerResult statementRunnerResult, boolean bl) throws SQLException {
        this.processResults(statementRunnerResult, bl, null);
    }

    protected RefCursorConsumer createRefCursorConsumer(ResultInfo resultInfo) {
        return new DefaultRefCursorConsumer(resultInfo, this.currentConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResults(StatementRunnerResult statementRunnerResult, boolean bl, ResultSet resultSet) throws SQLException {
        if (statementRunnerResult == null) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.currentConnection == null || this.currentConnection.isClosed()) {
            LogMgr.logError(callerInfo, "Current connection has been closed. Aborting...", null);
            return;
        }
        this.appendOutput(statementRunnerResult);
        this.appendWarnings(statementRunnerResult, true);
        if (!this.runner.getStatementHook().fetchResults()) {
            return;
        }
        boolean bl2 = this.runner.getStatementHook().fetchResults() && !this.runner.getStatementHook().displayResults();
        int n = -1;
        boolean bl3 = false;
        ResultProcessor resultProcessor = new ResultProcessor(this.currentStatement, resultSet, this.currentConnection);
        if (bl) {
            bl3 = true;
        } else {
            try {
                n = this.currentStatement.getUpdateCount();
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, "Error when calling getUpdateCount()", exception);
                n = -1;
            }
            bl3 = resultProcessor.hasMoreResults();
        }
        if (this.currentConnection == null || this.currentConnection.isClosed() || this.currentConnection.getMetadata() == null) {
            LogMgr.logError(callerInfo, "Current connection has been closed. Aborting...", null);
            return;
        }
        boolean bl4 = this.currentConnection.getDbSettings().retrieveWarningsForEachResult();
        boolean bl5 = this.currentConnection.getDbSettings().allowsMultipleGetUpdateCounts();
        int n2 = 0;
        int n3 = this.currentConnection.getDbSettings().getMaxResults();
        ResultSet resultSet2 = null;
        while (bl3 || n > -1) {
            if (this.currentConnection == null || this.currentConnection.isClosed()) {
                LogMgr.logError(callerInfo, "Current connection has been closed. Aborting...", null);
                return;
            }
            if (n > -1) {
                statementRunnerResult.addUpdateCountMsg(n);
            }
            if (bl3) {
                ResultSetConsumer resultSetConsumer;
                resultSet2 = resultProcessor.getResult();
                if (resultSet2 == null) break;
                if (bl4) {
                    this.appendWarnings(statementRunnerResult, false);
                }
                if ((resultSetConsumer = this.runner.getConsumer()) != null && !this.alwaysBufferResults) {
                    statementRunnerResult.addResultSet(resultSet2);
                    resultSetConsumer.consumeResult(statementRunnerResult);
                } else {
                    RefCursorConsumer refCursorConsumer;
                    boolean bl6;
                    block32: {
                        RowActionMonitor rowActionMonitor = null;
                        bl6 = this.runner.getStatementHook().displayResults();
                        if (this.showDataLoading && bl6) {
                            rowActionMonitor = this.rowMonitor;
                        }
                        this.currentRetrievalData = new DataStore(resultSet2, false, rowActionMonitor, this.maxRows, this.currentConnection);
                        refCursorConsumer = this.createRefCursorConsumer(this.currentRetrievalData.getResultInfo());
                        try {
                            this.currentRetrievalData.setGeneratingSql(statementRunnerResult.getSourceCommand());
                            if (bl2) {
                                int n4 = this.currentRetrievalData.fetchOnly(resultSet2);
                                statementRunnerResult.setRowsProcessed(n4);
                            } else {
                                this.currentRetrievalData.initData(resultSet2, this.maxRows, refCursorConsumer);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (this.currentRetrievalData != null && this.currentRetrievalData.isCancelled()) {
                                statementRunnerResult.addWarningByKey("MsgErrorDuringRetrieve");
                                statementRunnerResult.addMessage(ExceptionUtil.getAllExceptions(sQLException));
                                break block32;
                            }
                            throw sQLException;
                        }
                        finally {
                            JdbcUtils.closeResult(resultSet2);
                        }
                    }
                    statementRunnerResult.addRowsProcessed(this.currentRetrievalData.getRowCount());
                    if (bl6) {
                        if (!refCursorConsumer.containsOnlyRefCursors()) {
                            statementRunnerResult.addDataStore(this.currentRetrievalData);
                        }
                        for (DataStore dataStore : refCursorConsumer.getResults()) {
                            statementRunnerResult.addDataStore(dataStore);
                        }
                    }
                }
            }
            if (this.currentConnection == null || this.currentConnection.isClosed()) {
                LogMgr.logError(callerInfo, "Current connection has been closed. Aborting...", null);
                return;
            }
            bl3 = resultProcessor.hasMoreResults();
            if (bl5) {
                try {
                    n = this.currentStatement.getUpdateCount();
                }
                catch (Throwable throwable) {
                    LogMgr.logWarning(callerInfo, "Error when calling getUpdateCount(): " + ExceptionUtil.getDisplay(throwable));
                    n = -1;
                    bl5 = false;
                }
            } else {
                n = -1;
            }
            if (++n2 < n3) continue;
            LogMgr.logWarning(callerInfo, "Breaking out of loop because " + n3 + " iterations reached");
            break;
        }
        this.currentRetrievalData = null;
    }

    protected String getSqlToExecute(String string) {
        try {
            boolean bl = this.currentConnection.getRemoveComments();
            boolean bl2 = this.currentConnection.getRemoveNewLines();
            if (!bl && !bl2) {
                return string;
            }
            return SqlUtil.makeCleanSql(string, !bl2, !bl, false, this.currentConnection);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void setConnection(WbConnection wbConnection) {
        this.currentConnection = wbConnection;
    }

    public String getVerb() {
        return "";
    }

    public String getAlternateVerb() {
        return null;
    }

    public Collection<String> getAllVerbs() {
        if (this.getAlternateVerb() == null) {
            return Collections.singleton(this.getVerb());
        }
        return CollectionUtil.arrayList(this.getVerb(), this.getAlternateVerb());
    }

    public boolean isUpdatingCommand() {
        return this.isUpdatingCommand;
    }

    public boolean needConfirmation(WbConnection wbConnection, String string) {
        if (wbConnection == null || wbConnection.isClosed()) {
            return false;
        }
        if (wbConnection.confirmUpdatesInSession() && this.isUpdatingCommand(wbConnection, string)) {
            return true;
        }
        ConnectionProfile connectionProfile = this.getModificationTarget(wbConnection, string);
        if (connectionProfile == null) {
            return false;
        }
        if (connectionProfile.getPreventDMLWithoutWhere()) {
            return SqlUtil.isUnRestrictedDML(string, wbConnection);
        }
        return false;
    }

    public boolean isUpdatingCommand(WbConnection wbConnection, String string) {
        if (this.isUpdatingCommand) {
            return true;
        }
        if (wbConnection == null) {
            return this.isUpdatingCommand;
        }
        if (wbConnection.isClosed()) {
            return this.isUpdatingCommand;
        }
        String string2 = wbConnection.getParsingUtil().getSqlVerb(string);
        DbSettings dbSettings = wbConnection.getDbSettings();
        boolean bl = dbSettings.isUpdatingCommand(string2);
        if (bl) {
            return true;
        }
        if ("WITH".equalsIgnoreCase(string2)) {
            CommandMapper commandMapper = new CommandMapper(false);
            List<String> list = wbConnection.getParsingUtil().getCTEVerbs(wbConnection, string);
            for (String string3 : list) {
                if (dbSettings.isUpdatingCommand(string3)) {
                    return true;
                }
                SqlCommand sqlCommand = commandMapper.getCommandFromVerb(string3);
                if (sqlCommand == null || !sqlCommand.isUpdatingCommand()) continue;
                return true;
            }
        }
        return wbConnection.getMetadata().isSelectIntoNewTable(string);
    }

    public ConnectionProfile getModificationTarget(WbConnection wbConnection, String string) {
        if (wbConnection == null) {
            return null;
        }
        return wbConnection.getProfile();
    }

    public boolean isModificationAllowed(WbConnection wbConnection, String string) {
        if (wbConnection == null || wbConnection.isClosed()) {
            return true;
        }
        ConnectionProfile connectionProfile = this.getModificationTarget(wbConnection, string);
        if (connectionProfile == null) {
            return true;
        }
        if (!wbConnection.getProfile().equals(connectionProfile) && connectionProfile.isReadOnly()) {
            return false;
        }
        return !wbConnection.getProfile().equals(connectionProfile) || !wbConnection.isSessionReadOnly() || !this.isUpdatingCommand(wbConnection, string);
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    protected String getCommandLine(String string) {
        return SqlUtil.stripVerb(SqlUtil.makeCleanSql(string, false, false, true, this.currentConnection));
    }

    public WbFile evaluateFileArgument(String string) {
        String string2;
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        String string3 = StringUtil.trimQuotes(string);
        WbFile wbFile = new WbFile(string3);
        if (wbFile.isAbsolute()) {
            return wbFile;
        }
        if (this.runner != null && StringUtil.isNonEmpty(string2 = this.runner.getBaseDir())) {
            wbFile = new WbFile(string2, string3);
        }
        return wbFile;
    }

    public List<WbFile> evaluateWildcardFileArgs(String string) {
        return FileUtil.listFiles(string, this.getBaseDir());
    }

    protected void addErrorStatement(StatementRunnerResult statementRunnerResult, String string) {
        if (this.errorLevel != ErrorReportLevel.none) {
            StringBuilder stringBuilder = new StringBuilder(150);
            stringBuilder.append(ResourceMgr.getString("MsgExecuteError"));
            stringBuilder.append('\n');
            if (this.errorLevel == ErrorReportLevel.full) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(StringUtil.getMaxSubstring(string.trim(), Settings.getInstance().getMaxErrorStatementLength()));
            }
            statementRunnerResult.addMessage(stringBuilder);
            statementRunnerResult.addMessageNewLine();
        }
    }

    protected void addErrorInfo(StatementRunnerResult statementRunnerResult, String string, Exception exception) {
        this.addErrorStatement(statementRunnerResult, string);
        this.addErrorPosition(statementRunnerResult, string, exception);
    }

    protected void addErrorPosition(StatementRunnerResult statementRunnerResult, String string, Exception exception) {
        try {
            ErrorPositionReader errorPositionReader = ErrorPositionReader.Factory.createPositionReader(this.currentConnection);
            String string2 = null;
            string2 = statementRunnerResult.getSourceCommand() == null ? string : this.getSqlToExecute(statementRunnerResult.getSourceCommand());
            ErrorDescriptor errorDescriptor = errorPositionReader.getErrorPosition(this.currentConnection, string2, exception);
            if (errorDescriptor != null && errorDescriptor.getErrorMessage() != null) {
                errorDescriptor.setErrorCode(exception);
                String string3 = errorPositionReader.enhanceErrorMessage(string2, exception.getMessage(), errorDescriptor);
                statementRunnerResult.addErrorMessage(errorDescriptor, string3);
            } else {
                statementRunnerResult.addErrorMessage(exception);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve error position!", throwable);
            statementRunnerResult.addErrorMessage(ExceptionUtil.getAllExceptions(exception).toString());
        }
    }

    public String toString() {
        return this.getVerb();
    }

    protected boolean checkConditions(StatementRunnerResult statementRunnerResult) {
        if (!ConditionCheck.isCommandLineOK(statementRunnerResult, this.cmdLine)) {
            return false;
        }
        ConditionCheck.Result result = ConditionCheck.checkConditions(this.cmdLine, this.currentConnection, this::evaluateFileArgument);
        if (result.isOK()) {
            return true;
        }
        statementRunnerResult.addMessage(ConditionCheck.getMessage(this.getVerb(), result));
        statementRunnerResult.setSuccess();
        return false;
    }
}

