/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import workbench.db.WbConnection;
import workbench.db.firebird.FirebirdStatementHook;
import workbench.db.mssql.SqlServerStatementHook;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.oracle.OracleStatementHook;
import workbench.db.postgres.PostgresStatementHook;
import workbench.resource.Settings;
import workbench.sql.DefaultStatementHook;
import workbench.sql.StatementHook;
import workbench.sql.StatementRunner;

public class StatementHookFactory {
    public static final StatementHook DEFAULT_HOOK = new DefaultStatementHook();

    public static StatementHook getStatementHook(StatementRunner statementRunner) {
        WbConnection wbConnection = statementRunner.getConnection();
        if (wbConnection == null) {
            return DEFAULT_HOOK;
        }
        if (wbConnection.getMetadata() == null) {
            return DEFAULT_HOOK;
        }
        if (wbConnection.getMetadata().isOracle()) {
            return new OracleStatementHook();
        }
        if (wbConnection.getMetadata().isSqlServer() && SqlServerUtil.isSqlServer2008(wbConnection)) {
            return new SqlServerStatementHook();
        }
        if (wbConnection.getMetadata().isFirebird()) {
            return new FirebirdStatementHook(wbConnection);
        }
        if (wbConnection.getMetadata().isPostgres() && Settings.getInstance().getBoolProperty("workbench.db.postgresql.enable.listen", true)) {
            return new PostgresStatementHook(wbConnection);
        }
        return DEFAULT_HOOK;
    }
}

