/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import workbench.WbManager;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.interfaces.ExecutionController;
import workbench.interfaces.ParameterPrompter;
import workbench.interfaces.ResultLogger;
import workbench.interfaces.ResultSetConsumer;
import workbench.interfaces.ScriptErrorHandler;
import workbench.interfaces.SqlHistoryProvider;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.CommandMapper;
import workbench.sql.ErrorReportLevel;
import workbench.sql.OutputPrinter;
import workbench.sql.SavepointStrategy;
import workbench.sql.SqlCommand;
import workbench.sql.StatementHook;
import workbench.sql.StatementHookFactory;
import workbench.sql.StatementRunnerResult;
import workbench.sql.VariablePool;
import workbench.sql.annotations.CrossTabAnnotation;
import workbench.sql.annotations.RemoveEmptyResultsAnnotation;
import workbench.sql.annotations.RemoveResultAnnotation;
import workbench.sql.annotations.WbAnnotation;
import workbench.sql.commands.AlterSessionCommand;
import workbench.sql.commands.SetCommand;
import workbench.sql.commands.TransactionEndCommand;
import workbench.sql.wbcommands.WbEndBatch;
import workbench.sql.wbcommands.WbStartBatch;
import workbench.storage.DataStore;
import workbench.storage.DatastoreTransposer;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.CollectionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class StatementRunner
implements PropertyChangeListener {
    public static final String SERVER_MSG_PROP = "server_messages";
    private WbConnection mainConnection;
    private WbConnection currentConnection;
    private SqlCommand currentCommand;
    private StatementHook statementHook = StatementHookFactory.DEFAULT_HOOK;
    private ResultSetConsumer currentConsumer;
    private String baseDir;
    private RowActionMonitor rowMonitor;
    private ExecutionController controller;
    private WbStartBatch batchCommand;
    private ResultLogger resultLogger;
    private boolean verboseLogging;
    private boolean hideWarnings;
    private ErrorReportLevel errorLevel;
    private ParameterPrompter prompter;
    private boolean ignoreDropErrors;
    protected CommandMapper cmdMapper;
    private SavepointStrategy useSavepoint = SavepointStrategy.whenConfigured;
    private OutputPrinter messageOutput;
    private boolean traceStatements;
    private Savepoint savepoint;
    private final List<PropertyChangeListener> changeListeners = new ArrayList<PropertyChangeListener>();
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean showDataLoadingProgress = true;
    private boolean useMessageLoggerForResult = true;
    private final Map<String, String> sessionAttributes = new HashMap<String, String>();
    private final CrossTabAnnotation crossTab = new CrossTabAnnotation();
    private final RemoveEmptyResultsAnnotation removeEmpty = new RemoveEmptyResultsAnnotation();
    private final RemoveResultAnnotation removeResult = new RemoveResultAnnotation();
    private int macroClientId;
    private ScriptErrorHandler retryHandler;
    private SqlHistoryProvider history;

    public StatementRunner() {
        this.verboseLogging = !Settings.getInstance().getConsolidateLogMsg();
        this.errorLevel = Settings.getInstance().getStatementErrorReportLevel();
        this.cmdMapper = new CommandMapper();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.log.consolidate", "workbench.gui.log.errorstatement");
    }

    public void setMacroClientId(int n) {
        this.macroClientId = n;
    }

    public int getMacroClientId() {
        return this.macroClientId;
    }

    public ScriptErrorHandler getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(ScriptErrorHandler scriptErrorHandler) {
        this.retryHandler = scriptErrorHandler;
    }

    public void setHistoryProvider(SqlHistoryProvider sqlHistoryProvider) {
        this.history = sqlHistoryProvider;
    }

    public SqlHistoryProvider getHistoryProvider() {
        return this.history;
    }

    public void dispose() {
        Settings.getInstance().removePropertyChangeListener(this);
    }

    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners.add(propertyChangeListener);
    }

    public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners.remove(propertyChangeListener);
    }

    public void fireConnectionChanged() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "connection", null, this.currentConnection);
        for (PropertyChangeListener propertyChangeListener : this.changeListeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public boolean getTraceStatements() {
        return this.traceStatements;
    }

    public void setTraceStatements(boolean bl) {
        this.traceStatements = bl;
    }

    public void setMessagePrinter(OutputPrinter outputPrinter) {
        this.messageOutput = outputPrinter;
    }

    public void setSessionProperty(String string, String string2) {
        this.sessionAttributes.put(string, string2);
    }

    public void removeSessionProperty(String string) {
        this.sessionAttributes.remove(string);
    }

    public String getSessionAttribute(String string) {
        return this.sessionAttributes.get(string);
    }

    public boolean getBoolSessionAttribute(String string) {
        String string2 = this.sessionAttributes.get(string);
        return StringUtil.stringToBool(string2);
    }

    public void setUseMessageLoggerForResult(boolean bl) {
        this.useMessageLoggerForResult = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("workbench.gui.log.consolidate".equals(propertyChangeEvent.getPropertyName())) {
            this.verboseLogging = !Settings.getInstance().getConsolidateLogMsg();
        } else if ("workbench.gui.log.errorstatement".equals(propertyChangeEvent.getPropertyName())) {
            this.errorLevel = Settings.getInstance().getStatementErrorReportLevel();
        }
    }

    public void setShowDataLoadingProgress(boolean bl) {
        this.showDataLoadingProgress = false;
    }

    public void setErrorReportLevel(ErrorReportLevel errorReportLevel) {
        this.errorLevel = errorReportLevel;
    }

    public ExecutionController getExecutionController() {
        return this.controller;
    }

    public void setExecutionController(ExecutionController executionController) {
        this.controller = executionController;
    }

    public boolean getHideWarnings() {
        return this.hideWarnings;
    }

    public void setHideWarnings(boolean bl) {
        this.hideWarnings = bl;
    }

    public void setIgnoreDropErrors(boolean bl) {
        this.ignoreDropErrors = bl;
    }

    public boolean getIgnoreDropErrors() {
        return this.ignoreDropErrors;
    }

    public boolean hasPendingActions() {
        if (this.currentConsumer != null) {
            return true;
        }
        return this.statementHook.isPending();
    }

    public void addCommand(SqlCommand sqlCommand) {
        this.cmdMapper.addCommand(sqlCommand);
    }

    public Collection<String> getAllWbCommands() {
        return this.cmdMapper.getAllWbCommands();
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void setParameterPrompter(ParameterPrompter parameterPrompter) {
        this.prompter = parameterPrompter;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public SqlParsingUtil getParsingUtil() {
        return SqlParsingUtil.getInstance(this.currentConnection);
    }

    public WbConnection getConnection() {
        return this.currentConnection;
    }

    public boolean restoreMainConnection() {
        if (this.mainConnection != null) {
            this.currentConnection.disconnect();
            this.setConnection(this.mainConnection);
            this.mainConnection = null;
            return true;
        }
        return false;
    }

    public void changeConnection(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        if (wbConnection == this.currentConnection) {
            return;
        }
        if (this.mainConnection == null) {
            this.mainConnection = this.currentConnection;
        } else {
            this.currentConnection.disconnect();
        }
        this.setConnection(wbConnection);
    }

    public void setConnection(WbConnection wbConnection) {
        if (this.statementHook != null) {
            this.statementHook.close(wbConnection);
        }
        this.releaseSavepoint();
        this.cmdMapper.setConnection(wbConnection);
        this.currentConnection = wbConnection;
        this.fireConnectionChanged();
        if (this.currentConnection == null) {
            return;
        }
        ConnectionProfile connectionProfile = this.currentConnection.getProfile();
        if (connectionProfile != null) {
            this.ignoreDropErrors = connectionProfile.getIgnoreDropErrors();
            this.hideWarnings = connectionProfile.isHideWarnings();
        }
        this.statementHook = StatementHookFactory.getStatementHook(this);
        this.sessionAttributes.clear();
    }

    private boolean shouldEndTransactionForCommand(SqlCommand sqlCommand) {
        if (sqlCommand == null) {
            return false;
        }
        if (sqlCommand.isUpdatingCommand()) {
            return false;
        }
        if (sqlCommand instanceof TransactionEndCommand) {
            return false;
        }
        if (sqlCommand instanceof AlterSessionCommand) {
            return false;
        }
        if (sqlCommand instanceof SetCommand) {
            return false;
        }
        if (sqlCommand.isWbCommand()) {
            return sqlCommand.shouldEndTransaction();
        }
        return true;
    }

    private void endReadOnlyTransaction() {
        if (this.currentConnection == null) {
            return;
        }
        if (this.currentConnection.getAutoCommit()) {
            return;
        }
        if (this.currentConnection.getDbSettings() == null) {
            return;
        }
        if (!this.shouldEndTransactionForCommand(this.currentCommand)) {
            return;
        }
        if (this.currentConnection.endReadOnlyTransaction(new CallerInfo(){})) {
            LogMgr.logInfo(new CallerInfo(){}, "Ended the current transaction started by: " + this.currentCommand);
        }
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    public void setMessageLogger(ResultLogger resultLogger) {
        this.resultLogger = resultLogger;
    }

    public SqlCommand getCommandToUse(String string) {
        return this.cmdMapper.getCommandToUse(string);
    }

    public StatementRunnerResult runStatement(String string) throws SQLException, Exception {
        List<WbAnnotation> list;
        int n;
        boolean bl;
        boolean bl2;
        StatementRunnerResult statementRunnerResult = null;
        if (this.prompter != null && !(bl2 = this.prompter.processParameterPrompts(string))) {
            statementRunnerResult = new StatementRunnerResult(string);
            statementRunnerResult.setPromptingWasCancelled();
            return statementRunnerResult;
        }
        this.currentCommand = this.cmdMapper.getCommandToUse(string);
        if (this.currentCommand == null) {
            return null;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (!this.currentCommand.isModeSupported(WbManager.getInstance().getRunMode())) {
            statementRunnerResult = new StatementRunnerResult();
            statementRunnerResult.setSuccess();
            LogMgr.logWarning(callerInfo, this.currentCommand.getVerb() + " not supported in mode " + WbManager.getInstance().getRunMode().toString() + ". The statement has been ignored.");
            return statementRunnerResult;
        }
        if (this.currentConnection == null && this.currentCommand.isConnectionRequired()) {
            final String string2 = SqlParsingUtil.getInstance(null).getSqlVerb(string);
            SQLException sQLException = new SQLException("Cannot execute command '" + string2 + "' without a connection!"){

                @Override
                public String getLocalizedMessage() {
                    return ResourceMgr.getFormattedString("ErrConnRequired", string2);
                }
            };
            throw sQLException;
        }
        this.currentCommand.setStatementRunner(this);
        this.currentCommand.setRowMonitor(this.rowMonitor);
        this.currentCommand.setMessageLogger(this.resultLogger);
        this.currentCommand.setUseMessageLoggerForResults(this.useMessageLoggerForResult);
        if (this.currentConsumer != null && this.currentConsumer.ignoreMaxRows()) {
            this.currentCommand.setMaxRows(0);
        } else {
            this.currentCommand.setMaxRows(this.maxRows);
        }
        this.currentCommand.setQueryTimeout(this.queryTimeout);
        this.currentCommand.setConnection(this.currentConnection);
        this.currentCommand.setParameterPrompter(this.prompter);
        this.currentCommand.setErrorReportLevel(this.errorLevel);
        this.currentCommand.setShowDataLoading(this.showDataLoadingProgress);
        String string3 = string;
        if (VariablePool.getInstance().getParameterCount() > 0) {
            string3 = VariablePool.getInstance().replaceAllParameters(string);
            if (Settings.getInstance().getLogParameterSubstitution() && LogMgr.isDebugEnabled()) {
                if (StringUtil.equalString(string, string3)) {
                    LogMgr.logDebug(callerInfo, "No variables replaced for:\n" + string);
                } else {
                    LogMgr.logDebug(callerInfo, "Variable substitution:\n--- [statement before] ---\n" + string + "\n--- [statement after] ---\n" + string3 + "\n--- [end] ---");
                }
            }
        }
        if (!this.currentCommand.isModificationAllowed(this.currentConnection, string3)) {
            ConnectionProfile connectionProfile = this.currentCommand.getModificationTarget(this.currentConnection, string);
            String string4 = connectionProfile == null ? "" : connectionProfile.getName();
            statementRunnerResult = new StatementRunnerResult();
            String string5 = SqlParsingUtil.getInstance(this.currentConnection).getSqlVerb(string);
            String string6 = ResourceMgr.getFormattedString("MsgReadOnlyMode", string4, string5);
            LogMgr.logWarning(callerInfo, "Statement " + string5 + " ignored because connection is set to read only!");
            statementRunnerResult.addWarning(string6);
            statementRunnerResult.setSuccess();
            return statementRunnerResult;
        }
        if (this.controller != null && this.currentCommand.needConfirmation(this.currentConnection, string3) && !(bl = this.controller.confirmStatementExecution(string3))) {
            statementRunnerResult = new StatementRunnerResult();
            String string7 = ResourceMgr.getString("MsgStatementCancelled");
            statementRunnerResult.addWarning(string7);
            statementRunnerResult.setSuccess();
            return statementRunnerResult;
        }
        string3 = this.statementHook.preExec(this, string3);
        if (this.traceStatements && this.messageOutput != null) {
            this.messageOutput.printMessage(string3);
        }
        this.currentCommand.setAlwaysBufferResults((n = (list = WbAnnotation.readAllAnnotations(string3, this.crossTab, this.removeEmpty, this.removeResult)).indexOf(this.crossTab)) >= 0);
        long l = System.currentTimeMillis();
        statementRunnerResult = string3 == null ? new StatementRunnerResult() : this.currentCommand.execute(string3);
        if (this.currentCommand instanceof WbStartBatch && statementRunnerResult.isSuccess()) {
            this.batchCommand = (WbStartBatch)this.currentCommand;
        } else if (this.batchCommand != null && this.currentCommand instanceof WbEndBatch) {
            statementRunnerResult = this.batchCommand.executeBatch();
        }
        if (list.contains(this.removeEmpty)) {
            this.removeEmptyResults(statementRunnerResult);
        }
        if (list.contains(this.removeResult)) {
            statementRunnerResult.clearResultData();
        }
        if (n > -1) {
            this.processCrossTab(statementRunnerResult, list.get(n));
        }
        if (this.currentConsumer != null && this.currentCommand != this.currentConsumer && statementRunnerResult.isSuccess()) {
            this.currentConsumer.consumeResult(statementRunnerResult);
        }
        long l2 = System.currentTimeMillis() - l;
        this.statementHook.postExec(this, string3, statementRunnerResult);
        statementRunnerResult.setExecutionDuration(l2);
        if (Settings.getInstance().getLogAllStatements()) {
            StatementRunner.logStatement(string3, l2, this.currentConnection);
        }
        return statementRunnerResult;
    }

    private void processCrossTab(StatementRunnerResult statementRunnerResult, WbAnnotation wbAnnotation) {
        if (!statementRunnerResult.isSuccess()) {
            return;
        }
        List<DataStore> list = statementRunnerResult.getDataStores();
        ArgumentParser argumentParser = new ArgumentParser(false);
        argumentParser.addArgument("labelColumn");
        argumentParser.addArgument("addLabel");
        String string = wbAnnotation.getValue();
        argumentParser.parse(string);
        String string2 = StringUtil.trimToNull(argumentParser.getValue("labelColumn"));
        String string3 = argumentParser.getValue("addLabel");
        for (int i = 0; i < list.size(); ++i) {
            DataStore dataStore = list.get(i);
            DatastoreTransposer datastoreTransposer = new DatastoreTransposer(dataStore);
            DataStore dataStore2 = datastoreTransposer.transposeWithLabel(string2, string3, null);
            list.set(i, dataStore2);
            dataStore.reset();
        }
    }

    private void removeEmptyResults(StatementRunnerResult statementRunnerResult) {
        if (!statementRunnerResult.isSuccess()) {
            return;
        }
        List<DataStore> list = statementRunnerResult.getDataStores();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Iterator<DataStore> iterator = list.iterator();
        while (iterator.hasNext()) {
            DataStore dataStore = iterator.next();
            if (dataStore.getRowCount() != 0) continue;
            iterator.remove();
            if (!Settings.getInstance().showRemovedResultMessage()) continue;
            String string = StringUtil.getMaxSubstring(SqlUtil.makeCleanSql(dataStore.getGeneratingSql(), false, false, true, this.currentConnection), 150, " [...]");
            statementRunnerResult.addMessageByKey("MsgResultRemoved", string);
        }
    }

    public static void logStatement(String string, long l, WbConnection wbConnection) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 25);
        stringBuilder.append("Executed: ");
        if (wbConnection != null) {
            stringBuilder.append('(');
            stringBuilder.append(wbConnection.toString());
            stringBuilder.append(')');
        }
        if (Settings.getInstance().getBoolProperty("workbench.sql.log.statements.clean", false)) {
            stringBuilder.append(SqlUtil.makeCleanSql(string, false, true, true, wbConnection));
            stringBuilder.append(' ');
        } else {
            stringBuilder.append('\n');
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        if (l > -1L) {
            stringBuilder.append('(');
            stringBuilder.append(Long.toString(l));
            stringBuilder.append("ms)");
        }
        LogMgr.logInfo(new CallerInfo(){}, stringBuilder);
    }

    public StatementHook getStatementHook() {
        return this.statementHook;
    }

    public ResultSetConsumer getConsumer() {
        return this.currentConsumer;
    }

    public void setConsumer(ResultSetConsumer resultSetConsumer) {
        this.currentConsumer = resultSetConsumer;
    }

    public void setVerboseLogging(boolean bl) {
        this.verboseLogging = bl;
    }

    public boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    public void statementDone() {
        this.endReadOnlyTransaction();
        if (this.currentCommand != null && this.currentCommand != this.currentConsumer) {
            this.currentCommand.done();
            this.currentCommand = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        StatementRunner statementRunner = this;
        synchronized (statementRunner) {
            try {
                if (this.currentConsumer != null) {
                    this.currentConsumer.cancel();
                }
                if (this.currentConnection != null && Settings.getInstance().useOracleNativeCancel()) {
                    this.currentConnection.oracleCancel();
                }
                if (this.currentCommand != null) {
                    this.currentCommand.cancel();
                }
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error when cancelling statement", exception);
            }
        }
    }

    public void abort() {
        this.endReadOnlyTransaction();
        this.savepoint = null;
        this.currentCommand = null;
        this.currentConsumer = null;
        if (this.mainConnection != null) {
            this.currentConnection = this.mainConnection;
            this.mainConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        StatementRunner statementRunner = this;
        synchronized (statementRunner) {
            this.endReadOnlyTransaction();
            this.releaseSavepoint();
            this.currentConsumer = null;
            this.restoreMainConnection();
            if (this.currentConnection != null) {
                this.currentConnection.clearWarnings();
            }
        }
    }

    public SavepointStrategy getSavepointStrategy() {
        return this.useSavepoint;
    }

    public void setSavepointStrategy(SavepointStrategy savepointStrategy) {
        this.useSavepoint = savepointStrategy;
    }

    public void setUseSavepoint(boolean bl) {
        this.useSavepoint = bl ? SavepointStrategy.always : SavepointStrategy.never;
    }

    public boolean useSavepointForDML() {
        if (this.currentConnection == null) {
            return false;
        }
        switch (this.useSavepoint) {
            case always: {
                return true;
            }
            case never: {
                return false;
            }
        }
        return this.currentConnection.getDbSettings().useSavePointForDML();
    }

    public boolean useSavepointForDDL() {
        if (this.currentConnection == null) {
            return false;
        }
        switch (this.useSavepoint) {
            case always: {
                return true;
            }
            case never: {
                return false;
            }
        }
        return this.currentConnection.getDbSettings().useSavePointForDDL();
    }

    public void setSavepoint() {
        if (this.savepoint != null) {
            return;
        }
        try {
            this.savepoint = this.currentConnection.setSavepoint(new CallerInfo(){});
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error creating savepoint", sQLException);
            this.savepoint = null;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Savepoints not supported!", throwable);
            this.savepoint = null;
        }
    }

    public void releaseSavepoint() {
        if (this.savepoint == null || this.currentConnection == null) {
            return;
        }
        try {
            this.currentConnection.releaseSavepoint(this.savepoint, new CallerInfo(){});
        }
        finally {
            this.savepoint = null;
        }
    }

    public void rollbackSavepoint() {
        if (this.savepoint == null) {
            return;
        }
        try {
            this.currentConnection.rollback(this.savepoint, new CallerInfo(){});
        }
        finally {
            this.savepoint = null;
        }
    }
}

