/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.VariablesDataStore;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbProperties;

public class VariablePool
implements PropertyChangeListener {
    public static final String PROP_PREFIX = "wbp.";
    private final Map<String, String> data = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private final Map<String, List<String>> lookups = new HashMap<String, List<String>>();
    private final Set<String> globalVars = CollectionUtil.caseInsensitiveSet();
    private final Object lock = new Object();
    private String prefix;
    private String suffix;
    private final Pattern validNamePattern = Pattern.compile("[\\w\\.]*");
    private Pattern promptPattern;
    private Pattern variablePattern;

    public static VariablePool getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private VariablePool() {
        this.initPromptPattern();
        this.initFromProperties(System.getProperties());
        Settings.getInstance().addPropertyChangeListener(this, "workbench.sql.parameter.prefix", "workbench.sql.parameter.suffix");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPromptPattern() {
        Object object = this.lock;
        synchronized (object) {
            String string = this.getPrefix();
            String string2 = this.getSuffix();
            String string3 = StringUtil.quoteRegexMeta(string) + "[\\?&][\\w\\.]+" + StringUtil.quoteRegexMeta(string2);
            this.promptPattern = Pattern.compile(string3, 2);
            string3 = StringUtil.quoteRegexMeta(string) + "[\\?&]{0,1}[\\w\\.]+" + StringUtil.quoteRegexMeta(string2);
            this.variablePattern = Pattern.compile(string3, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrefix() {
        Object object = this.lock;
        synchronized (object) {
            if (this.prefix == null) {
                this.prefix = Settings.getInstance().getSqlParameterPrefix();
            }
            return this.prefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSuffix() {
        Object object = this.lock;
        synchronized (object) {
            if (this.suffix == null) {
                this.suffix = Settings.getInstance().getSqlParameterSuffix();
                if (StringUtil.isEmptyString(this.suffix)) {
                    this.suffix = "";
                }
            }
            return this.suffix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.prefix = null;
            this.suffix = null;
            this.initPromptPattern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        this.clear();
        Object object = this.lock;
        synchronized (object) {
            this.prefix = null;
            this.suffix = null;
            this.initPromptPattern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefixSuffix(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.prefix = string;
            this.suffix = string2;
            this.initPromptPattern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initFromProperties(Properties properties) {
        Map<String, String> map = this.data;
        synchronized (map) {
            this.data.clear();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith(PROP_PREFIX)) continue;
                String string2 = string.substring(PROP_PREFIX.length());
                String string3 = (String)entry.getValue();
                try {
                    this.setParameterValue(string2, string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogMgr.logError(new CallerInfo(){}, "Error setting variable", illegalArgumentException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, String> map = this.data;
        synchronized (map) {
            this.data.clear();
            this.lookups.clear();
        }
    }

    public Set<String> getVariablesNeedingPrompt(String string) {
        return this.getPromptVariables(string, false);
    }

    public DataStore getParametersToBePrompted(String string) {
        Set<String> set = this.getVariablesNeedingPrompt(string);
        if (set.isEmpty()) {
            return null;
        }
        return this.getVariablesDataStore(set, Settings.getInstance().getSortPromptVariables());
    }

    public boolean hasPrompt(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = this.promptPattern.matcher(string);
        if (matcher == null) {
            return false;
        }
        return matcher.find();
    }

    private Map<String, Pattern> getNamePatterns(Set<String> set) {
        HashMap<String, Pattern> hashMap = new HashMap<String, Pattern>();
        for (String string : set) {
            String string2 = this.buildVarNamePattern(string, false);
            Pattern pattern = Pattern.compile(string2, 2);
            hashMap.put(string, pattern);
        }
        return hashMap;
    }

    public boolean containsVariable(CharSequence charSequence, Set<String> set) {
        if (StringUtil.isBlank(charSequence)) {
            return false;
        }
        return this.containsVariable(charSequence, set, this.getNamePatterns(set));
    }

    private boolean containsVariable(CharSequence charSequence, Set<String> set, Map<String, Pattern> map) {
        if (StringUtil.isBlank(charSequence)) {
            return false;
        }
        for (String string : set) {
            String string2;
            String string3;
            Matcher matcher;
            Pattern pattern = map.get(string);
            if (pattern == null || !(matcher = pattern.matcher(charSequence)).find() || (string3 = matcher.group()) != null && (string2 = this.data.get(string)) != null && string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPromptVariables(String string, boolean bl) {
        if (string == null) {
            return Collections.emptySet();
        }
        Matcher matcher = this.promptPattern.matcher(string);
        if (matcher == null) {
            return Collections.emptySet();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Map<String, String> map = this.data;
        synchronized (map) {
            while (matcher.find()) {
                String string2;
                int n = matcher.start() + this.getPrefix().length();
                int n2 = matcher.end() - this.getSuffix().length();
                char c = string.charAt(n);
                String string3 = string.substring(n + 1, n2);
                if (!bl && '&' == c && (string2 = this.getParameterValue(string3)) != null && string2.length() > 0) continue;
                treeSet.add(string3);
                if (this.data.containsKey(string3)) continue;
                this.data.put(string3, "");
            }
        }
        return Collections.unmodifiableSet(treeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore getVariablesDataStore() {
        Map<String, String> map = this.data;
        synchronized (map) {
            return this.getVariablesDataStore(this.data.keySet(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore getVariablesDataStore(Set<String> set, boolean bl) {
        VariablesDataStore variablesDataStore = new VariablesDataStore();
        Map<String, String> map = this.data;
        synchronized (map) {
            for (String string : this.data.keySet()) {
                if (!set.contains(string)) continue;
                String string2 = this.data.get(string);
                int n = variablesDataStore.addRow();
                variablesDataStore.setValue(n, 0, (Object)string);
                variablesDataStore.setValue(n, 1, (Object)string2);
            }
        }
        if (bl) {
            variablesDataStore.sortByColumn(0, true);
        }
        variablesDataStore.resetStatus();
        return variablesDataStore;
    }

    public boolean isDefined(String string) {
        return this.data.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterValue(String string) {
        if (string == null) {
            return null;
        }
        Map<String, String> map = this.data;
        synchronized (map) {
            return this.data.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParameterCount() {
        Map<String, String> map = this.data;
        synchronized (map) {
            return this.data.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceAllParameters(String string) {
        if (this.data.isEmpty()) {
            return string;
        }
        Map<String, String> map = this.data;
        synchronized (map) {
            return this.replaceAllParameters(string, this.data);
        }
    }

    public String replaceAllParameters(String string, Map<String, String> map) {
        if (map.isEmpty()) {
            return string;
        }
        return this.replaceParameters(map, string);
    }

    private String replaceParameters(Map<String, String> map, String string) {
        if (string == null) {
            return null;
        }
        if (StringUtil.isBlank(string)) {
            return "";
        }
        if (!string.contains(this.getPrefix())) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        Set<String> set = map.keySet();
        Map<String, Pattern> map2 = this.getNamePatterns(set);
        while (this.containsVariable(stringBuilder, set, map2)) {
            for (String string2 : set) {
                String string3 = map.get(string2);
                Pattern pattern = map2.get(string2);
                this.replaceVarValue(stringBuilder, pattern, string3);
            }
        }
        return stringBuilder.toString();
    }

    public String removeVariables(String string) {
        if (string == null) {
            return string;
        }
        Matcher matcher = this.variablePattern.matcher(string);
        if (matcher == null) {
            return string;
        }
        return matcher.replaceAll("");
    }

    private boolean replaceVarValue(StringBuilder stringBuilder, Pattern pattern, String string) {
        if (string == null || pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(stringBuilder);
        int n = 0;
        boolean bl = false;
        while (matcher != null && matcher.find(n)) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuilder.replace(n2, n3, string);
            matcher = pattern.matcher(stringBuilder.toString());
            n = n2 + string.length();
            bl = true;
            if (n < stringBuilder.length()) continue;
            break;
        }
        return bl;
    }

    public String buildVarName(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
        stringBuilder.append(this.getPrefix());
        if (bl) {
            stringBuilder.append('?');
        }
        stringBuilder.append(string);
        String string2 = this.getSuffix();
        if (StringUtil.isNonEmpty(string2)) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public String buildVarNamePattern(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
        stringBuilder.append(StringUtil.quoteRegexMeta(this.getPrefix()));
        if (bl) {
            stringBuilder.append("[\\?\\&]{1}");
        } else {
            stringBuilder.append("[\\?\\&]?");
        }
        stringBuilder.append(string);
        stringBuilder.append(StringUtil.quoteRegexMeta(this.getSuffix()));
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeVariable(String string) {
        Object object;
        Object object2;
        if (string == null) {
            return 0;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = StringUtil.wildcardToRegex(string, true);
            object2 = Pattern.compile(string2, 2);
            for (String string3 : this.data.keySet()) {
                object = ((Pattern)object2).matcher(string3);
                if (!((Matcher)object).matches()) continue;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            arrayList.add(string);
        }
        int n = 0;
        object2 = this.data;
        synchronized (object2) {
            for (String string3 : arrayList) {
                object = this.data.remove(string3);
                if (object == null) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLookupValues(String string) {
        if (string == null) {
            return null;
        }
        Map<String, String> map = this.data;
        synchronized (map) {
            return this.lookups.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupValues(String string, List<String> list) {
        Map<String, String> map = this.data;
        synchronized (map) {
            this.lookups.put(string, list);
            if (!this.data.containsKey(string)) {
                this.data.put(string, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String string, String string2) throws IllegalArgumentException {
        if (this.isValidVariableName(string)) {
            Map<String, String> map = this.data;
            synchronized (map) {
                this.data.put(string, string2);
            }
        } else {
            String string3 = ResourceMgr.getString("ErrIllegalVariableName");
            string3 = StringUtil.replace(string3, "%varname%", string);
            string3 = string3 + "\n" + ResourceMgr.getString("ErrVarDefWrongName");
            throw new IllegalArgumentException(string3);
        }
    }

    public boolean isValidVariableName(String string) {
        return this.validNamePattern.matcher(string).matches();
    }

    public void clearGlobalVariables() {
        this.globalVars.clear();
    }

    public void readDefinition(String string, boolean bl) throws Exception {
        if (StringUtil.isBlank(string)) {
            return;
        }
        if (string.charAt(0) == '#') {
            this.readNameList(string.substring(1), bl);
        } else {
            this.readFromFile(string, null, bl);
        }
    }

    public void parseSingleDefinition(String string, boolean bl) {
        int n = string.indexOf(61);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            this.setParameterValue(string2, string3);
            if (bl) {
                this.globalVars.add(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogMgr.logWarning(new CallerInfo(){}, "Ignoring definition: " + string);
        }
    }

    private void readNameList(String string, boolean bl) {
        List<String> list = StringUtil.stringToList(string, ",");
        for (String string2 : list) {
            this.parseSingleDefinition(string2, bl);
        }
    }

    public Properties removeGlobalVars(Properties properties) {
        if (properties == null) {
            return properties;
        }
        Properties properties2 = new Properties(properties);
        for (String string : this.globalVars) {
            properties2.remove(string);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromProperties(Properties properties, String string) {
        if (CollectionUtil.isEmpty(properties)) {
            return;
        }
        Map<String, String> map = this.data;
        synchronized (map) {
            for (String string2 : properties.stringPropertyNames()) {
                if (this.globalVars.contains(string2)) {
                    LogMgr.logInfo(new CallerInfo(){}, "Not overriding global variable " + string2 + " with variable from " + string);
                    continue;
                }
                String string3 = properties.getProperty(string2);
                this.setParameterValue(string2, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVariables(Properties properties) {
        if (properties == null) {
            return;
        }
        Map<String, String> map = this.data;
        synchronized (map) {
            for (String string : properties.stringPropertyNames()) {
                if (this.globalVars.contains(string)) continue;
                this.removeVariable(string);
            }
        }
    }

    public void readFromFile(String string, String string2, boolean bl) throws IOException {
        WbProperties wbProperties = new WbProperties(this);
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        wbProperties.loadTextFile(file, string2);
        for (Map.Entry<Object, Object> entry : wbProperties.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (object == null || object2 == null) continue;
            this.setParameterValue((String)object, (String)object2);
            if (!bl) continue;
            this.globalVars.add((String)object);
        }
        String string3 = ResourceMgr.getFormattedString("MsgVarDefFileLoaded", file.getAbsolutePath());
        LogMgr.logInfo(new CallerInfo(){}, string3);
    }

    private static class InstanceHolder {
        protected static final VariablePool INSTANCE = new VariablePool();

        private InstanceHolder() {
        }
    }
}

