/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import workbench.db.DbMetadata;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class AlterSessionCommand
extends SqlCommand {
    public static final String VERB = "ALTER SESSION";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        String string2;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        statementRunnerResult.setSuccess();
        String string3 = null;
        String string4 = null;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
        DbMetadata dbMetadata = this.currentConnection.getMetadata();
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken.getContents().equals("SET")) {
            sQLToken = sQLLexer.getNextToken(false, false);
            String string5 = string2 = sQLToken == null ? null : sQLToken.getContents();
            if ("CURRENT_SCHEMA".equalsIgnoreCase(string2)) {
                string3 = dbMetadata.getCurrentSchema();
            }
            if ("CONTAINER".equalsIgnoreCase(string2) && this.currentConnection.hasMultipleOracleContainers()) {
                string4 = OracleUtils.getCurrentContainer(this.currentConnection);
            }
            if ("TIME_ZONE".equalsIgnoreCase(string2)) {
                sQLToken = sQLLexer.getNextToken(false, false);
                sQLToken = sQLLexer.getNextToken(false, false);
                if (sQLToken != null && this.changeOracleTimeZone(statementRunnerResult, sQLToken.getContents())) {
                    return statementRunnerResult;
                }
            }
        }
        try {
            this.currentStatement = this.currentConnection.createStatement();
            this.currentStatement.executeUpdate(string);
            if (string3 != null) {
                dbMetadata.clearCachedSchemaInformation();
                string2 = dbMetadata.getCurrentSchema();
                if (StringUtil.compareStrings(string3, string2, true) != 0) {
                    this.notifyConnection(ChangeType.schema, string3, string2);
                    statementRunnerResult.addMessageByKey("MsgSchemaChanged", string2);
                }
            } else if (string4 != null) {
                string2 = OracleUtils.getCurrentContainer(this.currentConnection);
                if (StringUtil.compareStrings(string4, string2, true) != 0) {
                    this.notifyConnection(ChangeType.container, string4, string2);
                    statementRunnerResult.addMessageByKey("MsgContainerChanged", string2);
                }
            } else {
                this.appendSuccessMessage(statementRunnerResult);
            }
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            this.addErrorInfo(statementRunnerResult, string, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string, exception);
        }
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyConnection(ChangeType changeType, String string, String string2) {
        boolean bl = this.currentConnection.isBusy();
        try {
            this.currentConnection.setBusy(false);
            switch (changeType) {
                case schema: {
                    this.currentConnection.schemaChanged(string, string2);
                    return;
                }
                case container: {
                    this.currentConnection.containerChanged(string, string2);
                    return;
                }
            }
            return;
        }
        finally {
            this.currentConnection.setBusy(bl);
        }
    }

    private boolean changeOracleTimeZone(StatementRunnerResult statementRunnerResult, String string) {
        Object object;
        Connection connection = this.currentConnection.getSqlConnection();
        Method method = null;
        try {
            object = this.currentConnection.getSqlConnection().getClass();
            method = ((Class)object).getMethod("setSessionTimeZone", String.class);
        }
        catch (Exception exception) {
            return false;
        }
        if (method != null) {
            try {
                object = StringUtil.trimQuotes(string);
                LogMgr.logDebug(new CallerInfo(){}, "Calling Oracle's setSessionTimeZone");
                method.setAccessible(true);
                method.invoke((Object)connection, object);
                statementRunnerResult.addMessage(ResourceMgr.getString("MsgTimezoneChanged") + " " + (String)object);
                statementRunnerResult.setSuccess();
                return true;
            }
            catch (Exception exception) {
                statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
                LogMgr.logError(new CallerInfo(){}, "Error setting Oracle timezone", exception);
            }
        }
        return false;
    }

    private static enum ChangeType {
        schema,
        container;

    }
}

