/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.io.FileNotFoundException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.LobFileStatement;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class UpdatingCommand
extends SqlCommand {
    private final String verb;
    private final boolean checkLobParameter;

    public static SqlCommand getUpdateCommand() {
        return new UpdatingCommand("UPDATE");
    }

    public static SqlCommand getDeleteCommand() {
        return new UpdatingCommand("DELETE");
    }

    public static SqlCommand getInsertCommand() {
        return new UpdatingCommand("INSERT");
    }

    public static SqlCommand getTruncateCommand() {
        return new UpdatingCommand("TRUNCATE");
    }

    public static SqlCommand getMergeCommand() {
        return new UpdatingCommand("MERGE");
    }

    private UpdatingCommand(String string) {
        this.verb = string;
        this.isUpdatingCommand = true;
        this.checkLobParameter = string.equals("UPDATE") || string.equals("INSERT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        LobFileStatement lobFileStatement = null;
        statementRunnerResult.ignoreUpdateCounts(this.currentConnection.getDbSettings().verbsWithoutUpdateCount().contains(this.verb));
        try {
            boolean bl = false;
            if (this.checkLobParameter) {
                try {
                    lobFileStatement = new LobFileStatement(string, this.getBaseDir());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    statementRunnerResult.addErrorMessage(fileNotFoundException.getMessage());
                    StatementRunnerResult statementRunnerResult2 = statementRunnerResult;
                    if (lobFileStatement != null) {
                        lobFileStatement.done();
                    }
                    this.done();
                    return statementRunnerResult2;
                }
            }
            if (this.runner.useSavepointForDML()) {
                this.runner.setSavepoint();
            }
            string = this.getSqlToExecute(string);
            if (lobFileStatement != null && lobFileStatement.containsParameter()) {
                bl = true;
                this.currentStatement = lobFileStatement.prepareStatement(this.currentConnection);
            } else if (Settings.getInstance().getCheckPreparedStatements() && this.currentConnection.getPreparedStatementPool().isRegistered(string)) {
                this.currentStatement = this.currentConnection.getPreparedStatementPool().prepareStatement(string);
                bl = true;
            } else {
                this.currentStatement = this.currentConnection.createStatement();
            }
            boolean bl2 = false;
            boolean bl3 = this.currentConnection.getDbSettings().supportsResultSetsWithDML();
            int n = -1;
            if (bl) {
                bl2 = ((PreparedStatement)this.currentStatement).execute();
            } else if (bl3) {
                bl2 = this.currentStatement.execute(string);
            } else {
                n = this.currentStatement.executeUpdate(string);
            }
            String string2 = this.getAffectedTable(string);
            if (StringUtil.isEmptyString(string2)) {
                this.appendSuccessMessage(statementRunnerResult);
            } else if (this.currentConnection.getDbSettings().showSuccessMessageForVerb(this.verb)) {
                String string3 = ResourceMgr.getFormattedString("MsgDMLSuccess", this.getMessageVerb(), string2);
                statementRunnerResult.addMessage(string3);
            }
            statementRunnerResult.setSuccess();
            if (bl3 || bl) {
                this.processResults(statementRunnerResult, bl2);
            } else if (n > -1) {
                statementRunnerResult.addUpdateCountMsg(n);
            }
            this.runner.releaseSavepoint();
        }
        catch (Exception exception) {
            this.runner.rollbackSavepoint();
            String string4 = this.getAffectedTable(string);
            if (StringUtil.isNonEmpty(string4)) {
                String string5 = ResourceMgr.getFormattedString("MsgDMLNoSuccess", this.getMessageVerb(), string4);
                statementRunnerResult.addMessage(string5);
            }
            this.addErrorInfo(statementRunnerResult, string, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string, exception);
        }
        finally {
            if (lobFileStatement != null) {
                lobFileStatement.done();
            }
            this.done();
        }
        return statementRunnerResult;
    }

    private String getMessageVerb() {
        String string = null;
        string = this.verb.equals("DELETE") ? "DELETE FROM" : (this.verb.equals("INSERT") ? "INSERT INTO" : this.verb);
        return string;
    }

    private String getAffectedTable(String string) {
        String string2 = null;
        if (this.verb.equals("UPDATE")) {
            string2 = SqlUtil.getUpdateTable(string, SqlUtil.getCatalogSeparator(this.currentConnection), this.currentConnection);
        } else if (this.verb.equals("DELETE")) {
            string2 = SqlUtil.getDeleteTable(string, SqlUtil.getCatalogSeparator(this.currentConnection), this.currentConnection);
        } else if (this.verb.equals("INSERT")) {
            string2 = SqlUtil.getInsertTable(string, SqlUtil.getCatalogSeparator(this.currentConnection), this.currentConnection);
        } else if (this.verb.equals("TRUNCATE")) {
            string2 = SqlUtil.getTruncateTable(string, SqlUtil.getCatalogSeparator(this.currentConnection), this.currentConnection);
        } else if (this.verb.equals("MERGE")) {
            string2 = SqlUtil.getMergeTable(string, this.currentConnection);
        }
        return string2;
    }

    @Override
    public String getVerb() {
        return this.verb;
    }
}

