/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.fksupport;

import java.util.Map;
import workbench.db.QuoteHandler;
import workbench.resource.GeneratedIdentifierCase;
import workbench.util.StringUtil;
import workbench.util.TableAlias;

public class JoinCondition {
    private TableAlias fromTable;
    private TableAlias toTable;
    private String fkName;
    private Map<String, String> joinColumns;
    private boolean preferUsingOperator = false;
    private boolean useParentheses = false;
    private GeneratedIdentifierCase keywordCase = GeneratedIdentifierCase.upper;
    private GeneratedIdentifierCase identifierCase = GeneratedIdentifierCase.asIs;

    public JoinCondition(TableAlias tableAlias, TableAlias tableAlias2, String string, Map<String, String> map) {
        this.fromTable = tableAlias;
        this.toTable = tableAlias2;
        this.fkName = string;
        this.joinColumns = map;
    }

    public void setUseParentheses(boolean bl) {
        this.useParentheses = bl;
    }

    public void setPreferUsingOperator(boolean bl) {
        this.preferUsingOperator = bl;
    }

    public TableAlias getFromTable() {
        return this.fromTable;
    }

    public TableAlias getToTable() {
        return this.toTable;
    }

    public String getFkName() {
        return this.fkName;
    }

    public void setKeywordCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.keywordCase = generatedIdentifierCase;
    }

    public void setIdentifierCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.identifierCase = generatedIdentifierCase;
    }

    public String getJoinCondition() {
        return this.getJoinCondition(true, QuoteHandler.STANDARD_HANDLER);
    }

    public String getJoinCondition(boolean bl, QuoteHandler quoteHandler) {
        if (this.preferUsingOperator && this.canUseUSING()) {
            return this.generateUSINGCondition(bl, quoteHandler);
        }
        return this.generateJoinCondition(bl, quoteHandler);
    }

    private String generateUSINGCondition(boolean bl, QuoteHandler quoteHandler) {
        StringBuilder stringBuilder = new StringBuilder(this.joinColumns.size() * 20 + 10);
        boolean bl2 = true;
        if (bl) {
            stringBuilder.append("USING ");
        }
        stringBuilder.append("(");
        for (Map.Entry<String, String> entry : this.joinColumns.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getColumnName(null, entry.getKey(), quoteHandler));
            bl2 = false;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String generateJoinCondition(boolean bl, QuoteHandler quoteHandler) {
        StringBuilder stringBuilder = new StringBuilder(this.joinColumns.size() * 20 + 10);
        String string = this.keywordCase == GeneratedIdentifierCase.upper ? " AND " : " and ";
        boolean bl2 = true;
        if (bl) {
            stringBuilder.append("ON ");
        }
        if (this.useParentheses) {
            stringBuilder.append("(");
        }
        for (Map.Entry<String, String> entry : this.joinColumns.entrySet()) {
            if (!bl2) {
                stringBuilder.append(string);
            }
            stringBuilder.append(this.getColumnName(this.fromTable, entry.getKey(), quoteHandler));
            stringBuilder.append(" = ");
            stringBuilder.append(this.getColumnName(this.toTable, entry.getValue(), quoteHandler));
            bl2 = false;
        }
        if (this.useParentheses) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String getColumnName(TableAlias tableAlias, String string, QuoteHandler quoteHandler) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        String string2 = quoteHandler.quoteObjectname(string);
        if (quoteHandler.isQuoted(string2)) {
            return string2;
        }
        switch (this.identifierCase) {
            case lower: {
                string2 = string.toLowerCase();
                break;
            }
            case upper: {
                string2 = string.toUpperCase();
                break;
            }
            default: {
                string2 = string;
            }
        }
        if (tableAlias != null) {
            string2 = tableAlias.getNameToUse() + "." + string2;
        }
        return string2;
    }

    private boolean canUseUSING() {
        for (Map.Entry<String, String> entry : this.joinColumns.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        StringBuilder stringBuilder2 = new StringBuilder(40);
        stringBuilder.append(this.toTable.getObjectName());
        stringBuilder.append("(");
        stringBuilder2.append(this.fromTable.getObjectName());
        stringBuilder2.append("(");
        boolean bl = true;
        for (Map.Entry<String, String> entry : this.joinColumns.entrySet()) {
            if (!bl) {
                stringBuilder.append(",");
                stringBuilder2.append(",");
            }
            stringBuilder.append(entry.getValue());
            stringBuilder2.append(entry.getKey());
        }
        stringBuilder.append(") - ");
        stringBuilder2.append(")");
        stringBuilder.append((CharSequence)stringBuilder2);
        return stringBuilder.toString();
    }
}

