/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.formatter;

import java.io.File;
import java.io.IOException;
import java.util.List;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.SqlFormatter;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ExternalFormatter
implements SqlFormatter {
    public static final String DEFAULT_DBID = "default";
    public static final String INPUT_FILE = "${wbin}";
    public static final String OUTPUT_FILE = "${wbout}";
    private String program;
    private String cmdLine;
    private String inputEncoding;
    private String outputEncoding;
    private boolean supportsMultipleStatements;
    private boolean enabled = true;

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isUsable() {
        return this.enabled && this.programExists();
    }

    public boolean programExists() {
        if (StringUtil.isBlank(this.program)) {
            return false;
        }
        WbFile wbFile = new WbFile(this.program);
        return wbFile.exists();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String string) {
        this.program = string;
    }

    public String getCommandLine() {
        return this.cmdLine;
    }

    public void setCommandLine(String string) {
        this.cmdLine = string;
    }

    public void setInputEncoding(String string) {
        this.inputEncoding = string;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    @Override
    public boolean supportsMultipleStatements() {
        return this.supportsMultipleStatements;
    }

    public void setSupportsMultipleStatements(boolean bl) {
        this.supportsMultipleStatements = bl;
    }

    @Override
    public String getFormattedSql(String string) {
        try {
            return this.runFormatter(string);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not format SQL statement", iOException);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runFormatter(String string) throws IOException {
        File file = File.createTempFile("wbf$_in", ".sql");
        File file2 = File.createTempFile("wbf$_out", ".sql");
        File file3 = File.createTempFile("wbf$_syserr", ".txt");
        File file4 = File.createTempFile("wbf$_sysout", ".txt");
        boolean bl = true;
        boolean bl2 = true;
        CallerInfo callerInfo = new CallerInfo(){};
        String string2 = StringUtil.coalesce(this.cmdLine, "");
        if (string2.contains(INPUT_FILE)) {
            string2 = string2.replace(INPUT_FILE, '\"' + file.getAbsolutePath() + '\"');
            bl2 = false;
        }
        if (string2.contains(OUTPUT_FILE)) {
            FileUtil.deleteSilently(file2);
            string2 = string2.replace(OUTPUT_FILE, '\"' + file2.getAbsolutePath() + '\"');
            bl = false;
        }
        if (this.inputEncoding == null) {
            this.inputEncoding = System.getProperty("file.encoding");
            LogMgr.logInfo(callerInfo, "Using encoding for SQL formatter input file: " + this.inputEncoding);
        }
        if (this.outputEncoding == null) {
            this.outputEncoding = this.inputEncoding;
            LogMgr.logInfo(callerInfo, "Using encoding for SQL formatter output file: " + this.outputEncoding);
        }
        try {
            String string3;
            FileUtil.writeString(file, string, this.inputEncoding, false);
            LogMgr.logDebug(callerInfo, "Input file written to: " + file.getAbsolutePath());
            WbFile wbFile = new WbFile(this.program);
            List<String> list = StringUtil.stringToList(string2, " ", false, false, false, true);
            list.add(0, '\"' + wbFile.getFullPath() + '\"');
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            processBuilder.directory(wbFile.getAbsoluteFile().getParentFile());
            if (bl2) {
                processBuilder.redirectInput(file);
            }
            if (bl) {
                processBuilder.redirectOutput(file2);
            } else {
                processBuilder.redirectOutput(file4);
            }
            processBuilder.redirectError(file3);
            LogMgr.logInfo(callerInfo, "Running external formatter: " + processBuilder.command());
            Process process = processBuilder.start();
            process.waitFor();
            int n = process.exitValue();
            LogMgr.logDebug(callerInfo, "Return value was: " + n);
            String string4 = FileUtil.readFile(file2, this.outputEncoding);
            if (!bl && StringUtil.isNonEmpty(string3 = this.readFile(file4))) {
                LogMgr.logInfo(callerInfo, "Output from formatter: " + string3);
            }
            if (StringUtil.isNonEmpty(string3 = this.readFile(file3))) {
                LogMgr.logWarning(callerInfo, "Error message from formatter: " + string3);
            }
            String string5 = StringUtil.trim(string4);
            return string5;
        }
        catch (Exception exception) {
            String string6 = this.readFile(file3);
            if (StringUtil.isNonEmpty(string6)) {
                LogMgr.logError(callerInfo, "Error message from formatter: " + string6, null);
                LogMgr.logDebug(callerInfo, "Error cause", exception);
            } else {
                LogMgr.logError(callerInfo, "Error running formatter", exception);
            }
        }
        finally {
            FileUtil.deleteSilently(file);
            FileUtil.deleteSilently(file2);
            FileUtil.deleteSilently(file3);
            FileUtil.deleteSilently(file4);
        }
        return string;
    }

    private String readFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        String string = null;
        try {
            string = FileUtil.readFile(file, System.getProperty("file.encoding"));
            string = StringUtil.trimToNull(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public String toString() {
        if (StringUtil.isEmptyString(this.program)) {
            return "<empty>";
        }
        WbFile wbFile = new WbFile(this.program);
        return wbFile.getAbsolutePath();
    }

    public static void saveDefinition(ExternalFormatter externalFormatter, String string) {
        if (externalFormatter == null) {
            return;
        }
        Settings.getInstance().setProperty("workbench.formatter." + string + ".program", externalFormatter.program == null ? "" : externalFormatter.program);
        Settings.getInstance().setProperty("workbench.formatter." + string + ".enabled", externalFormatter.isEnabled());
        Settings.getInstance().setProperty("workbench.formatter." + string + ".cmdline", externalFormatter.cmdLine);
        Settings.getInstance().setProperty("workbench.formatter." + string + ".inputencoding", externalFormatter.inputEncoding);
        Settings.getInstance().setProperty("workbench.formatter." + string + ".outputencoding", externalFormatter.outputEncoding);
        Settings.getInstance().setProperty("workbench.formatter." + string + ".supports.scripts", externalFormatter.supportsMultipleStatements);
    }

    public static ExternalFormatter getDefinition(String string) {
        if (StringUtil.isEmptyString(string)) {
            string = DEFAULT_DBID;
        }
        String string2 = Settings.getInstance().getProperty("workbench.formatter." + string + ".program", null);
        boolean bl = Settings.getInstance().getBoolProperty("workbench.formatter." + string + ".enabled", false);
        String string3 = Settings.getInstance().getProperty("workbench.formatter." + string + ".cmdline", null);
        String string4 = Settings.getInstance().getProperty("workbench.formatter." + string + ".inputencoding", null);
        String string5 = Settings.getInstance().getProperty("workbench.formatter." + string + ".outputencoding", null);
        boolean bl2 = Settings.getInstance().getBoolProperty("workbench.formatter." + string + ".supports.scripts", false);
        ExternalFormatter externalFormatter = new ExternalFormatter();
        externalFormatter.setCommandLine(string3);
        externalFormatter.setProgram(string2);
        externalFormatter.setInputEncoding(string4);
        externalFormatter.setOutputEncoding(string5);
        externalFormatter.setSupportsMultipleStatements(bl2);
        externalFormatter.setEnabled(bl);
        return externalFormatter;
    }
}

